/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.stream;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.filesystem.FileSystemOptions;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions$;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalLegacySink;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamExecLegacySink;
import org.apache.flink.table.planner.plan.rules.physical.stream.StreamExecLegacySinkRule$;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistribution$;
import org.apache.flink.table.sinks.PartitionableTableSink;
import org.apache.flink.table.sinks.TableSink;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\r3A!\u0001\u0002\u0001+\tA2\u000b\u001e:fC6,\u00050Z2MK\u001e\f7-_*j].\u0014V\u000f\\3\u000b\u0005\r!\u0011AB:ue\u0016\fWN\u0003\u0002\u0006\r\u0005A\u0001\u000f[=tS\u000e\fGN\u0003\u0002\b\u0011\u0005)!/\u001e7fg*\u0011\u0011BC\u0001\u0005a2\fgN\u0003\u0002\f\u0019\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0007\u000f\u0003\u0015!\u0018M\u00197f\u0015\ty\u0001#A\u0003gY&t7N\u0003\u0002\u0012%\u00051\u0011\r]1dQ\u0016T\u0011aE\u0001\u0004_J<7\u0001A\n\u0003\u0001Y\u0001\"a\u0006\u0010\u000e\u0003aQ!!\u0007\u000e\u0002\u000f\r|gN^3si*\u00111\u0004H\u0001\u0004e\u0016d'BA\u000f\u0011\u0003\u001d\u0019\u0017\r\\2ji\u0016L!a\b\r\u0003\u001b\r{gN^3si\u0016\u0014(+\u001e7f\u0011\u0015\t\u0003\u0001\"\u0001#\u0003\u0019a\u0014N\\5u}Q\t1\u0005\u0005\u0002%\u00015\t!\u0001C\u0003\u001a\u0001\u0011\u0005a\u0005\u0006\u0002(WA\u0011\u0001&K\u0007\u00025%\u0011!F\u0007\u0002\b%\u0016dgj\u001c3f\u0011\u0015YR\u00051\u0001(\u000f\u0015i#\u0001#\u0001/\u0003a\u0019FO]3b[\u0016CXm\u0019'fO\u0006\u001c\u0017pU5oWJ+H.\u001a\t\u0003I=2Q!\u0001\u0002\t\u0002A\u001a\"aL\u0019\u0011\u0005I*T\"A\u001a\u000b\u0003Q\nQa]2bY\u0006L!AN\u001a\u0003\r\u0005s\u0017PU3g\u0011\u0015\ts\u0006\"\u00019)\u0005q\u0003b\u0002\u001e0\u0005\u0004%\taO\u0001\t\u0013:\u001bF+\u0011(D\u000bV\tA\b\u0005\u0002>\u007f5\taH\u0003\u0002\n9%\u0011\u0001I\u0010\u0002\u000b%\u0016dw\n\u001d;Sk2,\u0007B\u0002\"0A\u0003%A(A\u0005J\u001dN#\u0016IT\"FA\u0001")
public class StreamExecLegacySinkRule
extends ConverterRule {
    public static RelOptRule INSTANCE() {
        return StreamExecLegacySinkRule$.MODULE$.INSTANCE();
    }

    @Override
    public RelNode convert(RelNode rel) {
        FlinkLogicalLegacySink sinkNode = (FlinkLogicalLegacySink)rel;
        RelTraitSet newTrait = rel.getTraitSet().replace(FlinkConventions$.MODULE$.STREAM_PHYSICAL());
        RelTraitSet requiredTraitSet = sinkNode.getInput().getTraitSet().replace(FlinkConventions$.MODULE$.STREAM_PHYSICAL());
        if (sinkNode.catalogTable() != null && sinkNode.catalogTable().isPartitioned()) {
            TableSink<?> tableSink = sinkNode.sink();
            if (tableSink instanceof PartitionableTableSink) {
                BoxedUnit boxedUnit;
                PartitionableTableSink partitionableTableSink = (PartitionableTableSink)tableSink;
                partitionableTableSink.setStaticPartition(JavaConversions$.MODULE$.mapAsJavaMap(sinkNode.staticPartitions()));
                Buffer dynamicPartFields = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(sinkNode.catalogTable().getPartitionKeys()).filter((Function1)new Serializable(this, sinkNode){
                    public static final long serialVersionUID = 0L;
                    private final FlinkLogicalLegacySink sinkNode$1;

                    public final boolean apply(String x$1) {
                        return !this.sinkNode$1.staticPartitions().contains((Object)x$1);
                    }
                    {
                        this.sinkNode$1 = sinkNode$1;
                    }
                });
                if (dynamicPartFields.nonEmpty()) {
                    Buffer dynamicPartIndices = (Buffer)dynamicPartFields.map((Function1)new Serializable(this, partitionableTableSink){
                        public static final long serialVersionUID = 0L;
                        private final PartitionableTableSink x2$1;

                        public final int apply(String x$2) {
                            return Predef$.MODULE$.refArrayOps((Object[])((TableSink)this.x2$1).getTableSchema().getFieldNames()).indexOf((Object)x$2);
                        }
                        {
                            this.x2$1 = x2$1;
                        }
                    }, Buffer$.MODULE$.canBuildFrom());
                    String shuffleEnable = (String)sinkNode.catalogTable().getProperties().get(FileSystemOptions.SINK_SHUFFLE_BY_PARTITION.key());
                    if (shuffleEnable != null && new StringOps(Predef$.MODULE$.augmentString(shuffleEnable)).toBoolean()) {
                        requiredTraitSet = requiredTraitSet.plus(FlinkRelDistribution$.MODULE$.hash(JavaConversions$.MODULE$.bufferAsJavaList((Buffer)dynamicPartIndices.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Integer apply(int x$1) {
                                return x$1;
                            }
                        }, Buffer$.MODULE$.canBuildFrom())), false));
                    }
                    if (partitionableTableSink.configurePartitionGrouping(false)) {
                        throw new TableException("Partition grouping in stream mode is not supported yet!");
                    }
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                throw new TableException(new StringBuilder().append((Object)"We need PartitionableTableSink to write data to").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" partitioned table: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sinkNode.sinkName()}))).toString());
            }
        }
        RelNode newInput = RelOptRule.convert(sinkNode.getInput(), requiredTraitSet);
        return new StreamExecLegacySink(rel.getCluster(), newTrait, newInput, sinkNode.sink(), sinkNode.sinkName());
    }

    public StreamExecLegacySinkRule() {
        super(FlinkLogicalLegacySink.class, FlinkConventions$.MODULE$.LOGICAL(), FlinkConventions$.MODULE$.STREAM_PHYSICAL(), "StreamExecLegacySinkRule");
    }
}

