/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.time.Duration;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.logical.LogicalWindow;
import org.apache.flink.table.planner.plan.utils.WindowEmitStrategy$;
import org.apache.flink.table.runtime.operators.window.TimeWindow;
import org.apache.flink.table.runtime.operators.window.triggers.ElementTriggers;
import org.apache.flink.table.runtime.operators.window.triggers.EventTimeTriggers;
import org.apache.flink.table.runtime.operators.window.triggers.ProcessingTimeTriggers;
import org.apache.flink.table.runtime.operators.window.triggers.Trigger;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001B\u0001\u0003\u0001E\u0011!cV5oI><X)\\5u'R\u0014\u0018\r^3hs*\u00111\u0001B\u0001\u0006kRLGn\u001d\u0006\u0003\u000b\u0019\tA\u0001\u001d7b]*\u0011q\u0001C\u0001\ba2\fgN\\3s\u0015\tI!\"A\u0003uC\ndWM\u0003\u0002\f\u0019\u0005)a\r\\5oW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M1R\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\r\u0005s\u0017PU3g\u0011!I\u0002A!A!\u0002\u0013Q\u0012aC5t\u000bZ,g\u000e\u001e+j[\u0016\u0004\"aG\u0016\u000f\u0005qIcBA\u000f)\u001d\tqrE\u0004\u0002 M9\u0011\u0001%\n\b\u0003C\u0011j\u0011A\t\u0006\u0003GA\ta\u0001\u0010:p_Rt\u0014\"A\b\n\u00055q\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0011!FB\u0001\ba\u0006\u001c7.Y4f\u0013\taSF\u0001\u0005K\u0005>|G.Z1o\u0015\tQc\u0001\u0003\u00050\u0001\t\u0005\t\u0015!\u0003\u001b\u0003=I7oU3tg&|gnV5oI><\b\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\u0002\u001d\u0015\f'\u000f\\=GSJ,G)\u001a7bsB\u00111dM\u0005\u0003i5\u0012QA\u0013'p]\u001eD\u0001B\u000e\u0001\u0003\u0002\u0003\u0006IAG\u0001\u0016K\u0006\u0014H.\u001f$je\u0016$U\r\\1z\u000b:\f'\r\\3e\u0011!A\u0004A!A!\u0002\u0013\u0011\u0014!\u00047bi\u00164\u0015N]3EK2\f\u0017\u0010\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003\u001b\u0003Qa\u0017\r^3GSJ,G)\u001a7bs\u0016s\u0017M\u00197fI\"AA\b\u0001B\u0001B\u0003%!'A\u0007bY2|w\u000fT1uK:,7o\u001d\u0005\u0006}\u0001!\taP\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011\u0001\u00135\tR#G\u000f\"\u0003\"!\u0011\u0001\u000e\u0003\tAQ!G\u001fA\u0002iAQaL\u001fA\u0002iAQ!M\u001fA\u0002IBQAN\u001fA\u0002iAQ\u0001O\u001fA\u0002IBQAO\u001fA\u0002iAQ\u0001P\u001fA\u0002IBQA\u0013\u0001\u0005\u0002-\u000b\u0001cZ3u\u00032dwn\u001e'bi\u0016tWm]:\u0016\u0003IBQ!\u0014\u0001\u0005\n9\u000bqb\u00195fG.4\u0016\r\\5eCRLwN\u001c\u000b\u0002\u001fB\u00111\u0003U\u0005\u0003#R\u0011A!\u00168ji\")1\u000b\u0001C\u0001)\u0006q\u0001O]8ek\u000e,W\u000b\u001d3bi\u0016\u001cX#\u0001\u000e\t\u000bY\u0003A\u0011A,\u0002\u0015\u001d,G\u000f\u0016:jO\u001e,'/F\u0001Y!\rI&\rZ\u0007\u00025*\u00111\fX\u0001\tiJLwmZ3sg*\u0011QLX\u0001\u0007o&tGm\\<\u000b\u0005}\u0003\u0017!C8qKJ\fGo\u001c:t\u0015\t\t\u0007\"A\u0004sk:$\u0018.\\3\n\u0005\rT&a\u0002+sS\u001e<WM\u001d\t\u0003K\u001al\u0011\u0001X\u0005\u0003Or\u0013!\u0002V5nK^Kg\u000eZ8x\u0011\u0015I\u0007\u0001\"\u0011k\u0003!!xn\u0015;sS:<G#A6\u0011\u00051|gBA\nn\u0013\tqG#\u0001\u0004Qe\u0016$WMZ\u0005\u0003aF\u0014aa\u0015;sS:<'B\u00018\u0015\u0011\u0015\u0019\b\u0001\"\u0003u\u0003e\u0019'/Z1uKR\u0013\u0018nZ4fe\u001a\u0013x.\\%oi\u0016\u0014h/\u00197\u0015\u0007UD(\u0010E\u0002\u0014mbK!a\u001e\u000b\u0003\r=\u0003H/[8o\u0011\u0015I(\u000f1\u0001\u001b\u0003=)g.\u00192mK\u0012+G.Y=F[&$\b\"B>s\u0001\u0004\u0011\u0014\u0001C5oi\u0016\u0014h/\u00197\t\u000bu\u0004A\u0011\u0002@\u0002!%tG/\u001a:wC2$vn\u0015;sS:<G\u0003B6\u0000\u0003\u0003AQ!\u001f?A\u0002iAQa\u001f?A\u0002I:q!!\u0002\u0003\u0011\u0003\t9!\u0001\nXS:$wn^#nSR\u001cFO]1uK\u001eL\bcA!\u0002\n\u00191\u0011A\u0001E\u0001\u0003\u0017\u00192!!\u0003\u0013\u0011\u001dq\u0014\u0011\u0002C\u0001\u0003\u001f!\"!a\u0002\t\u0011\u0005M\u0011\u0011\u0002C\u0001\u0003+\tQ!\u00199qYf$R\u0001QA\f\u0003OA\u0001\"!\u0007\u0002\u0012\u0001\u0007\u00111D\u0001\fi\u0006\u0014G.Z\"p]\u001aLw\r\u0005\u0003\u0002\u001e\u0005\rRBAA\u0010\u0015\r\t\t\u0003C\u0001\u0004CBL\u0017\u0002BA\u0013\u0003?\u00111\u0002V1cY\u0016\u001cuN\u001c4jO\"9Q,!\u0005A\u0002\u0005%\u0002\u0003BA\u0016\u0003ci!!!\f\u000b\u0007\u0005=B!A\u0004m_\u001eL7-\u00197\n\t\u0005M\u0012Q\u0006\u0002\u000e\u0019><\u0017nY1m/&tGm\\<\t\u0015\u0005]\u0012\u0011\u0002b\u0001\n\u0003\tI$\u0001\u0012U\u0003\ncUiX#Y\u000b\u000e{V)T%U?\u0016\u000b%\u000bT-`\r&\u0013ViX#O\u0003\ncU\tR\u000b\u0003\u0003w\u0001R!!\u0010\u0002Dii!!a\u0010\u000b\u0007\u0005\u0005#\"A\u0007d_:4\u0017nZ;sCRLwN\\\u0005\u0005\u0003\u000b\nyD\u0001\u0007D_:4\u0017nZ(qi&|g\u000eC\u0005\u0002J\u0005%\u0001\u0015!\u0003\u0002<\u0005\u0019C+\u0011\"M\u000b~+\u0005,R\"`\u000b6KEkX#B%2KvLR%S\u000b~+e*\u0011\"M\u000b\u0012\u0003\u0003\u0006BA$\u0003\u001b\u0002B!a\u0014\u0002V5\u0011\u0011\u0011\u000b\u0006\u0004\u0003'R\u0011AC1o]>$\u0018\r^5p]&!\u0011qKA)\u00051)\u0005\u0010]3sS6,g\u000e^1m\u0011)\tY&!\u0003C\u0002\u0013\u0005\u0011QL\u0001!)\u0006\u0013E*R0F1\u0016\u001bu,R'J)~+\u0015I\u0015'Z?\u001aK%+R0E\u000b2\u000b\u0015,\u0006\u0002\u0002`A)\u0011QHA\"W\"I\u00111MA\u0005A\u0003%\u0011qL\u0001\")\u0006\u0013E*R0F1\u0016\u001bu,R'J)~+\u0015I\u0015'Z?\u001aK%+R0E\u000b2\u000b\u0015\f\t\u0015\u0005\u0003C\ni\u0005\u0003\u0006\u0002j\u0005%!\u0019!C\u0001\u0003s\t\u0011\u0005V!C\u0019\u0016{V\tW#D?\u0016k\u0015\nV0M\u0003R+uLR%S\u000b~+e*\u0011\"M\u000b\u0012C\u0011\"!\u001c\u0002\n\u0001\u0006I!a\u000f\u0002EQ\u000b%\tT#`\u000bb+5iX#N\u0013R{F*\u0011+F?\u001aK%+R0F\u001d\u0006\u0013E*\u0012#!Q\u0011\tY'!\u0014\t\u0015\u0005M\u0014\u0011\u0002b\u0001\n\u0003\ti&A\u0010U\u0003\ncUiX#Y\u000b\u000e{V)T%U?2\u000bE+R0G\u0013J+u\fR#M\u0003fC\u0011\"a\u001e\u0002\n\u0001\u0006I!a\u0018\u0002AQ\u000b%\tT#`\u000bb+5iX#N\u0013R{F*\u0011+F?\u001aK%+R0E\u000b2\u000b\u0015\f\t\u0015\u0005\u0003k\ni\u0005")
public class WindowEmitStrategy {
    private final Boolean isEventTime;
    private final Boolean isSessionWindow;
    private final Long earlyFireDelay;
    private final Boolean earlyFireDelayEnabled;
    private final Long lateFireDelay;
    private final Boolean lateFireDelayEnabled;
    private final Long allowLateness;

    public static ConfigOption<String> TABLE_EXEC_EMIT_LATE_FIRE_DELAY() {
        return WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_LATE_FIRE_DELAY();
    }

    public static ConfigOption<Boolean> TABLE_EXEC_EMIT_LATE_FIRE_ENABLED() {
        return WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_LATE_FIRE_ENABLED();
    }

    public static ConfigOption<String> TABLE_EXEC_EMIT_EARLY_FIRE_DELAY() {
        return WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_EARLY_FIRE_DELAY();
    }

    public static ConfigOption<Boolean> TABLE_EXEC_EMIT_EARLY_FIRE_ENABLED() {
        return WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_EARLY_FIRE_ENABLED();
    }

    public static WindowEmitStrategy apply(TableConfig tableConfig, LogicalWindow logicalWindow) {
        return WindowEmitStrategy$.MODULE$.apply(tableConfig, logicalWindow);
    }

    public Long getAllowLateness() {
        return this.allowLateness;
    }

    private void checkValidation() {
        if (Predef$.MODULE$.Boolean2boolean(this.isSessionWindow) && (Predef$.MODULE$.Boolean2boolean(this.earlyFireDelayEnabled) || Predef$.MODULE$.Boolean2boolean(this.lateFireDelayEnabled))) {
            throw new TableException("Session window doesn't support EMIT strategy currently.");
        }
        if (Predef$.MODULE$.Boolean2boolean(this.isEventTime) && Predef$.MODULE$.Boolean2boolean(this.lateFireDelayEnabled) && Predef$.MODULE$.Long2long(this.allowLateness) <= 0L) {
            throw new TableException("The 'AFTER WATERMARK' emit strategy requires set 'minIdleStateRetentionTime' in table config.");
        }
        if (Predef$.MODULE$.Boolean2boolean(this.earlyFireDelayEnabled) && (this.earlyFireDelay == null || Predef$.MODULE$.Long2long(this.earlyFireDelay) < 0L)) {
            throw new TableException("Early-fire delay should not be null or negative value whenenable early-fire emit strategy.");
        }
        if (Predef$.MODULE$.Boolean2boolean(this.lateFireDelayEnabled) && (this.lateFireDelay == null || Predef$.MODULE$.Long2long(this.lateFireDelay) < 0L)) {
            throw new TableException("Late-fire delay should not be null or negative value whenenable late-fire emit strategy.");
        }
    }

    public Boolean produceUpdates() {
        return Predef$.MODULE$.Boolean2boolean(this.isEventTime) ? Predef$.MODULE$.boolean2Boolean(Predef$.MODULE$.Boolean2boolean(this.earlyFireDelayEnabled) || Predef$.MODULE$.Boolean2boolean(this.lateFireDelayEnabled)) : this.earlyFireDelayEnabled;
    }

    public Trigger<TimeWindow> getTrigger() {
        Option<Trigger<TimeWindow>> option;
        block11: {
            ProcessingTimeTriggers.AfterEndOfWindow afterEndOfWindow;
            block8: {
                ProcessingTimeTriggers.AfterEndOfWindow afterEndOfWindow2;
                block10: {
                    ProcessingTimeTriggers.AfterEndOfWindow trigger;
                    block9: {
                        Option<Trigger<TimeWindow>> earlyTrigger;
                        block2: {
                            Tuple2 tuple2;
                            block7: {
                                EventTimeTriggers.AfterEndOfWindow afterEndOfWindow3;
                                block4: {
                                    EventTimeTriggers.AfterEndOfWindow trigger2;
                                    block6: {
                                        block5: {
                                            block3: {
                                                earlyTrigger = this.createTriggerFromInterval(this.earlyFireDelayEnabled, this.earlyFireDelay);
                                                Option<Trigger<TimeWindow>> lateTrigger = this.createTriggerFromInterval(this.lateFireDelayEnabled, this.lateFireDelay);
                                                if (!Predef$.MODULE$.Boolean2boolean(this.isEventTime)) break block2;
                                                trigger2 = EventTimeTriggers.afterEndOfWindow();
                                                tuple2 = new Tuple2(earlyTrigger, lateTrigger);
                                                if (tuple2 == null) break block3;
                                                Option option2 = (Option)tuple2._1();
                                                Option option3 = (Option)tuple2._2();
                                                if (!(option2 instanceof Some)) break block3;
                                                Some some = (Some)option2;
                                                Trigger early = (Trigger)some.x();
                                                if (!(option3 instanceof Some)) break block3;
                                                Some some2 = (Some)option3;
                                                Trigger late = (Trigger)some2.x();
                                                afterEndOfWindow3 = trigger2.withEarlyFirings(early).withLateFirings(late);
                                                break block4;
                                            }
                                            if (tuple2 == null) break block5;
                                            Option option4 = (Option)tuple2._1();
                                            Option option5 = (Option)tuple2._2();
                                            if (!(option4 instanceof Some)) break block5;
                                            Some some = (Some)option4;
                                            Trigger early = (Trigger)some.x();
                                            if (!None$.MODULE$.equals(option5)) break block5;
                                            afterEndOfWindow3 = trigger2.withEarlyFirings(early);
                                            break block4;
                                        }
                                        if (tuple2 == null) break block6;
                                        Option option6 = (Option)tuple2._1();
                                        Option option7 = (Option)tuple2._2();
                                        if (!None$.MODULE$.equals(option6) || !(option7 instanceof Some)) break block6;
                                        Some some = (Some)option7;
                                        Trigger late = (Trigger)some.x();
                                        afterEndOfWindow3 = trigger2.withLateFirings(late);
                                        break block4;
                                    }
                                    if (tuple2 == null) break block7;
                                    Option option8 = (Option)tuple2._1();
                                    Option option9 = (Option)tuple2._2();
                                    if (!None$.MODULE$.equals(option8) || !None$.MODULE$.equals(option9)) break block7;
                                    afterEndOfWindow3 = trigger2;
                                }
                                afterEndOfWindow = afterEndOfWindow3;
                                break block8;
                            }
                            throw new MatchError((Object)tuple2);
                        }
                        trigger = ProcessingTimeTriggers.afterEndOfWindow();
                        option = earlyTrigger;
                        if (!(option instanceof Some)) break block9;
                        Some some = (Some)option;
                        Trigger early = (Trigger)some.x();
                        afterEndOfWindow2 = trigger.withEarlyFirings(early);
                        break block10;
                    }
                    if (!None$.MODULE$.equals(option)) break block11;
                    afterEndOfWindow2 = trigger;
                }
                afterEndOfWindow = afterEndOfWindow2;
            }
            return afterEndOfWindow;
        }
        throw new MatchError(option);
    }

    public String toString() {
        BoxedUnit boxedUnit;
        StringBuilder builder = new StringBuilder();
        String earlyString = this.intervalToString(this.earlyFireDelayEnabled, this.earlyFireDelay);
        String lateString = this.intervalToString(this.lateFireDelayEnabled, this.lateFireDelay);
        Object object = earlyString == null ? BoxedUnit.UNIT : builder.append("early ").append(earlyString);
        if (lateString == null) {
            boxedUnit = BoxedUnit.UNIT;
        } else {
            Object object2 = earlyString == null ? BoxedUnit.UNIT : builder.append(", ");
            boxedUnit = builder.append("late ").append(lateString);
        }
        return builder.toString();
    }

    private Option<Trigger<TimeWindow>> createTriggerFromInterval(Boolean enableDelayEmit, Long interval) {
        return Predef$.MODULE$.Boolean2boolean(enableDelayEmit) ? (Predef$.MODULE$.Long2long(interval) > 0L ? new Some((Object)ProcessingTimeTriggers.every((Duration)Duration.ofMillis(Predef$.MODULE$.Long2long(interval)))) : new Some((Object)ElementTriggers.every())) : None$.MODULE$;
    }

    private String intervalToString(Boolean enableDelayEmit, Long interval) {
        return Predef$.MODULE$.Boolean2boolean(enableDelayEmit) ? (Predef$.MODULE$.Long2long(interval) > 0L ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"delay ", " millisecond"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{interval})) : "no delay") : null;
    }

    public WindowEmitStrategy(Boolean isEventTime, Boolean isSessionWindow, Long earlyFireDelay, Boolean earlyFireDelayEnabled, Long lateFireDelay, Boolean lateFireDelayEnabled, Long allowLateness) {
        this.isEventTime = isEventTime;
        this.isSessionWindow = isSessionWindow;
        this.earlyFireDelay = earlyFireDelay;
        this.earlyFireDelayEnabled = earlyFireDelayEnabled;
        this.lateFireDelay = lateFireDelay;
        this.lateFireDelayEnabled = lateFireDelayEnabled;
        this.allowLateness = allowLateness;
        this.checkValidation();
    }
}

