/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.sinks;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;

public class SelectTableSinkSchemaConverter {
    public static TableSchema changeDefaultConversionClass(TableSchema tableSchema) {
        DataType[] oldTypes = tableSchema.getFieldDataTypes();
        String[] fieldNames = tableSchema.getFieldNames();
        TableSchema.Builder builder = TableSchema.builder();
        for (int i = 0; i < tableSchema.getFieldCount(); ++i) {
            DataType fieldType = LogicalTypeDataTypeConverter.fromLogicalTypeToDataType((LogicalType)LogicalTypeDataTypeConverter.fromDataTypeToLogicalType((DataType)oldTypes[i]));
            builder.field(fieldNames[i], fieldType);
        }
        return builder.build();
    }

    static TableSchema convertTimeAttributeToRegularTimestamp(TableSchema tableSchema) {
        DataType[] dataTypes = tableSchema.getFieldDataTypes();
        String[] oldNames = tableSchema.getFieldNames();
        TableSchema.Builder builder = TableSchema.builder();
        for (int i = 0; i < tableSchema.getFieldCount(); ++i) {
            TimestampType timestampType;
            DataType fieldType = dataTypes[i];
            String fieldName = oldNames[i];
            if (fieldType.getLogicalType() instanceof TimestampType && !(timestampType = (TimestampType)fieldType.getLogicalType()).getKind().equals((Object)TimestampKind.REGULAR)) {
                builder.field(fieldName, DataTypes.TIMESTAMP((int)3));
                continue;
            }
            builder.field(fieldName, fieldType);
        }
        return builder.build();
    }
}

