/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.calcite;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.sql.type.MapSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.api.common.typeinfo.NothingTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeSystem;
import org.apache.flink.table.planner.plan.schema.GenericRelDataType;
import org.apache.flink.table.planner.plan.schema.RawRelDataType;
import org.apache.flink.table.planner.plan.schema.StructuredRelDataType;
import org.apache.flink.table.planner.plan.schema.TimeIndicatorRelDataType;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.NullType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.TypeInformationRawType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.typeutils.TimeIndicatorTypeInfo;
import org.apache.flink.util.Preconditions;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class FlinkTypeFactory$ {
    public static final FlinkTypeFactory$ MODULE$;
    private final FlinkTypeFactory INSTANCE;

    static {
        new FlinkTypeFactory$();
    }

    public FlinkTypeFactory INSTANCE() {
        return this.INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTimeIndicatorType(LogicalType t) {
        LogicalType logicalType = t;
        if (!(logicalType instanceof TimestampType)) return false;
        TimestampType timestampType = (TimestampType)logicalType;
        TimestampKind timestampKind = timestampType.getKind();
        TimestampKind timestampKind2 = TimestampKind.ROWTIME;
        if (timestampKind == null) {
            if (timestampKind2 == null) return true;
        } else if (timestampKind.equals(timestampKind2)) return true;
        TimestampKind timestampKind3 = timestampType.getKind();
        TimestampKind timestampKind4 = TimestampKind.PROCTIME;
        if (timestampKind3 != null) {
            if (!timestampKind3.equals(timestampKind4)) return false;
            return true;
        }
        if (timestampKind4 == null) return true;
        return false;
    }

    public boolean isTimeIndicatorType(RelDataType relDataType) {
        RelDataType relDataType2 = relDataType;
        boolean bl = relDataType2 instanceof TimeIndicatorRelDataType;
        return bl;
    }

    public boolean isRowtimeIndicatorType(RelDataType relDataType) {
        TimeIndicatorRelDataType timeIndicatorRelDataType;
        RelDataType relDataType2 = relDataType;
        boolean bl = relDataType2 instanceof TimeIndicatorRelDataType && (timeIndicatorRelDataType = (TimeIndicatorRelDataType)relDataType2).isEventTime();
        return bl;
    }

    public boolean isProctimeIndicatorType(RelDataType relDataType) {
        TimeIndicatorRelDataType timeIndicatorRelDataType;
        RelDataType relDataType2 = relDataType;
        boolean bl = relDataType2 instanceof TimeIndicatorRelDataType && !(timeIndicatorRelDataType = (TimeIndicatorRelDataType)relDataType2).isEventTime();
        return bl;
    }

    @Deprecated
    public boolean isProctimeIndicatorType(TypeInformation<?> typeInfo) {
        TimeIndicatorTypeInfo timeIndicatorTypeInfo;
        TypeInformation<?> typeInformation = typeInfo;
        boolean bl = typeInformation instanceof TimeIndicatorTypeInfo && !(timeIndicatorTypeInfo = (TimeIndicatorTypeInfo)typeInformation).isEventTime();
        return bl;
    }

    @Deprecated
    public boolean isRowtimeIndicatorType(TypeInformation<?> typeInfo) {
        TimeIndicatorTypeInfo timeIndicatorTypeInfo;
        TypeInformation<?> typeInformation = typeInfo;
        boolean bl = typeInformation instanceof TimeIndicatorTypeInfo && (timeIndicatorTypeInfo = (TimeIndicatorTypeInfo)typeInformation).isEventTime();
        return bl;
    }

    @Deprecated
    public boolean isTimeIndicatorType(TypeInformation<?> typeInfo) {
        TypeInformation<?> typeInformation = typeInfo;
        boolean bl = typeInformation instanceof TimeIndicatorTypeInfo;
        return bl;
    }

    public LogicalType toLogicalType(RelDataType relDataType) {
        SqlTypeName sqlTypeName;
        block34: {
            MapType mapType;
            block6: {
                block33: {
                    block32: {
                        block31: {
                            block30: {
                                block29: {
                                    block28: {
                                        block27: {
                                            block26: {
                                                block25: {
                                                    block24: {
                                                        block23: {
                                                            block22: {
                                                                block21: {
                                                                    boolean bl;
                                                                    block20: {
                                                                        block19: {
                                                                            block18: {
                                                                                SqlTypeName sqlTypeName2;
                                                                                block17: {
                                                                                    block16: {
                                                                                        block15: {
                                                                                            block14: {
                                                                                                block13: {
                                                                                                    block12: {
                                                                                                        block11: {
                                                                                                            block10: {
                                                                                                                block9: {
                                                                                                                    block8: {
                                                                                                                        block7: {
                                                                                                                            block5: {
                                                                                                                                bl = false;
                                                                                                                                sqlTypeName2 = null;
                                                                                                                                sqlTypeName = relDataType.getSqlTypeName();
                                                                                                                                if (!((Object)((Object)SqlTypeName.BOOLEAN)).equals((Object)sqlTypeName)) break block5;
                                                                                                                                mapType = new BooleanType();
                                                                                                                                break block6;
                                                                                                                            }
                                                                                                                            if (!((Object)((Object)SqlTypeName.TINYINT)).equals((Object)sqlTypeName)) break block7;
                                                                                                                            mapType = new TinyIntType();
                                                                                                                            break block6;
                                                                                                                        }
                                                                                                                        if (!((Object)((Object)SqlTypeName.SMALLINT)).equals((Object)sqlTypeName)) break block8;
                                                                                                                        mapType = new SmallIntType();
                                                                                                                        break block6;
                                                                                                                    }
                                                                                                                    if (!((Object)((Object)SqlTypeName.INTEGER)).equals((Object)sqlTypeName)) break block9;
                                                                                                                    mapType = new IntType();
                                                                                                                    break block6;
                                                                                                                }
                                                                                                                if (!((Object)((Object)SqlTypeName.BIGINT)).equals((Object)sqlTypeName)) break block10;
                                                                                                                mapType = new BigIntType();
                                                                                                                break block6;
                                                                                                            }
                                                                                                            if (!((Object)((Object)SqlTypeName.FLOAT)).equals((Object)sqlTypeName)) break block11;
                                                                                                            mapType = new FloatType();
                                                                                                            break block6;
                                                                                                        }
                                                                                                        if (!((Object)((Object)SqlTypeName.DOUBLE)).equals((Object)sqlTypeName)) break block12;
                                                                                                        mapType = new DoubleType();
                                                                                                        break block6;
                                                                                                    }
                                                                                                    if (!((Object)((Object)SqlTypeName.CHAR)).equals((Object)sqlTypeName)) break block13;
                                                                                                    mapType = relDataType.getPrecision() == 0 ? CharType.ofEmptyLiteral() : new CharType(relDataType.getPrecision());
                                                                                                    break block6;
                                                                                                }
                                                                                                if (!((Object)((Object)SqlTypeName.VARCHAR)).equals((Object)sqlTypeName)) break block14;
                                                                                                mapType = relDataType.getPrecision() == 0 ? VarCharType.ofEmptyLiteral() : new VarCharType(relDataType.getPrecision());
                                                                                                break block6;
                                                                                            }
                                                                                            if (!((Object)((Object)SqlTypeName.BINARY)).equals((Object)sqlTypeName)) break block15;
                                                                                            mapType = relDataType.getPrecision() == 0 ? BinaryType.ofEmptyLiteral() : new BinaryType(relDataType.getPrecision());
                                                                                            break block6;
                                                                                        }
                                                                                        if (!((Object)((Object)SqlTypeName.VARBINARY)).equals((Object)sqlTypeName)) break block16;
                                                                                        mapType = relDataType.getPrecision() == 0 ? VarBinaryType.ofEmptyLiteral() : new VarBinaryType(relDataType.getPrecision());
                                                                                        break block6;
                                                                                    }
                                                                                    if (!((Object)((Object)SqlTypeName.DECIMAL)).equals((Object)sqlTypeName)) break block17;
                                                                                    mapType = new DecimalType(relDataType.getPrecision(), relDataType.getScale());
                                                                                    break block6;
                                                                                }
                                                                                if (!((Object)((Object)SqlTypeName.TIMESTAMP)).equals((Object)sqlTypeName)) break block18;
                                                                                bl = true;
                                                                                sqlTypeName2 = sqlTypeName;
                                                                                if (!(relDataType instanceof TimeIndicatorRelDataType)) break block18;
                                                                                TimeIndicatorRelDataType indicator = (TimeIndicatorRelDataType)relDataType;
                                                                                mapType = indicator.isEventTime() ? new TimestampType(true, TimestampKind.ROWTIME, 3) : new TimestampType(true, TimestampKind.PROCTIME, 3);
                                                                                break block6;
                                                                            }
                                                                            if (!((Object)((Object)SqlTypeName.DATE)).equals((Object)sqlTypeName)) break block19;
                                                                            mapType = new DateType();
                                                                            break block6;
                                                                        }
                                                                        if (!((Object)((Object)SqlTypeName.TIME)).equals((Object)sqlTypeName)) break block20;
                                                                        if (relDataType.getPrecision() > 3) {
                                                                            throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TIME precision is not supported: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)relDataType.getPrecision())})));
                                                                        }
                                                                        mapType = new TimeType();
                                                                        break block6;
                                                                    }
                                                                    if (!bl) break block21;
                                                                    mapType = new TimestampType(relDataType.getPrecision());
                                                                    break block6;
                                                                }
                                                                if (!((Object)((Object)SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE)).equals((Object)sqlTypeName)) break block22;
                                                                mapType = new LocalZonedTimestampType(relDataType.getPrecision());
                                                                break block6;
                                                            }
                                                            if (!SqlTypeName.YEAR_INTERVAL_TYPES.contains((Object)sqlTypeName)) break block23;
                                                            mapType = DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH()).getLogicalType();
                                                            break block6;
                                                        }
                                                        if (!SqlTypeName.DAY_INTERVAL_TYPES.contains((Object)sqlTypeName)) break block24;
                                                        if (relDataType.getPrecision() > 3) {
                                                            throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DAY_INTERVAL_TYPES precision is not supported: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)relDataType.getPrecision())})));
                                                        }
                                                        mapType = DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.SECOND((int)3)).getLogicalType();
                                                        break block6;
                                                    }
                                                    if (!((Object)((Object)SqlTypeName.NULL)).equals((Object)sqlTypeName)) break block25;
                                                    mapType = new NullType();
                                                    break block6;
                                                }
                                                if (!((Object)((Object)SqlTypeName.SYMBOL)).equals((Object)sqlTypeName)) break block26;
                                                mapType = new TypeInformationRawType(TypeExtractor.createTypeInfo(Enum.class));
                                                break block6;
                                            }
                                            if (!((Object)((Object)SqlTypeName.ANY)).equals((Object)sqlTypeName) || !(relDataType instanceof GenericRelDataType)) break block27;
                                            GenericRelDataType genericRelDataType = (GenericRelDataType)relDataType;
                                            mapType = genericRelDataType.genericType();
                                            break block6;
                                        }
                                        if (!((Object)((Object)SqlTypeName.ROW)).equals((Object)sqlTypeName) || !(relDataType instanceof RelRecordType)) break block28;
                                        mapType = this.toLogicalRowType(relDataType);
                                        break block6;
                                    }
                                    if (!((Object)((Object)SqlTypeName.STRUCTURED)).equals((Object)sqlTypeName) || !(relDataType instanceof StructuredRelDataType)) break block29;
                                    mapType = ((StructuredRelDataType)relDataType).getStructuredType();
                                    break block6;
                                }
                                if (!((Object)((Object)SqlTypeName.MULTISET)).equals((Object)sqlTypeName)) break block30;
                                mapType = new MultisetType(this.toLogicalType(relDataType.getComponentType()));
                                break block6;
                            }
                            if (!((Object)((Object)SqlTypeName.ARRAY)).equals((Object)sqlTypeName)) break block31;
                            mapType = new ArrayType(this.toLogicalType(relDataType.getComponentType()));
                            break block6;
                        }
                        if (!((Object)((Object)SqlTypeName.MAP)).equals((Object)sqlTypeName) || !(relDataType instanceof MapSqlType)) break block32;
                        MapSqlType mapRelDataType = (MapSqlType)relDataType;
                        mapType = new MapType(this.toLogicalType(mapRelDataType.getKeyType()), this.toLogicalType(mapRelDataType.getValueType()));
                        break block6;
                    }
                    if (!((Object)((Object)SqlTypeName.CURSOR)).equals((Object)sqlTypeName)) break block33;
                    mapType = new TypeInformationRawType((TypeInformation)new NothingTypeInfo());
                    break block6;
                }
                if (!((Object)((Object)SqlTypeName.OTHER)).equals((Object)sqlTypeName) || !(relDataType instanceof RawRelDataType)) break block34;
                mapType = ((RawRelDataType)relDataType).getRawType();
            }
            MapType logicalType = mapType;
            return logicalType.copy(relDataType.isNullable());
        }
        throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Type is not supported: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sqlTypeName})));
    }

    public TableSchema toTableSchema(RelDataType relDataType) {
        String[] fieldNames = (String[])relDataType.getFieldNames().toArray((Object[])new String[0]);
        DataType[] fieldTypes = (DataType[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(relDataType.getFieldList()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DataType apply(RelDataTypeField field) {
                return LogicalTypeDataTypeConverter.fromLogicalTypeToDataType((LogicalType)FlinkTypeFactory$.MODULE$.toLogicalType(field.getType()));
            }
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(DataType.class));
        return TableSchema.builder().fields(fieldNames, fieldTypes).build();
    }

    public RowType toLogicalRowType(RelDataType relType) {
        Preconditions.checkArgument((boolean)relType.isStruct());
        return RowType.of((LogicalType[])((LogicalType[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(relType.getFieldList()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LogicalType apply(RelDataTypeField fieldType) {
                return FlinkTypeFactory$.MODULE$.toLogicalType(fieldType.getType());
            }
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(LogicalType.class))), (String[])((String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(relType.getFieldNames()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class))));
    }

    private FlinkTypeFactory$() {
        MODULE$ = this;
        this.INSTANCE = new FlinkTypeFactory(new FlinkTypeSystem());
    }
}

