/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.physical.batch;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext$;
import org.apache.flink.table.planner.codegen.NestedLoopJoinCodeGenerator;
import org.apache.flink.table.planner.delegation.BatchPlanner;
import org.apache.flink.table.planner.plan.cost.FlinkCost$;
import org.apache.flink.table.planner.plan.cost.FlinkCostFactory;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode$;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchExecJoinBase;
import org.apache.flink.table.runtime.operators.CodeGenOperatorFactory;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.RowType;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rg\u0001B\u0001\u0003\u0001U\u0011qCQ1uG\",\u00050Z2OKN$X\r\u001a'p_BTu.\u001b8\u000b\u0005\r!\u0011!\u00022bi\u000eD'BA\u0003\u0007\u0003!\u0001\b._:jG\u0006d'BA\u0004\t\u0003\u0015qw\u000eZ3t\u0015\tI!\"\u0001\u0003qY\u0006t'BA\u0006\r\u0003\u001d\u0001H.\u00198oKJT!!\u0004\b\u0002\u000bQ\f'\r\\3\u000b\u0005=\u0001\u0012!\u00024mS:\\'BA\t\u0013\u0003\u0019\t\u0007/Y2iK*\t1#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001-A\u0011q\u0003G\u0007\u0002\u0005%\u0011\u0011D\u0001\u0002\u0012\u0005\u0006$8\r[#yK\u000eTu.\u001b8CCN,\u0007\u0002C\u000e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u000f\rdWo\u001d;feB\u0011Q$I\u0007\u0002=)\u0011\u0011b\b\u0006\u0003AA\tqaY1mG&$X-\u0003\u0002#=\ti!+\u001a7PaR\u001cE.^:uKJD\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!J\u0001\tiJ\f\u0017\u000e^*fiB\u0011QDJ\u0005\u0003Oy\u00111BU3m)J\f\u0017\u000e^*fi\"A\u0011\u0006\u0001B\u0001B\u0003%!&A\u0004mK\u001a$(+\u001a7\u0011\u0005-rS\"\u0001\u0017\u000b\u00055z\u0012a\u0001:fY&\u0011q\u0006\f\u0002\b%\u0016dgj\u001c3f\u0011!\t\u0004A!A!\u0002\u0013Q\u0013\u0001\u0003:jO\"$(+\u001a7\t\u0011M\u0002!\u0011!Q\u0001\nQ\n\u0011bY8oI&$\u0018n\u001c8\u0011\u0005UBT\"\u0001\u001c\u000b\u0005]z\u0012a\u0001:fq&\u0011\u0011H\u000e\u0002\b%\u0016Dhj\u001c3f\u0011!Y\u0004A!A!\u0002\u0013a\u0014\u0001\u00036pS:$\u0016\u0010]3\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}b\u0013\u0001B2pe\u0016L!!\u0011 \u0003\u0017){\u0017N\u001c*fYRK\b/\u001a\u0005\t\u0007\u0002\u0011)\u0019!C\u0001\t\u0006YA.\u001a4u\u0013N\u0014U/\u001b7e+\u0005)\u0005C\u0001$J\u001b\u00059%\"\u0001%\u0002\u000bM\u001c\u0017\r\\1\n\u0005);%a\u0002\"p_2,\u0017M\u001c\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u000b\u0006aA.\u001a4u\u0013N\u0014U/\u001b7eA!Aa\n\u0001BC\u0002\u0013\u0005A)A\u0007tS:<G.\u001a*po*{\u0017N\u001c\u0005\t!\u0002\u0011\t\u0011)A\u0005\u000b\u0006q1/\u001b8hY\u0016\u0014vn\u001e&pS:\u0004\u0003\"\u0002*\u0001\t\u0003\u0019\u0016A\u0002\u001fj]&$h\bF\u0005U+Z;\u0006,\u0017.\\9B\u0011q\u0003\u0001\u0005\u00067E\u0003\r\u0001\b\u0005\u0006IE\u0003\r!\n\u0005\u0006SE\u0003\rA\u000b\u0005\u0006cE\u0003\rA\u000b\u0005\u0006gE\u0003\r\u0001\u000e\u0005\u0006wE\u0003\r\u0001\u0010\u0005\u0006\u0007F\u0003\r!\u0012\u0005\u0006\u001dF\u0003\r!\u0012\u0005\u0006=\u0002!\teX\u0001\u0005G>\u0004\u0018\u0010F\u0004aG\u00124\u0007N[6\u0011\u0005u\n\u0017B\u00012?\u0005\u0011Qu.\u001b8\t\u000b\u0011j\u0006\u0019A\u0013\t\u000b\u0015l\u0006\u0019\u0001\u001b\u0002\u001b\r|g\u000eZ5uS>tW\t\u001f9s\u0011\u00159W\f1\u0001+\u0003\u0011aWM\u001a;\t\u000b%l\u0006\u0019\u0001\u0016\u0002\u000bILw\r\u001b;\t\u000bmj\u0006\u0019\u0001\u001f\t\u000b1l\u0006\u0019A#\u0002\u0019M,W.\u001b&pS:$uN\\3\t\u000b9\u0004A\u0011I8\u0002\u0019\u0015D\b\u000f\\1j]R+'/\\:\u0015\u0005A\u001c\bCA\u0016r\u0013\t\u0011HFA\u0005SK2<&/\u001b;fe\")A/\u001ca\u0001a\u0006\u0011\u0001o\u001e\u0005\u0006m\u0002!\te^\u0001\u0010G>l\u0007/\u001e;f'\u0016dgmQ8tiR\u0019\u0001p_@\u0011\u0005uI\u0018B\u0001>\u001f\u0005)\u0011V\r\\(qi\u000e{7\u000f\u001e\u0005\u0006\u0017U\u0004\r\u0001 \t\u0003;uL!A \u0010\u0003\u001bI+Gn\u00149u!2\fgN\\3s\u0011\u001d\t\t!\u001ea\u0001\u0003\u0007\t!!\\9\u0011\t\u0005\u0015\u00111B\u0007\u0003\u0003\u000fQ1!!\u0003-\u0003!iW\r^1eCR\f\u0017\u0002BA\u0007\u0003\u000f\u0011\u0001CU3m\u001b\u0016$\u0018\rZ1uCF+XM]=\t\u000f\u0005E\u0001\u0001\"\u0003\u0002\u0014\u0005\t2\u000f[;gM2,')^5mI\u000e{WO\u001c;\u0015\t\u0005U\u00111\u0004\t\u0004\r\u0006]\u0011bAA\r\u000f\n\u0019\u0011J\u001c;\t\u0011\u0005\u0005\u0011q\u0002a\u0001\u0003\u0007Aq!a\b\u0001\t\u0003\n\t#A\u0007tCRL7OZ=Ue\u0006LGo\u001d\u000b\u0005\u0003G\tI\u0003\u0005\u0003G\u0003KQ\u0013bAA\u0014\u000f\n1q\n\u001d;j_:Dq!a\u000b\u0002\u001e\u0001\u0007Q%\u0001\tsKF,\u0018N]3e)J\f\u0017\u000e^*fi\"9\u0011q\u0006\u0001\u0005B\u0005E\u0012!D4fi&s\u0007/\u001e;O_\u0012,7/\u0006\u0002\u00024A1\u0011QGA \u0003\u0007j!!a\u000e\u000b\t\u0005e\u00121H\u0001\u0005kRLGN\u0003\u0002\u0002>\u0005!!.\u0019<b\u0013\u0011\t\t%a\u000e\u0003\t1K7\u000f\u001e\u0019\u0005\u0003\u000b\n\t\u0007\u0005\u0005\u0002H\u00055\u0013\u0011KA/\u001b\t\tIEC\u0002\u0002L\u0019\tA!\u001a=fG&!\u0011qJA%\u0005!)\u00050Z2O_\u0012,\u0007\u0003BA*\u00033j!!!\u0016\u000b\u0007\u0005]#\"\u0001\u0006eK2,w-\u0019;j_:LA!a\u0017\u0002V\ta!)\u0019;dQBc\u0017M\u001c8feB!\u0011qLA1\u0019\u0001!A\"a\u0019\u0002.\u0005\u0005\t\u0011!B\u0001\u0003K\u00121a\u0018\u00132#\u0011\t9'!\u001c\u0011\u0007\u0019\u000bI'C\u0002\u0002l\u001d\u0013qAT8uQ&tw\rE\u0002G\u0003_J1!!\u001dH\u0005\r\te.\u001f\u0005\b\u0003k\u0002A\u0011IA<\u000359W\r^%oaV$X\tZ4fgV\u0011\u0011\u0011\u0010\t\u0007\u0003k\ty$a\u001f\u0011\t\u0005\u001d\u0013QP\u0005\u0005\u0003\u007f\nIE\u0001\u0005Fq\u0016\u001cW\tZ4f\u0011\u001d\t\u0019\t\u0001C!\u0003\u000b\u000b\u0001C]3qY\u0006\u001cW-\u00138qkRtu\u000eZ3\u0015\r\u0005\u001d\u0015QRAI!\r1\u0015\u0011R\u0005\u0004\u0003\u0017;%\u0001B+oSRD\u0001\"a$\u0002\u0002\u0002\u0007\u0011QC\u0001\u0010_J$\u0017N\\1m\u0013:\u0004\u0016M]3oi\"A\u00111SAA\u0001\u0004\t)*\u0001\u0007oK^Le\u000e];u\u001d>$W\r\r\u0003\u0002\u0018\u0006m\u0005\u0003CA$\u0003\u001b\n\t&!'\u0011\t\u0005}\u00131\u0014\u0003\r\u0003;\u000b\t*!A\u0001\u0002\u000b\u0005\u0011Q\r\u0002\u0004?\u0012\u001a\u0004bBAQ\u0001\u0011E\u00131U\u0001\u0018iJ\fgn\u001d7bi\u0016$v\u000e\u00157b]&sG/\u001a:oC2$B!!*\u0002BB1\u0011qUAY\u0003kk!!!+\u000b\t\u0005-\u0016QV\u0001\u0004I\u0006<'bAAX\u001d\u0005\u0019\u0011\r]5\n\t\u0005M\u0016\u0011\u0016\u0002\u000f)J\fgn\u001d4pe6\fG/[8o!\u0011\t9,!0\u000e\u0005\u0005e&bAA^\u0019\u0005!A-\u0019;b\u0013\u0011\ty,!/\u0003\u000fI{w\u000fR1uC\"91\"a(A\u0002\u0005E\u0003")
public class BatchExecNestedLoopJoin
extends BatchExecJoinBase {
    private final RelOptCluster cluster;
    private final RexNode condition;
    private final JoinRelType joinType;
    private final boolean leftIsBuild;
    private final boolean singleRowJoin;

    public boolean leftIsBuild() {
        return this.leftIsBuild;
    }

    public boolean singleRowJoin() {
        return this.singleRowJoin;
    }

    @Override
    public Join copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        return new BatchExecNestedLoopJoin(this.cluster, traitSet, left, right, conditionExpr, joinType, this.leftIsBuild(), this.singleRowJoin());
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("build", this.leftIsBuild() ? "left" : "right").itemIf("singleRowJoin", BoxesRunTime.boxToBoolean((boolean)this.singleRowJoin()), this.singleRowJoin());
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        Double leftRowCnt = mq.getRowCount(this.getLeft());
        Double rightRowCnt = mq.getRowCount(this.getRight());
        if (leftRowCnt == null || rightRowCnt == null) {
            return null;
        }
        RelNode buildRel = this.leftIsBuild() ? this.getLeft() : this.getRight();
        Double buildRows = mq.getRowCount(buildRel);
        Double buildRowSize = mq.getAverageRowSize(buildRel);
        double memoryCost = Predef$.MODULE$.Double2double(buildRows) * (Predef$.MODULE$.Double2double(buildRowSize) + (double)4) * (double)this.shuffleBuildCount(mq);
        double cpuCost = Predef$.MODULE$.Double2double(leftRowCnt) * Predef$.MODULE$.Double2double(rightRowCnt);
        FlinkCostFactory costFactory = (FlinkCostFactory)planner.getCostFactory();
        RelOptCost cost = costFactory.makeCost(Predef$.MODULE$.Double2double(mq.getRowCount(this)), cpuCost, 0.0, 0.0, memoryCost);
        return this.singleRowJoin() ? cost.multiplyBy(0.99) : cost;
    }

    private int shuffleBuildCount(RelMetadataQuery mq) {
        int n;
        RelNode probeRel = this.leftIsBuild() ? this.getRight() : this.getLeft();
        Double rowCount = mq.getRowCount(probeRel);
        if (rowCount == null) {
            n = 1;
        } else {
            Double probeRowSize = mq.getAverageRowSize(probeRel);
            n = Math.max(1, (int)(Predef$.MODULE$.Double2double(rowCount) * Predef$.MODULE$.Double2double(probeRowSize) / (double)FlinkCost$.MODULE$.SQL_DEFAULT_PARALLELISM_WORKER_PROCESS_SIZE()));
        }
        return n;
    }

    @Override
    public Option<RelNode> satisfyTraits(RelTraitSet requiredTraitSet) {
        return this.satisfyTraitsOnBroadcastJoin(requiredTraitSet, this.leftIsBuild());
    }

    @Override
    public List<ExecNode<BatchPlanner, ?>> getInputNodes() {
        return JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer(this.getInputs()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ExecNode<BatchPlanner, ?> apply(RelNode x$1) {
                return (ExecNode)((Object)x$1);
            }
        }, Buffer$.MODULE$.canBuildFrom()));
    }

    @Override
    public List<ExecEdge> getInputEdges() {
        Tuple2 tuple2;
        JoinRelType joinRelType = this.joinType;
        JoinRelType joinRelType2 = JoinRelType.FULL;
        Tuple2 tuple22 = !(joinRelType != null ? !((Object)((Object)joinRelType)).equals((Object)joinRelType2) : joinRelType2 != null) ? new Tuple2((Object)ExecEdge.RequiredShuffle.singleton(), (Object)ExecEdge.RequiredShuffle.singleton()) : (tuple2 = new Tuple2((Object)ExecEdge.RequiredShuffle.broadcast(), (Object)ExecEdge.RequiredShuffle.any()));
        if (tuple2 != null) {
            Tuple2 tuple23;
            ExecEdge.RequiredShuffle buildRequiredShuffle = (ExecEdge.RequiredShuffle)tuple2._1();
            ExecEdge.RequiredShuffle probeRequiredShuffle = (ExecEdge.RequiredShuffle)tuple2._2();
            Tuple2 tuple24 = tuple23 = new Tuple2((Object)buildRequiredShuffle, (Object)probeRequiredShuffle);
            ExecEdge.RequiredShuffle buildRequiredShuffle2 = (ExecEdge.RequiredShuffle)tuple24._1();
            ExecEdge.RequiredShuffle probeRequiredShuffle2 = (ExecEdge.RequiredShuffle)tuple24._2();
            ExecEdge buildEdge = ExecEdge.builder().requiredShuffle(buildRequiredShuffle2).damBehavior(ExecEdge.DamBehavior.BLOCKING).priority(0).build();
            ExecEdge probeEdge = ExecEdge.builder().requiredShuffle(probeRequiredShuffle2).damBehavior(ExecEdge.DamBehavior.PIPELINED).priority(1).build();
            return this.leftIsBuild() ? JavaConversions$.MODULE$.seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecEdge[]{buildEdge, probeEdge}))) : JavaConversions$.MODULE$.seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecEdge[]{probeEdge, buildEdge})));
        }
        throw new MatchError((Object)tuple2);
    }

    @Override
    public void replaceInputNode(int ordinalInParent, ExecNode<BatchPlanner, ?> newInputNode) {
        this.replaceInput(ordinalInParent, (RelNode)((Object)newInputNode));
    }

    @Override
    public Transformation<RowData> translateToPlanInternal(BatchPlanner planner) {
        Transformation<?> lInput = this.getInputNodes().get(0).translateToPlan(planner);
        Transformation<?> rInput = this.getInputNodes().get(1).translateToPlan(planner);
        RowType lType = ((InternalTypeInfo)lInput.getOutputType()).toRowType();
        RowType rType = ((InternalTypeInfo)rInput.getOutputType()).toRowType();
        RowType outputType = FlinkTypeFactory$.MODULE$.toLogicalRowType(this.getRowType());
        CodeGenOperatorFactory<RowData> op = new NestedLoopJoinCodeGenerator(CodeGeneratorContext$.MODULE$.apply(planner.getTableConfig()), this.singleRowJoin(), this.leftIsBuild(), lType, rType, outputType, this.flinkJoinType(), this.condition).gen();
        int parallelism = this.leftIsBuild() ? rInput.getParallelism() : lInput.getParallelism();
        long manageMem = this.singleRowJoin() ? 0L : MemorySize.parse((String)planner.getTableConfig().getConfiguration().getString(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_EXTERNAL_BUFFER_MEMORY)).getBytes();
        return ExecNode$.MODULE$.createTwoInputTransformation(lInput, rInput, this.getRelDetailedDescription(), op, InternalTypeInfo.of((RowType)outputType), parallelism, manageMem);
    }

    public BatchExecNestedLoopJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode leftRel, RelNode rightRel, RexNode condition, JoinRelType joinType, boolean leftIsBuild, boolean singleRowJoin) {
        this.cluster = cluster;
        this.condition = condition;
        this.joinType = joinType;
        this.leftIsBuild = leftIsBuild;
        this.singleRowJoin = singleRowJoin;
        super(cluster, traitSet, leftRel, rightRel, condition, joinType);
    }
}

