/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.physical.stream;

import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.KeyedProcessOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.plan.nodes.physical.stream.DeduplicateOperatorTranslator;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamExecDeduplicate;
import org.apache.flink.table.runtime.operators.bundle.KeyedMapBundleOperator;
import org.apache.flink.table.runtime.operators.bundle.MapBundleFunction;
import org.apache.flink.table.runtime.operators.bundle.trigger.BundleTrigger;
import org.apache.flink.table.runtime.operators.bundle.trigger.CountBundleTrigger;
import org.apache.flink.table.runtime.operators.deduplicate.RowTimeDeduplicateFunction;
import org.apache.flink.table.runtime.operators.deduplicate.RowTimeMiniBatchDeduplicateFunction;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.util.Preconditions;
import scala.Function1;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001U3A!\u0001\u0002\u0001+\t!#k\\<uS6,G)\u001a3va2L7-\u0019;f\u001fB,'/\u0019;peR\u0013\u0018M\\:mCR|'O\u0003\u0002\u0004\t\u000511\u000f\u001e:fC6T!!\u0002\u0004\u0002\u0011AD\u0017p]5dC2T!a\u0002\u0005\u0002\u000b9|G-Z:\u000b\u0005%Q\u0011\u0001\u00029mC:T!a\u0003\u0007\u0002\u000fAd\u0017M\u001c8fe*\u0011QBD\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u001fA\tQA\u001a7j].T!!\u0005\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0012aA8sO\u000e\u00011C\u0001\u0001\u0017!\t9\u0002$D\u0001\u0003\u0013\tI\"AA\u000fEK\u0012,\b\u000f\\5dCR,w\n]3sCR|'\u000f\u0016:b]Nd\u0017\r^8s\u0011!Y\u0002A!A!\u0002\u0013a\u0012a\u0003:poRK\b/Z%oM>\u00042!\b\u0012%\u001b\u0005q\"BA\u0010!\u0003%!\u0018\u0010]3vi&d7O\u0003\u0002\"\u0019\u00059!/\u001e8uS6,\u0017BA\u0012\u001f\u0005AIe\u000e^3s]\u0006dG+\u001f9f\u0013:4w\u000e\u0005\u0002&Q5\taE\u0003\u0002(\u0019\u0005!A-\u0019;b\u0013\tIcEA\u0004S_^$\u0015\r^1\t\u0011-\u0002!\u0011!Q\u0001\n1\n!b]3sS\u0006d\u0017N_3s!\ri3\u0007J\u0007\u0002])\u0011qd\f\u0006\u0003aE\naaY8n[>t'B\u0001\u001a\u000f\u0003\r\t\u0007/[\u0005\u0003i9\u0012a\u0002V=qKN+'/[1mSj,'\u000f\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0003-!\u0018M\u00197f\u0007>tg-[4\u0011\u0005aRT\"A\u001d\u000b\u0005Ib\u0011BA\u001e:\u0005-!\u0016M\u00197f\u0007>tg-[4\t\u0011u\u0002!\u0011!Q\u0001\ny\n1\u0002Z3ekBd\u0017nY1uKB\u0011qcP\u0005\u0003\u0001\n\u0011Qc\u0015;sK\u0006lW\t_3d\t\u0016$W\u000f\u001d7jG\u0006$X\rC\u0003C\u0001\u0011\u00051)\u0001\u0004=S:LGO\u0010\u000b\u0006\t\u00163u\t\u0013\t\u0003/\u0001AQaG!A\u0002qAQaK!A\u00021BQAN!A\u0002]BQ!P!A\u0002yBQA\u0013\u0001\u0005B-\u000b\u0011d\u0019:fCR,G)\u001a3va2L7-\u0019;f\u001fB,'/\u0019;peR\tA\n\u0005\u0003N'\u0012\"S\"\u0001(\u000b\u0005=\u0003\u0016!C8qKJ\fGo\u001c:t\u0015\t\u0011\u0014K\u0003\u0002S\u001d\u0005I1\u000f\u001e:fC6LgnZ\u0005\u0003):\u0013ac\u00148f\u0013:\u0004X\u000f^*ue\u0016\fWn\u00149fe\u0006$xN\u001d")
public class RowtimeDeduplicateOperatorTranslator
extends DeduplicateOperatorTranslator {
    private final InternalTypeInfo<RowData> rowTypeInfo;
    private final TypeSerializer<RowData> serializer;
    private final StreamExecDeduplicate deduplicate;

    @Override
    public OneInputStreamOperator<RowData, RowData> createDeduplicateOperator() {
        KeyedProcessOperator keyedProcessOperator;
        Buffer rowtimeField = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(this.deduplicate.getInput().getRowType().getFieldList()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(RelDataTypeField f) {
                return FlinkTypeFactory$.MODULE$.isRowtimeIndicatorType(f.getType());
            }
        });
        Preconditions.checkArgument((boolean)rowtimeField.nonEmpty());
        int rowtimeIndex = ((RelDataTypeField)JavaConversions$.MODULE$.bufferAsJavaList(rowtimeField).get(0)).getIndex();
        if (this.isMiniBatchEnabled()) {
            CountBundleTrigger trigger = new CountBundleTrigger(this.miniBatchSize());
            RowTimeMiniBatchDeduplicateFunction processFunction = new RowTimeMiniBatchDeduplicateFunction(this.rowTypeInfo, this.serializer, this.minRetentionTime(), rowtimeIndex, this.generateUpdateBefore(), this.generateInsert(), this.keepLastRow());
            keyedProcessOperator = new KeyedMapBundleOperator((MapBundleFunction)processFunction, (BundleTrigger)trigger);
        } else {
            RowTimeDeduplicateFunction processFunction = new RowTimeDeduplicateFunction(this.rowTypeInfo, this.minRetentionTime(), rowtimeIndex, this.generateUpdateBefore(), this.generateInsert(), this.keepLastRow());
            keyedProcessOperator = new KeyedProcessOperator((KeyedProcessFunction)processFunction);
        }
        return keyedProcessOperator;
    }

    public RowtimeDeduplicateOperatorTranslator(InternalTypeInfo<RowData> rowTypeInfo, TypeSerializer<RowData> serializer, TableConfig tableConfig, StreamExecDeduplicate deduplicate) {
        this.rowTypeInfo = rowTypeInfo;
        this.serializer = serializer;
        this.deduplicate = deduplicate;
        super(rowTypeInfo, serializer, tableConfig, deduplicate);
    }
}

