/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.Arrays;
import java.util.Collections;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rex.RexLiteral;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.abilities.SupportsLimitPushDown;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalSort;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalTableSourceScan;
import org.apache.flink.table.planner.plan.schema.FlinkPreparingTableBase;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;

public class PushLimitIntoTableSourceScanRule
extends RelOptRule {
    public static final PushLimitIntoTableSourceScanRule INSTANCE = new PushLimitIntoTableSourceScanRule();

    public PushLimitIntoTableSourceScanRule() {
        super(PushLimitIntoTableSourceScanRule.operand(FlinkLogicalSort.class, PushLimitIntoTableSourceScanRule.operand(FlinkLogicalTableSourceScan.class, PushLimitIntoTableSourceScanRule.none()), new RelOptRuleOperand[0]), "PushLimitIntoTableSourceScanRule");
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Sort sort = (Sort)call.rel(0);
        TableSourceTable tableSourceTable = call.rel(1).getTable().unwrap(TableSourceTable.class);
        boolean onlyLimit = sort.getCollation().getFieldCollations().isEmpty() && sort.fetch != null;
        return onlyLimit && tableSourceTable != null && tableSourceTable.tableSource() instanceof SupportsLimitPushDown && Arrays.stream(tableSourceTable.extraDigests()).noneMatch(str -> str.startsWith("limit=["));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Sort sort = (Sort)call.rel(0);
        FlinkLogicalTableSourceScan scan = (FlinkLogicalTableSourceScan)call.rel(1);
        TableSourceTable tableSourceTable = scan.getTable().unwrap(TableSourceTable.class);
        int offset = sort.offset == null ? 0 : RexLiteral.intValue(sort.offset);
        int limit = offset + RexLiteral.intValue(sort.fetch);
        TableSourceTable newTableSourceTable = this.applyLimit(limit, tableSourceTable);
        FlinkLogicalTableSourceScan newScan = FlinkLogicalTableSourceScan.create(scan.getCluster(), newTableSourceTable);
        RelNode newSort = sort.copy(sort.getTraitSet(), Collections.singletonList(newScan));
        call.transformTo(newSort);
    }

    private TableSourceTable applyLimit(long limit, FlinkPreparingTableBase relOptTable) {
        TableSourceTable oldTableSourceTable = relOptTable.unwrap(TableSourceTable.class);
        DynamicTableSource newTableSource = oldTableSourceTable.tableSource().copy();
        ((SupportsLimitPushDown)newTableSource).applyLimit(limit);
        FlinkStatistic statistic2 = relOptTable.getStatistic();
        long newRowCount = 0L;
        newRowCount = statistic2.getRowCount() != null ? Math.min(limit, statistic2.getRowCount().longValue()) : limit;
        TableStats newTableStats = new TableStats(newRowCount);
        FlinkStatistic newStatistic = FlinkStatistic.builder().statistic(statistic2).tableStats(newTableStats).build();
        String[] newExtraDigests = new String[]{"limit=[" + limit + "]"};
        return oldTableSourceTable.copy(newTableSource, newStatistic, newExtraDigests);
    }
}

