/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlGroupedWindowFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.expressions.PlannerProctimeAttribute;
import org.apache.flink.table.planner.expressions.PlannerRowtimeAttribute;
import org.apache.flink.table.planner.expressions.PlannerWindowEnd;
import org.apache.flink.table.planner.expressions.PlannerWindowStart;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.plan.logical.LogicalWindow;
import org.apache.flink.table.planner.plan.nodes.calcite.LogicalWindowAggregate;
import org.apache.flink.table.planner.plan.rules.logical.WindowPropertiesHavingRule;
import org.apache.flink.table.planner.plan.rules.logical.WindowPropertiesRule;
import org.apache.flink.table.planner.plan.utils.AggregateUtil$;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Symbol;
import scala.Symbol$;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;

public final class WindowPropertiesRules$ {
    public static final WindowPropertiesRules$ MODULE$;
    private final WindowPropertiesHavingRule WINDOW_PROPERTIES_HAVING_RULE;
    private final WindowPropertiesRule WINDOW_PROPERTIES_RULE;
    private static Symbol symbol$1;
    private static Symbol symbol$2;
    private static Symbol symbol$3;

    static {
        symbol$1 = Symbol$.MODULE$.apply("streamRowtime");
        symbol$2 = Symbol$.MODULE$.apply("streamProctime");
        symbol$3 = Symbol$.MODULE$.apply("batchRowtime");
        new WindowPropertiesRules$();
    }

    public WindowPropertiesHavingRule WINDOW_PROPERTIES_HAVING_RULE() {
        return this.WINDOW_PROPERTIES_HAVING_RULE;
    }

    public WindowPropertiesRule WINDOW_PROPERTIES_RULE() {
        return this.WINDOW_PROPERTIES_RULE;
    }

    public RelNode convertWindowNodes(RelBuilder builder, LogicalProject project, Option<LogicalFilter> filter, LogicalProject innerProject, LogicalWindowAggregate agg) {
        block5: {
            Seq seq;
            Seq startEndProperties;
            LogicalWindow w;
            block3: {
                String string;
                Symbol symbol;
                block4: {
                    String string2;
                    block2: {
                        String string3;
                        w = agg.getWindow();
                        Symbol windowType = this.getWindowType(w);
                        startEndProperties = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FlinkRelBuilder.PlannerNamedWindowProperty[]{new FlinkRelBuilder.PlannerNamedWindowProperty(this.propertyName(w, "start"), new PlannerWindowStart(w.aliasAttribute())), new FlinkRelBuilder.PlannerNamedWindowProperty(this.propertyName(w, "end"), new PlannerWindowEnd(w.aliasAttribute()))}));
                        symbol = windowType;
                        Option option = Symbol$.MODULE$.unapply((Object)symbol);
                        if (option.isEmpty() || !"streamRowtime".equals(string3 = (String)option.get())) break block2;
                        seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FlinkRelBuilder.PlannerNamedWindowProperty[]{new FlinkRelBuilder.PlannerNamedWindowProperty(this.propertyName(w, "rowtime"), new PlannerRowtimeAttribute(w.aliasAttribute())), new FlinkRelBuilder.PlannerNamedWindowProperty(this.propertyName(w, "proctime"), new PlannerProctimeAttribute(w.aliasAttribute()))}));
                        break block3;
                    }
                    Option option = Symbol$.MODULE$.unapply((Object)symbol);
                    if (option.isEmpty() || !"streamProctime".equals(string2 = (String)option.get())) break block4;
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FlinkRelBuilder.PlannerNamedWindowProperty[]{new FlinkRelBuilder.PlannerNamedWindowProperty(this.propertyName(w, "proctime"), new PlannerProctimeAttribute(w.aliasAttribute()))}));
                    break block3;
                }
                Option option = Symbol$.MODULE$.unapply((Object)symbol);
                if (option.isEmpty() || !"batchRowtime".equals(string = (String)option.get())) break block5;
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FlinkRelBuilder.PlannerNamedWindowProperty[]{new FlinkRelBuilder.PlannerNamedWindowProperty(this.propertyName(w, "rowtime"), new PlannerRowtimeAttribute(w.aliasAttribute()))}));
            }
            Seq timeProperties = seq;
            Seq properties = (Seq)startEndProperties.$plus$plus((GenTraversableOnce)timeProperties, Seq$.MODULE$.canBuildFrom());
            builder.push(agg.copy((Seq<FlinkRelBuilder.PlannerNamedWindowProperty>)properties));
            builder.project(JavaConversions$.MODULE$.bufferAsJavaList(JavaConversions$.MODULE$.asScalaBuffer(innerProject.getProjects()).$plus$plus((GenTraversableOnce)properties.map((Function1)new Serializable(builder){
                public static final long serialVersionUID = 0L;
                private final RelBuilder builder$1;

                public final RexInputRef apply(FlinkRelBuilder.PlannerNamedWindowProperty np) {
                    return this.builder$1.field(np.name());
                }
                {
                    this.builder$1 = builder$1;
                }
            }, Seq$.MODULE$.canBuildFrom()))));
            filter.foreach((Function1)new Serializable(builder, w){
                public static final long serialVersionUID = 0L;
                private final RelBuilder builder$1;
                private final LogicalWindow w$1;

                public final RelBuilder apply(LogicalFilter f) {
                    return this.builder$1.filter(WindowPropertiesRules$.MODULE$.replaceGroupAuxiliaries(f.getCondition(), this.w$1, this.builder$1));
                }
                {
                    this.builder$1 = builder$1;
                    this.w$1 = w$1;
                }
            });
            builder.project(JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer(project.getProjects()).map((Function1)new Serializable(builder, w){
                public static final long serialVersionUID = 0L;
                private final RelBuilder builder$1;
                private final LogicalWindow w$1;

                public final RexNode apply(RexNode expr) {
                    return WindowPropertiesRules$.MODULE$.replaceGroupAuxiliaries(expr, this.w$1, this.builder$1);
                }
                {
                    this.builder$1 = builder$1;
                    this.w$1 = w$1;
                }
            }, Buffer$.MODULE$.canBuildFrom())), project.getRowType().getFieldNames());
            return builder.build();
        }
        throw new TableException("Unknown window type encountered. Please report this bug.");
    }

    private Symbol getWindowType(LogicalWindow window) {
        block5: {
            Symbol symbol;
            block3: {
                block4: {
                    block2: {
                        if (!AggregateUtil$.MODULE$.isRowtimeAttribute(window.timeAttribute())) break block2;
                        symbol = symbol$1;
                        break block3;
                    }
                    if (!AggregateUtil$.MODULE$.isProctimeAttribute(window.timeAttribute())) break block4;
                    symbol = symbol$2;
                    break block3;
                }
                if (!LogicalTypeChecks.hasRoot((LogicalType)window.timeAttribute().getOutputDataType().getLogicalType(), (LogicalTypeRoot)LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE)) break block5;
                symbol = symbol$3;
            }
            return symbol;
        }
        throw new TableException("Unknown window type encountered. Please report this bug.");
    }

    private String propertyName(LogicalWindow window, String name) {
        return new StringBuilder().append((Object)window.aliasAttribute().name()).append((Object)name).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RexNode replaceGroupAuxiliaries(RexNode node, LogicalWindow window, RelBuilder builder) {
        RexBuilder rexBuilder = builder.getRexBuilder();
        Symbol windowType = this.getWindowType(window);
        boolean bl = false;
        RexCall rexCall = null;
        RexNode rexNode = node;
        if (rexNode instanceof RexCall) {
            bl = true;
            rexCall = (RexCall)rexNode;
            if (this.isWindowStart(rexCall)) {
                return rexBuilder.makeCast(rexCall.getType(), builder.field(this.propertyName(window, "start")), false);
            }
        }
        if (bl && this.isWindowEnd(rexCall)) {
            return rexBuilder.makeCast(rexCall.getType(), builder.field(this.propertyName(window, "end")), false);
        }
        if (bl && this.isWindowRowtime(rexCall)) {
            String string;
            Option option;
            String string2;
            Symbol symbol = windowType;
            Option option2 = Symbol$.MODULE$.unapply((Object)symbol);
            boolean bl2 = !option2.isEmpty() && "streamRowtime".equals(string2 = (String)option2.get()) ? true : !(option = Symbol$.MODULE$.unapply((Object)symbol)).isEmpty() && "batchRowtime".equals(string = (String)option.get());
            if (bl2) {
                RexNode rexNode2 = rexBuilder.makeCast(rexCall.getType(), builder.field(this.propertyName(window, "rowtime")), false);
                return rexNode2;
            }
            Option option3 = Symbol$.MODULE$.unapply((Object)symbol);
            if (option3.isEmpty()) throw new TableException("Unknown window type encountered. Please report this bug.");
            String string3 = (String)option3.get();
            if (!"streamProctime".equals(string3)) throw new TableException("Unknown window type encountered. Please report this bug.");
            throw new ValidationException("A proctime window cannot provide a rowtime attribute.");
        }
        if (bl && this.isWindowProctime(rexCall)) {
            String string;
            Option option;
            String string4;
            Symbol symbol = windowType;
            Option option4 = Symbol$.MODULE$.unapply((Object)symbol);
            boolean bl3 = !option4.isEmpty() && "streamProctime".equals(string4 = (String)option4.get()) ? true : !(option = Symbol$.MODULE$.unapply((Object)symbol)).isEmpty() && "streamRowtime".equals(string = (String)option.get());
            if (bl3) {
                RexNode rexNode3 = rexBuilder.makeCast(rexCall.getType(), builder.field(this.propertyName(window, "proctime")), false);
                return rexNode3;
            }
            Option option5 = Symbol$.MODULE$.unapply((Object)symbol);
            if (option5.isEmpty()) throw new TableException("Unknown window type encountered. Please report this bug.");
            String string5 = (String)option5.get();
            if (!"batchRowtime".equals(string5)) throw new TableException("Unknown window type encountered. Please report this bug.");
            throw new ValidationException("PROCTIME window property is not supported in batch queries.");
        }
        if (!bl) return rexNode;
        Buffer newOps = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(rexCall.getOperands()).map((Function1)new Serializable(window, builder){
            public static final long serialVersionUID = 0L;
            private final LogicalWindow window$1;
            private final RelBuilder builder$2;

            public final RexNode apply(RexNode x$1) {
                return WindowPropertiesRules$.MODULE$.replaceGroupAuxiliaries(x$1, this.window$1, this.builder$2);
            }
            {
                this.window$1 = window$1;
                this.builder$2 = builder$2;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        return rexCall.clone(rexCall.getType(), JavaConversions$.MODULE$.bufferAsJavaList(newOps));
    }

    private boolean isWindowStart(RexNode node) {
        boolean bl;
        RexCall rexCall;
        RexNode rexNode = node;
        if (rexNode instanceof RexCall && (rexCall = (RexCall)rexNode).getOperator().isGroupAuxiliary()) {
            boolean bl2;
            SqlOperator sqlOperator = rexCall.getOperator();
            SqlGroupedWindowFunction sqlGroupedWindowFunction = FlinkSqlOperatorTable.TUMBLE_START;
            SqlOperator sqlOperator2 = sqlOperator;
            if (!(sqlGroupedWindowFunction != null ? !((Object)sqlGroupedWindowFunction).equals(sqlOperator2) : sqlOperator2 != null)) {
                bl2 = true;
            } else {
                SqlGroupedWindowFunction sqlGroupedWindowFunction2 = FlinkSqlOperatorTable.HOP_START;
                SqlOperator sqlOperator3 = sqlOperator;
                if (!(sqlGroupedWindowFunction2 != null ? !((Object)sqlGroupedWindowFunction2).equals(sqlOperator3) : sqlOperator3 != null)) {
                    bl2 = true;
                } else {
                    SqlGroupedWindowFunction sqlGroupedWindowFunction3 = FlinkSqlOperatorTable.SESSION_START;
                    SqlOperator sqlOperator4 = sqlOperator;
                    bl2 = !(sqlGroupedWindowFunction3 != null ? !((Object)sqlGroupedWindowFunction3).equals(sqlOperator4) : sqlOperator4 != null);
                }
            }
            boolean bl3 = bl2;
            bl = bl3;
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean isWindowEnd(RexNode node) {
        boolean bl;
        RexCall rexCall;
        RexNode rexNode = node;
        if (rexNode instanceof RexCall && (rexCall = (RexCall)rexNode).getOperator().isGroupAuxiliary()) {
            boolean bl2;
            SqlOperator sqlOperator = rexCall.getOperator();
            SqlGroupedWindowFunction sqlGroupedWindowFunction = FlinkSqlOperatorTable.TUMBLE_END;
            SqlOperator sqlOperator2 = sqlOperator;
            if (!(sqlGroupedWindowFunction != null ? !((Object)sqlGroupedWindowFunction).equals(sqlOperator2) : sqlOperator2 != null)) {
                bl2 = true;
            } else {
                SqlGroupedWindowFunction sqlGroupedWindowFunction2 = FlinkSqlOperatorTable.HOP_END;
                SqlOperator sqlOperator3 = sqlOperator;
                if (!(sqlGroupedWindowFunction2 != null ? !((Object)sqlGroupedWindowFunction2).equals(sqlOperator3) : sqlOperator3 != null)) {
                    bl2 = true;
                } else {
                    SqlGroupedWindowFunction sqlGroupedWindowFunction3 = FlinkSqlOperatorTable.SESSION_END;
                    SqlOperator sqlOperator4 = sqlOperator;
                    bl2 = !(sqlGroupedWindowFunction3 != null ? !((Object)sqlGroupedWindowFunction3).equals(sqlOperator4) : sqlOperator4 != null);
                }
            }
            boolean bl3 = bl2;
            bl = bl3;
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean isWindowRowtime(RexNode node) {
        boolean bl;
        RexCall rexCall;
        RexNode rexNode = node;
        if (rexNode instanceof RexCall && (rexCall = (RexCall)rexNode).getOperator().isGroupAuxiliary()) {
            boolean bl2;
            SqlOperator sqlOperator = rexCall.getOperator();
            SqlGroupedWindowFunction sqlGroupedWindowFunction = FlinkSqlOperatorTable.TUMBLE_ROWTIME;
            SqlOperator sqlOperator2 = sqlOperator;
            if (!(sqlGroupedWindowFunction != null ? !((Object)sqlGroupedWindowFunction).equals(sqlOperator2) : sqlOperator2 != null)) {
                bl2 = true;
            } else {
                SqlGroupedWindowFunction sqlGroupedWindowFunction2 = FlinkSqlOperatorTable.HOP_ROWTIME;
                SqlOperator sqlOperator3 = sqlOperator;
                if (!(sqlGroupedWindowFunction2 != null ? !((Object)sqlGroupedWindowFunction2).equals(sqlOperator3) : sqlOperator3 != null)) {
                    bl2 = true;
                } else {
                    SqlGroupedWindowFunction sqlGroupedWindowFunction3 = FlinkSqlOperatorTable.SESSION_ROWTIME;
                    SqlOperator sqlOperator4 = sqlOperator;
                    bl2 = !(sqlGroupedWindowFunction3 != null ? !((Object)sqlGroupedWindowFunction3).equals(sqlOperator4) : sqlOperator4 != null);
                }
            }
            boolean bl3 = bl2;
            bl = bl3;
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean isWindowProctime(RexNode node) {
        boolean bl;
        RexCall rexCall;
        RexNode rexNode = node;
        if (rexNode instanceof RexCall && (rexCall = (RexCall)rexNode).getOperator().isGroupAuxiliary()) {
            boolean bl2;
            SqlOperator sqlOperator = rexCall.getOperator();
            SqlGroupedWindowFunction sqlGroupedWindowFunction = FlinkSqlOperatorTable.TUMBLE_PROCTIME;
            SqlOperator sqlOperator2 = sqlOperator;
            if (!(sqlGroupedWindowFunction != null ? !((Object)sqlGroupedWindowFunction).equals(sqlOperator2) : sqlOperator2 != null)) {
                bl2 = true;
            } else {
                SqlGroupedWindowFunction sqlGroupedWindowFunction2 = FlinkSqlOperatorTable.HOP_PROCTIME;
                SqlOperator sqlOperator3 = sqlOperator;
                if (!(sqlGroupedWindowFunction2 != null ? !((Object)sqlGroupedWindowFunction2).equals(sqlOperator3) : sqlOperator3 != null)) {
                    bl2 = true;
                } else {
                    SqlGroupedWindowFunction sqlGroupedWindowFunction3 = FlinkSqlOperatorTable.SESSION_PROCTIME;
                    SqlOperator sqlOperator4 = sqlOperator;
                    bl2 = !(sqlGroupedWindowFunction3 != null ? !((Object)sqlGroupedWindowFunction3).equals(sqlOperator4) : sqlOperator4 != null);
                }
            }
            boolean bl3 = bl2;
            bl = bl3;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasGroupAuxiliaries(RexNode node) {
        boolean bl = false;
        RexCall rexCall = null;
        RexNode rexNode = node;
        if (rexNode instanceof RexCall) {
            bl = true;
            rexCall = (RexCall)rexNode;
            if (rexCall.getOperator().isGroupAuxiliary()) {
                return true;
            }
        }
        if (!bl) return false;
        return JavaConversions$.MODULE$.asScalaBuffer(rexCall.operands).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(RexNode node) {
                return WindowPropertiesRules$.MODULE$.hasGroupAuxiliaries(node);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasGroupFunction(RexNode node) {
        boolean bl = false;
        RexCall rexCall = null;
        RexNode rexNode = node;
        if (rexNode instanceof RexCall) {
            bl = true;
            rexCall = (RexCall)rexNode;
            if (rexCall.getOperator().isGroup()) {
                return true;
            }
        }
        if (!bl) return false;
        return JavaConversions$.MODULE$.asScalaBuffer(rexCall.operands).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(RexNode node) {
                return WindowPropertiesRules$.MODULE$.hasGroupFunction(node);
            }
        });
    }

    private WindowPropertiesRules$() {
        MODULE$ = this;
        this.WINDOW_PROPERTIES_HAVING_RULE = new WindowPropertiesHavingRule();
        this.WINDOW_PROPERTIES_RULE = new WindowPropertiesRule();
    }
}

