/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import java.util.Collection;
import java.util.List;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.InputDependencyConstraint;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.runtime.jobgraph.ScheduleMode;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.GlobalDataExchangeMode;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.StreamGraphGenerator;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.planner.utils.ShuffleModeUtils;

public class ExecutorUtils {
    public static StreamGraph generateStreamGraph(StreamExecutionEnvironment execEnv, List<Transformation<?>> transformations) {
        if (transformations.size() <= 0) {
            throw new IllegalStateException("No operators defined in streaming topology. Cannot generate StreamGraph.");
        }
        StreamGraphGenerator generator = new StreamGraphGenerator(transformations, execEnv.getConfig(), execEnv.getCheckpointConfig()).setStateBackend(execEnv.getStateBackend()).setChaining(execEnv.isChainingEnabled()).setUserArtifacts((Collection)execEnv.getCachedFiles()).setTimeCharacteristic(execEnv.getStreamTimeCharacteristic()).setDefaultBufferTimeout(execEnv.getBufferTimeout());
        return generator.generate();
    }

    public static void setBatchProperties(StreamExecutionEnvironment execEnv, TableConfig tableConfig) {
        ExecutionConfig executionConfig = execEnv.getConfig();
        executionConfig.enableObjectReuse();
        executionConfig.setLatencyTrackingInterval(-1L);
        execEnv.getConfig().setAutoWatermarkInterval(0L);
        execEnv.setBufferTimeout(-1L);
        if (ExecutorUtils.isShuffleModeAllBlocking(tableConfig)) {
            executionConfig.setDefaultInputDependencyConstraint(InputDependencyConstraint.ALL);
        }
    }

    public static void setBatchProperties(StreamGraph streamGraph, TableConfig tableConfig) {
        streamGraph.getStreamNodes().forEach(sn -> sn.setResources(ResourceSpec.UNKNOWN, ResourceSpec.UNKNOWN));
        streamGraph.setChaining(true);
        streamGraph.setAllVerticesInSameSlotSharingGroupByDefault(false);
        streamGraph.setScheduleMode(ScheduleMode.LAZY_FROM_SOURCES_WITH_BATCH_SLOT_REQUEST);
        streamGraph.setStateBackend(null);
        if (streamGraph.getCheckpointConfig().isCheckpointingEnabled()) {
            throw new IllegalArgumentException("Checkpoint is not supported for batch jobs.");
        }
        streamGraph.setGlobalDataExchangeMode(ExecutorUtils.getGlobalDataExchangeMode(tableConfig));
    }

    private static boolean isShuffleModeAllBlocking(TableConfig tableConfig) {
        return ExecutorUtils.getGlobalDataExchangeMode(tableConfig) == GlobalDataExchangeMode.ALL_EDGES_BLOCKING;
    }

    private static GlobalDataExchangeMode getGlobalDataExchangeMode(TableConfig tableConfig) {
        return ShuffleModeUtils.getShuffleModeAsGlobalDataExchangeMode(tableConfig.getConfiguration());
    }
}

