/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.inference;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.functions.inference.OperatorBindingCallContext;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeInferenceUtil;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.logical.LogicalType;

@Internal
public final class TypeInferenceReturnInference
implements SqlReturnTypeInference {
    private final DataTypeFactory dataTypeFactory;
    private final FunctionDefinition definition;
    private final TypeInference typeInference;

    public TypeInferenceReturnInference(DataTypeFactory dataTypeFactory, FunctionDefinition definition, TypeInference typeInference) {
        this.dataTypeFactory = dataTypeFactory;
        this.definition = definition;
        this.typeInference = typeInference;
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        OperatorBindingCallContext callContext = new OperatorBindingCallContext(this.dataTypeFactory, this.definition, opBinding, null);
        try {
            return this.inferReturnTypeOrError(ShortcutUtils.unwrapTypeFactory(opBinding), callContext);
        }
        catch (ValidationException e) {
            throw TypeInferenceUtil.createInvalidCallException((CallContext)callContext, (ValidationException)e);
        }
        catch (Throwable t) {
            throw TypeInferenceUtil.createUnexpectedException((CallContext)callContext, (Throwable)t);
        }
    }

    private RelDataType inferReturnTypeOrError(FlinkTypeFactory typeFactory, CallContext callContext) {
        LogicalType inferredType = TypeInferenceUtil.inferOutputType((CallContext)callContext, (TypeStrategy)this.typeInference.getOutputTypeStrategy()).getLogicalType();
        return typeFactory.createFieldTypeFromLogicalType(inferredType);
    }
}

