/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.sources;

import java.sql.Timestamp;
import java.util.List;
import java.util.function.Function;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.ResolvedFieldReference;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.expressions.converter.ExpressionConverter;
import org.apache.flink.table.runtime.types.DataTypePrecisionFixer;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.runtime.types.TypeInfoLogicalTypeConverter;
import org.apache.flink.table.sources.DefinedFieldMapping;
import org.apache.flink.table.sources.DefinedProctimeAttribute;
import org.apache.flink.table.sources.DefinedRowtimeAttributes;
import org.apache.flink.table.sources.RowtimeAttributeDescriptor;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.sources.tsextractors.TimestampExtractor;
import org.apache.flink.table.sources.tsextractors.TimestampExtractorUtils;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypeVisitor;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class TableSourceUtil$ {
    public static final TableSourceUtil$ MODULE$;

    static {
        new TableSourceUtil$();
    }

    public DataType fixPrecisionForProducedDataType(TableSource<?> tableSource, RowType logicalSchema) {
        Option<String> option;
        block7: {
            LogicalType logicalType;
            LogicalType sourceLogicalType;
            RowType rowType;
            block6: {
                block5: {
                    option = this.getProctimeAttribute(tableSource);
                    if (!(option instanceof Some)) break block5;
                    Some some = (Some)option;
                    String proctime2 = (String)some.x();
                    List fields2 = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)JavaConversions$.MODULE$.asScalaBuffer(logicalSchema.getFields()).filter((Function1)new Serializable(proctime2){
                        public static final long serialVersionUID = 0L;
                        private final String proctime$1;

                        public final boolean apply(RowType.RowField f) {
                            return !f.getName().equals(this.proctime$1);
                        }
                        {
                            this.proctime$1 = proctime$1;
                        }
                    })).asJava();
                    rowType = new RowType(logicalSchema.isNullable(), fields2);
                    break block6;
                }
                if (!None$.MODULE$.equals(option)) break block7;
                rowType = logicalSchema;
            }
            RowType schemaWithoutProctime = rowType;
            LogicalType logicalType2 = sourceLogicalType = LogicalTypeDataTypeConverter.fromDataTypeToLogicalType((DataType)tableSource.getProducedDataType());
            if (logicalType2 instanceof RowType) {
                RowType rowType2 = (RowType)logicalType2;
                Map logicalNamesToTypes = ((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(schemaWithoutProctime.getFields()).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, LogicalType> apply(RowType.RowField f) {
                        return new Tuple2((Object)f.getName(), (Object)f.getType());
                    }
                }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                List fields3 = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)JavaConversions$.MODULE$.asScalaBuffer(rowType2.getFields()).map((Function1)new Serializable(tableSource, logicalNamesToTypes){
                    public static final long serialVersionUID = 0L;
                    private final TableSource tableSource$1;
                    private final Map logicalNamesToTypes$1;

                    public final RowType.RowField apply(RowType.RowField f) {
                        Some some;
                        String n;
                        Option option = TableSourceUtil$.MODULE$.org$apache$flink$table$planner$sources$TableSourceUtil$$mapping$1(f.getName(), this.tableSource$1);
                        LogicalType logicalType = option instanceof Some && this.logicalNamesToTypes$1.contains((Object)(n = (String)(some = (Some)option).x())) ? (LogicalType)this.logicalNamesToTypes$1.apply((Object)n) : f.getType();
                        LogicalType t = logicalType;
                        return new RowType.RowField(f.getName(), t);
                    }
                    {
                        this.tableSource$1 = tableSource$1;
                        this.logicalNamesToTypes$1 = logicalNamesToTypes$1;
                    }
                }, Buffer$.MODULE$.canBuildFrom())).asJava();
                logicalType = new RowType(schemaWithoutProctime.isNullable(), fields3);
            } else {
                logicalType = ((RowType.RowField)schemaWithoutProctime.getFields().get(0)).getType();
            }
            LogicalType correspondingLogicalType = logicalType;
            return (DataType)tableSource.getProducedDataType().accept((DataTypeVisitor)new DataTypePrecisionFixer(correspondingLogicalType));
        }
        throw new MatchError(option);
    }

    public RelDataType getSourceRowTypeFromSource(FlinkTypeFactory typeFactory, TableSource<?> tableSource, boolean streaming) {
        TableSchema tableSchema = tableSource.getTableSchema();
        String[] fieldNames = tableSchema.getFieldNames();
        DataType[] fieldDataTypes = tableSchema.getFieldDataTypes();
        ObjectRef fieldTypes = ObjectRef.create((Object)((LogicalType[])Predef$.MODULE$.refArrayOps((Object[])fieldDataTypes).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LogicalType apply(DataType x$1) {
                return LogicalTypeDataTypeConverter.fromDataTypeToLogicalType((DataType)x$1);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogicalType.class)))));
        if (streaming) {
            String[] rowtimeAttributes = this.getRowtimeAttributes(tableSource);
            Option<String> proctimeAttributes = this.getProctimeAttribute(tableSource);
            Predef$.MODULE$.refArrayOps((Object[])rowtimeAttributes).foreach((Function1)new Serializable(fieldNames, fieldTypes){
                public static final long serialVersionUID = 0L;
                private final String[] fieldNames$1;
                private final ObjectRef fieldTypes$1;

                public final void apply(String rowtimeField) {
                    int idx = Predef$.MODULE$.refArrayOps((Object[])this.fieldNames$1).indexOf((Object)rowtimeField);
                    TimestampType rowtimeType = new TimestampType(true, TimestampKind.ROWTIME, 3);
                    this.fieldTypes$1.elem = (LogicalType[])Predef$.MODULE$.refArrayOps((Object[])((LogicalType[])this.fieldTypes$1.elem)).patch(idx, (GenSeq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TimestampType[]{rowtimeType})), 1, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogicalType.class)));
                }
                {
                    this.fieldNames$1 = fieldNames$1;
                    this.fieldTypes$1 = fieldTypes$1;
                }
            });
            proctimeAttributes.foreach((Function1)new Serializable(fieldNames, fieldTypes){
                public static final long serialVersionUID = 0L;
                private final String[] fieldNames$1;
                private final ObjectRef fieldTypes$1;

                public final void apply(String proctimeField) {
                    int idx = Predef$.MODULE$.refArrayOps((Object[])this.fieldNames$1).indexOf((Object)proctimeField);
                    LocalZonedTimestampType proctimeType = new LocalZonedTimestampType(true, TimestampKind.PROCTIME, 3);
                    this.fieldTypes$1.elem = (LogicalType[])Predef$.MODULE$.refArrayOps((Object[])((LogicalType[])this.fieldTypes$1.elem)).patch(idx, (GenSeq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LocalZonedTimestampType[]{proctimeType})), 1, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogicalType.class)));
                }
                {
                    this.fieldNames$1 = fieldNames$1;
                    this.fieldTypes$1 = fieldTypes$1;
                }
            });
        }
        return typeFactory.buildRelNodeRowType((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])fieldNames), (Seq<LogicalType>)Predef$.MODULE$.wrapRefArray((Object[])((LogicalType[])fieldTypes.elem)));
    }

    public RelDataType getSourceRowType(FlinkTypeFactory typeFactory, TableSchema tableSchema, Option<TableSource<?>> tableSource, boolean streaming) {
        RelDataType relDataType;
        String[] fieldNames = tableSchema.getFieldNames();
        DataType[] fieldDataTypes = tableSchema.getFieldDataTypes();
        if (tableSource.isDefined()) {
            relDataType = this.getSourceRowTypeFromSource(typeFactory, (TableSource)tableSource.get(), streaming);
        } else {
            LogicalType[] fieldTypes = (LogicalType[])Predef$.MODULE$.refArrayOps((Object[])fieldDataTypes).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final LogicalType apply(DataType x$1) {
                    return LogicalTypeDataTypeConverter.fromDataTypeToLogicalType((DataType)x$1);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogicalType.class)));
            relDataType = typeFactory.buildRelNodeRowType((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])fieldNames), (Seq<LogicalType>)Predef$.MODULE$.wrapRefArray((Object[])fieldTypes));
        }
        return relDataType;
    }

    public Option<RowtimeAttributeDescriptor> getRowtimeAttributeDescriptor(TableSource<?> tableSource, RelDataType rowType) {
        None$ none$;
        TableSource<?> tableSource2 = tableSource;
        if (tableSource2 instanceof DefinedRowtimeAttributes) {
            Object object;
            DefinedRowtimeAttributes definedRowtimeAttributes = (DefinedRowtimeAttributes)tableSource2;
            List descriptors = definedRowtimeAttributes.getRowtimeAttributeDescriptors();
            if (descriptors.size() == 0) {
                object = None$.MODULE$;
            } else {
                if (descriptors.size() > 1) {
                    throw new ValidationException("Table with has more than a single rowtime attribute..");
                }
                RowtimeAttributeDescriptor descriptor = (RowtimeAttributeDescriptor)descriptors.get(0);
                object = rowType.getFieldNames().contains(descriptor.getAttributeName()) ? new Some((Object)descriptor) : None$.MODULE$;
            }
            none$ = object;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public RexNode getRowtimeExtractionExpression(TimestampExtractor extractor, DataType physicalInputType, RelBuilder relBuilder, Function<String, String> nameMapping) {
        ResolvedFieldReference[] accessedFields = TimestampExtractorUtils.getAccessedFields((TimestampExtractor)extractor, (DataType)physicalInputType, nameMapping);
        relBuilder.push(this.createSchemaRelNode(accessedFields, relBuilder.getCluster()));
        RexNode expr = (RexNode)this.constructExpression(extractor, accessedFields).accept((ExpressionVisitor)new ExpressionConverter(relBuilder));
        relBuilder.clear();
        return expr;
    }

    private RelNode createSchemaRelNode(ResolvedFieldReference[] fields2, RelOptCluster cluster) {
        int maxIdx = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])fields2).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(ResolvedFieldReference x$2) {
                return x$2.fieldIndex();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).max((Ordering)Ordering.Int$.MODULE$));
        Map idxMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])fields2).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Tuple2<String, LogicalType>> apply(ResolvedFieldReference f) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)f.fieldIndex())), (Object)new Tuple2((Object)f.name(), (Object)TypeInfoLogicalTypeConverter.fromTypeInfoToLogicalType((TypeInformation)f.resultType())));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))));
        Tuple2 tuple2 = ((GenericTraversableTemplate)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), maxIdx).map((Function1)new Serializable(idxMap){
            public static final long serialVersionUID = 0L;
            private final Map idxMap$1;

            public final Tuple2<String, LogicalType> apply(int i) {
                return (Tuple2)this.idxMap$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)i), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, TinyIntType> apply() {
                        return new Tuple2((Object)"", (Object)new TinyIntType());
                    }
                });
            }
            {
                this.idxMap$1 = idxMap$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 != null) {
            Tuple2 tuple22;
            IndexedSeq physicalFields = (IndexedSeq)tuple2._1();
            IndexedSeq physicalTypes = (IndexedSeq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)physicalFields, (Object)physicalTypes);
            IndexedSeq physicalFields2 = (IndexedSeq)tuple23._1();
            IndexedSeq physicalTypes2 = (IndexedSeq)tuple23._2();
            RelDataType physicalSchema = ((FlinkTypeFactory)cluster.getTypeFactory()).buildRelNodeRowType((Seq<String>)physicalFields2, (Seq<LogicalType>)physicalTypes2);
            return LogicalValues.createEmpty(cluster, physicalSchema);
        }
        throw new MatchError((Object)tuple2);
    }

    private Expression constructExpression(TimestampExtractor timestampExtractor, ResolvedFieldReference[] fieldAccesses) {
        Expression expression2 = timestampExtractor.getExpression(fieldAccesses);
        DataType outputType = (DataType)DataTypes.TIMESTAMP((int)3).bridgedTo(Timestamp.class);
        return new CallExpression((FunctionDefinition)BuiltInFunctionDefinitions.REINTERPRET_CAST, JavaConversions$.MODULE$.seqAsJavaList((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ResolvedExpression[]{(ResolvedExpression)expression2, ApiExpressionUtils.typeLiteral((DataType)outputType), ApiExpressionUtils.valueLiteral((Object)BoxesRunTime.boxToBoolean((boolean)false))}))), outputType);
    }

    private String[] getRowtimeAttributes(TableSource<?> tableSource) {
        String[] stringArray;
        TableSource<?> tableSource2 = tableSource;
        if (tableSource2 instanceof DefinedRowtimeAttributes) {
            DefinedRowtimeAttributes definedRowtimeAttributes = (DefinedRowtimeAttributes)tableSource2;
            stringArray = (String[])((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(definedRowtimeAttributes.getRowtimeAttributeDescriptors()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(RowtimeAttributeDescriptor x$4) {
                    return x$4.getAttributeName();
                }
            }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        } else {
            stringArray = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        }
        return stringArray;
    }

    private Option<String> getProctimeAttribute(TableSource<?> tableSource) {
        DefinedProctimeAttribute definedProctimeAttribute;
        TableSource<?> tableSource2 = tableSource;
        Object object = tableSource2 instanceof DefinedProctimeAttribute && (definedProctimeAttribute = (DefinedProctimeAttribute)tableSource2).getProctimeAttribute() != null ? new Some((Object)definedProctimeAttribute.getProctimeAttribute()) : None$.MODULE$;
        return object;
    }

    public final Option org$apache$flink$table$planner$sources$TableSourceUtil$$mapping$1(String physicalName, TableSource tableSource$1) {
        Some some;
        DefinedFieldMapping definedFieldMapping;
        TableSource tableSource = tableSource$1;
        if (tableSource instanceof DefinedFieldMapping && (definedFieldMapping = (DefinedFieldMapping)tableSource).getFieldMapping() != null) {
            Map map = (Map)JavaConversions$.MODULE$.mapAsScalaMap(definedFieldMapping.getFieldMapping()).toMap(Predef$.MODULE$.$conforms()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, String> apply(Tuple2<String, String> x$1) {
                    return x$1.swap();
                }
            }, Map$.MODULE$.canBuildFrom());
            some = map.get((Object)physicalName);
        } else {
            some = new Some((Object)physicalName);
        }
        return some;
    }

    private TableSourceUtil$() {
        MODULE$ = this;
    }
}

