/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.stream;

import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.TableScan;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.planner.connectors.DynamicSourceUtils;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions$;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalTableSourceScan;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalChangelogNormalize;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalTableSourceScan;
import org.apache.flink.table.planner.plan.rules.physical.stream.StreamPhysicalTableSourceScanRule$;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistribution;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistribution$;
import org.apache.flink.table.planner.plan.utils.ScanUtil$;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t4A!\u0001\u0002\u0001+\t\t3\u000b\u001e:fC6\u0004\u0006._:jG\u0006dG+\u00192mKN{WO]2f'\u000e\fgNU;mK*\u00111\u0001B\u0001\u0007gR\u0014X-Y7\u000b\u0005\u00151\u0011\u0001\u00039isNL7-\u00197\u000b\u0005\u001dA\u0011!\u0002:vY\u0016\u001c(BA\u0005\u000b\u0003\u0011\u0001H.\u00198\u000b\u0005-a\u0011a\u00029mC:tWM\u001d\u0006\u0003\u001b9\tQ\u0001^1cY\u0016T!a\u0004\t\u0002\u000b\u0019d\u0017N\\6\u000b\u0005E\u0011\u0012AB1qC\u000eDWMC\u0001\u0014\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0003\u0005\u0002\u0018=5\t\u0001D\u0003\u0002\u001a5\u000591m\u001c8wKJ$(BA\u000e\u001d\u0003\r\u0011X\r\u001c\u0006\u0003;A\tqaY1mG&$X-\u0003\u0002 1\ti1i\u001c8wKJ$XM\u001d*vY\u0016D\u0001\"\t\u0001\u0003\u0002\u0003\u0006IAI\u0001\u0007G>tg-[4\u0011\u0005\r\u001adB\u0001\u00132\u001d\t)\u0003G\u0004\u0002'_9\u0011qE\f\b\u0003Q5r!!\u000b\u0017\u000e\u0003)R!a\u000b\u000b\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0012BA\t\u0013\u0013\ti\u0002#\u0003\u0002\u001c9%\u0011\u0011DG\u0005\u0003ea\tQbQ8om\u0016\u0014H/\u001a:Sk2,\u0017B\u0001\u001b6\u0005\u0019\u0019uN\u001c4jO*\u0011!\u0007\u0007\u0005\u0006o\u0001!\t\u0001O\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005eZ\u0004C\u0001\u001e\u0001\u001b\u0005\u0011\u0001\"B\u00117\u0001\u0004\u0011\u0003\"B\u001f\u0001\t\u0003r\u0014aB7bi\u000eDWm\u001d\u000b\u0003\u007f\u0015\u0003\"\u0001Q\"\u000e\u0003\u0005S\u0011AQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\t\u0006\u0013qAQ8pY\u0016\fg\u000eC\u0003Gy\u0001\u0007q)\u0001\u0003dC2d\u0007C\u0001%K\u001b\u0005I%BA\u0005\u001d\u0013\tY\u0015J\u0001\bSK2|\u0005\u000f\u001e*vY\u0016\u001c\u0015\r\u001c7\t\u000be\u0001A\u0011A'\u0015\u00059\u0013\u0006CA(Q\u001b\u0005Q\u0012BA)\u001b\u0005\u001d\u0011V\r\u001c(pI\u0016DQa\u0007'A\u00029;Q\u0001\u0016\u0002\t\u0002U\u000b\u0011e\u0015;sK\u0006l\u0007\u000b[=tS\u000e\fG\u000eV1cY\u0016\u001cv.\u001e:dKN\u001b\u0017M\u001c*vY\u0016\u0004\"A\u000f,\u0007\u000b\u0005\u0011\u0001\u0012A,\u0014\u0005YC\u0006C\u0001!Z\u0013\tQ\u0016I\u0001\u0004B]f\u0014VM\u001a\u0005\u0006oY#\t\u0001\u0018\u000b\u0002+\"9aL\u0016b\u0001\n\u0003y\u0016\u0001C%O'R\u000bejQ#\u0016\u0003eBa!\u0019,!\u0002\u0013I\u0014!C%O'R\u000bejQ#!\u0001")
public class StreamPhysicalTableSourceScanRule
extends ConverterRule {
    public static StreamPhysicalTableSourceScanRule INSTANCE() {
        return StreamPhysicalTableSourceScanRule$.MODULE$.INSTANCE();
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        boolean bl;
        TableScan scan = (TableScan)call.rel(0);
        TableSourceTable tableSourceTable = scan.getTable().unwrap(TableSourceTable.class);
        TableSourceTable tableSourceTable2 = tableSourceTable;
        if (tableSourceTable2 != null) {
            TableSourceTable tableSourceTable3 = tableSourceTable2;
            DynamicTableSource dynamicTableSource = tableSourceTable3.tableSource();
            boolean bl2 = dynamicTableSource instanceof ScanTableSource;
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public RelNode convert(RelNode rel) {
        AbstractRelNode abstractRelNode;
        FlinkLogicalTableSourceScan scan = (FlinkLogicalTableSourceScan)rel;
        RelTraitSet traitSet = rel.getTraitSet().replace(FlinkConventions$.MODULE$.STREAM_PHYSICAL());
        TableConfig tableConfig = ShortcutUtils.unwrapContext(rel.getCluster()).getTableConfig();
        TableSourceTable table = (TableSourceTable)scan.getTable();
        StreamPhysicalTableSourceScan newScan = new StreamPhysicalTableSourceScan(rel.getCluster(), traitSet, scan.getHints(), table);
        ResolvedSchema resolvedSchema = table.contextResolvedTable().getResolvedSchema();
        if (!scan.eventTimeSnapshotRequired() && (DynamicSourceUtils.isUpsertSource(resolvedSchema, table.tableSource()) || DynamicSourceUtils.isSourceChangeEventsDuplicate(resolvedSchema, table.tableSource(), tableConfig))) {
            UniqueConstraint primaryKey = (UniqueConstraint)resolvedSchema.getPrimaryKey().get();
            List keyFields = primaryKey.getColumns();
            List<String> inputFieldNames = newScan.getRowType().getFieldNames();
            int[] primaryKeyIndices = ScanUtil$.MODULE$.getPrimaryKeyIndices(inputFieldNames, keyFields);
            FlinkRelDistribution requiredDistribution = FlinkRelDistribution$.MODULE$.hash(primaryKeyIndices, true);
            RelTraitSet requiredTraitSet = rel.getCluster().getPlanner().emptyTraitSet().replace(requiredDistribution).replace(FlinkConventions$.MODULE$.STREAM_PHYSICAL());
            RelNode newInput = RelOptRule.convert((RelNode)newScan, requiredTraitSet);
            abstractRelNode = new StreamPhysicalChangelogNormalize(scan.getCluster(), traitSet, newInput, primaryKeyIndices, table.contextResolvedTable());
        } else {
            abstractRelNode = newScan;
        }
        return abstractRelNode;
    }

    public StreamPhysicalTableSourceScanRule(ConverterRule.Config config) {
        super(config);
    }
}

