/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import java.util.Properties;
import org.apache.hadoop.security.authentication.util.Signer;
import org.apache.hadoop.security.authentication.util.SignerException;
import org.apache.hadoop.security.authentication.util.SignerSecretProvider;
import org.apache.hadoop.security.authentication.util.StringSignerSecretProvider;
import org.apache.hadoop.security.authentication.util.TestSigner;
import org.junit.Assert;
import org.junit.Test;

public class TestSigner {
    @Test
    public void testNullAndEmptyString() throws Exception {
        Signer signer = new Signer((SignerSecretProvider)this.createStringSignerSecretProvider());
        try {
            signer.sign(null);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Throwable ex) {
            Assert.fail();
        }
        try {
            signer.sign("");
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Throwable ex) {
            Assert.fail();
        }
    }

    @Test
    public void testSignature() throws Exception {
        Signer signer = new Signer((SignerSecretProvider)this.createStringSignerSecretProvider());
        String s1 = signer.sign("ok");
        String s2 = signer.sign("ok");
        String s3 = signer.sign("wrong");
        Assert.assertEquals((Object)s1, (Object)s2);
        Assert.assertNotEquals((Object)s1, (Object)s3);
    }

    @Test
    public void testVerify() throws Exception {
        Signer signer = new Signer((SignerSecretProvider)this.createStringSignerSecretProvider());
        String t = "test";
        String s = signer.sign(t);
        String e = signer.verifyAndExtract(s);
        Assert.assertEquals((Object)t, (Object)e);
    }

    @Test
    public void testInvalidSignedText() throws Exception {
        Signer signer = new Signer((SignerSecretProvider)this.createStringSignerSecretProvider());
        try {
            signer.verifyAndExtract("test");
            Assert.fail();
        }
        catch (SignerException ex) {
        }
        catch (Throwable ex) {
            Assert.fail();
        }
    }

    @Test
    public void testTampering() throws Exception {
        Signer signer = new Signer((SignerSecretProvider)this.createStringSignerSecretProvider());
        String t = "test";
        String s = signer.sign(t);
        s = s + "x";
        try {
            signer.verifyAndExtract(s);
            Assert.fail();
        }
        catch (SignerException ex) {
        }
        catch (Throwable ex) {
            Assert.fail();
        }
    }

    private StringSignerSecretProvider createStringSignerSecretProvider() throws Exception {
        StringSignerSecretProvider secretProvider = new StringSignerSecretProvider();
        Properties secretProviderProps = new Properties();
        secretProviderProps.setProperty("signature.secret", "secret");
        secretProvider.init(secretProviderProps, null, -1L);
        return secretProvider;
    }

    @Test
    public void testMultipleSecrets() throws Exception {
        TestSignerSecretProvider secretProvider = new TestSignerSecretProvider(this);
        Signer signer = new Signer((SignerSecretProvider)secretProvider);
        secretProvider.setCurrentSecret("secretB");
        String t1 = "test";
        String s1 = signer.sign(t1);
        String e1 = signer.verifyAndExtract(s1);
        Assert.assertEquals((Object)t1, (Object)e1);
        secretProvider.setPreviousSecret("secretA");
        String t2 = "test";
        String s2 = signer.sign(t2);
        String e2 = signer.verifyAndExtract(s2);
        Assert.assertEquals((Object)t2, (Object)e2);
        Assert.assertEquals((Object)s1, (Object)s2);
        secretProvider.setCurrentSecret("secretC");
        secretProvider.setPreviousSecret("secretB");
        String t3 = "test";
        String s3 = signer.sign(t3);
        String e3 = signer.verifyAndExtract(s3);
        Assert.assertEquals((Object)t3, (Object)e3);
        Assert.assertNotEquals((Object)s1, (Object)s3);
        String e1b = signer.verifyAndExtract(s1);
        Assert.assertEquals((Object)t1, (Object)e1b);
        secretProvider.setCurrentSecret("secretD");
        secretProvider.setPreviousSecret("secretC");
        try {
            signer.verifyAndExtract(s1);
            Assert.fail();
        }
        catch (SignerException ex) {
            // empty catch block
        }
    }
}

