/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.TestRestoreSnapshotFromClient;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestRestoreSnapshotFromClientWithRegionReplicas
extends TestRestoreSnapshotFromClient {
    @Override
    protected int getNumReplicas() {
        return 3;
    }

    @Test
    public void testOnlineSnapshotAfterSplittingRegions() throws IOException, InterruptedException {
        List regionInfos = this.admin.getTableRegions(this.tableName);
        RegionReplicaUtil.removeNonDefaultRegions((Collection)regionInfos);
        this.splitRegion((HRegionInfo)regionInfos.get(0));
        this.admin.snapshot(this.snapshotName1, this.tableName);
        TableName clonedTableName = TableName.valueOf((String)("testOnlineSnapshotAfterSplittingRegions-" + System.currentTimeMillis()));
        this.admin.cloneSnapshot(this.snapshotName1, clonedTableName);
        SnapshotTestingUtils.verifyRowCount(TEST_UTIL, clonedTableName, this.snapshot1Rows);
    }
}

