/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.PTFTopNHash;
import org.apache.hadoop.hive.ql.exec.PTFUtils;
import org.apache.hadoop.hive.ql.exec.TerminalOperator;
import org.apache.hadoop.hive.ql.exec.TopNHash;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.objectinspector.InspectableObject;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StandardUnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.util.hash.MurmurHash;

public class ReduceSinkOperator
extends TerminalOperator<ReduceSinkDesc>
implements Serializable,
TopNHash.BinaryCollector {
    private static final long serialVersionUID = 1L;
    private static final MurmurHash hash;
    private transient ObjectInspector[] partitionObjectInspectors;
    private transient ObjectInspector[] bucketObjectInspectors;
    private transient int buckColIdxInKey;
    private boolean firstRow;
    private transient int tag;
    private boolean skipTag = false;
    private transient InspectableObject tempInspectableObject = new InspectableObject();
    private transient int[] valueIndex;
    protected transient OutputCollector out;
    protected transient ExprNodeEvaluator[] keyEval;
    protected transient ExprNodeEvaluator[] valueEval;
    protected transient ExprNodeEvaluator[] partitionEval;
    protected transient ExprNodeEvaluator[] bucketEval = null;
    protected transient Serializer keySerializer;
    protected transient boolean keyIsText;
    protected transient Serializer valueSerializer;
    protected transient byte[] tagByte = new byte[1];
    protected transient int numDistributionKeys;
    protected transient int numDistinctExprs;
    protected transient String[] inputAliases;
    protected transient boolean useUniformHash = false;
    protected transient TopNHash reducerHash = new TopNHash();
    protected transient HiveKey keyWritable = new HiveKey();
    protected transient ObjectInspector keyObjectInspector;
    protected transient ObjectInspector valueObjectInspector;
    protected transient Object[] cachedValues;
    protected transient List<List<Integer>> distinctColIndices;
    protected transient Random random;
    protected transient int bucketNumber = -1;
    protected transient Object[][] cachedKeys;
    private StructField recIdField;
    private StructField bucketField;
    private StructObjectInspector acidRowInspector;
    private StructObjectInspector recIdInspector;
    private IntObjectInspector bucketInspector;
    protected transient long numRows = 0L;
    protected transient long cntr = 1L;
    private final transient LongWritable recordCounter = new LongWritable();

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        try {
            int index;
            this.numRows = 0L;
            this.statsMap.put(this.getCounterName(Counter.RECORDS_OUT_INTERMEDIATE, hconf), this.recordCounter);
            ArrayList<ExprNodeDesc> keys = ((ReduceSinkDesc)this.conf).getKeyCols();
            if (this.isLogDebugEnabled) {
                this.LOG.debug((Object)("keys size is " + keys.size()));
                for (ExprNodeDesc k : keys) {
                    this.LOG.debug((Object)("Key exprNodeDesc " + k.getExprString()));
                }
            }
            this.keyEval = new ExprNodeEvaluator[keys.size()];
            int i = 0;
            for (ExprNodeDesc e : keys) {
                this.keyEval[i++] = ExprNodeEvaluatorFactory.get(e);
            }
            this.numDistributionKeys = ((ReduceSinkDesc)this.conf).getNumDistributionKeys();
            this.distinctColIndices = ((ReduceSinkDesc)this.conf).getDistinctColumnIndices();
            this.numDistinctExprs = this.distinctColIndices.size();
            this.valueEval = new ExprNodeEvaluator[((ReduceSinkDesc)this.conf).getValueCols().size()];
            i = 0;
            for (ExprNodeDesc e : ((ReduceSinkDesc)this.conf).getValueCols()) {
                this.valueEval[i++] = ExprNodeEvaluatorFactory.get(e);
            }
            this.partitionEval = new ExprNodeEvaluator[((ReduceSinkDesc)this.conf).getPartitionCols().size()];
            i = 0;
            for (ExprNodeDesc e : ((ReduceSinkDesc)this.conf).getPartitionCols()) {
                index = ExprNodeDescUtils.indexOf(e, keys);
                this.partitionEval[i++] = index < 0 ? ExprNodeEvaluatorFactory.get(e) : this.keyEval[index];
            }
            if (((ReduceSinkDesc)this.conf).getBucketCols() != null && !((ReduceSinkDesc)this.conf).getBucketCols().isEmpty()) {
                this.bucketEval = new ExprNodeEvaluator[((ReduceSinkDesc)this.conf).getBucketCols().size()];
                i = 0;
                for (ExprNodeDesc e : ((ReduceSinkDesc)this.conf).getBucketCols()) {
                    index = ExprNodeDescUtils.indexOf(e, keys);
                    this.bucketEval[i++] = index < 0 ? ExprNodeEvaluatorFactory.get(e) : this.keyEval[index];
                }
                this.buckColIdxInKey = ((ReduceSinkDesc)this.conf).getPartitionCols().size();
            }
            this.tag = ((ReduceSinkDesc)this.conf).getTag();
            this.tagByte[0] = (byte)this.tag;
            this.skipTag = ((ReduceSinkDesc)this.conf).getSkipTag();
            if (this.isLogInfoEnabled) {
                this.LOG.info((Object)("Using tag = " + this.tag));
            }
            TableDesc keyTableDesc = ((ReduceSinkDesc)this.conf).getKeySerializeInfo();
            this.keySerializer = (Serializer)((Object)keyTableDesc.getDeserializerClass().newInstance());
            this.keySerializer.initialize(null, keyTableDesc.getProperties());
            this.keyIsText = this.keySerializer.getSerializedClass().equals(Text.class);
            TableDesc valueTableDesc = ((ReduceSinkDesc)this.conf).getValueSerializeInfo();
            this.valueSerializer = (Serializer)((Object)valueTableDesc.getDeserializerClass().newInstance());
            this.valueSerializer.initialize(null, valueTableDesc.getProperties());
            int limit = ((ReduceSinkDesc)this.conf).getTopN();
            float memUsage = ((ReduceSinkDesc)this.conf).getTopNMemoryUsage();
            if (limit >= 0 && memUsage > 0.0f) {
                this.reducerHash = ((ReduceSinkDesc)this.conf).isPTFReduceSink() ? new PTFTopNHash() : this.reducerHash;
                this.reducerHash.initialize(limit, memUsage, ((ReduceSinkDesc)this.conf).isMapGroupBy(), this);
            }
            this.useUniformHash = ((ReduceSinkDesc)this.conf).getReducerTraits().contains((Object)ReduceSinkDesc.ReducerTraits.UNIFORM);
            this.firstRow = true;
            this.initializeChildren(hconf);
        }
        catch (Exception e) {
            String msg = "Error initializing ReduceSinkOperator: " + e.getMessage();
            this.LOG.error((Object)msg, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String getCounterName(Counter counter, Configuration hconf) {
        String context = hconf.get("__hive.context.name", "");
        if (context != null && !context.isEmpty()) {
            context = "_" + context.replace(" ", "_");
        }
        return (Object)((Object)counter) + context;
    }

    protected static StructObjectInspector initEvaluatorsAndReturnStruct(ExprNodeEvaluator[] evals, List<List<Integer>> distinctColIndices, List<String> outputColNames, int length, ObjectInspector rowInspector) throws HiveException {
        int inspectorLen = evals.length > length ? length + 1 : evals.length;
        ArrayList<ObjectInspector> sois = new ArrayList<ObjectInspector>(inspectorLen);
        ObjectInspector[] fieldObjectInspectors = ReduceSinkOperator.initEvaluators(evals, 0, length, rowInspector);
        sois.addAll(Arrays.asList(fieldObjectInspectors));
        if (outputColNames.size() > length) {
            assert (distinctColIndices != null);
            ArrayList<ObjectInspector> uois = new ArrayList<ObjectInspector>();
            for (List<Integer> distinctCols : distinctColIndices) {
                ArrayList<String> names = new ArrayList<String>();
                ArrayList<ObjectInspector> eois = new ArrayList<ObjectInspector>();
                int numExprs = 0;
                for (int i : distinctCols) {
                    names.add(HiveConf.getColumnInternalName(numExprs));
                    eois.add(evals[i].initialize(rowInspector));
                    ++numExprs;
                }
                uois.add(ObjectInspectorFactory.getStandardStructObjectInspector(names, eois));
            }
            StandardUnionObjectInspector uoi = ObjectInspectorFactory.getStandardUnionObjectInspector(uois);
            sois.add(uoi);
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector(outputColNames, sois);
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        try {
            ObjectInspector rowInspector = this.inputObjInspectors[tag];
            if (this.firstRow) {
                this.firstRow = false;
                if (((ReduceSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.UPDATE || ((ReduceSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.DELETE) {
                    assert (rowInspector instanceof StructObjectInspector) : "Exptected rowInspector to be instance of StructObjectInspector but it is a " + rowInspector.getClass().getName();
                    this.acidRowInspector = (StructObjectInspector)rowInspector;
                    this.recIdField = this.acidRowInspector.getAllStructFieldRefs().get(0);
                    this.recIdInspector = (StructObjectInspector)this.recIdField.getFieldObjectInspector();
                    this.bucketField = this.recIdInspector.getAllStructFieldRefs().get(1);
                    this.bucketInspector = (IntObjectInspector)this.bucketField.getFieldObjectInspector();
                }
                if (this.isLogInfoEnabled) {
                    this.LOG.info((Object)("keys are " + ((ReduceSinkDesc)this.conf).getOutputKeyColumnNames() + " num distributions: " + ((ReduceSinkDesc)this.conf).getNumDistributionKeys()));
                }
                this.keyObjectInspector = ReduceSinkOperator.initEvaluatorsAndReturnStruct(this.keyEval, this.distinctColIndices, ((ReduceSinkDesc)this.conf).getOutputKeyColumnNames(), this.numDistributionKeys, rowInspector);
                this.valueObjectInspector = ReduceSinkOperator.initEvaluatorsAndReturnStruct(this.valueEval, ((ReduceSinkDesc)this.conf).getOutputValueColumnNames(), rowInspector);
                this.partitionObjectInspectors = ReduceSinkOperator.initEvaluators(this.partitionEval, rowInspector);
                if (this.bucketEval != null) {
                    this.bucketObjectInspectors = ReduceSinkOperator.initEvaluators(this.bucketEval, rowInspector);
                }
                int numKeys = this.numDistinctExprs > 0 ? this.numDistinctExprs : 1;
                int keyLen = this.numDistinctExprs > 0 ? this.numDistributionKeys + 1 : this.numDistributionKeys;
                this.cachedKeys = new Object[numKeys][keyLen];
                this.cachedValues = new Object[this.valueEval.length];
            }
            this.populateCachedDistributionKeys(row, 0);
            if (this.bucketEval != null) {
                this.bucketNumber = this.computeBucketNumber(row, ((ReduceSinkDesc)this.conf).getNumBuckets());
                this.cachedKeys[0][this.buckColIdxInKey] = new Text(String.valueOf(this.bucketNumber));
            } else if (((ReduceSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.UPDATE || ((ReduceSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.DELETE) {
                this.bucketNumber = this.computeBucketNumber(row, ((ReduceSinkDesc)this.conf).getNumBuckets());
            }
            HiveKey firstKey = this.toHiveKey(this.cachedKeys[0], tag, null);
            int distKeyLength = firstKey.getDistKeyLength();
            if (this.numDistinctExprs > 0) {
                this.populateCachedDistinctKeys(row, 0);
                firstKey = this.toHiveKey(this.cachedKeys[0], tag, distKeyLength);
            }
            int hashCode = this.useUniformHash && this.partitionEval.length > 0 ? this.computeMurmurHash(firstKey) : this.computeHashCode(row, this.bucketNumber);
            firstKey.setHashCode(hashCode);
            boolean partKeyNull = ((ReduceSinkDesc)this.conf).isPTFReduceSink() && this.partitionKeysAreNull(row);
            int firstIndex = this.reducerHash.tryStoreKey(firstKey, partKeyNull);
            if (firstIndex == -2) {
                return;
            }
            BytesWritable value = this.makeValueWritable(row);
            if (firstIndex == -1) {
                this.collect(firstKey, (Writable)value);
            } else {
                assert (firstIndex >= 0);
                this.reducerHash.storeValue(firstIndex, firstKey.hashCode(), value, false);
            }
            for (int i = 1; i < this.numDistinctExprs; ++i) {
                System.arraycopy(this.cachedKeys[0], 0, this.cachedKeys[i], 0, this.numDistributionKeys);
                this.populateCachedDistinctKeys(row, i);
                HiveKey hiveKey = this.toHiveKey(this.cachedKeys[i], tag, distKeyLength);
                hiveKey.setHashCode(hashCode);
                this.collect(hiveKey, (Writable)value);
            }
        }
        catch (HiveException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    private int computeBucketNumber(Object row, int numBuckets) throws HiveException {
        int buckNum = 0;
        if (((ReduceSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.UPDATE || ((ReduceSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.DELETE) {
            Object recIdValue = this.acidRowInspector.getStructFieldData(row, this.recIdField);
            buckNum = this.bucketInspector.get(this.recIdInspector.getStructFieldData(recIdValue, this.bucketField));
            if (this.isLogTraceEnabled) {
                this.LOG.trace((Object)("Acid choosing bucket number " + buckNum));
            }
        } else {
            for (int i = 0; i < this.bucketEval.length; ++i) {
                Object o = this.bucketEval[i].evaluate(row);
                buckNum = buckNum * 31 + ObjectInspectorUtils.hashCode(o, this.bucketObjectInspectors[i]);
            }
        }
        if (buckNum < 0) {
            buckNum = -1 * buckNum;
        }
        return buckNum % numBuckets;
    }

    private void populateCachedDistributionKeys(Object row, int index) throws HiveException {
        for (int i = 0; i < this.numDistributionKeys; ++i) {
            this.cachedKeys[index][i] = this.keyEval[i].evaluate(row);
        }
        if (this.cachedKeys[0].length > this.numDistributionKeys) {
            this.cachedKeys[index][this.numDistributionKeys] = null;
        }
    }

    private void populateCachedDistinctKeys(Object row, int index) throws HiveException {
        StandardUnionObjectInspector.StandardUnion union = new StandardUnionObjectInspector.StandardUnion((byte)index, new Object[this.distinctColIndices.get(index).size()]);
        this.cachedKeys[index][this.numDistributionKeys] = union;
        Object[] distinctParameters = (Object[])union.getObject();
        for (int distinctParamI = 0; distinctParamI < distinctParameters.length; ++distinctParamI) {
            distinctParameters[distinctParamI] = this.keyEval[this.distinctColIndices.get(index).get(distinctParamI)].evaluate(row);
        }
        union.setTag((byte)index);
    }

    protected final int computeMurmurHash(HiveKey firstKey) {
        return hash.hash(firstKey.getBytes(), firstKey.getDistKeyLength(), 0);
    }

    private int computeHashCode(Object row, int buckNum) throws HiveException {
        int hashCode;
        int keyHashCode = 0;
        if (this.partitionEval.length == 0) {
            if (((ReduceSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.NOT_ACID) {
                if (this.random == null) {
                    this.random = new Random(12345L);
                }
                keyHashCode = this.random.nextInt();
            } else {
                keyHashCode = 1;
            }
        } else {
            for (int i = 0; i < this.partitionEval.length; ++i) {
                Object o = this.partitionEval[i].evaluate(row);
                keyHashCode = keyHashCode * 31 + ObjectInspectorUtils.hashCode(o, this.partitionObjectInspectors[i]);
            }
        }
        int n = hashCode = buckNum < 0 ? keyHashCode : keyHashCode * 31 + buckNum;
        if (this.isLogTraceEnabled) {
            this.LOG.trace((Object)("Going to return hash code " + hashCode));
        }
        return hashCode;
    }

    private boolean partitionKeysAreNull(Object row) throws HiveException {
        if (this.partitionEval.length != 0) {
            for (int i = 0; i < this.partitionEval.length; ++i) {
                Object o = this.partitionEval[i].evaluate(row);
                if (o == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected HiveKey toHiveKey(Object obj, int tag, Integer distLength) throws SerDeException {
        BinaryComparable key = (BinaryComparable)this.keySerializer.serialize(obj, this.keyObjectInspector);
        int keyLength = key.getLength();
        if (tag == -1 || this.skipTag) {
            this.keyWritable.set(key.getBytes(), 0, keyLength);
        } else {
            this.keyWritable.setSize(keyLength + 1);
            System.arraycopy(key.getBytes(), 0, this.keyWritable.get(), 0, keyLength);
            this.keyWritable.get()[keyLength] = this.tagByte[0];
        }
        this.keyWritable.setDistKeyLength(distLength == null ? keyLength : distLength);
        return this.keyWritable;
    }

    @Override
    public void collect(byte[] key, byte[] value, int hash) throws IOException {
        HiveKey keyWritable = new HiveKey(key, hash);
        BytesWritable valueWritable = new BytesWritable(value);
        this.collect(keyWritable, (Writable)valueWritable);
    }

    protected void collect(BytesWritable keyWritable, Writable valueWritable) throws IOException {
        if (null != this.out) {
            ++this.numRows;
            if (this.isLogInfoEnabled && this.numRows == this.cntr) {
                this.cntr *= 10L;
                this.LOG.info((Object)(this.toString() + ": records written - " + this.numRows));
            }
            this.out.collect((Object)keyWritable, (Object)valueWritable);
        }
    }

    private BytesWritable makeValueWritable(Object row) throws Exception {
        int length = this.valueEval.length;
        if (this.bucketEval != null) {
            --length;
            assert (this.bucketNumber >= 0);
            this.cachedValues[length] = new Text(String.valueOf(this.bucketNumber));
        }
        for (int i = 0; i < length; ++i) {
            this.cachedValues[i] = this.valueEval[i].evaluate(row);
        }
        return (BytesWritable)this.valueSerializer.serialize(this.cachedValues, this.valueObjectInspector);
    }

    @Override
    protected void closeOp(boolean abort) throws HiveException {
        if (!abort) {
            this.reducerHash.flush();
        }
        super.closeOp(abort);
        this.out = null;
        if (this.isLogInfoEnabled) {
            this.LOG.info((Object)(this.toString() + ": records written - " + this.numRows));
        }
        this.recordCounter.set(this.numRows);
    }

    @Override
    public String getName() {
        return ReduceSinkOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "RS";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.REDUCESINK;
    }

    @Override
    public boolean opAllowedBeforeMapJoin() {
        return false;
    }

    public void setSkipTag(boolean value) {
        this.skipTag = value;
    }

    public void setValueIndex(int[] valueIndex) {
        this.valueIndex = valueIndex;
    }

    public int[] getValueIndex() {
        return this.valueIndex;
    }

    public void setInputAliases(String[] inputAliases) {
        this.inputAliases = inputAliases;
    }

    public String[] getInputAliases() {
        return this.inputAliases;
    }

    @Override
    public void setOutputCollector(OutputCollector _out) {
        this.out = _out;
    }

    static {
        PTFUtils.makeTransient(ReduceSinkOperator.class, "inputAliases", "valueIndex");
        hash = (MurmurHash)MurmurHash.getInstance();
    }

    public static enum Counter {
        RECORDS_OUT_INTERMEDIATE;

    }
}

