/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lockmgr;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.hadoop.hive.ql.metadata.DummyPartition;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;

public class HiveLockObject {
    String[] pathNames = null;
    private HiveLockObjectData data;

    public HiveLockObject() {
        this.data = null;
    }

    public HiveLockObject(String path, HiveLockObjectData lockData) {
        this.pathNames = new String[1];
        this.pathNames[0] = path;
        this.data = lockData;
    }

    public HiveLockObject(String[] paths, HiveLockObjectData lockData) {
        this.pathNames = paths;
        this.data = lockData;
    }

    public HiveLockObject(Table tbl, HiveLockObjectData lockData) {
        this(new String[]{tbl.getDbName(), tbl.getTableName()}, lockData);
    }

    public HiveLockObject(Partition par, HiveLockObjectData lockData) {
        this(new String[]{par.getTable().getDbName(), par.getTable().getTableName(), par.getName()}, lockData);
    }

    public HiveLockObject(DummyPartition par, HiveLockObjectData lockData) {
        this(new String[]{par.getName()}, lockData);
    }

    public String[] getPaths() {
        return this.pathNames;
    }

    public String getName() {
        if (this.pathNames == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.pathNames.length; ++i) {
            if (i > 0) {
                builder.append('/');
            }
            builder.append(this.pathNames[i]);
        }
        return builder.toString();
    }

    public String getDisplayName() {
        if (this.pathNames == null) {
            return null;
        }
        if (this.pathNames.length == 1) {
            return this.pathNames[0];
        }
        if (this.pathNames.length == 2) {
            return this.pathNames[0] + "@" + this.pathNames[1];
        }
        String ret = this.pathNames[0] + "@" + this.pathNames[1] + "@";
        boolean first = true;
        for (int i = 2; i < this.pathNames.length; ++i) {
            if (!first) {
                ret = ret + "/";
            } else {
                first = false;
            }
            ret = ret + this.pathNames[i];
        }
        return ret;
    }

    public HiveLockObjectData getData() {
        return this.data;
    }

    public void setData(HiveLockObjectData data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (!(o instanceof HiveLockObject)) {
            return false;
        }
        HiveLockObject tgt = (HiveLockObject)o;
        return StringUtils.equals(this.getName(), tgt.getName()) && (this.data == null ? tgt.getData() == null : this.data.equals(tgt.getData()));
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.pathNames);
        boolean data_present = this.data == null;
        builder.append(data_present);
        if (data_present) {
            builder.append(this.data);
        }
        return builder.toHashCode();
    }

    private static String removeDelimiter(String in) {
        if (in == null) {
            return null;
        }
        return in.replaceAll(":", "");
    }

    public static class HiveLockObjectData {
        private String queryId;
        private String lockTime;
        private String lockMode;
        private String queryStr;
        private String clientIp;

        public HiveLockObjectData(String queryId, String lockTime, String lockMode, String queryStr) {
            this.queryId = HiveLockObject.removeDelimiter(queryId);
            this.lockTime = HiveLockObject.removeDelimiter(lockTime);
            this.lockMode = HiveLockObject.removeDelimiter(lockMode);
            this.queryStr = HiveLockObject.removeDelimiter(queryStr == null ? null : queryStr.trim());
        }

        public HiveLockObjectData(String data) {
            if (data == null) {
                return;
            }
            String[] elem = data.split(":");
            this.queryId = elem[0];
            this.lockTime = elem[1];
            this.lockMode = elem[2];
            this.queryStr = elem[3];
            if (elem.length >= 5) {
                this.clientIp = elem[4];
            }
        }

        public String getQueryId() {
            return this.queryId;
        }

        public String getLockTime() {
            return this.lockTime;
        }

        public String getLockMode() {
            return this.lockMode;
        }

        public String getQueryStr() {
            return this.queryStr;
        }

        public String toString() {
            return this.queryId + ":" + this.lockTime + ":" + this.lockMode + ":" + this.queryStr + ":" + this.clientIp;
        }

        public String getClientIp() {
            return this.clientIp;
        }

        public void setClientIp(String clientIp) {
            this.clientIp = clientIp;
        }

        public boolean equals(Object o) {
            boolean ret;
            if (!(o instanceof HiveLockObjectData)) {
                return false;
            }
            HiveLockObjectData target = (HiveLockObjectData)o;
            boolean bl = this.queryId == null ? target.queryId == null : (ret = target.queryId != null && this.queryId.equals(target.queryId));
            boolean bl2 = ret && (this.lockTime == null ? target.lockTime == null : target.lockTime != null && this.lockTime.equals(target.lockTime)) ? true : (ret = false);
            boolean bl3 = ret && (this.lockMode == null ? target.lockMode == null : target.lockMode != null && this.lockMode.equals(target.lockMode)) ? true : (ret = false);
            boolean bl4 = ret && (this.queryStr == null ? target.queryStr == null : target.queryStr != null && this.queryStr.equals(target.queryStr)) ? true : (ret = false);
            ret = ret && (this.clientIp == null ? target.clientIp == null : target.clientIp != null && this.clientIp.equals(target.clientIp));
            return ret;
        }

        public int hashCode() {
            HashCodeBuilder builder = new HashCodeBuilder();
            boolean queryId_present = this.queryId == null;
            builder.append(queryId_present);
            if (queryId_present) {
                builder.append(this.queryId);
            }
            boolean lockTime_present = this.lockTime == null;
            builder.append(this.lockTime);
            if (lockTime_present) {
                builder.append(this.lockTime);
            }
            boolean lockMode_present = this.lockMode == null;
            builder.append(this.lockMode);
            if (lockMode_present) {
                builder.append(this.lockMode);
            }
            boolean queryStr_present = this.queryStr == null;
            builder.append(this.queryStr);
            if (queryStr_present) {
                builder.append(this.queryStr);
            }
            boolean clienIp_present = this.clientIp == null;
            builder.append(this.clientIp);
            if (clienIp_present) {
                builder.append(this.clientIp);
            }
            return builder.toHashCode();
        }
    }
}

