/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Stack;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.LimitOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.LimitDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;

public class LimitPushdownOptimizer
implements Transform {
    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", ReduceSinkOperator.getOperatorName() + "%" + ".*" + LimitOperator.getOperatorName() + "%"), new TopNReducer());
        LimitPushdownContext context = new LimitPushdownContext(pctx.getConf());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, opRules, context);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>(pctx.getTopOps().values());
        ogw.startWalking(topNodes, null);
        return pctx;
    }

    private static class LimitPushdownContext
    implements NodeProcessorCtx {
        private float threshold;

        public LimitPushdownContext(HiveConf conf) throws SemanticException {
            this.threshold = conf.getFloatVar(HiveConf.ConfVars.HIVELIMITPUSHDOWNMEMORYUSAGE);
            if (this.threshold <= 0.0f || this.threshold >= 1.0f) {
                throw new SemanticException("Invalid memory usage value " + this.threshold + " for " + (Object)((Object)HiveConf.ConfVars.HIVELIMITPUSHDOWNMEMORYUSAGE));
            }
        }
    }

    private static class TopNReducer
    implements NodeProcessor {
        private TopNReducer() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            Operator rs = null;
            for (int i = stack.size() - 2; i >= 0; --i) {
                Operator operator = (Operator)stack.get(i);
                if (operator.getNumChild() != 1) {
                    return false;
                }
                if (operator instanceof ReduceSinkOperator) {
                    rs = (ReduceSinkOperator)operator;
                    break;
                }
                if (operator.acceptLimitPushdown()) continue;
                return false;
            }
            if (rs != null) {
                LimitOperator limit = (LimitOperator)nd;
                ((ReduceSinkDesc)rs.getConf()).setTopN(((LimitDesc)limit.getConf()).getLimit());
                ((ReduceSinkDesc)rs.getConf()).setTopNMemoryUsage(((LimitPushdownContext)procCtx).threshold);
                if (rs.getNumChild() == 1 && ((ArrayList)rs.getChildren()).get(0) instanceof GroupByOperator) {
                    ((ReduceSinkDesc)rs.getConf()).setMapGroupBy(true);
                }
            }
            return true;
        }
    }
}

