/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieNotSupportedException;

@ConfigClassProperty(name="Clustering Configs", groupName=ConfigGroups.Names.WRITE_CLIENT, description="Configurations that control the clustering table service in hudi, which optimizes the storage layout for better query performance by sorting and sizing data files.")
public class HoodieClusteringConfig
extends HoodieConfig {
    public static final String CLUSTERING_STRATEGY_PARAM_PREFIX = "hoodie.clustering.plan.strategy.";
    public static final String SPARK_SIZED_BASED_CLUSTERING_PLAN_STRATEGY = "org.apache.hudi.client.clustering.plan.strategy.SparkSizeBasedClusteringPlanStrategy";
    public static final String JAVA_SIZED_BASED_CLUSTERING_PLAN_STRATEGY = "org.apache.hudi.client.clustering.plan.strategy.JavaSizeBasedClusteringPlanStrategy";
    public static final String SPARK_SORT_AND_SIZE_EXECUTION_STRATEGY = "org.apache.hudi.client.clustering.run.strategy.SparkSortAndSizeExecutionStrategy";
    public static final String JAVA_SORT_AND_SIZE_EXECUTION_STRATEGY = "org.apache.hudi.client.clustering.run.strategy.JavaSortAndSizeExecutionStrategy";
    public static final String LAYOUT_OPTIMIZE_PARAM_PREFIX = "hoodie.layout.optimize.";
    public static final ConfigProperty<String> DAYBASED_LOOKBACK_PARTITIONS = ConfigProperty.key((String)"hoodie.clustering.plan.strategy.daybased.lookback.partitions").defaultValue((Object)"2").sinceVersion("0.7.0").withDocumentation("Number of partitions to list to create ClusteringPlan");
    public static final ConfigProperty<String> PLAN_STRATEGY_SMALL_FILE_LIMIT = ConfigProperty.key((String)"hoodie.clustering.plan.strategy.small.file.limit").defaultValue((Object)String.valueOf(629145600L)).sinceVersion("0.7.0").withDocumentation("Files smaller than the size specified here are candidates for clustering");
    public static final ConfigProperty<String> PLAN_STRATEGY_CLASS_NAME = ConfigProperty.key((String)"hoodie.clustering.plan.strategy.class").defaultValue((Object)"org.apache.hudi.client.clustering.plan.strategy.SparkSizeBasedClusteringPlanStrategy").sinceVersion("0.7.0").withDocumentation("Config to provide a strategy class (subclass of ClusteringPlanStrategy) to create clustering plan i.e select what file groups are being clustered. Default strategy, looks at the clustering small file size limit (determined by " + PLAN_STRATEGY_SMALL_FILE_LIMIT.key() + ") to pick the small file slices within partitions for clustering.");
    public static final ConfigProperty<String> EXECUTION_STRATEGY_CLASS_NAME = ConfigProperty.key((String)"hoodie.clustering.execution.strategy.class").defaultValue((Object)"org.apache.hudi.client.clustering.run.strategy.SparkSortAndSizeExecutionStrategy").sinceVersion("0.7.0").withDocumentation("Config to provide a strategy class (subclass of RunClusteringStrategy) to define how the  clustering plan is executed. By default, we sort the file groups in th plan by the specified columns, while  meeting the configured target file sizes.");
    public static final ConfigProperty<String> INLINE_CLUSTERING = ConfigProperty.key((String)"hoodie.clustering.inline").defaultValue((Object)"false").sinceVersion("0.7.0").withDocumentation("Turn on inline clustering - clustering will be run after each write operation is complete");
    public static final ConfigProperty<String> INLINE_CLUSTERING_MAX_COMMITS = ConfigProperty.key((String)"hoodie.clustering.inline.max.commits").defaultValue((Object)"4").sinceVersion("0.7.0").withDocumentation("Config to control frequency of clustering planning");
    public static final ConfigProperty<String> ASYNC_CLUSTERING_MAX_COMMITS = ConfigProperty.key((String)"hoodie.clustering.async.max.commits").defaultValue((Object)"4").sinceVersion("0.9.0").withDocumentation("Config to control frequency of async clustering");
    public static final ConfigProperty<String> PLAN_STRATEGY_SKIP_PARTITIONS_FROM_LATEST = ConfigProperty.key((String)"hoodie.clustering.plan.strategy.daybased.skipfromlatest.partitions").defaultValue((Object)"0").sinceVersion("0.9.0").withDocumentation("Number of partitions to skip from latest when choosing partitions to create ClusteringPlan");
    public static final ConfigProperty<String> PLAN_STRATEGY_MAX_BYTES_PER_OUTPUT_FILEGROUP = ConfigProperty.key((String)"hoodie.clustering.plan.strategy.max.bytes.per.group").defaultValue((Object)String.valueOf(0x80000000L)).sinceVersion("0.7.0").withDocumentation("Each clustering operation can create multiple output file groups. Total amount of data processed by clustering operation is defined by below two properties (CLUSTERING_MAX_BYTES_PER_GROUP * CLUSTERING_MAX_NUM_GROUPS). Max amount of data to be included in one group");
    public static final ConfigProperty<String> PLAN_STRATEGY_MAX_GROUPS = ConfigProperty.key((String)"hoodie.clustering.plan.strategy.max.num.groups").defaultValue((Object)"30").sinceVersion("0.7.0").withDocumentation("Maximum number of groups to create as part of ClusteringPlan. Increasing groups will increase parallelism");
    public static final ConfigProperty<String> PLAN_STRATEGY_TARGET_FILE_MAX_BYTES = ConfigProperty.key((String)"hoodie.clustering.plan.strategy.target.file.max.bytes").defaultValue((Object)String.valueOf(0x40000000L)).sinceVersion("0.7.0").withDocumentation("Each group can produce 'N' (CLUSTERING_MAX_GROUP_SIZE/CLUSTERING_TARGET_FILE_SIZE) output file groups");
    public static final ConfigProperty<String> PLAN_STRATEGY_SORT_COLUMNS = ConfigProperty.key((String)"hoodie.clustering.plan.strategy.sort.columns").noDefaultValue().sinceVersion("0.7.0").withDocumentation("Columns to sort the data by when clustering");
    public static final ConfigProperty<String> UPDATES_STRATEGY = ConfigProperty.key((String)"hoodie.clustering.updates.strategy").defaultValue((Object)"org.apache.hudi.client.clustering.update.strategy.SparkRejectUpdateStrategy").sinceVersion("0.7.0").withDocumentation("Determines how to handle updates, deletes to file groups that are under clustering. Default strategy just rejects the update");
    public static final ConfigProperty<String> ASYNC_CLUSTERING_ENABLE = ConfigProperty.key((String)"hoodie.clustering.async.enabled").defaultValue((Object)"false").sinceVersion("0.7.0").withDocumentation("Enable running of clustering service, asynchronously as inserts happen on the table.");
    public static final ConfigProperty<Boolean> PRESERVE_COMMIT_METADATA = ConfigProperty.key((String)"hoodie.clustering.preserve.commit.metadata").defaultValue((Object)true).sinceVersion("0.9.0").withDocumentation("When rewriting data, preserves existing hoodie_commit_time");
    public static final ConfigProperty LAYOUT_OPTIMIZE_ENABLE = ConfigProperty.key((String)"hoodie.layout.optimize.enable").defaultValue((Object)false).sinceVersion("0.10.0").withDocumentation("Enable use z-ordering/space-filling curves to optimize the layout of table to boost query performance. This parameter takes precedence over clustering strategy set using " + EXECUTION_STRATEGY_CLASS_NAME.key());
    public static final ConfigProperty LAYOUT_OPTIMIZE_STRATEGY = ConfigProperty.key((String)"hoodie.layout.optimize.strategy").defaultValue((Object)"z-order").sinceVersion("0.10.0").withDocumentation("Type of layout optimization to be applied, current only supports `z-order` and `hilbert` curves.");
    public static final ConfigProperty LAYOUT_OPTIMIZE_CURVE_BUILD_METHOD = ConfigProperty.key((String)"hoodie.layout.optimize.curve.build.method").defaultValue((Object)"direct").sinceVersion("0.10.0").withDocumentation("Controls how data is sampled to build the space filling curves. two methods: `direct`,`sample`.The direct method is faster than the sampling, however sample method would produce a better data layout.");
    public static final ConfigProperty LAYOUT_OPTIMIZE_BUILD_CURVE_SAMPLE_SIZE = ConfigProperty.key((String)"hoodie.layout.optimize.build.curve.sample.size").defaultValue((Object)"200000").sinceVersion("0.10.0").withDocumentation("when setting" + LAYOUT_OPTIMIZE_CURVE_BUILD_METHOD.key() + " to `sample`, the amount of sampling to be done.Large sample size leads to better results, at the expense of more memory usage.");
    public static final ConfigProperty LAYOUT_OPTIMIZE_DATA_SKIPPING_ENABLE = ConfigProperty.key((String)"hoodie.layout.optimize.data.skipping.enable").defaultValue((Object)true).sinceVersion("0.10.0").withDocumentation("Enable data skipping by collecting statistics once layout optimization is complete.");
    public static final ConfigProperty<Boolean> ROLLBACK_PENDING_CLUSTERING_ON_CONFLICT = ConfigProperty.key((String)"hoodie.clustering.rollback.pending.replacecommit.on.conflict").defaultValue((Object)false).sinceVersion("0.10.0").withDocumentation("If updates are allowed to file groups pending clustering, then set this config to rollback failed or pending clustering instants. Pending clustering will be rolled back ONLY IF there is conflict between incoming upsert and filegroup to be clustered. Please exercise caution while setting this config, especially when clustering is done very frequently. This could lead to race condition in rare scenarios, for example, when the clustering completes after instants are fetched but before rollback completed.");
    @Deprecated
    public static final String CLUSTERING_PLAN_STRATEGY_CLASS = PLAN_STRATEGY_CLASS_NAME.key();
    @Deprecated
    public static final String DEFAULT_CLUSTERING_PLAN_STRATEGY_CLASS = (String)PLAN_STRATEGY_CLASS_NAME.defaultValue();
    @Deprecated
    public static final String CLUSTERING_EXECUTION_STRATEGY_CLASS = EXECUTION_STRATEGY_CLASS_NAME.key();
    @Deprecated
    public static final String DEFAULT_CLUSTERING_EXECUTION_STRATEGY_CLASS = (String)EXECUTION_STRATEGY_CLASS_NAME.defaultValue();
    @Deprecated
    public static final String INLINE_CLUSTERING_PROP = INLINE_CLUSTERING.key();
    @Deprecated
    private static final String DEFAULT_INLINE_CLUSTERING = (String)INLINE_CLUSTERING.defaultValue();
    @Deprecated
    public static final String INLINE_CLUSTERING_MAX_COMMIT_PROP = INLINE_CLUSTERING_MAX_COMMITS.key();
    @Deprecated
    private static final String DEFAULT_INLINE_CLUSTERING_NUM_COMMITS = (String)INLINE_CLUSTERING_MAX_COMMITS.defaultValue();
    @Deprecated
    public static final String CLUSTERING_TARGET_PARTITIONS = DAYBASED_LOOKBACK_PARTITIONS.key();
    @Deprecated
    public static final String DEFAULT_CLUSTERING_TARGET_PARTITIONS = (String)DAYBASED_LOOKBACK_PARTITIONS.defaultValue();
    @Deprecated
    public static final String CLUSTERING_PLAN_SMALL_FILE_LIMIT = PLAN_STRATEGY_SMALL_FILE_LIMIT.key();
    @Deprecated
    public static final String DEFAULT_CLUSTERING_PLAN_SMALL_FILE_LIMIT = (String)PLAN_STRATEGY_SMALL_FILE_LIMIT.defaultValue();
    @Deprecated
    public static final String CLUSTERING_MAX_BYTES_PER_GROUP = PLAN_STRATEGY_MAX_BYTES_PER_OUTPUT_FILEGROUP.key();
    @Deprecated
    public static final String DEFAULT_CLUSTERING_MAX_GROUP_SIZE = (String)PLAN_STRATEGY_MAX_BYTES_PER_OUTPUT_FILEGROUP.defaultValue();
    @Deprecated
    public static final String CLUSTERING_MAX_NUM_GROUPS = PLAN_STRATEGY_MAX_GROUPS.key();
    @Deprecated
    public static final String DEFAULT_CLUSTERING_MAX_NUM_GROUPS = (String)PLAN_STRATEGY_MAX_GROUPS.defaultValue();
    @Deprecated
    public static final String CLUSTERING_TARGET_FILE_MAX_BYTES = PLAN_STRATEGY_TARGET_FILE_MAX_BYTES.key();
    @Deprecated
    public static final String DEFAULT_CLUSTERING_TARGET_FILE_MAX_BYTES = (String)PLAN_STRATEGY_TARGET_FILE_MAX_BYTES.defaultValue();
    @Deprecated
    public static final String CLUSTERING_SORT_COLUMNS_PROPERTY = PLAN_STRATEGY_SORT_COLUMNS.key();
    @Deprecated
    public static final String CLUSTERING_UPDATES_STRATEGY_PROP = UPDATES_STRATEGY.key();
    @Deprecated
    public static final String DEFAULT_CLUSTERING_UPDATES_STRATEGY = (String)UPDATES_STRATEGY.defaultValue();
    @Deprecated
    public static final String ASYNC_CLUSTERING_ENABLE_OPT_KEY = ASYNC_CLUSTERING_ENABLE.key();
    @Deprecated
    public static final String DEFAULT_ASYNC_CLUSTERING_ENABLE_OPT_VAL = (String)ASYNC_CLUSTERING_ENABLE.defaultValue();

    public boolean isAsyncClusteringEnabled() {
        return this.getBooleanOrDefault(ASYNC_CLUSTERING_ENABLE);
    }

    public boolean isInlineClusteringEnabled() {
        return this.getBooleanOrDefault(INLINE_CLUSTERING);
    }

    public static HoodieClusteringConfig from(TypedProperties props) {
        return HoodieClusteringConfig.newBuilder().fromProperties((Properties)props).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum BuildLayoutOptimizationStrategy {
        ZORDER("z-order"),
        HILBERT("hilbert");

        private final String value;

        private BuildLayoutOptimizationStrategy(String value) {
            this.value = value;
        }

        public String toCustomString() {
            return this.value;
        }

        public static BuildLayoutOptimizationStrategy fromValue(String value) {
            switch (value.toLowerCase(Locale.ROOT)) {
                case "z-order": {
                    return ZORDER;
                }
                case "hilbert": {
                    return HILBERT;
                }
            }
            throw new HoodieException("Invalid value of Type.");
        }
    }

    public static enum BuildCurveStrategyType {
        DIRECT("direct"),
        SAMPLE("sample");

        private final String value;

        private BuildCurveStrategyType(String value) {
            this.value = value;
        }

        public static BuildCurveStrategyType fromValue(String value) {
            switch (value.toLowerCase(Locale.ROOT)) {
                case "direct": {
                    return DIRECT;
                }
                case "sample": {
                    return SAMPLE;
                }
            }
            throw new HoodieException("Invalid value of Type.");
        }
    }

    public static class Builder {
        private final HoodieClusteringConfig clusteringConfig = new HoodieClusteringConfig();
        private EngineType engineType = EngineType.SPARK;

        public Builder withEngineType(EngineType engineType) {
            this.engineType = engineType;
            return this;
        }

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.clusteringConfig.getProps().load((Reader)reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder withClusteringPlanStrategyClass(String clusteringStrategyClass) {
            this.clusteringConfig.setValue(PLAN_STRATEGY_CLASS_NAME, clusteringStrategyClass);
            return this;
        }

        public Builder withClusteringExecutionStrategyClass(String runClusteringStrategyClass) {
            this.clusteringConfig.setValue(EXECUTION_STRATEGY_CLASS_NAME, runClusteringStrategyClass);
            return this;
        }

        public Builder withClusteringTargetPartitions(int clusteringTargetPartitions) {
            this.clusteringConfig.setValue(DAYBASED_LOOKBACK_PARTITIONS, String.valueOf(clusteringTargetPartitions));
            return this;
        }

        public Builder withClusteringSkipPartitionsFromLatest(int clusteringSkipPartitionsFromLatest) {
            this.clusteringConfig.setValue(PLAN_STRATEGY_SKIP_PARTITIONS_FROM_LATEST, String.valueOf(clusteringSkipPartitionsFromLatest));
            return this;
        }

        public Builder withClusteringPlanSmallFileLimit(long clusteringSmallFileLimit) {
            this.clusteringConfig.setValue(PLAN_STRATEGY_SMALL_FILE_LIMIT, String.valueOf(clusteringSmallFileLimit));
            return this;
        }

        public Builder withClusteringSortColumns(String sortColumns) {
            this.clusteringConfig.setValue(PLAN_STRATEGY_SORT_COLUMNS, sortColumns);
            return this;
        }

        public Builder withClusteringMaxBytesInGroup(long clusteringMaxGroupSize) {
            this.clusteringConfig.setValue(PLAN_STRATEGY_MAX_BYTES_PER_OUTPUT_FILEGROUP, String.valueOf(clusteringMaxGroupSize));
            return this;
        }

        public Builder withClusteringMaxNumGroups(int maxNumGroups) {
            this.clusteringConfig.setValue(PLAN_STRATEGY_MAX_GROUPS, String.valueOf(maxNumGroups));
            return this;
        }

        public Builder withClusteringTargetFileMaxBytes(long targetFileSize) {
            this.clusteringConfig.setValue(PLAN_STRATEGY_TARGET_FILE_MAX_BYTES, String.valueOf(targetFileSize));
            return this;
        }

        public Builder withInlineClustering(Boolean inlineClustering) {
            this.clusteringConfig.setValue(INLINE_CLUSTERING, String.valueOf(inlineClustering));
            return this;
        }

        public Builder withInlineClusteringNumCommits(int numCommits) {
            this.clusteringConfig.setValue(INLINE_CLUSTERING_MAX_COMMITS, String.valueOf(numCommits));
            return this;
        }

        public Builder withAsyncClusteringMaxCommits(int numCommits) {
            this.clusteringConfig.setValue(ASYNC_CLUSTERING_MAX_COMMITS, String.valueOf(numCommits));
            return this;
        }

        public Builder fromProperties(Properties props) {
            this.clusteringConfig.getProps().putAll((Map)props);
            return this;
        }

        public Builder withClusteringUpdatesStrategy(String updatesStrategyClass) {
            this.clusteringConfig.setValue(UPDATES_STRATEGY, updatesStrategyClass);
            return this;
        }

        public Builder withAsyncClustering(Boolean asyncClustering) {
            this.clusteringConfig.setValue(ASYNC_CLUSTERING_ENABLE, String.valueOf(asyncClustering));
            return this;
        }

        public Builder withPreserveHoodieCommitMetadata(Boolean preserveHoodieCommitMetadata) {
            this.clusteringConfig.setValue(PRESERVE_COMMIT_METADATA, String.valueOf(preserveHoodieCommitMetadata));
            return this;
        }

        public Builder withRollbackPendingClustering(Boolean rollbackPendingClustering) {
            this.clusteringConfig.setValue(ROLLBACK_PENDING_CLUSTERING_ON_CONFLICT, String.valueOf(rollbackPendingClustering));
            return this;
        }

        public Builder withSpaceFillingCurveDataOptimizeEnable(Boolean enable) {
            this.clusteringConfig.setValue(LAYOUT_OPTIMIZE_ENABLE, String.valueOf(enable));
            return this;
        }

        public Builder withDataOptimizeStrategy(String strategy) {
            this.clusteringConfig.setValue(LAYOUT_OPTIMIZE_STRATEGY, strategy);
            return this;
        }

        public Builder withDataOptimizeBuildCurveStrategy(String method) {
            this.clusteringConfig.setValue(LAYOUT_OPTIMIZE_CURVE_BUILD_METHOD, method);
            return this;
        }

        public Builder withDataOptimizeBuildCurveSampleNumber(int sampleNumber) {
            this.clusteringConfig.setValue(LAYOUT_OPTIMIZE_BUILD_CURVE_SAMPLE_SIZE, String.valueOf(sampleNumber));
            return this;
        }

        public Builder withDataOptimizeDataSkippingEnable(boolean dataSkipping) {
            this.clusteringConfig.setValue(LAYOUT_OPTIMIZE_DATA_SKIPPING_ENABLE, String.valueOf(dataSkipping));
            return this;
        }

        public HoodieClusteringConfig build() {
            this.clusteringConfig.setDefaultValue(PLAN_STRATEGY_CLASS_NAME, this.getDefaultPlanStrategyClassName(this.engineType));
            this.clusteringConfig.setDefaultValue(EXECUTION_STRATEGY_CLASS_NAME, this.getDefaultExecutionStrategyClassName(this.engineType));
            this.clusteringConfig.setDefaults(HoodieClusteringConfig.class.getName());
            return this.clusteringConfig;
        }

        private String getDefaultPlanStrategyClassName(EngineType engineType) {
            switch (engineType) {
                case SPARK: {
                    return HoodieClusteringConfig.SPARK_SIZED_BASED_CLUSTERING_PLAN_STRATEGY;
                }
                case FLINK: 
                case JAVA: {
                    return HoodieClusteringConfig.JAVA_SIZED_BASED_CLUSTERING_PLAN_STRATEGY;
                }
            }
            throw new HoodieNotSupportedException("Unsupported engine " + engineType);
        }

        private String getDefaultExecutionStrategyClassName(EngineType engineType) {
            switch (engineType) {
                case SPARK: {
                    return HoodieClusteringConfig.SPARK_SORT_AND_SIZE_EXECUTION_STRATEGY;
                }
                case FLINK: 
                case JAVA: {
                    return HoodieClusteringConfig.JAVA_SORT_AND_SIZE_EXECUTION_STRATEGY;
                }
            }
            throw new HoodieNotSupportedException("Unsupported engine " + engineType);
        }
    }
}

