/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.simple;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.model.EmptyHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndexUtils;
import org.apache.hudi.index.simple.HoodieSimpleIndex;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.table.HoodieTable;

public class HoodieGlobalSimpleIndex<T extends HoodieRecordPayload<T>>
extends HoodieSimpleIndex<T> {
    public HoodieGlobalSimpleIndex(HoodieWriteConfig config, Option<BaseKeyGenerator> keyGeneratorOpt) {
        super(config, keyGeneratorOpt);
    }

    @Override
    public HoodieData<HoodieRecord<T>> tagLocation(HoodieData<HoodieRecord<T>> records, HoodieEngineContext context, HoodieTable hoodieTable) {
        return this.tagLocationInternal(records, context, hoodieTable);
    }

    @Override
    protected HoodieData<HoodieRecord<T>> tagLocationInternal(HoodieData<HoodieRecord<T>> inputRecords, HoodieEngineContext context, HoodieTable hoodieTable) {
        HoodiePairData keyedInputRecords = inputRecords.mapToPair((SerializablePairFunction & Serializable)entry -> new ImmutablePair((Object)entry.getRecordKey(), entry));
        HoodiePairData<HoodieKey, HoodieRecordLocation> allRecordLocationsInTable = this.fetchAllRecordLocations(context, hoodieTable, this.config.getGlobalSimpleIndexParallelism());
        return this.getTaggedRecords(keyedInputRecords, allRecordLocationsInTable);
    }

    protected HoodiePairData<HoodieKey, HoodieRecordLocation> fetchAllRecordLocations(HoodieEngineContext context, HoodieTable hoodieTable, int parallelism) {
        List<Pair<String, HoodieBaseFile>> latestBaseFiles = this.getAllBaseFilesInTable(context, hoodieTable);
        return this.fetchRecordLocations(context, hoodieTable, parallelism, latestBaseFiles);
    }

    protected List<Pair<String, HoodieBaseFile>> getAllBaseFilesInTable(HoodieEngineContext context, HoodieTable hoodieTable) {
        HoodieTableMetaClient metaClient = hoodieTable.getMetaClient();
        List allPartitionPaths = FSUtils.getAllPartitionPaths((HoodieEngineContext)context, (HoodieMetadataConfig)this.config.getMetadataConfig(), (String)metaClient.getBasePath());
        return HoodieIndexUtils.getLatestBaseFilesForAllPartitions(allPartitionPaths, context, hoodieTable);
    }

    private HoodieData<HoodieRecord<T>> getTaggedRecords(HoodiePairData<String, HoodieRecord<T>> incomingRecords, HoodiePairData<HoodieKey, HoodieRecordLocation> existingRecords) {
        HoodiePairData existingRecordByRecordKey = existingRecords.mapToPair((SerializablePairFunction & Serializable)entry -> new ImmutablePair((Object)((HoodieKey)entry.getLeft()).getRecordKey(), (Object)Pair.of((Object)((HoodieKey)entry.getLeft()).getPartitionPath(), (Object)entry.getRight())));
        return incomingRecords.leftOuterJoin(existingRecordByRecordKey).values().flatMap((SerializableFunction & Serializable)entry -> {
            List<HoodieRecord> taggedRecords;
            HoodieRecord inputRecord = (HoodieRecord)entry.getLeft();
            Option partitionPathLocationPair = Option.ofNullable((Object)((Option)entry.getRight()).orElse(null));
            if (partitionPathLocationPair.isPresent()) {
                String partitionPath = (String)((Pair)partitionPathLocationPair.get()).getKey();
                HoodieRecordLocation location = (HoodieRecordLocation)((Pair)partitionPathLocationPair.get()).getRight();
                if (this.config.getGlobalSimpleIndexUpdatePartitionPath() && !inputRecord.getPartitionPath().equals(partitionPath)) {
                    HoodieRecord deleteRecord = new HoodieRecord(new HoodieKey(inputRecord.getRecordKey(), partitionPath), (HoodieRecordPayload)new EmptyHoodieRecordPayload());
                    deleteRecord.setCurrentLocation(location);
                    deleteRecord.seal();
                    HoodieRecord insertRecord = HoodieIndexUtils.getTaggedRecord(inputRecord, (Option<HoodieRecordLocation>)Option.empty());
                    taggedRecords = Arrays.asList(deleteRecord, insertRecord);
                } else {
                    HoodieRecord newRecord = new HoodieRecord(new HoodieKey(inputRecord.getRecordKey(), partitionPath), inputRecord.getData());
                    taggedRecords = Collections.singletonList(HoodieIndexUtils.getTaggedRecord(newRecord, (Option<HoodieRecordLocation>)Option.ofNullable((Object)location)));
                }
            } else {
                taggedRecords = Collections.singletonList(HoodieIndexUtils.getTaggedRecord(inputRecord, (Option<HoodieRecordLocation>)Option.empty()));
            }
            return taggedRecords.iterator();
        });
    }

    @Override
    public boolean isGlobal() {
        return true;
    }
}

