/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen.parser;

import java.util.Arrays;
import java.util.Collections;
import java.util.TimeZone;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.keygen.KeyGenUtils;
import org.apache.hudi.keygen.TimestampBasedAvroKeyGenerator;
import org.apache.hudi.keygen.parser.AbstractHoodieDateTimeParser;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;

public class HoodieDateTimeParserImpl
extends AbstractHoodieDateTimeParser {
    private String configInputDateFormatList;
    private final DateTimeZone inputDateTimeZone;

    public HoodieDateTimeParserImpl(TypedProperties config) {
        super(config);
        KeyGenUtils.checkRequiredProperties(config, Arrays.asList("hoodie.deltastreamer.keygen.timebased.timestamp.type", "hoodie.deltastreamer.keygen.timebased.output.dateformat"));
        this.inputDateTimeZone = this.getInputDateTimeZone();
    }

    private DateTimeFormatter getInputDateFormatter() {
        if (this.configInputDateFormatList.isEmpty()) {
            throw new IllegalArgumentException("hoodie.deltastreamer.keygen.timebased.input.dateformat configuration is required");
        }
        DateTimeFormatter formatter = new DateTimeFormatterBuilder().append(null, (DateTimeParser[])Arrays.stream(this.configInputDateFormatList.split(this.configInputDateFormatDelimiter)).map(String::trim).map(DateTimeFormat::forPattern).map(DateTimeFormatter::getParser).toArray(DateTimeParser[]::new)).toFormatter();
        formatter = this.inputDateTimeZone != null ? formatter.withZone(this.inputDateTimeZone) : formatter.withOffsetParsed();
        return formatter;
    }

    @Override
    public String getOutputDateFormat() {
        return this.config.getString("hoodie.deltastreamer.keygen.timebased.output.dateformat");
    }

    @Override
    public Option<DateTimeFormatter> getInputFormatter() {
        TimestampBasedAvroKeyGenerator.TimestampType timestampType = TimestampBasedAvroKeyGenerator.TimestampType.valueOf(this.config.getString("hoodie.deltastreamer.keygen.timebased.timestamp.type"));
        if (timestampType == TimestampBasedAvroKeyGenerator.TimestampType.DATE_STRING || timestampType == TimestampBasedAvroKeyGenerator.TimestampType.MIXED) {
            KeyGenUtils.checkRequiredProperties(this.config, Collections.singletonList("hoodie.deltastreamer.keygen.timebased.input.dateformat"));
            this.configInputDateFormatList = this.config.getString("hoodie.deltastreamer.keygen.timebased.input.dateformat", "");
            return Option.of((Object)this.getInputDateFormatter());
        }
        return Option.empty();
    }

    @Override
    public DateTimeZone getInputDateTimeZone() {
        String inputTimeZone = this.config.containsKey((Object)"hoodie.deltastreamer.keygen.timebased.timezone") ? this.config.getString("hoodie.deltastreamer.keygen.timebased.timezone", "GMT") : this.config.getString("hoodie.deltastreamer.keygen.timebased.input.timezone", "");
        return !inputTimeZone.trim().isEmpty() ? DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(inputTimeZone)) : null;
    }

    @Override
    public DateTimeZone getOutputDateTimeZone() {
        String outputTimeZone = this.config.containsKey((Object)"hoodie.deltastreamer.keygen.timebased.timezone") ? this.config.getString("hoodie.deltastreamer.keygen.timebased.timezone", "GMT") : this.config.getString("hoodie.deltastreamer.keygen.timebased.output.timezone", "");
        return !outputTimeZone.trim().isEmpty() ? DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(outputTimeZone)) : null;
    }
}

