/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.avro.model.HoodieIndexCommitMetadata;
import org.apache.hudi.avro.model.HoodieIndexPlan;
import org.apache.hudi.avro.model.HoodieRestoreMetadata;
import org.apache.hudi.avro.model.HoodieRestorePlan;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieRollbackPlan;
import org.apache.hudi.avro.model.HoodieSavepointMetadata;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieJavaEngineContext;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.apache.hudi.exception.HoodieUpsertException;
import org.apache.hudi.io.HoodieCreateHandle;
import org.apache.hudi.io.HoodieMergeHandle;
import org.apache.hudi.io.HoodieSortedMergeHandle;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.HoodieCompactionHandler;
import org.apache.hudi.table.HoodieJavaTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.bootstrap.HoodieBootstrapWriteMetadata;
import org.apache.hudi.table.action.clean.CleanActionExecutor;
import org.apache.hudi.table.action.clean.CleanPlanActionExecutor;
import org.apache.hudi.table.action.cluster.ClusteringPlanActionExecutor;
import org.apache.hudi.table.action.cluster.JavaExecuteClusteringCommitActionExecutor;
import org.apache.hudi.table.action.commit.JavaBulkInsertCommitActionExecutor;
import org.apache.hudi.table.action.commit.JavaBulkInsertPreppedCommitActionExecutor;
import org.apache.hudi.table.action.commit.JavaDeleteCommitActionExecutor;
import org.apache.hudi.table.action.commit.JavaInsertCommitActionExecutor;
import org.apache.hudi.table.action.commit.JavaInsertOverwriteCommitActionExecutor;
import org.apache.hudi.table.action.commit.JavaInsertOverwriteTableCommitActionExecutor;
import org.apache.hudi.table.action.commit.JavaInsertPreppedCommitActionExecutor;
import org.apache.hudi.table.action.commit.JavaMergeHelper;
import org.apache.hudi.table.action.commit.JavaUpsertCommitActionExecutor;
import org.apache.hudi.table.action.commit.JavaUpsertPreppedCommitActionExecutor;
import org.apache.hudi.table.action.index.RunIndexActionExecutor;
import org.apache.hudi.table.action.index.ScheduleIndexActionExecutor;
import org.apache.hudi.table.action.restore.CopyOnWriteRestoreActionExecutor;
import org.apache.hudi.table.action.rollback.BaseRollbackPlanActionExecutor;
import org.apache.hudi.table.action.rollback.CopyOnWriteRollbackActionExecutor;
import org.apache.hudi.table.action.rollback.RestorePlanActionExecutor;
import org.apache.hudi.table.action.savepoint.SavepointActionExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieJavaCopyOnWriteTable<T extends HoodieRecordPayload>
extends HoodieJavaTable<T>
implements HoodieCompactionHandler<T> {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieJavaCopyOnWriteTable.class);

    protected HoodieJavaCopyOnWriteTable(HoodieWriteConfig config, HoodieEngineContext context, HoodieTableMetaClient metaClient) {
        super(config, context, metaClient);
    }

    public boolean isTableServiceAction(String actionType) {
        return !actionType.equals("commit");
    }

    public HoodieWriteMetadata<List<WriteStatus>> upsert(HoodieEngineContext context, String instantTime, List<HoodieRecord<T>> records) {
        return new JavaUpsertCommitActionExecutor<T>(context, this.config, (HoodieTable)this, instantTime, records).execute();
    }

    public HoodieWriteMetadata<List<WriteStatus>> insert(HoodieEngineContext context, String instantTime, List<HoodieRecord<T>> records) {
        return new JavaInsertCommitActionExecutor<T>(context, this.config, (HoodieTable)this, instantTime, records).execute();
    }

    public HoodieWriteMetadata<List<WriteStatus>> bulkInsert(HoodieEngineContext context, String instantTime, List<HoodieRecord<T>> records, Option<BulkInsertPartitioner> bulkInsertPartitioner) {
        return new JavaBulkInsertCommitActionExecutor<T>((HoodieJavaEngineContext)context, this.config, (HoodieTable)this, instantTime, records, bulkInsertPartitioner).execute();
    }

    public HoodieWriteMetadata<List<WriteStatus>> delete(HoodieEngineContext context, String instantTime, List<HoodieKey> keys) {
        return new JavaDeleteCommitActionExecutor(context, this.config, (HoodieTable)this, instantTime, keys).execute();
    }

    public HoodieWriteMetadata deletePartitions(HoodieEngineContext context, String instantTime, List<String> partitions) {
        throw new HoodieNotSupportedException("Delete partitions is not supported yet");
    }

    public HoodieWriteMetadata<List<WriteStatus>> upsertPrepped(HoodieEngineContext context, String instantTime, List<HoodieRecord<T>> preppedRecords) {
        return new JavaUpsertPreppedCommitActionExecutor<T>((HoodieJavaEngineContext)context, this.config, (HoodieTable)this, instantTime, preppedRecords).execute();
    }

    public HoodieWriteMetadata<List<WriteStatus>> insertPrepped(HoodieEngineContext context, String instantTime, List<HoodieRecord<T>> preppedRecords) {
        return new JavaInsertPreppedCommitActionExecutor<T>((HoodieJavaEngineContext)context, this.config, (HoodieTable)this, instantTime, preppedRecords).execute();
    }

    public HoodieWriteMetadata<List<WriteStatus>> bulkInsertPrepped(HoodieEngineContext context, String instantTime, List<HoodieRecord<T>> preppedRecords, Option<BulkInsertPartitioner> bulkInsertPartitioner) {
        return new JavaBulkInsertPreppedCommitActionExecutor<T>((HoodieJavaEngineContext)context, this.config, (HoodieTable)this, instantTime, preppedRecords, bulkInsertPartitioner).execute();
    }

    public HoodieWriteMetadata<List<WriteStatus>> insertOverwrite(HoodieEngineContext context, String instantTime, List<HoodieRecord<T>> records) {
        return new JavaInsertOverwriteCommitActionExecutor<T>(context, this.config, (HoodieTable)this, instantTime, records).execute();
    }

    public HoodieWriteMetadata<List<WriteStatus>> insertOverwriteTable(HoodieEngineContext context, String instantTime, List<HoodieRecord<T>> records) {
        return new JavaInsertOverwriteTableCommitActionExecutor<T>(context, this.config, (HoodieTable)this, instantTime, records).execute();
    }

    public Option<HoodieCompactionPlan> scheduleCompaction(HoodieEngineContext context, String instantTime, Option<Map<String, String>> extraMetadata) {
        throw new HoodieNotSupportedException("ScheduleCompaction is not supported on a CopyOnWrite table");
    }

    public HoodieWriteMetadata<List<WriteStatus>> compact(HoodieEngineContext context, String compactionInstantTime) {
        throw new HoodieNotSupportedException("Compaction is not supported on a CopyOnWrite table");
    }

    public Option<HoodieClusteringPlan> scheduleClustering(HoodieEngineContext context, String instantTime, Option<Map<String, String>> extraMetadata) {
        return new ClusteringPlanActionExecutor(context, this.config, (HoodieTable)this, instantTime, extraMetadata).execute();
    }

    public HoodieWriteMetadata<List<WriteStatus>> cluster(HoodieEngineContext context, String clusteringInstantTime) {
        return new JavaExecuteClusteringCommitActionExecutor(context, this.config, this, clusteringInstantTime).execute();
    }

    public HoodieBootstrapWriteMetadata<List<WriteStatus>> bootstrap(HoodieEngineContext context, Option<Map<String, String>> extraMetadata) {
        throw new HoodieNotSupportedException("Bootstrap is not supported yet");
    }

    public void rollbackBootstrap(HoodieEngineContext context, String instantTime) {
        throw new HoodieNotSupportedException("RollbackBootstrap is not supported yet");
    }

    public Option<HoodieRollbackPlan> scheduleRollback(HoodieEngineContext context, String instantTime, HoodieInstant instantToRollback, boolean skipTimelinePublish, boolean shouldRollbackUsingMarkers) {
        return new BaseRollbackPlanActionExecutor(context, this.config, (HoodieTable)this, instantTime, instantToRollback, skipTimelinePublish, shouldRollbackUsingMarkers).execute();
    }

    public Option<HoodieCleanerPlan> scheduleCleaning(HoodieEngineContext context, String instantTime, Option<Map<String, String>> extraMetadata) {
        return new CleanPlanActionExecutor(context, this.config, (HoodieTable)this, instantTime, extraMetadata).execute();
    }

    public HoodieCleanMetadata clean(HoodieEngineContext context, String cleanInstantTime, boolean skipLocking) {
        return new CleanActionExecutor(context, this.config, (HoodieTable)this, cleanInstantTime).execute();
    }

    public HoodieRollbackMetadata rollback(HoodieEngineContext context, String rollbackInstantTime, HoodieInstant commitInstant, boolean deleteInstants, boolean skipLocking) {
        return new CopyOnWriteRollbackActionExecutor(context, this.config, (HoodieTable)this, rollbackInstantTime, commitInstant, deleteInstants, skipLocking).execute();
    }

    public Option<HoodieIndexPlan> scheduleIndexing(HoodieEngineContext context, String indexInstantTime, List<MetadataPartitionType> partitionsToIndex) {
        return new ScheduleIndexActionExecutor(context, this.config, (HoodieTable)this, indexInstantTime, partitionsToIndex).execute();
    }

    public Option<HoodieIndexCommitMetadata> index(HoodieEngineContext context, String indexInstantTime) {
        return new RunIndexActionExecutor(context, this.config, (HoodieTable)this, indexInstantTime).execute();
    }

    public HoodieSavepointMetadata savepoint(HoodieEngineContext context, String instantToSavepoint, String user, String comment) {
        return new SavepointActionExecutor(context, this.config, (HoodieTable)this, instantToSavepoint, user, comment).execute();
    }

    public Option<HoodieRestorePlan> scheduleRestore(HoodieEngineContext context, String restoreInstantTime, String instantToRestore) {
        return new RestorePlanActionExecutor(context, this.config, (HoodieTable)this, restoreInstantTime, instantToRestore).execute();
    }

    public HoodieRestoreMetadata restore(HoodieEngineContext context, String restoreInstantTime, String instantToRestore) {
        return new CopyOnWriteRestoreActionExecutor(context, this.config, (HoodieTable)this, restoreInstantTime, instantToRestore).execute();
    }

    public Iterator<List<WriteStatus>> handleUpdate(String instantTime, String partitionPath, String fileId, Map<String, HoodieRecord<T>> keyToNewRecords, HoodieBaseFile oldDataFile) throws IOException {
        HoodieMergeHandle upsertHandle = this.getUpdateHandle(instantTime, partitionPath, fileId, keyToNewRecords, oldDataFile);
        return this.handleUpdateInternal(upsertHandle, instantTime, fileId);
    }

    protected Iterator<List<WriteStatus>> handleUpdateInternal(HoodieMergeHandle<?, ?, ?, ?> upsertHandle, String instantTime, String fileId) throws IOException {
        if (upsertHandle.getOldFilePath() == null) {
            throw new HoodieUpsertException("Error in finding the old file path at commit " + instantTime + " for fileId: " + fileId);
        }
        JavaMergeHelper.newInstance().runMerge(this, upsertHandle);
        if (upsertHandle.getPartitionPath() == null) {
            LOG.info("Upsert Handle has partition path as null " + upsertHandle.getOldFilePath() + ", " + upsertHandle.writeStatuses());
        }
        return Collections.singletonList(upsertHandle.writeStatuses()).iterator();
    }

    protected HoodieMergeHandle getUpdateHandle(String instantTime, String partitionPath, String fileId, Map<String, HoodieRecord<T>> keyToNewRecords, HoodieBaseFile dataFileToBeMerged) {
        if (this.requireSortedRecords()) {
            return new HoodieSortedMergeHandle(this.config, instantTime, (HoodieTable)this, keyToNewRecords, partitionPath, fileId, dataFileToBeMerged, this.taskContextSupplier, Option.empty());
        }
        return new HoodieMergeHandle(this.config, instantTime, (HoodieTable)this, keyToNewRecords, partitionPath, fileId, dataFileToBeMerged, this.taskContextSupplier, Option.empty());
    }

    public Iterator<List<WriteStatus>> handleInsert(String instantTime, String partitionPath, String fileId, Map<String, HoodieRecord<? extends HoodieRecordPayload>> recordMap) {
        HoodieCreateHandle createHandle = new HoodieCreateHandle(this.config, instantTime, (HoodieTable)this, partitionPath, fileId, recordMap, this.taskContextSupplier);
        createHandle.write();
        return Collections.singletonList(createHandle.close()).iterator();
    }
}

