/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table;

import java.util.List;
import java.util.Map;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieJavaEngineContext;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.HoodieJavaCopyOnWriteTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.commit.JavaBulkInsertPreppedCommitActionExecutor;
import org.apache.hudi.table.action.compact.HoodieJavaMergeOnReadTableCompactor;
import org.apache.hudi.table.action.compact.RunCompactionActionExecutor;
import org.apache.hudi.table.action.compact.ScheduleCompactionActionExecutor;
import org.apache.hudi.table.action.deltacommit.JavaUpsertPreppedDeltaCommitActionExecutor;

public class HoodieJavaMergeOnReadTable<T extends HoodieRecordPayload>
extends HoodieJavaCopyOnWriteTable<T> {
    protected HoodieJavaMergeOnReadTable(HoodieWriteConfig config, HoodieEngineContext context, HoodieTableMetaClient metaClient) {
        super(config, context, metaClient);
    }

    @Override
    public boolean isTableServiceAction(String actionType) {
        return !actionType.equals("deltacommit");
    }

    @Override
    public HoodieWriteMetadata<List<WriteStatus>> upsertPrepped(HoodieEngineContext context, String instantTime, List<HoodieRecord<T>> preppedRecords) {
        return new JavaUpsertPreppedDeltaCommitActionExecutor<T>((HoodieJavaEngineContext)context, this.config, (HoodieTable)this, instantTime, preppedRecords).execute();
    }

    @Override
    public HoodieWriteMetadata<List<WriteStatus>> bulkInsertPrepped(HoodieEngineContext context, String instantTime, List<HoodieRecord<T>> preppedRecords, Option<BulkInsertPartitioner> bulkInsertPartitioner) {
        return new JavaBulkInsertPreppedCommitActionExecutor<T>((HoodieJavaEngineContext)context, this.config, (HoodieTable)this, instantTime, preppedRecords, bulkInsertPartitioner).execute();
    }

    @Override
    public Option<HoodieCompactionPlan> scheduleCompaction(HoodieEngineContext context, String instantTime, Option<Map<String, String>> extraMetadata) {
        ScheduleCompactionActionExecutor scheduleCompactionExecutor = new ScheduleCompactionActionExecutor(context, this.config, (HoodieTable)this, instantTime, extraMetadata, new HoodieJavaMergeOnReadTableCompactor());
        return scheduleCompactionExecutor.execute();
    }

    @Override
    public HoodieWriteMetadata<List<WriteStatus>> compact(HoodieEngineContext context, String compactionInstantTime) {
        RunCompactionActionExecutor compactionExecutor = new RunCompactionActionExecutor(context, this.config, (HoodieTable)this, compactionInstantTime, new HoodieJavaMergeOnReadTableCompactor(), new HoodieJavaCopyOnWriteTable(this.config, context, this.getMetaClient()));
        return HoodieJavaMergeOnReadTable.convertMetadata((HoodieWriteMetadata<HoodieData<WriteStatus>>)compactionExecutor.execute());
    }
}

