/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.util.function.Supplier;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieSavepointException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.CreateSavepointsProcedure$;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\u0001\u0003\u0001E\u0011\u0011d\u0011:fCR,7+\u0019<fa>Lg\u000e^:Qe>\u001cW\rZ;sK*\u00111\u0001B\u0001\u000baJ|7-\u001a3ve\u0016\u001c(BA\u0003\u0007\u0003\u001d\u0019w.\\7b]\u0012T!a\u0002\u0005\u0002\t!,H-\u001b\u0006\u0003\u0013)\t1a]9m\u0015\tYA\"A\u0003ta\u0006\u00148N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<7\u0001A\n\u0005\u0001I1\u0012\u0004\u0005\u0002\u0014)5\t!!\u0003\u0002\u0016\u0005\ti!)Y:f!J|7-\u001a3ve\u0016\u0004\"aE\f\n\u0005a\u0011!\u0001\u0005)s_\u000e,G-\u001e:f\u0005VLG\u000eZ3s!\tQR$D\u0001\u001c\u0015\ta\"\"\u0001\u0005j]R,'O\\1m\u0013\tq2DA\u0004M_\u001e<\u0017N\\4\t\u000b\u0001\u0002A\u0011A\u0011\u0002\rqJg.\u001b;?)\u0005\u0011\u0003CA\n\u0001\u0011\u001d!\u0003A1A\u0005\n\u0015\n!\u0002U!S\u00036+E+\u0012*T+\u00051\u0003cA\u0014+Y5\t\u0001FC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003FA\u0003BeJ\f\u0017\u0010\u0005\u0002\u0014[%\u0011aF\u0001\u0002\u0013!J|7-\u001a3ve\u0016\u0004\u0016M]1nKR,'\u000f\u0003\u00041\u0001\u0001\u0006IAJ\u0001\f!\u0006\u0013\u0016)T#U\u000bJ\u001b\u0006\u0005C\u00043\u0001\t\u0007I\u0011B\u001a\u0002\u0017=+F\u000bU+U?RK\u0006+R\u000b\u0002iA\u0011Q\u0007O\u0007\u0002m)\u0011q\u0007C\u0001\u0006if\u0004Xm]\u0005\u0003sY\u0012!b\u0015;sk\u000e$H+\u001f9f\u0011\u0019Y\u0004\u0001)A\u0005i\u0005aq*\u0016+Q+R{F+\u0017)FA!)Q\b\u0001C\u0001K\u0005Q\u0001/\u0019:b[\u0016$XM]:\t\u000b}\u0002A\u0011A\u001a\u0002\u0015=,H\u000f];u)f\u0004X\rC\u0003B\u0001\u0011\u0005#)\u0001\u0003dC2dGCA\"T!\r!Ej\u0014\b\u0003\u000b*s!AR%\u000e\u0003\u001dS!\u0001\u0013\t\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0013BA&)\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0014(\u0003\u0007M+\u0017O\u0003\u0002LQA\u0011\u0001+U\u0007\u0002\u0011%\u0011!\u000b\u0003\u0002\u0004%><\b\"\u0002+A\u0001\u0004)\u0016\u0001B1sON\u0004\"a\u0005,\n\u0005]\u0013!!\u0004)s_\u000e,G-\u001e:f\u0003J<7\u000fC\u0003Z\u0001\u0011\u0005#,A\u0003ck&dG-F\u0001\\!\t\u0019B,\u0003\u0002^\u0005\tI\u0001K]8dK\u0012,(/Z\u0004\u0006?\nA\t\u0001Y\u0001\u001a\u0007J,\u0017\r^3TCZ,\u0007o\\5oiN\u0004&o\\2fIV\u0014X\r\u0005\u0002\u0014C\u001a)\u0011A\u0001E\u0001EN\u0011\u0011m\u0019\t\u0003O\u0011L!!\u001a\u0015\u0003\r\u0005s\u0017PU3g\u0011\u0015\u0001\u0013\r\"\u0001h)\u0005\u0001\u0007bB5b\u0005\u0004%\tA[\u0001\u0005\u001d\u0006kU)F\u0001l!\tawN\u0004\u0002([&\u0011a\u000eK\u0001\u0007!J,G-\u001a4\n\u0005A\f(AB*ue&twM\u0003\u0002oQ!11/\u0019Q\u0001\n-\fQAT!N\u000b\u0002BQ!^1\u0005\u0002Y\fqAY;jY\u0012,'/F\u0001x!\rAxPF\u0007\u0002s*\u0011!p_\u0001\tMVt7\r^5p]*\u0011A0`\u0001\u0005kRLGNC\u0001\u007f\u0003\u0011Q\u0017M^1\n\u0007\u0005\u0005\u0011P\u0001\u0005TkB\u0004H.[3s\u0001")
public class CreateSavepointsProcedure
extends BaseProcedure
implements ProcedureBuilder,
Logging {
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Supplier<ProcedureBuilder> builder() {
        return CreateSavepointsProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return CreateSavepointsProcedure$.MODULE$.NAME();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Seq<Row> call(ProcedureArgs args) {
        super.checkArgs(this.PARAMETERS(), args);
        Option<Object> tableName = this.getArgValueOrDefault(args, this.PARAMETERS()[0]);
        String commitTime = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[1]).get();
        String user = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[2]).get();
        String comments = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[3]).get();
        String basePath = this.getBasePath(tableName, this.getBasePath$default$2());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(basePath).build();
        HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
        if (!activeTimeline.getCommitsTimeline().filterCompletedInstants().containsInstant(commitTime)) throw new HoodieException(new StringBuilder().append((Object)"Commit ").append((Object)commitTime).append((Object)" not found in Commits ").append((Object)activeTimeline).toString());
        SparkRDDWriteClient<? extends HoodieRecordPayload<?>> client = this.createHoodieClient(this.jsc(), basePath);
        boolean result = false;
        try {
            client.savepoint(commitTime, user, comments);
            this.logInfo((Function0<String>)new Serializable(this, commitTime){
                public static final long serialVersionUID = 0L;
                private final String commitTime$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The commit ", " has been savepointed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.commitTime$1}));
                }
                {
                    this.commitTime$1 = commitTime$1;
                }
            });
            result = true;
            return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)result)}))}));
        }
        catch (HoodieSavepointException hoodieSavepointException) {
            this.logWarning((Function0<String>)new Serializable(this, commitTime){
                public static final long serialVersionUID = 0L;
                private final String commitTime$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed: Could not create savepoint ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.commitTime$1}));
                }
                {
                    this.commitTime$1 = commitTime$1;
                }
            });
        }
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)result)}))}));
    }

    @Override
    public Procedure build() {
        return new CreateSavepointsProcedure();
    }

    public CreateSavepointsProcedure() {
        Logging.class.$init$((Logging)this);
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.required(1, "commit_Time", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(2, "user", DataTypes.StringType, ""), ProcedureParameter$.MODULE$.optional(3, "comments", DataTypes.StringType, "")});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("create_savepoint_result", DataTypes.BooleanType, true, Metadata$.MODULE$.empty())}));
    }
}

