/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import org.apache.hudi.HoodieSparkUtils$;
import org.apache.spark.sql.HoodieCatalystExpressionUtils$;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.StringContains;
import org.apache.spark.sql.sources.StringEndsWith;
import org.apache.spark.sql.sources.StringStartsWith;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001B\u0001\u0003\u0001%\u0011Q\u0005V3ti\u000e{gN^3si\u001aKG\u000e^3s)>\u001c\u0015\r^1msN$X\t\u001f9sKN\u001c\u0018n\u001c8\u000b\u0005\r!\u0011\u0001\u00025vI&T!!\u0002\u0004\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0011aA8sO\u000e\u00011C\u0001\u0001\u000b!\tYa\"D\u0001\r\u0015\u0005i\u0011!B:dC2\f\u0017BA\b\r\u0005\u0019\te.\u001f*fM\")\u0011\u0003\u0001C\u0001%\u00051A(\u001b8jiz\"\u0012a\u0005\t\u0003)\u0001i\u0011A\u0001\u0005\t-\u0001A)\u0019!C\u0005/\u0005YA/\u00192mKN\u001b\u0007.Z7b+\u0005A\u0002CA\r!\u001b\u0005Q\"BA\u000e\u001d\u0003\u0015!\u0018\u0010]3t\u0015\tib$A\u0002tc2T!a\b\u0003\u0002\u000bM\u0004\u0018M]6\n\u0005\u0005R\"AC*ueV\u001cG\u000fV=qK\"A1\u0005\u0001E\u0001B\u0003&\u0001$\u0001\u0007uC\ndWmU2iK6\f\u0007\u0005C\u0003&\u0001\u0011%a%A\u000ed_:4XM\u001d;U_\u000e\u000bG/\u00197zgR,\u0005\u0010\u001d:fgNLwN\u001c\u000b\u0004OIj\u0004cA\u0006)U%\u0011\u0011\u0006\u0004\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005-\u0002T\"\u0001\u0017\u000b\u00055r\u0013aC3yaJ,7o]5p]NT!a\f\u000f\u0002\u0011\r\fG/\u00197zgRL!!\r\u0017\u0003\u0015\u0015C\bO]3tg&|g\u000eC\u00034I\u0001\u0007A'A\u0004gS2$XM]:\u0011\u0007-)t'\u0003\u00027\u0019\t)\u0011I\u001d:bsB\u0011\u0001hO\u0007\u0002s)\u0011!\bH\u0001\bg>,(oY3t\u0013\ta\u0014H\u0001\u0004GS2$XM\u001d\u0005\u0006-\u0011\u0002\r\u0001\u0007\u0005\u0006\u007f\u0001!\t\u0001Q\u0001\u0010i\u0016\u001cHOQ1tK\u000e{gN^3siR\t\u0011\t\u0005\u0002\f\u0005&\u00111\t\u0004\u0002\u0005+:LG\u000f\u000b\u0002?\u000bB\u0011a)T\u0007\u0002\u000f*\u0011\u0001*S\u0001\u0004CBL'B\u0001&L\u0003\u001dQW\u000f]5uKJT!\u0001\u0014\u0004\u0002\u000b),h.\u001b;\n\u00059;%\u0001\u0002+fgRDQ\u0001\u0015\u0001\u0005\u0002\u0001\u000b!\u0003^3ti\u000e{gN^3si\u001aKG\u000e^3sg\"\u0012q*\u0012\u0005\u0006'\u0002!I\u0001V\u0001\u0013G\",7m[\"p]Z,'\u000f\u001e$jYR,'\u000fF\u0002B+^CQA\u0016*A\u0002]\naAZ5mi\u0016\u0014\b\"\u0002-S\u0001\u0004I\u0016\u0001E3ya\u0016\u001cG/\u0012=qe\u0016\u001c8/[8o!\tQVL\u0004\u0002\f7&\u0011A\fD\u0001\u0007!J,G-\u001a4\n\u0005y{&AB*ue&twM\u0003\u0002]\u0019!)\u0011\r\u0001C\u0005E\u0006\u00192\r[3dW\u000e{gN^3si\u001aKG\u000e^3sgR\u0019\u0011i\u00193\t\u000bM\u0002\u0007\u0019\u0001\u001b\t\u000ba\u0003\u0007\u0019A-\t\u000b\u0019\u0004A\u0011B4\u0002\u0005\u0015\fHcA\u001ciU\")\u0011.\u001aa\u00013\u0006I\u0011\r\u001e;sS\n,H/\u001a\u0005\u0006W\u0016\u0004\r\u0001\\\u0001\u0006m\u0006dW/\u001a\t\u0003\u00175L!A\u001c\u0007\u0003\u0007\u0005s\u0017\u0010C\u0003q\u0001\u0011%\u0011/A\u0002fcN$2a\u000e:t\u0011\u0015Iw\u000e1\u0001Z\u0011\u0015Yw\u000e1\u0001m\u0011\u0015)\b\u0001\"\u0003w\u0003\t9G\u000fF\u00028obDQ!\u001b;A\u0002eCQa\u001b;A\u00021DQA\u001f\u0001\u0005\nm\f1a\u001a;f)\r9D0 \u0005\u0006Sf\u0004\r!\u0017\u0005\u0006Wf\u0004\r\u0001\u001c\u0005\u0007\u007f\u0002!I!!\u0001\u0002\u00051$H#B\u001c\u0002\u0004\u0005\u0015\u0001\"B5\u007f\u0001\u0004I\u0006\"B6\u007f\u0001\u0004a\u0007bBA\u0005\u0001\u0011%\u00111B\u0001\u0004YR,G#B\u001c\u0002\u000e\u0005=\u0001BB5\u0002\b\u0001\u0007\u0011\f\u0003\u0004l\u0003\u000f\u0001\r\u0001\u001c\u0005\b\u0003'\u0001A\u0011BA\u000b\u0003\tIg\u000eF\u00038\u0003/\tI\u0002\u0003\u0004j\u0003#\u0001\r!\u0017\u0005\t\u00037\t\t\u00021\u0001\u0002\u001e\u00051a/\u00197vKN\u0004BaCA\u0010Y&\u0019\u0011\u0011\u0005\u0007\u0003\u0015q\u0012X\r]3bi\u0016$g\bC\u0004\u0002&\u0001!I!a\n\u0002\r%\u001ch*\u001e7m)\r9\u0014\u0011\u0006\u0005\u0007S\u0006\r\u0002\u0019A-\t\u000f\u00055\u0002\u0001\"\u0003\u00020\u0005I\u0011n\u001d(pi:+H\u000e\u001c\u000b\u0004o\u0005E\u0002BB5\u0002,\u0001\u0007\u0011\fC\u0004\u00026\u0001!I!a\u000e\u0002\u0007\u0005tG\rF\u00038\u0003s\ti\u0004C\u0004\u0002<\u0005M\u0002\u0019A\u001c\u0002\t1,g\r\u001e\u0005\b\u0003\u007f\t\u0019\u00041\u00018\u0003\u0015\u0011\u0018n\u001a5u\u0011\u001d\t\u0019\u0005\u0001C\u0005\u0003\u000b\n!a\u001c:\u0015\u000b]\n9%!\u0013\t\u000f\u0005m\u0012\u0011\ta\u0001o!9\u0011qHA!\u0001\u00049\u0004bBA'\u0001\u0011%\u0011qJ\u0001\u0004]>$HcA\u001c\u0002R!9\u00111KA&\u0001\u00049\u0014!B2iS2$\u0007bBA,\u0001\u0011%\u0011\u0011L\u0001\ngR\f'\u000f^,ji\"$RaNA.\u0003;Ba![A+\u0001\u0004I\u0006BB6\u0002V\u0001\u0007\u0011\fC\u0004\u0002b\u0001!I!a\u0019\u0002\u000f\u0015tGmV5uQR)q'!\u001a\u0002h!1\u0011.a\u0018A\u0002eCaa[A0\u0001\u0004I\u0006bBA6\u0001\u0011%\u0011QN\u0001\tG>tG/Y5ogR)q'a\u001c\u0002r!1\u0011.!\u001bA\u0002eCaa[A5\u0001\u0004I\u0006")
public class TestConvertFilterToCatalystExpression {
    private StructType tableSchema;
    private volatile boolean bitmap$0;

    private StructType tableSchema$lzycompute() {
        TestConvertFilterToCatalystExpression testConvertFilterToCatalystExpression = this;
        synchronized (testConvertFilterToCatalystExpression) {
            if (!this.bitmap$0) {
                ArrayBuffer fields = new ArrayBuffer();
                fields.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("id", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4())}));
                fields.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("name", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4())}));
                fields.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("price", (DataType)DoubleType$.MODULE$, true, StructField$.MODULE$.apply$default$4())}));
                fields.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("ts", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4())}));
                this.tableSchema = StructType$.MODULE$.apply((Seq)fields);
                this.bitmap$0 = true;
            }
            return this.tableSchema;
        }
    }

    private StructType tableSchema() {
        return this.bitmap$0 ? this.tableSchema : this.tableSchema$lzycompute();
    }

    private Option<Expression> convertToCatalystExpression(Filter[] filters, StructType tableSchema) {
        Option[] expressions = (Option[])Predef$.MODULE$.refArrayOps((Object[])filters).map((Function1)new Serializable(this, tableSchema){
            public static final long serialVersionUID = 0L;
            private final StructType tableSchema$1;

            public final Option<Expression> apply(Filter x$1) {
                return HoodieCatalystExpressionUtils$.MODULE$.convertToCatalystExpression(x$1, this.tableSchema$1);
            }
            {
                this.tableSchema$1 = tableSchema$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Option.class)));
        return Predef$.MODULE$.refArrayOps((Object[])expressions).nonEmpty() && Predef$.MODULE$.refArrayOps((Object[])expressions).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Option<Expression> p) {
                return p.isDefined();
            }
        }) ? new Some(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])expressions).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Expression apply(Option<Expression> x$2) {
                return (Expression)x$2.get();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Expression.class)))).reduce((Function2)And$.MODULE$)) : None$.MODULE$;
    }

    @Test
    public void testBaseConvert() {
        this.checkConvertFilter(this.eq("id", BoxesRunTime.boxToInteger((int)1)), "(`id` = 1)");
        this.checkConvertFilter(this.eqs("name", "a1"), "(`name` <=> 'a1')");
        this.checkConvertFilter(this.lt("price", BoxesRunTime.boxToInteger((int)10)), "(`price` < 10)");
        this.checkConvertFilter(this.lte("ts", BoxesRunTime.boxToInteger((int)1)), "(`ts` <= 1)");
        this.checkConvertFilter(this.gt("price", BoxesRunTime.boxToInteger((int)10)), "(`price` > 10)");
        this.checkConvertFilter(this.gte("price", BoxesRunTime.boxToInteger((int)10)), "(`price` >= 10)");
        this.checkConvertFilter(this.in("id", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)})), "(`id` IN (1, 2, 3))");
        this.checkConvertFilter(this.isNull("id"), "(`id` IS NULL)");
        this.checkConvertFilter(this.isNotNull("name"), "(`name` IS NOT NULL)");
        this.checkConvertFilter(this.and(this.lt("ts", BoxesRunTime.boxToInteger((int)10)), this.gt("ts", BoxesRunTime.boxToInteger((int)1))), "((`ts` < 10) AND (`ts` > 1))");
        this.checkConvertFilter(this.or(this.lte("ts", BoxesRunTime.boxToInteger((int)10)), this.gte("ts", BoxesRunTime.boxToInteger((int)1))), "((`ts` <= 10) OR (`ts` >= 1))");
        this.checkConvertFilter(this.not(this.and(this.lt("ts", BoxesRunTime.boxToInteger((int)10)), this.gt("ts", BoxesRunTime.boxToInteger((int)1)))), "(NOT ((`ts` < 10) AND (`ts` > 1)))");
        this.checkConvertFilter(this.startWith("name", "ab"), "`name` LIKE 'ab%'");
        this.checkConvertFilter(this.endWith("name", "cd"), "`name` LIKE '%cd'");
        this.checkConvertFilter(this.contains("name", "e"), "`name` LIKE '%e%'");
    }

    @Test
    public void testConvertFilters() {
        this.checkConvertFilters((Filter[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Filter.class)), null);
        this.checkConvertFilters((Filter[])((Object[])new Filter[]{this.eq("id", BoxesRunTime.boxToInteger((int)1))}), "(`id` = 1)");
        this.checkConvertFilters((Filter[])((Object[])new Filter[]{this.lt("ts", BoxesRunTime.boxToInteger((int)10)), this.gt("ts", BoxesRunTime.boxToInteger((int)1))}), "((`ts` < 10) AND (`ts` > 1))");
    }

    private void checkConvertFilter(Filter filter, String expectExpression) {
        String removeQuotesIfNeed = expectExpression != null && HoodieSparkUtils$.MODULE$.gteqSpark3_2() ? expectExpression.replace("`", "") : expectExpression;
        Option exp = HoodieCatalystExpressionUtils$.MODULE$.convertToCatalystExpression(filter, this.tableSchema());
        if (removeQuotesIfNeed == null) {
            Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)exp.isEmpty()), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else {
            Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)exp.isDefined()), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            Assertions.assertEquals((Object)removeQuotesIfNeed, (Object)((Expression)exp.get()).sql());
        }
    }

    private void checkConvertFilters(Filter[] filters, String expectExpression) {
        String removeQuotesIfNeed = expectExpression != null && HoodieSparkUtils$.MODULE$.gteqSpark3_2() ? expectExpression.replace("`", "") : expectExpression;
        Option<Expression> exp = this.convertToCatalystExpression(filters, this.tableSchema());
        if (removeQuotesIfNeed == null) {
            Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)exp.isEmpty()), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else {
            Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)exp.isDefined()), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            Assertions.assertEquals((Object)removeQuotesIfNeed, (Object)((Expression)exp.get()).sql());
        }
    }

    private Filter eq(String attribute, Object value) {
        return new EqualTo(attribute, value);
    }

    private Filter eqs(String attribute, Object value) {
        return new EqualNullSafe(attribute, value);
    }

    private Filter gt(String attribute, Object value) {
        return new GreaterThan(attribute, value);
    }

    private Filter gte(String attribute, Object value) {
        return new GreaterThanOrEqual(attribute, value);
    }

    private Filter lt(String attribute, Object value) {
        return new LessThan(attribute, value);
    }

    private Filter lte(String attribute, Object value) {
        return new LessThanOrEqual(attribute, value);
    }

    private Filter in(String attribute, Seq<Object> values) {
        return new In(attribute, (Object[])values.toArray(ClassTag$.MODULE$.Any()));
    }

    private Filter isNull(String attribute) {
        return new IsNull(attribute);
    }

    private Filter isNotNull(String attribute) {
        return new IsNotNull(attribute);
    }

    private Filter and(Filter left, Filter right) {
        return new And(left, right);
    }

    private Filter or(Filter left, Filter right) {
        return new Or(left, right);
    }

    private Filter not(Filter child) {
        return new Not(child);
    }

    private Filter startWith(String attribute, String value) {
        return new StringStartsWith(attribute, value);
    }

    private Filter endWith(String attribute, String value) {
        return new StringEndsWith(attribute, value);
    }

    private Filter contains(String attribute, String value) {
        return new StringContains(attribute, value);
    }
}

