/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.ScalaAssertionSupport;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.model.EmptyHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodiePayloadConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieKeyException;
import org.apache.hudi.keygen.ComplexKeyGenerator;
import org.apache.hudi.keygen.GlobalDeleteKeyGenerator;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.keygen.SimpleKeyGenerator;
import org.apache.hudi.keygen.SparkKeyGeneratorInterface;
import org.apache.hudi.testutils.KeyGeneratorTestUtilities;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t\u0015a\u0001B\u0001\u0003\u0001%\u0011a\u0003V3ti\u0012\u000bG/Y*pkJ\u001cW\rR3gCVdGo\u001d\u0006\u0003\u0007\u0011\tA\u0001[;eS*\u0011QAB\u0001\u0007CB\f7\r[3\u000b\u0003\u001d\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0006\u0011\u0005-aQ\"\u0001\u0002\n\u00055\u0011!!F*dC2\f\u0017i]:feRLwN\\*vaB|'\u000f\u001e\u0005\u0006\u001f\u0001!\t\u0001E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0001\"a\u0003\u0001\t\u000fM\u0001!\u0019!C\u0001)\u000511o\u00195f[\u0006,\u0012!\u0006\t\u0003-ei\u0011a\u0006\u0006\u00031\u0011\tA!\u0019<s_&\u0011!d\u0006\u0002\u0007'\u000eDW-\\1\t\rq\u0001\u0001\u0015!\u0003\u0016\u0003\u001d\u00198\r[3nC\u0002BqA\b\u0001C\u0002\u0013\u0005q$\u0001\u0006tiJ,8\r\u001e+za\u0016,\u0012\u0001\t\t\u0003C!j\u0011A\t\u0006\u0003G\u0011\nQ\u0001^=qKNT!!\n\u0014\u0002\u0007M\fHN\u0003\u0002(\t\u0005)1\u000f]1sW&\u0011\u0011F\t\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007BB\u0016\u0001A\u0003%\u0001%A\u0006tiJ,8\r\u001e+za\u0016\u0004\u0003\"C\u0017\u0001\u0001\u0004\u0005\r\u0011\"\u0001/\u0003)\u0011\u0017m]3SK\u000e|'\u000fZ\u000b\u0002_A\u0011\u0001gM\u0007\u0002c)\u0011!gF\u0001\bO\u0016tWM]5d\u0013\t!\u0014GA\u0007HK:,'/[2SK\u000e|'\u000f\u001a\u0005\nm\u0001\u0001\r\u00111A\u0005\u0002]\naBY1tKJ+7m\u001c:e?\u0012*\u0017\u000f\u0006\u00029}A\u0011\u0011\bP\u0007\u0002u)\t1(A\u0003tG\u0006d\u0017-\u0003\u0002>u\t!QK\\5u\u0011\u001dyT'!AA\u0002=\n1\u0001\u001f\u00132\u0011\u0019\t\u0005\u0001)Q\u0005_\u0005Y!-Y:f%\u0016\u001cwN\u001d3!\u0011%\u0019\u0005\u00011AA\u0002\u0013\u0005A)A\u0004cCN,'k\\<\u0016\u0003\u0015\u0003\"AR$\u000e\u0003\u0011J!\u0001\u0013\u0013\u0003\u0007I{w\u000fC\u0005K\u0001\u0001\u0007\t\u0019!C\u0001\u0017\u0006Y!-Y:f%><x\fJ3r)\tAD\nC\u0004@\u0013\u0006\u0005\t\u0019A#\t\r9\u0003\u0001\u0015)\u0003F\u0003!\u0011\u0017m]3S_^\u0004\u0003\"\u0003)\u0001\u0001\u0004\u0005\r\u0011\"\u0001R\u0003-Ig\u000e^3s]\u0006d'k\\<\u0016\u0003I\u0003\"a\u0015,\u000e\u0003QS!!\u0016\u0013\u0002\u0011\r\fG/\u00197zgRL!a\u0016+\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0005\n3\u0002\u0001\r\u00111A\u0005\u0002i\u000bq\"\u001b8uKJt\u0017\r\u001c*po~#S-\u001d\u000b\u0003qmCqa\u0010-\u0002\u0002\u0003\u0007!\u000b\u0003\u0004^\u0001\u0001\u0006KAU\u0001\rS:$XM\u001d8bYJ{w\u000f\t\u0005\b?\u0002\u0011\r\u0011\"\u0001a\u00039!Xm\u001d;TiJ,8\r\u001e(b[\u0016,\u0012!\u0019\t\u0003E\u001el\u0011a\u0019\u0006\u0003I\u0016\fA\u0001\\1oO*\ta-\u0001\u0003kCZ\f\u0017B\u00015d\u0005\u0019\u0019FO]5oO\"1!\u000e\u0001Q\u0001\n\u0005\fq\u0002^3tiN#(/^2u\u001d\u0006lW\r\t\u0005\bY\u0002\u0011\r\u0011\"\u0001a\u00035!Xm\u001d;OC6,7\u000f]1dK\"1a\u000e\u0001Q\u0001\n\u0005\fa\u0002^3ti:\u000bW.Z:qC\u000e,\u0007\u0005C\u0003q\u0001\u0011\u0005\u0011/\u0001\u0006j]&$\u0018.\u00197ju\u0016$\u0012\u0001\u000f\u0015\u0003_N\u0004\"\u0001^>\u000e\u0003UT!A^<\u0002\u0007\u0005\u0004\u0018N\u0003\u0002ys\u00069!.\u001e9ji\u0016\u0014(B\u0001>\u0007\u0003\u0015QWO\\5u\u0013\taXO\u0001\u0006CK\u001a|'/Z#bG\"DQA \u0001\u0005\n}\fAbZ3u\u0017\u0016L8i\u001c8gS\u001e$\u0002\"!\u0001\u0002\u0012\u0005\u0005\u0012Q\u0005\t\u0005\u0003\u0007\ti!\u0004\u0002\u0002\u0006)!\u0011qAA\u0005\u0003\u0019\u0019wN\u001c4jO*\u0019\u00111\u0002\u0002\u0002\r\r|W.\\8o\u0013\u0011\ty!!\u0002\u0003\u001fQK\b/\u001a3Qe>\u0004XM\u001d;jKNDq!a\u0005~\u0001\u0004\t)\"\u0001\nsK\u000e|'\u000fZ&fs\u001aKW\r\u001c3OC6,\u0007\u0003BA\f\u0003;q1!OA\r\u0013\r\tYBO\u0001\u0007!J,G-\u001a4\n\u0007!\fyBC\u0002\u0002\u001ciBq!a\t~\u0001\u0004\t)\"\u0001\nqCJ$\u0018\u000e^5p]B\u000bG\u000f\u001b$jK2$\u0007bBA\u0014{\u0002\u0007\u0011QC\u0001\u0016Q&4Xm\u0015;zY\u0016\u0004\u0016M\u001d;ji&|g.\u001b8h\u0011\u0019\tY\u0003\u0001C\u0001c\u00061B/Z:u'&l\u0007\u000f\\3LKf<UM\\3sCR|'\u000f\u000b\u0003\u0002*\u0005=\u0002c\u0001;\u00022%\u0019\u00111G;\u0003\tQ+7\u000f\u001e\u0005\u0007\u0003o\u0001A\u0011A9\u0002QQ,7\u000f^+tKJ$UMZ5oK\u0012\\U-_$f]\u0016\u0014\u0018\r^8s/>\u00148n],ji\"\u0014vn^:)\t\u0005U\u0012q\u0006\u0004\u0007\u0003{\u0001\u0001!a\u0010\u0003/U\u001bXM\u001d#fM&tW\rZ&fs\u001e+g.\u001a:bi>\u00148CBA\u001e\u0003\u0003\ni\u0005\u0005\u0003\u0002D\u0005%SBAA#\u0015\r\t9EA\u0001\u0007W\u0016Lx-\u001a8\n\t\u0005-\u0013Q\t\u0002\r\u0017\u0016Lx)\u001a8fe\u0006$xN\u001d\t\u0005\u0003\u0007\ny%\u0003\u0003\u0002R\u0005\u0015#AG*qCJ\\7*Z=HK:,'/\u0019;pe&sG/\u001a:gC\u000e,\u0007bCA+\u0003w\u0011\t\u0011)A\u0005\u0003\u0003\tQ\u0001\u001d:paNDqaDA\u001e\t\u0003\tI\u0006\u0006\u0003\u0002\\\u0005}\u0003\u0003BA/\u0003wi\u0011\u0001\u0001\u0005\t\u0003+\n9\u00061\u0001\u0002\u0002!Q\u00111MA\u001e\u0005\u0004%\t!!\u001a\u0002\u001bI,7m\u001c:e\u0017\u0016L\bK]8q+\t\t)\u0002C\u0005\u0002j\u0005m\u0002\u0015!\u0003\u0002\u0016\u0005q!/Z2pe\u0012\\U-\u001f)s_B\u0004\u0003BCA7\u0003w\u0011\r\u0011\"\u0001\u0002f\u0005\t\u0002/\u0019:uSRLwN\u001c)bi\"\u0004&o\u001c9\t\u0013\u0005E\u00141\bQ\u0001\n\u0005U\u0011A\u00059beRLG/[8o!\u0006$\b\u000e\u0015:pa\u0002B!\"!\u001e\u0002<\t\u0007I\u0011AA3\u0003-\u0019FKU+D)~s\u0015)T#\t\u0013\u0005e\u00141\bQ\u0001\n\u0005U\u0011\u0001D*U%V\u001bEk\u0018(B\u001b\u0016\u0003\u0003BCA?\u0003w\u0011\r\u0011\"\u0001\u0002f\u0005Ia*Q'F'B\u000b5)\u0012\u0005\n\u0003\u0003\u000bY\u0004)A\u0005\u0003+\t!BT!N\u000bN\u0003\u0016iQ#!\u00111\t))a\u000fA\u0002\u0003\u0007I\u0011AAD\u0003-\u0019wN\u001c<feR,'O\u00128\u0016\u0005\u0005%\u0005#B\u001d\u0002\f\u0016{\u0013bAAGu\tIa)\u001e8di&|g.\r\u0005\r\u0003#\u000bY\u00041AA\u0002\u0013\u0005\u00111S\u0001\u0010G>tg/\u001a:uKJ4en\u0018\u0013fcR\u0019\u0001(!&\t\u0013}\ny)!AA\u0002\u0005%\u0005\"CAM\u0003w\u0001\u000b\u0015BAE\u00031\u0019wN\u001c<feR,'O\u00128!\u0011!\ti*a\u000f\u0005B\u0005}\u0015AB4fi.+\u0017\u0010\u0006\u0003\u0002\"\u00065\u0006\u0003BAR\u0003Sk!!!*\u000b\t\u0005\u001d\u0016\u0011B\u0001\u0006[>$W\r\\\u0005\u0005\u0003W\u000b)KA\u0005I_>$\u0017.Z&fs\"9\u0011qVAN\u0001\u0004y\u0013A\u0002:fG>\u0014H\r\u0003\u0005\u00024\u0006mB\u0011IA[\u000319W\r\u001e*fG>\u0014HmS3z)\u0011\t)\"a.\t\u000f\u0005e\u0016\u0011\u0017a\u0001\u000b\u0006\u0019!o\\<\t\u0011\u0005M\u00161\bC!\u0003{#b!a0\u0002N\u0006=\u0007\u0003BAa\u0003\u0013l!!a1\u000b\u0007\r\n)MC\u0002\u0002H\u001a\na!\u001e8tC\u001a,\u0017\u0002BAf\u0003\u0007\u0014!\"\u0016+GqM#(/\u001b8h\u0011\u001d\tI,a/A\u0002ICaaEA^\u0001\u0004\u0001\u0003\u0002CAj\u0003w!\t%!6\u0002!\u001d,G\u000fU1si&$\u0018n\u001c8QCRDG\u0003BA\u000b\u0003/Dq!!/\u0002R\u0002\u0007Q\t\u0003\u0005\u0002T\u0006mB\u0011IAn)\u0019\ty,!8\u0002`\"1\u0001+!7A\u0002ICaAHAm\u0001\u0004\u0001\u0003BBAr\u0001\u0011\u0005\u0011/A\fuKN$8i\\7qY\u0016D8*Z=HK:,'/\u0019;pe\"\"\u0011\u0011]A\u0018\u0011\u0019\tI\u000f\u0001C\u0001c\u0006aB/Z:u\u000f2|'-\u00197EK2,G/Z&fs\u001e+g.\u001a:bi>\u0014\b\u0006BAt\u0003_Aa!a<\u0001\t\u0003\t\u0018A\t;fgR|e/\u001a:xe&$XmV5uQ2\u000bG/Z:u\u0003Z\u0014x\u000eU1zY>\fG\r\u000b\u0003\u0002n\u0006=\u0002BBA{\u0001\u0011\u0005\u0011/\u0001\u001euKN$xJ^3soJLG/Z,ji\"d\u0015\r^3ti\u00063(o\u001c)bs2|\u0017\rZ\"p[\nLg.Z!oI\u001e+G/\u00169eCR,g+\u00197vK\"\"\u00111_A\u0018\u0011\u0019\tY\u0010\u0001C\u0001c\u00061D/Z:u\t\u00164\u0017-\u001e7u\u0011>|G-[3SK\u000e|'\u000f\u001a)bs2|\u0017\rZ\"p[\nLg.Z!oI\u001e+G/\u00169eCR,g+\u00197vK\"\"\u0011\u0011`A\u0018\u0011\u0019\u0011\t\u0001\u0001C\u0001c\u0006aB/Z:u\u000b6\u0004H/\u001f%p_\u0012LWMU3d_J$\u0007+Y=m_\u0006$\u0007\u0006BA\u0000\u0003_\u0001")
public class TestDataSourceDefaults
extends ScalaAssertionSupport {
    private final Schema schema = SchemaTestUtil.getComplexEvolvedSchema();
    private final StructType structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(this.schema());
    private GenericRecord baseRecord;
    private Row baseRow;
    private InternalRow internalRow;
    private final String testStructName;
    private final String testNamespace;

    public Schema schema() {
        return this.schema;
    }

    public StructType structType() {
        return this.structType;
    }

    public GenericRecord baseRecord() {
        return this.baseRecord;
    }

    public void baseRecord_$eq(GenericRecord x$1) {
        this.baseRecord = x$1;
    }

    public Row baseRow() {
        return this.baseRow;
    }

    public void baseRow_$eq(Row x$1) {
        this.baseRow = x$1;
    }

    public InternalRow internalRow() {
        return this.internalRow;
    }

    public void internalRow_$eq(InternalRow x$1) {
        this.internalRow = x$1;
    }

    public String testStructName() {
        return this.testStructName;
    }

    public String testNamespace() {
        return this.testNamespace;
    }

    @BeforeEach
    public void initialize() {
        this.baseRecord_$eq(SchemaTestUtil.generateAvroRecordFromJson((Schema)this.schema(), (int)1, (String)"001", (String)"f1"));
        this.baseRow_$eq(KeyGeneratorTestUtilities.getRow(this.baseRecord(), this.schema(), this.structType()));
        this.internalRow_$eq(KeyGeneratorTestUtilities.getInternalRow(this.baseRow()));
    }

    private TypedProperties getKeyConfig(String recordKeyFieldName, String partitionPathField, String hiveStylePartitioning) {
        TypedProperties props = new TypedProperties();
        props.setProperty(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), recordKeyFieldName);
        props.setProperty(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), partitionPathField);
        props.setProperty(DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING().key(), hiveStylePartitioning);
        return props;
    }

    @Test
    public void testSimpleKeyGenerator() {
        SimpleKeyGenerator keyGen = new SimpleKeyGenerator(this.getKeyConfig("field1", "name", "false"));
        HoodieKey expectedKey = new HoodieKey("field1", "name1");
        Assertions.assertEquals((Object)expectedKey, (Object)keyGen.getKey(this.baseRecord()));
        Assertions.assertEquals((Object)expectedKey.getRecordKey(), (Object)keyGen.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)expectedKey.getPartitionPath(), (Object)keyGen.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey.getRecordKey()), (Object)keyGen.getRecordKey(this.internalRow(), this.structType()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey.getPartitionPath()), (Object)keyGen.getPartitionPath(this.internalRow(), this.structType()));
        TypedProperties props = new TypedProperties();
        props.setProperty(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "field1");
        this.assertThrows(IllegalArgumentException.class, new Serializable(this, props){
            public static final long serialVersionUID = 0L;
            private final TypedProperties props$1;

            public final SimpleKeyGenerator apply() {
                return new SimpleKeyGenerator(this.props$1);
            }
            {
                this.props$1 = props$1;
            }
        });
        TypedProperties props2 = new TypedProperties();
        props2.setProperty(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "partitionField");
        this.assertThrows(IllegalArgumentException.class, new Serializable(this, props2){
            public static final long serialVersionUID = 0L;
            private final TypedProperties props$2;

            public final SimpleKeyGenerator apply() {
                return new SimpleKeyGenerator(this.props$2);
            }
            {
                this.props$2 = props$2;
            }
        });
        SimpleKeyGenerator keyGen2 = new SimpleKeyGenerator(this.getKeyConfig("testNestedRecord.userId", "testNestedRecord.isAdmin", "false"));
        Assertions.assertEquals((Object)new HoodieKey("UserId1@001", "false"), (Object)keyGen2.getKey(this.baseRecord()));
        SimpleKeyGenerator keyGen3 = new SimpleKeyGenerator(this.getKeyConfig("testNestedRecord.NotThere", "testNestedRecord.isAdmin", "false"));
        this.assertThrows(HoodieException.class, new Serializable(this, keyGen3){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDataSourceDefaults $outer;
            private final SimpleKeyGenerator keyGen$1;

            public final HoodieKey apply() {
                return this.keyGen$1.getKey(this.$outer.baseRecord());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.keyGen$1 = keyGen$1;
            }
        });
        SimpleKeyGenerator keyGen4 = new SimpleKeyGenerator(this.getKeyConfig("testNestedRecord.userId", "testNestedRecord.notThere", "false"));
        this.assertThrows(HoodieException.class, new Serializable(this, keyGen4){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDataSourceDefaults $outer;
            private final SimpleKeyGenerator keyGen$2;

            public final String apply() {
                return this.keyGen$2.getPartitionPath(this.$outer.baseRow());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.keyGen$2 = keyGen$2;
            }
        });
        this.assertThrows(HoodieException.class, new Serializable(this, keyGen4){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDataSourceDefaults $outer;
            private final SimpleKeyGenerator keyGen$2;

            public final UTF8String apply() {
                return this.keyGen$2.getPartitionPath(this.$outer.internalRow(), this.$outer.structType());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.keyGen$2 = keyGen$2;
            }
        });
        SimpleKeyGenerator keyGen5 = new SimpleKeyGenerator(this.getKeyConfig("field1", "name", "true"));
        Assertions.assertEquals((Object)"name=name1", (Object)keyGen5.getKey(this.baseRecord()).getPartitionPath());
        Assertions.assertEquals((Object)"name=name1", (Object)keyGen5.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)"name=name1"), (Object)keyGen5.getPartitionPath(this.internalRow(), this.structType()));
        SimpleKeyGenerator keyGen6 = new SimpleKeyGenerator(this.getKeyConfig("field1", "name", "false"));
        this.baseRecord().put("name", (Object)"");
        this.baseRow_$eq(KeyGeneratorTestUtilities.getRow(this.baseRecord(), this.schema(), this.structType()));
        this.internalRow_$eq(KeyGeneratorTestUtilities.getInternalRow(this.baseRow()));
        Assertions.assertEquals((Object)"__HIVE_DEFAULT_PARTITION__", (Object)keyGen6.getKey(this.baseRecord()).getPartitionPath());
        Assertions.assertEquals((Object)"__HIVE_DEFAULT_PARTITION__", (Object)keyGen6.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)"__HIVE_DEFAULT_PARTITION__"), (Object)keyGen6.getPartitionPath(this.internalRow(), this.structType()));
        this.baseRecord().put("name", null);
        this.baseRow_$eq(KeyGeneratorTestUtilities.getRow(this.baseRecord(), this.schema(), this.structType()));
        this.internalRow_$eq(KeyGeneratorTestUtilities.getInternalRow(this.baseRow()));
        Assertions.assertEquals((Object)"__HIVE_DEFAULT_PARTITION__", (Object)keyGen6.getKey(this.baseRecord()).getPartitionPath());
        Assertions.assertEquals((Object)"__HIVE_DEFAULT_PARTITION__", (Object)keyGen6.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)"__HIVE_DEFAULT_PARTITION__"), (Object)keyGen6.getPartitionPath(this.internalRow(), this.structType()));
        TypedProperties props3 = new TypedProperties();
        props3.setProperty(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "field1");
        props3.setProperty(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "name");
        SimpleKeyGenerator keyGen7 = new SimpleKeyGenerator(props3);
        this.baseRecord().put("field1", (Object)"");
        this.baseRow_$eq(KeyGeneratorTestUtilities.getRow(this.baseRecord(), this.schema(), this.structType()));
        this.internalRow_$eq(KeyGeneratorTestUtilities.getInternalRow(this.baseRow()));
        this.assertThrows(HoodieKeyException.class, new Serializable(this, keyGen7){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDataSourceDefaults $outer;
            private final SimpleKeyGenerator keyGen$3;

            public final HoodieKey apply() {
                return this.keyGen$3.getKey(this.$outer.baseRecord());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.keyGen$3 = keyGen$3;
            }
        });
        this.assertThrows(HoodieKeyException.class, new Serializable(this, keyGen7){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDataSourceDefaults $outer;
            private final SimpleKeyGenerator keyGen$3;

            public final String apply() {
                return this.keyGen$3.getRecordKey(this.$outer.baseRow());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.keyGen$3 = keyGen$3;
            }
        });
        this.assertThrows(HoodieKeyException.class, new Serializable(this, keyGen7){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDataSourceDefaults $outer;
            private final SimpleKeyGenerator keyGen$3;

            public final UTF8String apply() {
                return this.keyGen$3.getRecordKey(this.$outer.internalRow(), this.$outer.structType());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.keyGen$3 = keyGen$3;
            }
        });
        this.baseRecord().put("field1", null);
        this.baseRow_$eq(KeyGeneratorTestUtilities.getRow(this.baseRecord(), this.schema(), this.structType()));
        this.internalRow_$eq(KeyGeneratorTestUtilities.getInternalRow(this.baseRow()));
        this.assertThrows(HoodieKeyException.class, new Serializable(this, keyGen7){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDataSourceDefaults $outer;
            private final SimpleKeyGenerator keyGen$3;

            public final HoodieKey apply() {
                return this.keyGen$3.getKey(this.$outer.baseRecord());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.keyGen$3 = keyGen$3;
            }
        });
        this.assertThrows(HoodieKeyException.class, new Serializable(this, keyGen7){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDataSourceDefaults $outer;
            private final SimpleKeyGenerator keyGen$3;

            public final String apply() {
                return this.keyGen$3.getRecordKey(this.$outer.baseRow());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.keyGen$3 = keyGen$3;
            }
        });
        this.assertThrows(HoodieKeyException.class, new Serializable(this, keyGen7){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDataSourceDefaults $outer;
            private final SimpleKeyGenerator keyGen$3;

            public final UTF8String apply() {
                return this.keyGen$3.getRecordKey(this.$outer.internalRow(), this.$outer.structType());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.keyGen$3 = keyGen$3;
            }
        });
    }

    @Test
    public void testUserDefinedKeyGeneratorWorksWithRows() {
        UserDefinedKeyGenerator keyGen = new UserDefinedKeyGenerator(this.getKeyConfig("field1", "name", "false"));
        Assertions.assertEquals((Object)"field1", (Object)keyGen.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)"name1", (Object)keyGen.getPartitionPath(this.baseRow()));
    }

    @Test
    public void testComplexKeyGenerator() {
        ComplexKeyGenerator keyGen = new ComplexKeyGenerator(this.getKeyConfig("field1,name", "field1,name", "false"));
        HoodieKey expectedKey = new HoodieKey("field1:field1,name:name1", "field1/name1");
        Assertions.assertEquals((Object)expectedKey, (Object)keyGen.getKey(this.baseRecord()));
        Assertions.assertEquals((Object)expectedKey.getRecordKey(), (Object)keyGen.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)expectedKey.getPartitionPath(), (Object)keyGen.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey.getRecordKey()), (Object)keyGen.getRecordKey(this.internalRow(), this.structType()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey.getPartitionPath()), (Object)keyGen.getPartitionPath(this.internalRow(), this.structType()));
        this.assertThrows(IllegalArgumentException.class, new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDataSourceDefaults $outer;

            public final UTF8String apply() {
                TypedProperties props = new TypedProperties();
                props.setProperty(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "field1");
                ComplexKeyGenerator keyGen = new ComplexKeyGenerator(props);
                keyGen.getKey(this.$outer.baseRecord());
                keyGen.getRecordKey(this.$outer.baseRow());
                return keyGen.getRecordKey(this.$outer.internalRow(), this.$outer.structType());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.assertThrows(IllegalArgumentException.class, new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDataSourceDefaults $outer;

            public final UTF8String apply() {
                TypedProperties props = new TypedProperties();
                props.setProperty(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "partitionField");
                ComplexKeyGenerator keyGen = new ComplexKeyGenerator(props);
                keyGen.getKey(this.$outer.baseRecord());
                keyGen.getPartitionPath(this.$outer.baseRow());
                return keyGen.getPartitionPath(this.$outer.internalRow(), this.$outer.structType());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        ComplexKeyGenerator keyGen2 = new ComplexKeyGenerator(this.getKeyConfig("testNestedRecord.userId,testNestedRecord.isAdmin", "testNestedRecord.userId,testNestedRecord.isAdmin", "false"));
        HoodieKey expectedKey2 = new HoodieKey("testNestedRecord.userId:UserId1@001,testNestedRecord.isAdmin:false", "UserId1@001/false");
        Assertions.assertEquals((Object)expectedKey2, (Object)keyGen2.getKey(this.baseRecord()));
        Assertions.assertEquals((Object)expectedKey2.getRecordKey(), (Object)keyGen2.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)expectedKey2.getPartitionPath(), (Object)keyGen2.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey2.getRecordKey()), (Object)keyGen2.getRecordKey(this.internalRow(), this.structType()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey2.getPartitionPath()), (Object)keyGen2.getPartitionPath(this.internalRow(), this.structType()));
        ComplexKeyGenerator keyGen3 = new ComplexKeyGenerator(this.getKeyConfig("testNestedRecord.NotThere", "testNestedRecord.isAdmin", "false"));
        this.assertThrows(HoodieException.class, new Serializable(this, keyGen3){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDataSourceDefaults $outer;
            private final ComplexKeyGenerator keyGen$4;

            public final HoodieKey apply() {
                return this.keyGen$4.getKey(this.$outer.baseRecord());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.keyGen$4 = keyGen$4;
            }
        });
        this.assertThrows(HoodieException.class, new Serializable(this, keyGen3){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDataSourceDefaults $outer;
            private final ComplexKeyGenerator keyGen$4;

            public final String apply() {
                return this.keyGen$4.getRecordKey(this.$outer.baseRow());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.keyGen$4 = keyGen$4;
            }
        });
        this.assertThrows(HoodieException.class, new Serializable(this, keyGen3){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDataSourceDefaults $outer;
            private final ComplexKeyGenerator keyGen$4;

            public final UTF8String apply() {
                return this.keyGen$4.getRecordKey(this.$outer.internalRow(), this.$outer.structType());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.keyGen$4 = keyGen$4;
            }
        });
        ComplexKeyGenerator keyGen4 = new ComplexKeyGenerator(this.getKeyConfig("testNestedRecord.userId", "testNestedRecord.notThere", "false"));
        this.assertThrows(HoodieException.class, new Serializable(this, keyGen4){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDataSourceDefaults $outer;
            private final ComplexKeyGenerator keyGen$5;

            public final String apply() {
                return this.keyGen$5.getPartitionPath(this.$outer.baseRow());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.keyGen$5 = keyGen$5;
            }
        });
        this.assertThrows(HoodieException.class, new Serializable(this, keyGen4){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDataSourceDefaults $outer;
            private final ComplexKeyGenerator keyGen$5;

            public final UTF8String apply() {
                return this.keyGen$5.getPartitionPath(this.$outer.internalRow(), this.$outer.structType());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.keyGen$5 = keyGen$5;
            }
        });
        ComplexKeyGenerator keyGen5 = new ComplexKeyGenerator(this.getKeyConfig("field1,name", "field1,name", "true"));
        HoodieKey expectedKey3 = new HoodieKey("field1:field1,name:name1", "field1=field1/name=name1");
        Assertions.assertEquals((Object)expectedKey3, (Object)keyGen5.getKey(this.baseRecord()));
        Assertions.assertEquals((Object)expectedKey3.getRecordKey(), (Object)keyGen5.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)expectedKey3.getPartitionPath(), (Object)keyGen5.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey3.getRecordKey()), (Object)keyGen5.getRecordKey(this.internalRow(), this.structType()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey3.getPartitionPath()), (Object)keyGen5.getPartitionPath(this.internalRow(), this.structType()));
        ComplexKeyGenerator keyGen6 = new ComplexKeyGenerator(this.getKeyConfig("field1,name", "field1,name", "false"));
        this.baseRecord().put("name", (Object)"");
        this.baseRow_$eq(KeyGeneratorTestUtilities.getRow(this.baseRecord(), this.schema(), this.structType()));
        this.internalRow_$eq(KeyGeneratorTestUtilities.getInternalRow(this.baseRow()));
        HoodieKey expectedKey4 = new HoodieKey("field1:field1,name:__empty__", "field1/__HIVE_DEFAULT_PARTITION__");
        Assertions.assertEquals((Object)expectedKey4, (Object)keyGen6.getKey(this.baseRecord()));
        Assertions.assertEquals((Object)expectedKey4.getRecordKey(), (Object)keyGen6.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)expectedKey4.getPartitionPath(), (Object)keyGen6.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey4.getRecordKey()), (Object)keyGen6.getRecordKey(this.internalRow(), this.structType()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey4.getPartitionPath()), (Object)keyGen6.getPartitionPath(this.internalRow(), this.structType()));
        ComplexKeyGenerator keyGen7 = new ComplexKeyGenerator(this.getKeyConfig("field1,name", "field1,name", "false"));
        this.baseRecord().put("name", null);
        this.baseRow_$eq(KeyGeneratorTestUtilities.getRow(this.baseRecord(), this.schema(), this.structType()));
        this.internalRow_$eq(KeyGeneratorTestUtilities.getInternalRow(this.baseRow()));
        HoodieKey expectedKey5 = new HoodieKey("field1:field1,name:__null__", "field1/__HIVE_DEFAULT_PARTITION__");
        Assertions.assertEquals((Object)expectedKey5, (Object)keyGen7.getKey(this.baseRecord()));
        Assertions.assertEquals((Object)expectedKey5.getRecordKey(), (Object)keyGen7.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)expectedKey5.getPartitionPath(), (Object)keyGen7.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey5.getRecordKey()), (Object)keyGen7.getRecordKey(this.internalRow(), this.structType()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey5.getPartitionPath()), (Object)keyGen7.getPartitionPath(this.internalRow(), this.structType()));
        TypedProperties props = new TypedProperties();
        props.setProperty(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "field1,name");
        props.setProperty(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "field1,name");
        ComplexKeyGenerator keyGen8 = new ComplexKeyGenerator(props);
        this.baseRecord().put("name", (Object)"");
        this.baseRecord().put("field1", null);
        this.baseRow_$eq(KeyGeneratorTestUtilities.getRow(this.baseRecord(), this.schema(), this.structType()));
        this.internalRow_$eq(KeyGeneratorTestUtilities.getInternalRow(this.baseRow()));
        this.assertThrows(HoodieKeyException.class, new Serializable(this, keyGen8){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDataSourceDefaults $outer;
            private final ComplexKeyGenerator keyGen$6;

            public final HoodieKey apply() {
                return this.keyGen$6.getKey(this.$outer.baseRecord());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.keyGen$6 = keyGen$6;
            }
        });
        this.assertThrows(HoodieKeyException.class, new Serializable(this, keyGen8){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDataSourceDefaults $outer;
            private final ComplexKeyGenerator keyGen$6;

            public final String apply() {
                return this.keyGen$6.getRecordKey(this.$outer.baseRow());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.keyGen$6 = keyGen$6;
            }
        });
        this.assertThrows(HoodieKeyException.class, new Serializable(this, keyGen8){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDataSourceDefaults $outer;
            private final ComplexKeyGenerator keyGen$6;

            public final UTF8String apply() {
                return this.keyGen$6.getRecordKey(this.$outer.internalRow(), this.$outer.structType());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.keyGen$6 = keyGen$6;
            }
        });
        ComplexKeyGenerator keyGen9 = new ComplexKeyGenerator(this.getKeyConfig("field1, name", "field1, name", "false"));
        this.baseRecord().put("name", (Object)"name1");
        this.baseRecord().put("field1", (Object)"field1");
        this.baseRow_$eq(KeyGeneratorTestUtilities.getRow(this.baseRecord(), this.schema(), this.structType()));
        this.internalRow_$eq(KeyGeneratorTestUtilities.getInternalRow(this.baseRow()));
        HoodieKey expectedKey6 = new HoodieKey("field1:field1,name:name1", "field1/name1");
        Assertions.assertEquals((Object)expectedKey6, (Object)keyGen9.getKey(this.baseRecord()));
        Assertions.assertEquals((Object)expectedKey6.getRecordKey(), (Object)keyGen9.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)expectedKey6.getPartitionPath(), (Object)keyGen9.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey6.getRecordKey()), (Object)keyGen9.getRecordKey(this.internalRow(), this.structType()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey6.getPartitionPath()), (Object)keyGen9.getPartitionPath(this.internalRow(), this.structType()));
        ComplexKeyGenerator keyGen10 = new ComplexKeyGenerator(this.getKeyConfig("field1,", "field1,", "false"));
        HoodieKey expectedKey7 = new HoodieKey("field1:field1", "field1");
        Assertions.assertEquals((Object)expectedKey7, (Object)keyGen10.getKey(this.baseRecord()));
        Assertions.assertEquals((Object)expectedKey7.getRecordKey(), (Object)keyGen10.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)expectedKey7.getPartitionPath(), (Object)keyGen10.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey7.getRecordKey()), (Object)keyGen10.getRecordKey(this.internalRow(), this.structType()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey7.getPartitionPath()), (Object)keyGen10.getPartitionPath(this.internalRow(), this.structType()));
    }

    @Test
    public void testGlobalDeleteKeyGenerator() {
        GlobalDeleteKeyGenerator keyGen = new GlobalDeleteKeyGenerator(this.getKeyConfig("field1,name", "field1,name", "false"));
        HoodieKey expectedKey = new HoodieKey("field1:field1,name:name1", "");
        Assertions.assertEquals((Object)expectedKey, (Object)keyGen.getKey(this.baseRecord()));
        Assertions.assertEquals((Object)expectedKey.getRecordKey(), (Object)keyGen.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)expectedKey.getPartitionPath(), (Object)keyGen.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey.getRecordKey()), (Object)keyGen.getRecordKey(this.internalRow(), this.structType()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey.getPartitionPath()), (Object)keyGen.getPartitionPath(this.internalRow(), this.structType()));
        TypedProperties props = new TypedProperties();
        props.setProperty(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "field1,name");
        GlobalDeleteKeyGenerator keyGen2 = new GlobalDeleteKeyGenerator(props);
        HoodieKey expectedKey2 = new HoodieKey("field1:field1,name:name1", "");
        Assertions.assertEquals((Object)expectedKey2, (Object)keyGen2.getKey(this.baseRecord()));
        Assertions.assertEquals((Object)expectedKey2.getRecordKey(), (Object)keyGen2.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)expectedKey2.getPartitionPath(), (Object)keyGen2.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey2.getRecordKey()), (Object)keyGen2.getRecordKey(this.internalRow(), this.structType()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey2.getPartitionPath()), (Object)keyGen2.getPartitionPath(this.internalRow(), this.structType()));
        this.baseRecord().put("name", (Object)"");
        this.baseRow_$eq(KeyGeneratorTestUtilities.getRow(this.baseRecord(), this.schema(), this.structType()));
        this.internalRow_$eq(KeyGeneratorTestUtilities.getInternalRow(this.baseRow()));
        GlobalDeleteKeyGenerator keyGen3 = new GlobalDeleteKeyGenerator(this.getKeyConfig("field1,name", "field1,name", "false"));
        HoodieKey expectedKey3 = new HoodieKey("field1:field1,name:__empty__", "");
        Assertions.assertEquals((Object)expectedKey3.getRecordKey(), (Object)keyGen3.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)expectedKey3.getPartitionPath(), (Object)keyGen3.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey3.getRecordKey()), (Object)keyGen3.getRecordKey(this.internalRow(), this.structType()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey3.getPartitionPath()), (Object)keyGen3.getPartitionPath(this.internalRow(), this.structType()));
        this.baseRecord().put("name", null);
        this.baseRow_$eq(KeyGeneratorTestUtilities.getRow(this.baseRecord(), this.schema(), this.structType()));
        this.internalRow_$eq(KeyGeneratorTestUtilities.getInternalRow(this.baseRow()));
        GlobalDeleteKeyGenerator keyGen4 = new GlobalDeleteKeyGenerator(this.getKeyConfig("field1,name", "field1,name", "false"));
        HoodieKey expectedKey4 = new HoodieKey("field1:field1,name:__null__", "");
        Assertions.assertEquals((Object)expectedKey4.getRecordKey(), (Object)keyGen4.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)expectedKey4.getPartitionPath(), (Object)keyGen4.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey4.getRecordKey()), (Object)keyGen4.getRecordKey(this.internalRow(), this.structType()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey4.getPartitionPath()), (Object)keyGen4.getPartitionPath(this.internalRow(), this.structType()));
        TypedProperties props2 = new TypedProperties();
        props2.setProperty(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "partitionField");
        this.assertThrows(IllegalArgumentException.class, new Serializable(this, props2){
            public static final long serialVersionUID = 0L;
            private final TypedProperties props$3;

            public final GlobalDeleteKeyGenerator apply() {
                return new GlobalDeleteKeyGenerator(this.props$3);
            }
            {
                this.props$3 = props$3;
            }
        });
        GlobalDeleteKeyGenerator keyGen5 = new GlobalDeleteKeyGenerator(this.getKeyConfig("testNestedRecord.NotThere", "testNestedRecord.isAdmin", "false"));
        this.assertThrows(HoodieException.class, new Serializable(this, keyGen5){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDataSourceDefaults $outer;
            private final GlobalDeleteKeyGenerator keyGen$7;

            public final HoodieKey apply() {
                return this.keyGen$7.getKey(this.$outer.baseRecord());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.keyGen$7 = keyGen$7;
            }
        });
        this.assertThrows(HoodieException.class, new Serializable(this, keyGen5){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDataSourceDefaults $outer;
            private final GlobalDeleteKeyGenerator keyGen$7;

            public final String apply() {
                return this.keyGen$7.getRecordKey(this.$outer.baseRow());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.keyGen$7 = keyGen$7;
            }
        });
        this.assertThrows(HoodieException.class, new Serializable(this, keyGen5){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDataSourceDefaults $outer;
            private final GlobalDeleteKeyGenerator keyGen$7;

            public final UTF8String apply() {
                return this.keyGen$7.getRecordKey(this.$outer.internalRow(), this.$outer.structType());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.keyGen$7 = keyGen$7;
            }
        });
        TypedProperties props3 = new TypedProperties();
        props3.setProperty(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "field1,name");
        GlobalDeleteKeyGenerator keyGen6 = new GlobalDeleteKeyGenerator(props3);
        this.baseRecord().put("name", (Object)"");
        this.baseRecord().put("field1", null);
        this.baseRow_$eq(KeyGeneratorTestUtilities.getRow(this.baseRecord(), this.schema(), this.structType()));
        this.internalRow_$eq(KeyGeneratorTestUtilities.getInternalRow(this.baseRow()));
        this.assertThrows(HoodieKeyException.class, new Serializable(this, keyGen6){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDataSourceDefaults $outer;
            private final GlobalDeleteKeyGenerator keyGen$8;

            public final HoodieKey apply() {
                return this.keyGen$8.getKey(this.$outer.baseRecord());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.keyGen$8 = keyGen$8;
            }
        });
        this.assertThrows(HoodieKeyException.class, new Serializable(this, keyGen6){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDataSourceDefaults $outer;
            private final GlobalDeleteKeyGenerator keyGen$8;

            public final String apply() {
                return this.keyGen$8.getRecordKey(this.$outer.baseRow());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.keyGen$8 = keyGen$8;
            }
        });
        this.assertThrows(HoodieKeyException.class, new Serializable(this, keyGen6){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDataSourceDefaults $outer;
            private final GlobalDeleteKeyGenerator keyGen$8;

            public final UTF8String apply() {
                return this.keyGen$8.getRecordKey(this.$outer.internalRow(), this.$outer.structType());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.keyGen$8 = keyGen$8;
            }
        });
    }

    @Test
    public void testOverwriteWithLatestAvroPayload() {
        OverwriteWithLatestAvroPayload overWritePayload1 = new OverwriteWithLatestAvroPayload(this.baseRecord(), (Comparable)Predef$.MODULE$.int2Integer(1));
        GenericRecord laterRecord = SchemaTestUtil.generateAvroRecordFromJson((Schema)this.schema(), (int)2, (String)"001", (String)"f1");
        OverwriteWithLatestAvroPayload overWritePayload2 = new OverwriteWithLatestAvroPayload(laterRecord, (Comparable)Predef$.MODULE$.int2Integer(2));
        OverwriteWithLatestAvroPayload combinedPayload12 = overWritePayload1.preCombine(overWritePayload2);
        GenericRecord combinedGR12 = (GenericRecord)combinedPayload12.getInsertValue(this.schema()).get();
        Assertions.assertEquals((Object)"field2", (Object)combinedGR12.get("field1").toString());
        OverwriteWithLatestAvroPayload combinedPayload21 = overWritePayload2.preCombine(overWritePayload1);
        GenericRecord combinedGR21 = (GenericRecord)combinedPayload21.getInsertValue(this.schema()).get();
        Assertions.assertEquals((Object)"field2", (Object)combinedGR21.get("field1").toString());
    }

    @Test
    public void testOverwriteWithLatestAvroPayloadCombineAndGetUpdateValue() {
        Object baseOrderingVal = this.baseRecord().get("favoriteIntNumber");
        Schema fieldSchema = this.baseRecord().getSchema().getField("favoriteIntNumber").schema();
        TypedProperties props = new TypedProperties();
        props.put((Object)"hoodie.payload.ordering.field", (Object)"favoriteIntNumber");
        OverwriteWithLatestAvroPayload basePayload = new OverwriteWithLatestAvroPayload(this.baseRecord(), (Comparable)HoodieAvroUtils.convertValueForSpecificDataTypes((Schema)fieldSchema, (Object)baseOrderingVal, (boolean)false));
        GenericRecord laterRecord = SchemaTestUtil.generateAvroRecordFromJson((Schema)this.schema(), (int)2, (String)"001", (String)"f1");
        Object laterOrderingVal = laterRecord.get("favoriteIntNumber");
        OverwriteWithLatestAvroPayload newerPayload = new OverwriteWithLatestAvroPayload(laterRecord, (Comparable)HoodieAvroUtils.convertValueForSpecificDataTypes((Schema)fieldSchema, (Object)laterOrderingVal, (boolean)false));
        OverwriteWithLatestAvroPayload preCombinedPayload = basePayload.preCombine(newerPayload);
        GenericRecord precombinedGR = (GenericRecord)preCombinedPayload.getInsertValue(this.schema()).get();
        Assertions.assertEquals((Object)"field2", (Object)precombinedGR.get("field1").toString());
    }

    @Test
    public void testDefaultHoodieRecordPayloadCombineAndGetUpdateValue() {
        Schema fieldSchema = this.baseRecord().getSchema().getField("favoriteIntNumber").schema();
        TypedProperties props = HoodiePayloadConfig.newBuilder().withPayloadOrderingField("favoriteIntNumber").build().getProps();
        GenericRecord laterRecord = SchemaTestUtil.generateAvroRecordFromJson((Schema)this.schema(), (int)2, (String)"001", (String)"f1");
        Object laterOrderingVal = laterRecord.get("favoriteIntNumber");
        GenericRecord earlierRecord = SchemaTestUtil.generateAvroRecordFromJson((Schema)this.schema(), (int)1, (String)"000", (String)"f1");
        Object earlierOrderingVal = earlierRecord.get("favoriteIntNumber");
        DefaultHoodieRecordPayload laterPayload = new DefaultHoodieRecordPayload(laterRecord, (Comparable)HoodieAvroUtils.convertValueForSpecificDataTypes((Schema)fieldSchema, (Object)laterOrderingVal, (boolean)false));
        DefaultHoodieRecordPayload earlierPayload = new DefaultHoodieRecordPayload(earlierRecord, (Comparable)HoodieAvroUtils.convertValueForSpecificDataTypes((Schema)fieldSchema, (Object)earlierOrderingVal, (boolean)false));
        OverwriteWithLatestAvroPayload preCombinedPayload = laterPayload.preCombine((OverwriteWithLatestAvroPayload)earlierPayload);
        GenericRecord precombinedGR = (GenericRecord)preCombinedPayload.getInsertValue(this.schema()).get();
        Assertions.assertEquals((Object)"field2", (Object)precombinedGR.get("field1").toString());
        Assertions.assertEquals((Object)laterOrderingVal, (Object)precombinedGR.get("favoriteIntNumber"));
        Option earlierWithLater = earlierPayload.combineAndGetUpdateValue((IndexedRecord)laterRecord, this.schema(), (Properties)props);
        GenericRecord earlierwithLaterGR = (GenericRecord)earlierWithLater.get();
        Assertions.assertEquals((Object)"field2", (Object)earlierwithLaterGR.get("field1").toString());
        Assertions.assertEquals((Object)laterOrderingVal, (Object)earlierwithLaterGR.get("favoriteIntNumber"));
        Option laterWithEarlier = laterPayload.combineAndGetUpdateValue((IndexedRecord)earlierRecord, this.schema(), (Properties)props);
        GenericRecord laterWithEarlierGR = (GenericRecord)laterWithEarlier.get();
        Assertions.assertEquals((Object)"field2", (Object)laterWithEarlierGR.get("field1").toString());
        Assertions.assertEquals((Object)laterOrderingVal, (Object)laterWithEarlierGR.get("favoriteIntNumber"));
    }

    @Test
    public void testEmptyHoodieRecordPayload() {
        EmptyHoodieRecordPayload emptyPayload1 = new EmptyHoodieRecordPayload(this.baseRecord(), (Comparable)Predef$.MODULE$.int2Integer(1));
        GenericRecord laterRecord = SchemaTestUtil.generateAvroRecordFromJson((Schema)this.schema(), (int)2, (String)"001", (String)"f1");
        EmptyHoodieRecordPayload emptyPayload2 = new EmptyHoodieRecordPayload(laterRecord, (Comparable)Predef$.MODULE$.int2Integer(2));
        EmptyHoodieRecordPayload combinedPayload12 = emptyPayload1.preCombine(emptyPayload2);
        Option combined12 = combinedPayload12.getInsertValue(this.schema());
        Assertions.assertEquals((Object)Option.empty(), (Object)combined12);
    }

    public TestDataSourceDefaults() {
        this.testStructName = "testStructName";
        this.testNamespace = "testNamespace";
    }

    public class UserDefinedKeyGenerator
    extends KeyGenerator
    implements SparkKeyGeneratorInterface {
        private final String recordKeyProp;
        private final String partitionPathProp;
        private final String STRUCT_NAME;
        private final String NAMESPACE;
        private Function1<Row, GenericRecord> converterFn;

        public String recordKeyProp() {
            return this.recordKeyProp;
        }

        public String partitionPathProp() {
            return this.partitionPathProp;
        }

        public String STRUCT_NAME() {
            return this.STRUCT_NAME;
        }

        public String NAMESPACE() {
            return this.NAMESPACE;
        }

        public Function1<Row, GenericRecord> converterFn() {
            return this.converterFn;
        }

        public void converterFn_$eq(Function1<Row, GenericRecord> x$1) {
            this.converterFn = x$1;
        }

        public HoodieKey getKey(GenericRecord record) {
            return new HoodieKey(HoodieAvroUtils.getNestedFieldValAsString((GenericRecord)record, (String)this.recordKeyProp(), (boolean)true, (boolean)false), HoodieAvroUtils.getNestedFieldValAsString((GenericRecord)record, (String)this.partitionPathProp(), (boolean)true, (boolean)false));
        }

        public String getRecordKey(Row row) {
            if (this.converterFn() == null) {
                this.converterFn_$eq((Function1<Row, GenericRecord>)AvroConversionUtils$.MODULE$.createConverterToAvro(row.schema(), this.STRUCT_NAME(), this.NAMESPACE()));
            }
            GenericRecord genericRecord = (GenericRecord)this.converterFn().apply((Object)row);
            return this.getKey(genericRecord).getRecordKey();
        }

        public UTF8String getRecordKey(InternalRow row, StructType schema) {
            return null;
        }

        public String getPartitionPath(Row row) {
            if (this.converterFn() == null) {
                this.converterFn_$eq((Function1<Row, GenericRecord>)AvroConversionUtils$.MODULE$.createConverterToAvro(row.schema(), this.STRUCT_NAME(), this.NAMESPACE()));
            }
            GenericRecord genericRecord = (GenericRecord)this.converterFn().apply((Object)row);
            return this.getKey(genericRecord).getPartitionPath();
        }

        public UTF8String getPartitionPath(InternalRow internalRow, StructType structType) {
            return null;
        }

        public /* synthetic */ TestDataSourceDefaults org$apache$hudi$TestDataSourceDefaults$UserDefinedKeyGenerator$$$outer() {
            return TestDataSourceDefaults.this;
        }

        public UserDefinedKeyGenerator(TypedProperties props) {
            if (TestDataSourceDefaults.this == null) {
                throw null;
            }
            super(props);
            this.recordKeyProp = props.getString(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key());
            this.partitionPathProp = props.getString(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key());
            this.STRUCT_NAME = "hoodieRowTopLevelField";
            this.NAMESPACE = "hoodieRow";
        }
    }
}

