/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.stream.Stream;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.DataSourceWriteOptions;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieStorageConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.execution.bulkinsert.RDDCustomColumnsSortPartitioner;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
public class TestDataSourceUtils {
    private static final String HIVE_DATABASE = "testdb1";
    private static final String HIVE_TABLE = "hive_trips";
    @Mock
    private SparkRDDWriteClient hoodieWriteClient;
    @Mock
    private JavaRDD<HoodieRecord> hoodieRecords;
    @Captor
    private ArgumentCaptor<Option> optionCaptor;
    private HoodieWriteConfig config;
    private String avroSchemaString = "{\"type\": \"record\",\"name\": \"events\",\"fields\": [ {\"name\": \"event_date1\", \"type\" : [{\"type\" : \"int\", \"logicalType\" : \"date\"}, \"null\"]},{\"name\": \"event_date2\", \"type\" : {\"type\": \"int\", \"logicalType\" : \"date\"}},{\"name\": \"event_date3\", \"type\" : [\"null\", {\"type\" : \"int\", \"logicalType\" : \"date\"}]},{\"name\": \"event_name\", \"type\": \"string\"},{\"name\": \"event_organizer\", \"type\": \"string\"},{\"name\": \"event_cost1\", \"type\": [{\"type\": \"fixed\", \"name\": \"dc\", \"size\": 5, \"logicalType\": \"decimal\", \"precision\": 10, \"scale\": 6}, \"null\"]},{\"name\": \"event_cost2\", \"type\": {\"type\": \"fixed\", \"name\": \"ef\", \"size\": 5, \"logicalType\": \"decimal\", \"precision\": 10, \"scale\": 6}},{\"name\": \"event_cost3\", \"type\": [\"null\", {\"type\": \"fixed\", \"name\": \"fg\", \"size\": 5, \"logicalType\": \"decimal\", \"precision\": 10, \"scale\": 6}]}]}";

    @BeforeEach
    public void setUp() {
        this.config = HoodieWriteConfig.newBuilder().withPath("/").build();
    }

    @Test
    public void testAvroRecordsFieldConversion() {
        Schema avroSchema = new Schema.Parser().parse(this.avroSchemaString);
        GenericData.Record record = new GenericData.Record(avroSchema);
        record.put("event_date1", (Object)18000);
        record.put("event_date2", (Object)18001);
        record.put("event_date3", (Object)18002);
        record.put("event_name", (Object)"Hudi Meetup");
        record.put("event_organizer", (Object)"Hudi PMC");
        BigDecimal bigDecimal = new BigDecimal("123.184331");
        Schema decimalSchema = (Schema)avroSchema.getField("event_cost1").schema().getTypes().get(0);
        Conversions.DecimalConversion decimalConversions = new Conversions.DecimalConversion();
        GenericFixed genericFixed = decimalConversions.toFixed(bigDecimal, decimalSchema, (LogicalType)LogicalTypes.decimal((int)10, (int)6));
        record.put("event_cost1", (Object)genericFixed);
        record.put("event_cost2", (Object)genericFixed);
        record.put("event_cost3", (Object)genericFixed);
        Assertions.assertEquals((Object)LocalDate.ofEpochDay(18000L).toString(), (Object)HoodieAvroUtils.getNestedFieldValAsString((GenericRecord)record, (String)"event_date1", (boolean)true, (boolean)false));
        Assertions.assertEquals((Object)LocalDate.ofEpochDay(18001L).toString(), (Object)HoodieAvroUtils.getNestedFieldValAsString((GenericRecord)record, (String)"event_date2", (boolean)true, (boolean)false));
        Assertions.assertEquals((Object)LocalDate.ofEpochDay(18002L).toString(), (Object)HoodieAvroUtils.getNestedFieldValAsString((GenericRecord)record, (String)"event_date3", (boolean)true, (boolean)false));
        Assertions.assertEquals((Object)"Hudi Meetup", (Object)HoodieAvroUtils.getNestedFieldValAsString((GenericRecord)record, (String)"event_name", (boolean)true, (boolean)false));
        Assertions.assertEquals((Object)"Hudi PMC", (Object)HoodieAvroUtils.getNestedFieldValAsString((GenericRecord)record, (String)"event_organizer", (boolean)true, (boolean)false));
        Assertions.assertEquals((Object)bigDecimal.toString(), (Object)HoodieAvroUtils.getNestedFieldValAsString((GenericRecord)record, (String)"event_cost1", (boolean)true, (boolean)false));
        Assertions.assertEquals((Object)bigDecimal.toString(), (Object)HoodieAvroUtils.getNestedFieldValAsString((GenericRecord)record, (String)"event_cost2", (boolean)true, (boolean)false));
        Assertions.assertEquals((Object)bigDecimal.toString(), (Object)HoodieAvroUtils.getNestedFieldValAsString((GenericRecord)record, (String)"event_cost3", (boolean)true, (boolean)false));
    }

    @Test
    public void testDoWriteOperationWithoutUserDefinedBulkInsertPartitioner() throws HoodieException {
        Mockito.when((Object)this.hoodieWriteClient.getConfig()).thenReturn((Object)this.config);
        DataSourceUtils.doWriteOperation((SparkRDDWriteClient)this.hoodieWriteClient, this.hoodieRecords, (String)"test-time", (WriteOperationType)WriteOperationType.BULK_INSERT);
        ((SparkRDDWriteClient)Mockito.verify((Object)this.hoodieWriteClient, (VerificationMode)Mockito.times((int)1))).bulkInsert((JavaRDD)ArgumentMatchers.any(this.hoodieRecords.getClass()), ArgumentMatchers.anyString(), (Option)this.optionCaptor.capture());
        MatcherAssert.assertThat((Object)this.optionCaptor.getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Option.empty())));
    }

    @Test
    public void testDoWriteOperationWithNonExistUserDefinedBulkInsertPartitioner() throws HoodieException {
        this.setAndVerifyHoodieWriteClientWith("NonExistClassName");
        Exception exception = (Exception)Assertions.assertThrows(HoodieException.class, () -> DataSourceUtils.doWriteOperation((SparkRDDWriteClient)this.hoodieWriteClient, this.hoodieRecords, (String)"test-time", (WriteOperationType)WriteOperationType.BULK_INSERT));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.containsString((String)"Could not create UserDefinedBulkInsertPartitioner"));
    }

    @Test
    public void testDoWriteOperationWithUserDefinedBulkInsertPartitioner() throws HoodieException {
        this.setAndVerifyHoodieWriteClientWith(NoOpBulkInsertPartitioner.class.getName());
        DataSourceUtils.doWriteOperation((SparkRDDWriteClient)this.hoodieWriteClient, this.hoodieRecords, (String)"test-time", (WriteOperationType)WriteOperationType.BULK_INSERT);
        ((SparkRDDWriteClient)Mockito.verify((Object)this.hoodieWriteClient, (VerificationMode)Mockito.times((int)1))).bulkInsert((JavaRDD)ArgumentMatchers.any(this.hoodieRecords.getClass()), ArgumentMatchers.anyString(), (Option)this.optionCaptor.capture());
        MatcherAssert.assertThat((Object)((Option)this.optionCaptor.getValue()).get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NoOpBulkInsertPartitioner.class)));
    }

    @Test
    public void testCreateUserDefinedBulkInsertPartitionerRowsWithInValidPartitioner() throws HoodieException {
        this.config = HoodieWriteConfig.newBuilder().withPath("/").withUserDefinedBulkInsertPartitionerClass("NonExistentUserDefinedClass").build();
        Exception exception = (Exception)Assertions.assertThrows(HoodieException.class, () -> DataSourceUtils.createUserDefinedBulkInsertPartitionerWithRows((HoodieWriteConfig)this.config));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.containsString((String)"Could not create UserDefinedBulkInsertPartitionerRows"));
    }

    @Test
    public void testCreateUserDefinedBulkInsertPartitionerRowsWithValidPartitioner() throws HoodieException {
        this.config = HoodieWriteConfig.newBuilder().withPath("/").withUserDefinedBulkInsertPartitionerClass(NoOpBulkInsertPartitionerRows.class.getName()).build();
        Option partitioner = DataSourceUtils.createUserDefinedBulkInsertPartitionerWithRows((HoodieWriteConfig)this.config);
        MatcherAssert.assertThat((Object)partitioner.isPresent(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testCreateRDDCustomColumnsSortPartitionerWithValidPartitioner() throws HoodieException {
        this.config = HoodieWriteConfig.newBuilder().withPath("/").withUserDefinedBulkInsertPartitionerClass(RDDCustomColumnsSortPartitioner.class.getName()).withUserDefinedBulkInsertPartitionerSortColumns("column1, column2").withSchema(this.avroSchemaString).build();
        Option partitioner = DataSourceUtils.createUserDefinedBulkInsertPartitionerWithRows((HoodieWriteConfig)this.config);
        MatcherAssert.assertThat((Object)partitioner.isPresent(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testCreateHoodieConfigWithAsyncClustering() {
        ArrayList<ImmutablePair> asyncClusteringKeyValues = new ArrayList<ImmutablePair>(4);
        asyncClusteringKeyValues.add(new ImmutablePair((Object)DataSourceWriteOptions.ASYNC_CLUSTERING_ENABLE().key(), (Object)true));
        asyncClusteringKeyValues.add(new ImmutablePair((Object)HoodieClusteringConfig.ASYNC_CLUSTERING_ENABLE.key(), (Object)true));
        asyncClusteringKeyValues.add(new ImmutablePair((Object)"hoodie.datasource.clustering.async.enable", (Object)true));
        asyncClusteringKeyValues.add(new ImmutablePair((Object)"hoodie.clustering.async.enabled", (Object)true));
        asyncClusteringKeyValues.stream().forEach(pair -> {
            HashMap<Object, Object> params = new HashMap<Object, Object>(3);
            params.put(DataSourceWriteOptions.TABLE_TYPE().key(), DataSourceWriteOptions.TABLE_TYPE().defaultValue());
            params.put(DataSourceWriteOptions.PAYLOAD_CLASS_NAME().key(), DataSourceWriteOptions.PAYLOAD_CLASS_NAME().defaultValue());
            params.put(pair.left, ((Boolean)pair.right).toString());
            HoodieWriteConfig hoodieConfig = DataSourceUtils.createHoodieConfig((String)this.avroSchemaString, (String)this.config.getBasePath(), (String)"test", params);
            Assertions.assertEquals((Object)pair.right, (Object)hoodieConfig.isAsyncClusteringEnabled());
            TypedProperties prop = new TypedProperties();
            prop.putAll(params);
            Assertions.assertEquals((Object)pair.right, (Object)HoodieClusteringConfig.from((TypedProperties)prop).isAsyncClusteringEnabled());
        });
    }

    private void setAndVerifyHoodieWriteClientWith(String partitionerClassName) {
        this.config = HoodieWriteConfig.newBuilder().withPath(this.config.getBasePath()).withUserDefinedBulkInsertPartitionerClass(partitionerClassName).build();
        Mockito.when((Object)this.hoodieWriteClient.getConfig()).thenReturn((Object)this.config);
        MatcherAssert.assertThat((Object)this.config.getUserDefinedBulkInsertPartitionerClass(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)partitionerClassName)));
    }

    @ParameterizedTest
    @MethodSource(value={"testAutoModifyParquetWriteLegacyFormatParameterParams"})
    public void testAutoModifyParquetWriteLegacyFormatParameter(boolean smallDecimal, Boolean propValue, Boolean expectedPropValue) {
        DecimalType decimalType = smallDecimal ? DecimalType$.MODULE$.apply(10, 2) : DecimalType$.MODULE$.apply(38, 10);
        StructType structType = StructType$.MODULE$.apply(Arrays.asList(StructField.apply((String)"d1", (DataType)decimalType, (boolean)false, (Metadata)Metadata.empty())));
        HashMap options = propValue != null ? Collections.singletonMap(HoodieStorageConfig.PARQUET_WRITE_LEGACY_FORMAT_ENABLED.key(), String.valueOf(propValue)) : new HashMap();
        DataSourceUtils.tryOverrideParquetWriteLegacyFormatProperty(options, (StructType)structType);
        Boolean finalPropValue = (Boolean)Option.ofNullable(options.get(HoodieStorageConfig.PARQUET_WRITE_LEGACY_FORMAT_ENABLED.key())).map(Boolean::parseBoolean).orElse(null);
        Assertions.assertEquals((Object)expectedPropValue, (Object)finalPropValue);
    }

    private static Stream<Arguments> testAutoModifyParquetWriteLegacyFormatParameterParams() {
        return Arrays.stream(new Object[][]{{true, null, true}, {false, null, null}, {true, false, false}, {true, true, true}, {false, true, true}, {false, false, false}}).map(Arguments::of);
    }

    public static class NoOpBulkInsertPartitionerRows
    implements BulkInsertPartitioner<Dataset<Row>> {
        public NoOpBulkInsertPartitionerRows(HoodieWriteConfig config) {
        }

        public Dataset<Row> repartitionRecords(Dataset<Row> records, int outputSparkPartitions) {
            return records;
        }

        public boolean arePartitionRecordsSorted() {
            return false;
        }
    }

    public static class NoOpBulkInsertPartitioner<T extends HoodieRecordPayload>
    implements BulkInsertPartitioner<JavaRDD<HoodieRecord<T>>> {
        public NoOpBulkInsertPartitioner(HoodieWriteConfig config) {
        }

        public JavaRDD<HoodieRecord<T>> repartitionRecords(JavaRDD<HoodieRecord<T>> records, int outputSparkPartitions) {
            return records;
        }

        public boolean arePartitionRecordsSorted() {
            return false;
        }
    }
}

