/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.commons.io.FileUtils;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieSparkSqlWriter$;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.HoodieWriterUtils$;
import org.apache.hudi.TestHoodieSparkSqlWriter$;
import org.apache.hudi.TestHoodieSparkSqlWriter$StringLongTest$;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieBootstrapConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.execution.bulkinsert.BulkInsertSortMode;
import org.apache.hudi.functional.TestBootstrap;
import org.apache.hudi.keygen.ComplexKeyGenerator;
import org.apache.hudi.keygen.NonpartitionedKeyGenerator;
import org.apache.hudi.keygen.SimpleKeyGenerator;
import org.apache.hudi.testutils.DataSourceTestUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.hudi.HoodieSparkSessionExtension;
import org.apache.spark.sql.hudi.command.SqlKeyGenerator;
import org.apache.spark.sql.hudi.command.SqlKeyGenerator$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Matchers$;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple5;
import scala.Tuple6;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\u0011%a\u0001B\u0001\u0003\u0001%\u0011\u0001\u0004V3ti\"{w\u000eZ5f'B\f'o[*rY^\u0013\u0018\u000e^3s\u0015\t\u0019A!\u0001\u0003ik\u0012L'BA\u0003\u0007\u0003\u0019\t\u0007/Y2iK*\tq!A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u0015A\u00111BD\u0007\u0002\u0019)\tQ\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0010\u0019\t1\u0011I\\=SK\u001aDQ!\u0005\u0001\u0005\u0002I\ta\u0001P5oSRtD#A\n\u0011\u0005Q\u0001Q\"\u0001\u0002\t\u0013Y\u0001\u0001\u0019!a\u0001\n\u00039\u0012!B:qCJ\\W#\u0001\r\u0011\u0005eiR\"\u0001\u000e\u000b\u0005ma\u0012aA:rY*\u0011a\u0003B\u0005\u0003=i\u0011Ab\u00159be.\u001cVm]:j_:D\u0011\u0002\t\u0001A\u0002\u0003\u0007I\u0011A\u0011\u0002\u0013M\u0004\u0018M]6`I\u0015\fHC\u0001\u0012&!\tY1%\u0003\u0002%\u0019\t!QK\\5u\u0011\u001d1s$!AA\u0002a\t1\u0001\u001f\u00132\u0011\u0019A\u0003\u0001)Q\u00051\u000511\u000f]1sW\u0002B\u0011B\u000b\u0001A\u0002\u0003\u0007I\u0011A\u0016\u0002\u0015M\fHnQ8oi\u0016DH/F\u0001-!\tIR&\u0003\u0002/5\tQ1+\u0015'D_:$X\r\u001f;\t\u0013A\u0002\u0001\u0019!a\u0001\n\u0003\t\u0014AD:rY\u000e{g\u000e^3yi~#S-\u001d\u000b\u0003EIBqAJ\u0018\u0002\u0002\u0003\u0007A\u0006\u0003\u00045\u0001\u0001\u0006K\u0001L\u0001\fgFd7i\u001c8uKb$\b\u0005C\u00057\u0001\u0001\u0007\t\u0019!C\u0001o\u0005\u00111oY\u000b\u0002qA\u0011\u0011HO\u0007\u00029%\u00111\b\b\u0002\r'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\n{\u0001\u0001\r\u00111A\u0005\u0002y\naa]2`I\u0015\fHC\u0001\u0012@\u0011\u001d1C(!AA\u0002aBa!\u0011\u0001!B\u0013A\u0014aA:dA!I1\t\u0001a\u0001\u0002\u0004%\t\u0001R\u0001\ti\u0016l\u0007\u000fU1uQV\tQ\t\u0005\u0002G\u001b6\tqI\u0003\u0002I\u0013\u0006!a-\u001b7f\u0015\tQ5*A\u0002oS>T\u0011\u0001T\u0001\u0005U\u00064\u0018-\u0003\u0002O\u000f\n!\u0001+\u0019;i\u0011%\u0001\u0006\u00011AA\u0002\u0013\u0005\u0011+\u0001\u0007uK6\u0004\b+\u0019;i?\u0012*\u0017\u000f\u0006\u0002#%\"9aeTA\u0001\u0002\u0004)\u0005B\u0002+\u0001A\u0003&Q)A\u0005uK6\u0004\b+\u0019;iA!Ia\u000b\u0001a\u0001\u0002\u0004%\t\u0001R\u0001\u0012i\u0016l\u0007OQ8piN#(/\u00199QCRD\u0007\"\u0003-\u0001\u0001\u0004\u0005\r\u0011\"\u0001Z\u0003U!X-\u001c9C_>$8\u000b\u001e:baB\u000bG\u000f[0%KF$\"A\t.\t\u000f\u0019:\u0016\u0011!a\u0001\u000b\"1A\f\u0001Q!\n\u0015\u000b!\u0003^3na\n{w\u000e^*ue\u0006\u0004\b+\u0019;iA!9a\f\u0001a\u0001\n\u0003y\u0016A\u00055p_\u0012LWMR8p)\u0006\u0014G.\u001a(b[\u0016,\u0012\u0001\u0019\t\u0003C\u0012l\u0011A\u0019\u0006\u0003G.\u000bA\u0001\\1oO&\u0011QM\u0019\u0002\u0007'R\u0014\u0018N\\4\t\u000f\u001d\u0004\u0001\u0019!C\u0001Q\u00061\u0002n\\8eS\u00164un\u001c+bE2,g*Y7f?\u0012*\u0017\u000f\u0006\u0002#S\"9aEZA\u0001\u0002\u0004\u0001\u0007BB6\u0001A\u0003&\u0001-A\ni_>$\u0017.\u001a$p_R\u000b'\r\\3OC6,\u0007\u0005C\u0005n\u0001\u0001\u0007\t\u0019!C\u0001]\u0006aA/Z7q\u0005\u0006\u001cX\rU1uQV\tq\u000e\u0005\u0002qg:\u00111\"]\u0005\u0003e2\ta\u0001\u0015:fI\u00164\u0017BA3u\u0015\t\u0011H\u0002C\u0005w\u0001\u0001\u0007\t\u0019!C\u0001o\u0006\u0001B/Z7q\u0005\u0006\u001cX\rU1uQ~#S-\u001d\u000b\u0003EaDqAJ;\u0002\u0002\u0003\u0007q\u000e\u0003\u0004{\u0001\u0001\u0006Ka\\\u0001\u000ei\u0016l\u0007OQ1tKB\u000bG\u000f\u001b\u0011\t\u000fq\u0004\u0001\u0019!C\u0001{\u0006\u00192m\\7n_:$\u0016M\u00197f\u001b>$\u0017NZ5feV\ta\u0010\u0005\u0003q\u007f>|\u0017bAA\u0001i\n\u0019Q*\u00199\t\u0013\u0005\u0015\u0001\u00011A\u0005\u0002\u0005\u001d\u0011aF2p[6|g\u000eV1cY\u0016lu\u000eZ5gS\u0016\u0014x\fJ3r)\r\u0011\u0013\u0011\u0002\u0005\tM\u0005\r\u0011\u0011!a\u0001}\"9\u0011Q\u0002\u0001!B\u0013q\u0018\u0001F2p[6|g\u000eV1cY\u0016lu\u000eZ5gS\u0016\u0014\bE\u0002\u0004\u0002\u0012\u0001\u0001\u00151\u0003\u0002\u000f'R\u0014\u0018N\\4M_:<G+Z:u'\u001d\tyACA\u000b\u00037\u00012aCA\f\u0013\r\tI\u0002\u0004\u0002\b!J|G-^2u!\rY\u0011QD\u0005\u0004\u0003?a!\u0001D*fe&\fG.\u001b>bE2,\u0007BCA\u0012\u0003\u001f\u0011)\u001a!C\u0001]\u0006!Q/^5e\u0011)\t9#a\u0004\u0003\u0012\u0003\u0006Ia\\\u0001\u0006kVLG\r\t\u0005\f\u0003W\tyA!f\u0001\n\u0003\ti#\u0001\u0002ugV\u0011\u0011q\u0006\t\u0004\u0017\u0005E\u0012bAA\u001a\u0019\t!Aj\u001c8h\u0011-\t9$a\u0004\u0003\u0012\u0003\u0006I!a\f\u0002\u0007Q\u001c\b\u0005C\u0004\u0012\u0003\u001f!\t!a\u000f\u0015\r\u0005u\u0012\u0011IA\"!\u0011\ty$a\u0004\u000e\u0003\u0001Aq!a\t\u0002:\u0001\u0007q\u000e\u0003\u0005\u0002,\u0005e\u0002\u0019AA\u0018\u0011)\t9%a\u0004\u0002\u0002\u0013\u0005\u0011\u0011J\u0001\u0005G>\u0004\u0018\u0010\u0006\u0004\u0002>\u0005-\u0013Q\n\u0005\n\u0003G\t)\u0005%AA\u0002=D!\"a\u000b\u0002FA\u0005\t\u0019AA\u0018\u0011)\t\t&a\u0004\u0012\u0002\u0013\u0005\u00111K\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t)FK\u0002p\u0003/Z#!!\u0017\u0011\t\u0005m\u0013QM\u0007\u0003\u0003;RA!a\u0018\u0002b\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003Gb\u0011AC1o]>$\u0018\r^5p]&!\u0011qMA/\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\u000b\u0003W\ny!%A\u0005\u0002\u00055\u0014AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003_RC!a\f\u0002X!I\u00111OA\b\u0003\u0003%\teX\u0001\u000eaJ|G-^2u!J,g-\u001b=\t\u0015\u0005]\u0014qBA\u0001\n\u0003\tI(\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002|A\u00191\"! \n\u0007\u0005}DBA\u0002J]RD!\"a!\u0002\u0010\u0005\u0005I\u0011AAC\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\"\u0002\u000eB\u00191\"!#\n\u0007\u0005-EBA\u0002B]fD\u0011BJAA\u0003\u0003\u0005\r!a\u001f\t\u0015\u0005E\u0015qBA\u0001\n\u0003\n\u0019*A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t)\n\u0005\u0004\u0002\u0018\u0006u\u0015qQ\u0007\u0003\u00033S1!a'\r\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003?\u000bIJ\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011)\t\u0019+a\u0004\u0002\u0002\u0013\u0005\u0011QU\u0001\tG\u0006tW)];bYR!\u0011qUAW!\rY\u0011\u0011V\u0005\u0004\u0003Wc!a\u0002\"p_2,\u0017M\u001c\u0005\nM\u0005\u0005\u0016\u0011!a\u0001\u0003\u000fC!\"!-\u0002\u0010\u0005\u0005I\u0011IAZ\u0003!A\u0017m\u001d5D_\u0012,GCAA>\u0011)\t9,a\u0004\u0002\u0002\u0013\u0005\u0013\u0011X\u0001\ti>\u001cFO]5oOR\t\u0001\r\u0003\u0006\u0002>\u0006=\u0011\u0011!C!\u0003\u007f\u000ba!Z9vC2\u001cH\u0003BAT\u0003\u0003D\u0011BJA^\u0003\u0003\u0005\r!a\"\b\u0013\u0005\u0015\u0007!!A\t\u0002\u0005\u001d\u0017AD*ue&tw\rT8oOR+7\u000f\u001e\t\u0005\u0003\u007f\tIMB\u0005\u0002\u0012\u0001\t\t\u0011#\u0001\u0002LN1\u0011\u0011ZAg\u00037\u0001\u0012\"a4\u0002V>\fy#!\u0010\u000e\u0005\u0005E'bAAj\u0019\u00059!/\u001e8uS6,\u0017\u0002BAl\u0003#\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83\u0011\u001d\t\u0012\u0011\u001aC\u0001\u00037$\"!a2\t\u0015\u0005]\u0016\u0011ZA\u0001\n\u000b\nI\f\u0003\u0006\u0002b\u0006%\u0017\u0011!CA\u0003G\fQ!\u00199qYf$b!!\u0010\u0002f\u0006\u001d\bbBA\u0012\u0003?\u0004\ra\u001c\u0005\t\u0003W\ty\u000e1\u0001\u00020!Q\u00111^Ae\u0003\u0003%\t)!<\u0002\u000fUt\u0017\r\u001d9msR!\u0011q^A~!\u0015Y\u0011\u0011_A{\u0013\r\t\u0019\u0010\u0004\u0002\u0007\u001fB$\u0018n\u001c8\u0011\r-\t9p\\A\u0018\u0013\r\tI\u0010\u0004\u0002\u0007)V\u0004H.\u001a\u001a\t\u0015\u0005u\u0018\u0011^A\u0001\u0002\u0004\ti$A\u0002yIABqA!\u0001\u0001\t\u0003\u0011\u0019!A\u0003tKR,\u0006\u000fF\u0001#Q\u0011\tyPa\u0002\u0011\t\t%!qC\u0007\u0003\u0005\u0017QAA!\u0004\u0003\u0010\u0005\u0019\u0011\r]5\u000b\t\tE!1C\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\u0011)BB\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u00053\u0011YA\u0001\u0006CK\u001a|'/Z#bG\"DqA!\b\u0001\t\u0003\u0011\u0019!\u0001\u0005uK\u0006\u0014Hi\\<oQ\u0011\u0011YB!\t\u0011\t\t%!1E\u0005\u0005\u0005K\u0011YAA\u0005BMR,'/R1dQ\"9!\u0011\u0006\u0001\u0005\u0002\t\r\u0011\u0001E5oSR\u001c\u0006/\u0019:l\u0007>tG/\u001a=u\u0011\u001d\u0011i\u0003\u0001C\u0001\u0005\u0007\tAc\u00197fC:,\bo\u00159be.\u001cuN\u001c;fqR\u001c\bb\u0002B\u0019\u0001\u0011\u0005!1G\u0001\u000fIJ|\u0007/T3uC\u001aKW\r\u001c3t)\u0011\u0011)D!\u0011\u0011\u000be\u00119Da\u000f\n\u0007\te\"DA\u0004ECR\f7/\u001a;\u0011\u0007e\u0011i$C\u0002\u0003@i\u00111AU8x\u0011!\u0011\u0019Ea\fA\u0002\tU\u0012A\u00013g\u0011\u001d\u00119\u0005\u0001C\u0001\u0005\u0013\nqbZ3u\u0007>lWn\u001c8QCJ\fWn\u001d\u000b\b}\n-#q\nB)\u0011\u001d\u0011iE!\u0012A\u0002\u0015\u000bA\u0001]1uQ\"1aL!\u0012A\u0002=DqAa\u0015\u0003F\u0001\u0007q.A\u0005uC\ndW\rV=qK\"9!q\u000b\u0001\u0005\u0002\te\u0013aE2p]Z,'\u000f\u001e*po2K7\u000f\u001e+p'\u0016\fH\u0003\u0002B.\u0005g\u0002bA!\u0018\u0003n\tmb\u0002\u0002B0\u0005SrAA!\u0019\u0003h5\u0011!1\r\u0006\u0004\u0005KB\u0011A\u0002\u001fs_>$h(C\u0001\u000e\u0013\r\u0011Y\u0007D\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011yG!\u001d\u0003\u0007M+\u0017OC\u0002\u0003l1A\u0001B!\u001e\u0003V\u0001\u0007!qO\u0001\nS:\u0004X\u000f\u001e'jgR\u0004bA!\u001f\u0003\u0000\tmRB\u0001B>\u0015\r\u0011ihS\u0001\u0005kRLG.\u0003\u0003\u0003\u0002\nm$\u0001\u0002'jgRDqA!\"\u0001\t\u0003\u00119)\u0001\u000euKN$()\u001e7l\u0013:\u001cXM\u001d;XSRD7k\u001c:u\u001b>$W\rF\u0004#\u0005\u0013\u0013iJ!)\t\u0011\t-%1\u0011a\u0001\u0005\u001b\u000b\u0001b]8si6{G-\u001a\t\u0005\u0005\u001f\u0013I*\u0004\u0002\u0003\u0012*!!1\u0013BK\u0003)\u0011W\u000f\\6j]N,'\u000f\u001e\u0006\u0004\u0005/\u0013\u0011!C3yK\u000e,H/[8o\u0013\u0011\u0011YJ!%\u0003%\t+Hn[%og\u0016\u0014HoU8si6{G-\u001a\u0005\u000b\u0005?\u0013\u0019\t%AA\u0002\u0005\u001d\u0016A\u00059paVd\u0017\r^3NKR\fg)[3mIND!Ba)\u0003\u0004B\u0005\t\u0019AAT\u0003A)g.\u00192mK>\u001b5iQ8oM&<7\u000fC\u0004\u0003(\u0002!\tAa\u0001\u0002?Q,7\u000f\u001e)be\u0006lW\r^3sg^KG\u000f[,sSR,G)\u001a4bk2$8\u000f\u000b\u0003\u0003&\n-\u0006\u0003\u0002B\u0005\u0005[KAAa,\u0003\f\t!A+Z:u\u0011\u001d\u0011\u0019\f\u0001C\u0001\u0005\u0007\t1\u0005^3tiRC'o\\<Fq\u000e,\u0007\u000f^5p]&sg/\u00197jIN+'/[1mSj,'\u000f\u000b\u0003\u00032\n-\u0006b\u0002B]\u0001\u0011\u0005!1A\u00012i\u0016\u001cH\u000f\u00165s_^,\u0005pY3qi&|g.\u00117sK\u0006$\u00170\u0012=jgR\u001cx+\u001b;i\u0003B\u0004XM\u001c3TCZ,Wj\u001c3fQ\u0011\u00119La+\t\u000f\t}\u0006\u0001\"\u0001\u0003\u0004\u0005aC/Z:u-\u0006d\u0017\u000eZ1uKR\u000b'\r\\3D_:4\u0017nZ,ji\"|e/\u001a:xe&$XmU1wK6{G-\u001a\u0015\u0005\u0005{\u0013Y\u000bC\u0004\u0003F\u0002!\tAa2\u00023Q,7\u000f\u001e\"vY.Len]3si\u001a{'oU8si6{G-\u001a\u000b\u0004E\t%\u0007\u0002\u0003BF\u0005\u0007\u0004\rA!$)\u0011\t\r'Q\u001aBo\u0005?\u0004BAa4\u0003Z6\u0011!\u0011\u001b\u0006\u0005\u0005'\u0014).\u0001\u0005qe>4\u0018\u000eZ3s\u0015\u0011\u00119Na\u0004\u0002\rA\f'/Y7t\u0013\u0011\u0011YN!5\u0003\u0015\u0015sW/\\*pkJ\u001cW-A\u0003wC2,Xm\t\u0002\u0003\u000e\"\"!1\u0019Br!\u0011\u0011)Oa:\u000e\u0005\tU\u0017\u0002\u0002Bu\u0005+\u0014\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0011\u001d\u0011i\u000f\u0001C\u0001\u0005\u0007\t\u0001\u0005^3ti\n+Hn[%og\u0016\u0014HOR8s'>\u0014H/T8eK^KG\u000f[(D\u0007\"\"!1\u001eBV\u0011\u001d\u0011\u0019\u0010\u0001C\u0001\u0005k\f1\u0005^3ti\n+Hn[%og\u0016\u0014HOR8s!>\u0004X\u000f\\1uK6+G/\u0019$jK2$7\u000fF\u0002#\u0005oD\u0001Ba(\u0003r\u0002\u0007\u0011q\u0015\u0015\t\u0005c\u0014Yp!\u0001\u0004\u0004A!!q\u001aB\u007f\u0013\u0011\u0011yP!5\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\tE>|G.Z1og2\"1QAB\u00043\u0005\t\u0011$\u0001\u0001)\t\tE(1\u001d\u0005\b\u0007\u001b\u0001A\u0011\u0001B\u0002\u0003y!Xm\u001d;ESN\f'\r\\3B]\u0012,e.\u00192mK6+G/\u0019$jK2$7\u000f\u000b\u0003\u0004\f\t-\u0006bBB\n\u0001\u0011\u0005!1A\u0001#i\u0016\u001cH\u000f\u0012:pa\u0012+\b\u000f\\5dCR,7OU8x\r>\u0014()\u001e7l\u0013:\u001cXM\u001d;)\t\rE!1\u0016\u0005\b\u00073\u0001A\u0011\u0001B\u0002\u0003\u001d\"Xm\u001d;J]N,'\u000f\u001e#bi\u0006\u001cX\r^,ji\"|W\u000f\u001e)sK\u000e|WNY5oK\u001aKW\r\u001c3)\t\r]!1\u0016\u0005\b\u0007?\u0001A\u0011\u0001B\u0002\u0003\u0019\"Xm\u001d;J]N,'\u000f\u001e#bi\u0006\u001cX\r^,ji\"|W\u000f\u001e)beRLG/[8o\r&,G\u000e\u001a\u0015\u0005\u0007;\u0011Y\u000bC\u0004\u0004&\u0001!\tAa\u0001\u0002kQ,7\u000f\u001e\"vY.Len]3si\u0012\u000bG/Y:fi^KG\u000f\u001b#bi\u0006\u001cx.\u001e:dK&k\u0007\u000f\\'vYRL\u0007\u000f\\3S_VtGm\u001d\u0015\u0005\u0007G\u0011Y\u000bC\u0004\u0004,\u0001!\ta!\f\u0002eQ,7\u000f\u001e#bi\u0006\u001cx.\u001e:dK&s7/\u001a:u\r>\u0014H+\u00192mKRK\b/\u001a\"bg\u00164\u0015\u000e\\3NKR\fg)[3mIN$rAIB\u0018\u0007c\u0019\u0019\u0004C\u0004\u0003T\r%\u0002\u0019A8\t\u0011\t}5\u0011\u0006a\u0001\u0003OCqa!\u000e\u0004*\u0001\u0007q.\u0001\bcCN,g)\u001b7f\r>\u0014X.\u0019;)\u0011\r%2\u0011\bBo\u0007\u007f\u0001BAa4\u0004<%!1Q\bBi\u00051iU\r\u001e5pIN{WO]2fY\t\u0019\t%\t\u0002\u0004D\u0005!B/Z:u\t\u0006$\u0018m]8ve\u000e,\u0017J\\:feRDCa!\u000b\u0003d\"91\u0011\n\u0001\u0005\u0002\r-\u0013a\n;fgR<\u0016\u000e\u001e5ECR\f7o\\;sG\u0016\u0014un\u001c;tiJ\f\u0007OR8s)\u0006\u0014G.\u001a+za\u0016$2AIB'\u0011\u001d\u0011\u0019fa\u0012A\u0002=D\u0003ba\u0012\u0003|\u000eE31K\u0001\bgR\u0014\u0018N\\4tY\u0011\u0019)f!\u0017\"\u0005\r]\u0013!D\"P!f{vJT0X%&#V)\t\u0002\u0004\\\u0005iQ*\u0012*H\u000b~{ej\u0018*F\u0003\u0012CCaa\u0012\u0003d\"91\u0011\r\u0001\u0005\u0002\r\r\u0014\u0001I5oSRL\u0017\r\\5{K6+G/Y\"mS\u0016tGOR8s\u0005>|Go\u001d;sCB$\u0012BIB3\u0007S\u001aYga\u001c\t\u000f\r\u001d4q\fa\u0001}\u0006qam\\8UC\ndW\rU1sC6\u001c\bb\u0002B*\u0007?\u0002\ra\u001c\u0005\t\u0007[\u001ay\u00061\u0001\u0002(\u0006\u0001\u0012\r\u001a3C_>$8\u000f\u001e:baB\u000bG\u000f\u001b\u0005\t\u0007c\u001ay\u00061\u0001\u0002(\u0006a\u0011N\\5u\u0005\u0006\u001cX\rU1uQ\"91Q\u000f\u0001\u0005\u0002\r]\u0014a\b;fgR\u001c6\r[3nC\u00163x\u000e\\;uS>tgi\u001c:UC\ndW\rV=qKR\u0019!e!\u001f\t\u000f\tM31\u000fa\u0001_\"B11\u000fB~\u0007#\u001ai\b\f\u0003\u0004V\re\u0003\u0006BB:\u0005GDqaa!\u0001\t\u0003\u0011\u0019!\u0001\u0012uKN$\u0018J\\2sK6,g\u000e^1m-&,woV5uQJ+\u0007\u000f\\1dK6,g\u000e\u001e\u0015\u0005\u0007\u0003\u0013Y\u000bC\u0004\u0004\n\u0002!\taa#\u0002-Q,7\u000f\u001e#fY\u0016$X\rU1si&$\u0018n\u001c8t-J\"2AIBG\u0011!\u0019yia\"A\u0002\u0005\u001d\u0016aG;tKB\u000b'\u000f^5uS>t7\u000fV8EK2,G/Z\"p]\u001aLw\r\u000b\u0005\u0004\b\nm8\u0011ABJY\u0011\u0019)aa\u0002)\t\r\u001d%1\u001d\u0005\b\u00073\u0003A\u0011ABN\u0003%\"Xm\u001d;O_:\u0004\u0016M\u001d;ji&|g\u000eV1cY\u0016<\u0016\u000e\u001e5NKR\fG/\u00192mKN+\b\u000f]8siR\u0019!e!(\t\u0011\tM3q\u0013a\u0001\u0007?\u0003Ba!)\u0004,6\u001111\u0015\u0006\u0005\u0007K\u001b9+A\u0003n_\u0012,GNC\u0002\u0004*\n\taaY8n[>t\u0017\u0002BBW\u0007G\u0013q\u0002S8pI&,G+\u00192mKRK\b/\u001a\u0015\t\u0007/\u0013iM!8\u00042\u000e\u00121q\u0014\u0015\u0005\u0007/\u0013\u0019\u000fC\u0004\u00048\u0002!\tAa\u0001\u0002oQ,7\u000f\u001e+p/JLG/Z,ji\"|W\u000f\u001e)be\u0006lW\r^3sg&s7\r\\;eK\u0012Le\u000eS8pI&,G+\u00192mK\u000e{gNZ5hQ\u0011\u0019)La+\t\u000f\ru\u0006\u0001\"\u0001\u0003\u0004\u0005\u0001C/Z:u\u001d>t\u0007/\u0019:uSR|g.\u001a3U_\u0012+g-Y;mi.+\u0017pR3oQ\u0011\u0019YLa+\t\u000f\r\r\u0007\u0001\"\u0001\u0003\u0004\u0005\u0001C/Z:u\t\u00164\u0017-\u001e7u\u0017\u0016Lx)\u001a8U_:{g\u000e]1si&$xN\\3eQ\u0011\u0019\tMa+\t\u000f\r%\u0007\u0001\"\u0001\u0003\u0004\u0005QB/Z:u\u001d>\\U-_$f]R{7+[7qY\u0016\\U-_$f]\"\"1q\u0019BV\u0011\u001d\u0019y\r\u0001C\u0001\u0005\u0007\t!\u0004^3tiNKW\u000e\u001d7f\u0017\u0016Lx)\u001a8U_:{7*Z=HK:DCa!4\u0003,\"91Q\u001b\u0001\u0005\u0002\t\r\u0011!\u0007;fgR<U\r^(sS\u001eLgnS3z\u000f\u0016tWM]1u_JDCaa5\u0003,\"I11\u001c\u0001\u0012\u0002\u0013\u00051Q\\\u0001%i\u0016\u001cHOQ;mW&s7/\u001a:u/&$\bnU8si6{G-\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u00111q\u001c\u0016\u0005\u0003O\u000b9\u0006C\u0005\u0004d\u0002\t\n\u0011\"\u0001\u0004^\u0006!C/Z:u\u0005Vd7.\u00138tKJ$x+\u001b;i'>\u0014H/T8eK\u0012\"WMZ1vYR$3gB\u0004\u0004h\nA\ta!;\u00021Q+7\u000f\u001e%p_\u0012LWm\u00159be.\u001c\u0016\u000f\\,sSR,'\u000fE\u0002\u0015\u0007W4a!\u0001\u0002\t\u0002\r58cABv\u0015!9\u0011ca;\u0005\u0002\rEHCABu\u0011!\u0019\u0019ea;\u0005\u0002\rUXCAB|!\u0019\u0019Ipa@\u0005\u00045\u001111 \u0006\u0005\u0007{\u0014Y(\u0001\u0004tiJ,\u0017-\\\u0005\u0005\t\u0003\u0019YP\u0001\u0004TiJ,\u0017-\u001c\t\u0005\u0005\u001f$)!\u0003\u0003\u0005\b\tE'!C!sOVlWM\u001c;t\u0001")
public class TestHoodieSparkSqlWriter {
    private SparkSession spark;
    private SQLContext sqlContext;
    private SparkContext sc;
    private Path tempPath;
    private Path tempBootStrapPath;
    private String hoodieFooTableName = "hoodie_foo_tbl";
    private String tempBasePath;
    private scala.collection.immutable.Map<String, String> commonTableModifier = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    private volatile TestHoodieSparkSqlWriter$StringLongTest$ StringLongTest$module;

    public static Stream<Arguments> testDatasourceInsert() {
        return TestHoodieSparkSqlWriter$.MODULE$.testDatasourceInsert();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TestHoodieSparkSqlWriter$StringLongTest$ StringLongTest$lzycompute() {
        TestHoodieSparkSqlWriter testHoodieSparkSqlWriter = this;
        synchronized (testHoodieSparkSqlWriter) {
            if (this.StringLongTest$module != null) return this.StringLongTest$module;
            this.StringLongTest$module = new TestHoodieSparkSqlWriter$StringLongTest$(this);
            return this.StringLongTest$module;
        }
    }

    public SparkSession spark() {
        return this.spark;
    }

    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    public SparkContext sc() {
        return this.sc;
    }

    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    public Path tempPath() {
        return this.tempPath;
    }

    public void tempPath_$eq(Path x$1) {
        this.tempPath = x$1;
    }

    public Path tempBootStrapPath() {
        return this.tempBootStrapPath;
    }

    public void tempBootStrapPath_$eq(Path x$1) {
        this.tempBootStrapPath = x$1;
    }

    public String hoodieFooTableName() {
        return this.hoodieFooTableName;
    }

    public void hoodieFooTableName_$eq(String x$1) {
        this.hoodieFooTableName = x$1;
    }

    public String tempBasePath() {
        return this.tempBasePath;
    }

    public void tempBasePath_$eq(String x$1) {
        this.tempBasePath = x$1;
    }

    public scala.collection.immutable.Map<String, String> commonTableModifier() {
        return this.commonTableModifier;
    }

    public void commonTableModifier_$eq(scala.collection.immutable.Map<String, String> x$1) {
        this.commonTableModifier = x$1;
    }

    public TestHoodieSparkSqlWriter$StringLongTest$ StringLongTest() {
        return this.StringLongTest$module == null ? this.StringLongTest$lzycompute() : this.StringLongTest$module;
    }

    @BeforeEach
    public void setUp() {
        this.initSparkContext();
        this.tempPath_$eq(Files.createTempDirectory("hoodie_test_path", new FileAttribute[0]));
        this.tempBootStrapPath_$eq(Files.createTempDirectory("hoodie_test_bootstrap", new FileAttribute[0]));
        this.tempBasePath_$eq(((Object)this.tempPath().toAbsolutePath()).toString());
        this.commonTableModifier_$eq(this.getCommonParams(this.tempPath(), this.hoodieFooTableName(), HoodieTableType.COPY_ON_WRITE.name()));
    }

    @AfterEach
    public void tearDown() {
        this.cleanupSparkContexts();
        FileUtils.deleteDirectory((File)this.tempPath().toFile());
        FileUtils.deleteDirectory((File)this.tempBootStrapPath().toFile());
    }

    public void initSparkContext() {
        SparkConf sparkConf = new SparkConf();
        Object object = HoodieSparkUtils$.MODULE$.gteqSpark3_2() ? sparkConf.set("spark.sql.catalog.spark_catalog", "org.apache.spark.sql.hudi.catalog.HoodieCatalog") : BoxedUnit.UNIT;
        this.spark_$eq(SparkSession$.MODULE$.builder().appName(this.hoodieFooTableName()).master("local[2]").withExtensions((Function1)new HoodieSparkSessionExtension()).config("spark.serializer", "org.apache.spark.serializer.KryoSerializer").config(sparkConf).getOrCreate());
        this.sc_$eq(this.spark().sparkContext());
        this.sc().setLogLevel("ERROR");
        this.sqlContext_$eq(this.spark().sqlContext());
    }

    public void cleanupSparkContexts() {
        if (this.sqlContext() != null) {
            this.sqlContext().clearCache();
            this.sqlContext_$eq(null);
        }
        if (this.sc() != null) {
            this.sc().stop();
            this.sc_$eq(null);
        }
        if (this.spark() != null) {
            this.spark().close();
        }
    }

    public Dataset<Row> dropMetaFields(Dataset<Row> df) {
        return df.drop((String)HoodieRecord.HOODIE_META_COLUMNS.get(0)).drop((String)HoodieRecord.HOODIE_META_COLUMNS.get(1)).drop((String)HoodieRecord.HOODIE_META_COLUMNS.get(2)).drop((String)HoodieRecord.HOODIE_META_COLUMNS.get(3)).drop((String)HoodieRecord.HOODIE_META_COLUMNS.get(4));
    }

    public scala.collection.immutable.Map<String, String> getCommonParams(Path path, String hoodieFooTableName, String tableType) {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)((Object)path.toAbsolutePath()).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)hoodieFooTableName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()), (Object)"org.apache.hudi.keygen.SimpleKeyGenerator")}));
    }

    public Seq<Row> convertRowListToSeq(java.util.List<Row> inputList) {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(inputList.iterator()).asScala()).toSeq();
    }

    public void testBulkInsertWithSortMode(BulkInsertSortMode sortMode, boolean populateMetaFields, boolean enableOCCConfigs) {
        Dataset<Row> trimmedDf;
        scala.collection.immutable.Map fooTableModifier = this.commonTableModifier().updated((Object)"hoodie.bulkinsert.shuffle.parallelism", (Object)"4").updated((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key(), (Object)DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL()).updated((Object)DataSourceWriteOptions$.MODULE$.ENABLE_ROW_WRITER().key(), (Object)"true").updated((Object)HoodieTableConfig.POPULATE_META_FIELDS.key(), (Object)String.valueOf(populateMetaFields)).updated((Object)HoodieWriteConfig.BULK_INSERT_SORT_MODE.key(), (Object)sortMode.name());
        if (enableOCCConfigs) {
            fooTableModifier = fooTableModifier.updated((Object)"hoodie.write.concurrency.mode", (Object)"optimistic_concurrency_control").updated((Object)"hoodie.cleaner.policy.failed.writes", (Object)"LAZY").updated((Object)"hoodie.write.lock.provider", (Object)"org.apache.hudi.client.transaction.lock.InProcessLockProvider");
        }
        Schema schema = DataSourceTestUtils.getStructTypeExampleSchema();
        StructType structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema);
        java.util.List<Row> inserts = DataSourceTestUtils.generateRandomRows(1000);
        Dataset toUpdateDataset = this.sqlContext().createDataFrame(DataSourceTestUtils.getUniqueRows(inserts, 40), structType);
        java.util.List<Row> updates = DataSourceTestUtils.updateRowsWithHigherTs((Dataset<Row>)toUpdateDataset);
        Buffer records = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(inserts).union((GenSeq)JavaConversions$.MODULE$.asScalaBuffer(updates), Buffer$.MODULE$.canBuildFrom());
        Seq<Row> recordsSeq = this.convertRowListToSeq(JavaConversions$.MODULE$.bufferAsJavaList(records));
        SparkContext qual$1 = this.sc();
        Seq<Row> x$14 = recordsSeq;
        int x$15 = qual$1.parallelize$default$2();
        Dataset df = this.spark().createDataFrame(qual$1.parallelize(x$14, x$15, ClassTag$.MODULE$.apply(Row.class)), structType);
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, fooTableModifier, df, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8());
        Seq partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2016/03/15", "2015/03/16", "2015/03/17"}));
        String[] fullPartitionPaths = new String[3];
        Predef$.MODULE$.refArrayOps((Object[])fullPartitionPaths).indices().foreach$mVc$sp((Function1)new Serializable(this, partitions, fullPartitionPaths){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestHoodieSparkSqlWriter $outer;
            private final Seq partitions$1;
            private final String[] fullPartitionPaths$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.fullPartitionPaths$1[i] = String.format("%s/%s/*", this.$outer.tempBasePath(), this.partitions$1.apply(i));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitions$1 = partitions$1;
                this.fullPartitionPaths$1 = fullPartitionPaths$1;
            }
        });
        Dataset actualDf = this.sqlContext().read().parquet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{fullPartitionPaths[0], fullPartitionPaths[1], fullPartitionPaths[2]}));
        if (!populateMetaFields) {
            List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4})).foreach((Function1)new Serializable(this, actualDf){
                public static final long serialVersionUID = 0L;
                private final Dataset actualDf$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    Assertions.assertEquals((long)0L, (long)this.actualDf$1.select((String)HoodieRecord.HOODIE_META_COLUMNS.get(i), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Row entry) {
                            return !entry.mkString(",").equals("");
                        }
                    }).count());
                }
                {
                    this.actualDf$1 = actualDf$1;
                }
            });
        }
        Predef$.MODULE$.assert(df.except(trimmedDf = this.dropMetaFields((Dataset<Row>)actualDf)).count() == 0L);
    }

    public boolean testBulkInsertWithSortMode$default$2() {
        return true;
    }

    public boolean testBulkInsertWithSortMode$default$3() {
        return false;
    }

    @Test
    public void testParametersWithWriteDefaults() {
        scala.collection.immutable.Map originals = HoodieWriterUtils$.MODULE$.parametersWithWriteDefaults(Predef$.MODULE$.Map().empty());
        String rhsKey = "hoodie.right.hand.side.key";
        String rhsVal = "hoodie.right.hand.side.val";
        scala.collection.immutable.Map modifier = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()), (Object)DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rhsKey), (Object)rhsVal)}));
        scala.collection.immutable.Map modified = HoodieWriterUtils$.MODULE$.parametersWithWriteDefaults(modifier);
        Serializable matcher = new Serializable(this, modified){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map modified$1;

            public final Assertion apply(String k, String v) {
                return Matchers$.MODULE$.convertToAnyShouldWrapper(this.modified$1.apply((Object)k), new Position("TestHoodieSparkSqlWriter.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229), Prettifier$.MODULE$.default()).should(Matchers$.MODULE$.be().apply((Object)v));
            }
            {
                this.modified$1 = modified$1;
            }
        };
        originals.foreach((Function1)new Serializable(this, rhsKey, rhsVal, (Function2)matcher){
            public static final long serialVersionUID = 0L;
            private final String rhsKey$1;
            private final String rhsVal$1;
            private final Function2 matcher$1;

            public final Assertion apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2;
                block6: {
                    Assertion assertion;
                    block3: {
                        block5: {
                            block4: {
                                String string;
                                block2: {
                                    String string2;
                                    tuple2 = x0$1;
                                    if (tuple2 == null || !"hoodie.datasource.write.operation".equals(string2 = (String)tuple2._1())) break block2;
                                    assertion = (Assertion)this.matcher$1.apply((Object)"hoodie.datasource.write.operation", (Object)DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL());
                                    break block3;
                                }
                                if (tuple2 == null || !"hoodie.datasource.write.table.type".equals(string = (String)tuple2._1())) break block4;
                                assertion = (Assertion)this.matcher$1.apply((Object)"hoodie.datasource.write.table.type", (Object)DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL());
                                break block3;
                            }
                            if (tuple2 == null) break block5;
                            String string = (String)tuple2._1();
                            String string3 = this.rhsKey$1;
                            String string4 = string;
                            if (string3 != null ? !string3.equals(string4) : string4 != null) break block5;
                            assertion = (Assertion)this.matcher$1.apply((Object)this.rhsKey$1, (Object)this.rhsVal$1);
                            break block3;
                        }
                        if (tuple2 == null) break block6;
                        String k = (String)tuple2._1();
                        String v = (String)tuple2._2();
                        assertion = (Assertion)this.matcher$1.apply((Object)k, (Object)v);
                    }
                    return assertion;
                }
                throw new MatchError(tuple2);
            }
            {
                this.rhsKey$1 = rhsKey$1;
                this.rhsVal$1 = rhsVal$1;
                this.matcher$1 = matcher$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testThrowExceptionInvalidSerializer() {
        this.spark().stop();
        SparkSession session = SparkSession$.MODULE$.builder().appName("hoodie_test").master("local").getOrCreate();
        try {
            SQLContext sqlContext = session.sqlContext();
            scala.collection.immutable.Map options = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)"hoodie/test/path"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test_tbl")}));
            HoodieException e = (HoodieException)Matchers$.MODULE$.intercept((Function0)new Serializable(this, session, sqlContext, options){
                public static final long serialVersionUID = 0L;
                private final SparkSession session$1;
                private final SQLContext sqlContext$1;
                private final scala.collection.immutable.Map options$1;

                public final Tuple6<Object, Option<String>, Option<String>, Option<String>, SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>, HoodieTableConfig> apply() {
                    return HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext$1, SaveMode.ErrorIfExists, this.options$1, this.session$1.emptyDataFrame(), HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8());
                }
                {
                    this.session$1 = session$1;
                    this.sqlContext$1 = sqlContext$1;
                    this.options$1 = options$1;
                }
            }, ClassTag$.MODULE$.apply(HoodieException.class), new Position("TestHoodieSparkSqlWriter.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248));
            Predef$.MODULE$.assert(e.getMessage().contains("spark.serializer"));
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.stop();
            this.initSparkContext();
            throw throwable;
        }
        session.stop();
        this.initSparkContext();
    }

    @Test
    public void testThrowExceptionAlreadyExistsWithAppendSaveMode() {
        scala.collection.immutable.Map fooTableModifier = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)this.tempBasePath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)this.hoodieFooTableName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4")}));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.hudi.TestHoodieSparkSqlWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.hudi.TestHoodieSparkSqlWriter"), "StringLongTest"), (List)Nil$.MODULE$);
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator1$1(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset dataFrame = this.spark().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringLongTest[]{new StringLongTest(this, UUID.randomUUID().toString(), new Date().getTime())})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator1$1(this)));
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, fooTableModifier, dataFrame, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8());
        scala.collection.immutable.Map barTableModifier = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)this.tempBasePath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_bar_tbl"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4")}));
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.hudi.TestHoodieSparkSqlWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.hudi.TestHoodieSparkSqlWriter"), "StringLongTest"), (List)Nil$.MODULE$);
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator2$1(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset dataFrame2 = this.spark().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringLongTest[]{new StringLongTest(this, UUID.randomUUID().toString(), new Date().getTime())})), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator2$1(this)));
        HoodieException tableAlreadyExistException = (HoodieException)Matchers$.MODULE$.intercept((Function0)new Serializable(this, barTableModifier, dataFrame2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestHoodieSparkSqlWriter $outer;
            private final scala.collection.immutable.Map barTableModifier$1;
            private final Dataset dataFrame2$1;

            public final Tuple6<Object, Option<String>, Option<String>, Option<String>, SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>, HoodieTableConfig> apply() {
                return HoodieSparkSqlWriter$.MODULE$.write(this.$outer.sqlContext(), SaveMode.Append, this.barTableModifier$1, this.dataFrame2$1, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.barTableModifier$1 = barTableModifier$1;
                this.dataFrame2$1 = dataFrame2$1;
            }
        }, ClassTag$.MODULE$.apply(HoodieException.class), new Position("TestHoodieSparkSqlWriter.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
        Predef$.MODULE$.assert(tableAlreadyExistException.getMessage().contains("Config conflict"));
        Predef$.MODULE$.assert(tableAlreadyExistException.getMessage().contains(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":\\thoodie_bar_tbl\\thoodie_foo_tbl"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieWriteConfig.TBL_NAME.key()}))));
        scala.collection.immutable.Map deleteTableModifier = barTableModifier.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()), (Object)"delete")})));
        HoodieException deleteCmdException = (HoodieException)Matchers$.MODULE$.intercept((Function0)new Serializable(this, dataFrame2, deleteTableModifier){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestHoodieSparkSqlWriter $outer;
            private final Dataset dataFrame2$1;
            private final scala.collection.immutable.Map deleteTableModifier$1;

            public final Tuple6<Object, Option<String>, Option<String>, Option<String>, SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>, HoodieTableConfig> apply() {
                return HoodieSparkSqlWriter$.MODULE$.write(this.$outer.sqlContext(), SaveMode.Append, this.deleteTableModifier$1, this.dataFrame2$1, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dataFrame2$1 = dataFrame2$1;
                this.deleteTableModifier$1 = deleteTableModifier$1;
            }
        }, ClassTag$.MODULE$.apply(HoodieException.class), new Position("TestHoodieSparkSqlWriter.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
        Predef$.MODULE$.assert(tableAlreadyExistException.getMessage().contains("Config conflict"));
        Predef$.MODULE$.assert(tableAlreadyExistException.getMessage().contains(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":\\thoodie_bar_tbl\\thoodie_foo_tbl"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieWriteConfig.TBL_NAME.key()}))));
    }

    @Test
    public void testValidateTableConfigWithOverwriteSaveMode() {
        scala.collection.immutable.Map tableModifier1 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)this.tempBasePath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)this.hoodieFooTableName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.datasource.write.recordkey.field"), (Object)"uuid")}));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.hudi.TestHoodieSparkSqlWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.hudi.TestHoodieSparkSqlWriter"), "StringLongTest"), (List)Nil$.MODULE$);
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator3$1(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset dataFrame = this.spark().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringLongTest[]{new StringLongTest(this, UUID.randomUUID().toString(), new Date().getTime())})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator3$1(this)));
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Overwrite, tableModifier1, dataFrame, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8());
        scala.collection.immutable.Map tableModifier2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)this.tempBasePath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)this.hoodieFooTableName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.datasource.write.recordkey.field"), (Object)"ts")}));
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.hudi.TestHoodieSparkSqlWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.hudi.TestHoodieSparkSqlWriter"), "StringLongTest"), (List)Nil$.MODULE$);
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator4$1(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset dataFrame2 = this.spark().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringLongTest[]{new StringLongTest(this, UUID.randomUUID().toString(), new Date().getTime())})), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator4$1(this)));
        HoodieException hoodieException = (HoodieException)Matchers$.MODULE$.intercept((Function0)new Serializable(this, tableModifier2, dataFrame2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestHoodieSparkSqlWriter $outer;
            private final scala.collection.immutable.Map tableModifier2$1;
            private final Dataset dataFrame2$2;

            public final Tuple6<Object, Option<String>, Option<String>, Option<String>, SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>, HoodieTableConfig> apply() {
                return HoodieSparkSqlWriter$.MODULE$.write(this.$outer.sqlContext(), SaveMode.Append, this.tableModifier2$1, this.dataFrame2$2, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tableModifier2$1 = tableModifier2$1;
                this.dataFrame2$2 = dataFrame2$2;
            }
        }, ClassTag$.MODULE$.apply(HoodieException.class), new Position("TestHoodieSparkSqlWriter.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
        Predef$.MODULE$.assert(hoodieException.getMessage().contains("Config conflict"));
        Predef$.MODULE$.assert(hoodieException.getMessage().contains(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RecordKey:\\tts\\tuuid"})).s((Seq)Nil$.MODULE$)));
        Predef$.MODULE$.assert(BoxesRunTime.unboxToBoolean((Object)HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Overwrite, tableModifier2, dataFrame2, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8())._1()));
    }

    @ParameterizedTest
    @EnumSource(value=BulkInsertSortMode.class)
    public void testBulkInsertForSortMode(BulkInsertSortMode sortMode) {
        this.testBulkInsertWithSortMode(sortMode, true, this.testBulkInsertWithSortMode$default$3());
    }

    @Test
    public void testBulkInsertForSortModeWithOCC() {
        this.testBulkInsertWithSortMode(BulkInsertSortMode.GLOBAL_SORT, true, true);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testBulkInsertForPopulateMetaFields(boolean populateMetaFields) {
        this.testBulkInsertWithSortMode(BulkInsertSortMode.NONE, populateMetaFields, this.testBulkInsertWithSortMode$default$3());
    }

    @Test
    public void testDisableAndEnableMetaFields() {
        this.testBulkInsertWithSortMode(BulkInsertSortMode.NONE, false, this.testBulkInsertWithSortMode$default$3());
        scala.collection.immutable.Map fooTableModifier = this.commonTableModifier().updated((Object)"hoodie.bulkinsert.shuffle.parallelism", (Object)"4").updated((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key(), (Object)DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL()).updated((Object)DataSourceWriteOptions$.MODULE$.ENABLE_ROW_WRITER().key(), (Object)"true").updated((Object)HoodieWriteConfig.BULK_INSERT_SORT_MODE.key(), (Object)BulkInsertSortMode.NONE.name()).updated((Object)HoodieTableConfig.POPULATE_META_FIELDS.key(), (Object)"true");
        Schema schema = DataSourceTestUtils.getStructTypeExampleSchema();
        StructType structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema);
        java.util.List<Row> inserts = DataSourceTestUtils.generateRandomRows(1000);
        SparkContext qual$2 = this.sc();
        Buffer x$16 = JavaConversions$.MODULE$.asScalaBuffer(inserts);
        int x$17 = qual$2.parallelize$default$2();
        Dataset df = this.spark().createDataFrame(qual$2.parallelize((Seq)x$16, x$17, ClassTag$.MODULE$.apply(Row.class)), structType);
        try {
            HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, fooTableModifier, df, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8());
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (Exception exception) {
            Assertions.fail((Throwable)exception);
        }
        catch (HoodieException hoodieException) {
            Assertions.assertTrue((boolean)hoodieException.getMessage().startsWith("Config conflict"));
        }
    }

    @Test
    public void testDropDuplicatesRowForBulkInsert() {
        try {
            scala.collection.immutable.Map fooTableModifier = this.commonTableModifier().updated((Object)"hoodie.bulkinsert.shuffle.parallelism", (Object)"4").updated((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key(), (Object)DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL()).updated((Object)DataSourceWriteOptions$.MODULE$.ENABLE_ROW_WRITER().key(), (Object)"true").updated((Object)DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS().key(), (Object)"true");
            Schema schema = DataSourceTestUtils.getStructTypeExampleSchema();
            StructType structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema);
            java.util.List<Row> records = DataSourceTestUtils.generateRandomRows(100);
            Seq<Row> recordsSeq = this.convertRowListToSeq(records);
            SparkContext qual$3 = this.spark().sparkContext();
            Seq<Row> x$18 = recordsSeq;
            int x$19 = qual$3.parallelize$default$2();
            Dataset df = this.spark().createDataFrame(qual$3.parallelize(x$18, x$19, ClassTag$.MODULE$.apply(Row.class)), structType);
            HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, fooTableModifier, df, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8());
            Assertions.fail((String)"Drop duplicates with bulk insert in row writing should have thrown exception");
        }
        catch (HoodieException hoodieException) {
            Assertions.assertTrue((boolean)hoodieException.getMessage().contains("Dropping duplicates with bulk_insert in row writer path is not supported yet"));
        }
    }

    @Test
    public void testInsertDatasetWithoutPrecombineField() {
        scala.collection.immutable.Map fooTableModifier = this.commonTableModifier().updated((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key(), (Object)DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).updated((Object)DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS().key(), (Object)"false");
        Schema schema = DataSourceTestUtils.getStructTypeExampleSchema();
        StructType structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema);
        java.util.List<Row> records = DataSourceTestUtils.generateRandomRows(100);
        Seq<Row> recordsSeq = this.convertRowListToSeq(records);
        SparkContext qual$4 = this.sc();
        Seq<Row> x$20 = recordsSeq;
        int x$21 = qual$4.parallelize$default$2();
        Dataset df = this.spark().createDataFrame(qual$4.parallelize(x$20, x$21, ClassTag$.MODULE$.apply(Row.class)), structType);
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, (scala.collection.immutable.Map)fooTableModifier.$minus((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), df, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8());
        Seq partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2016/03/15", "2015/03/16", "2015/03/17"}));
        String[] fullPartitionPaths = new String[3];
        Predef$.MODULE$.refArrayOps((Object[])fullPartitionPaths).indices().foreach$mVc$sp((Function1)new Serializable(this, partitions, fullPartitionPaths){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestHoodieSparkSqlWriter $outer;
            private final Seq partitions$2;
            private final String[] fullPartitionPaths$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.fullPartitionPaths$2[i] = String.format("%s/%s/*", this.$outer.tempBasePath(), this.partitions$2.apply(i));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitions$2 = partitions$2;
                this.fullPartitionPaths$2 = fullPartitionPaths$2;
            }
        });
        Dataset actualDf = this.spark().sqlContext().read().parquet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{fullPartitionPaths[0], fullPartitionPaths[1], fullPartitionPaths[2]}));
        Dataset<Row> trimmedDf = this.dropMetaFields((Dataset<Row>)actualDf);
        Predef$.MODULE$.assert(df.except(trimmedDf).count() == 0L);
    }

    @Test
    public void testInsertDatasetWithoutPartitionField() {
        scala.collection.immutable.Map tableOpts = this.commonTableModifier().updated((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key(), (Object)DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL());
        Schema schema = DataSourceTestUtils.getStructTypeExampleSchema();
        StructType structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema);
        java.util.List<Row> records = DataSourceTestUtils.generateRandomRows(1);
        Seq<Row> recordsSeq = this.convertRowListToSeq(records);
        SparkContext qual$5 = this.sc();
        Seq<Row> x$22 = recordsSeq;
        int x$23 = qual$5.parallelize$default$2();
        Dataset df = this.spark().createDataFrame(qual$5.parallelize(x$22, x$23, ClassTag$.MODULE$.apply(Row.class)), structType);
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, tableOpts, df){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestHoodieSparkSqlWriter $outer;
            private final scala.collection.immutable.Map tableOpts$1;
            private final Dataset df$1;

            public final Tuple6<Object, Option<String>, Option<String>, Option<String>, SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>, HoodieTableConfig> apply() {
                return HoodieSparkSqlWriter$.MODULE$.write(this.$outer.sqlContext(), SaveMode.Append, (scala.collection.immutable.Map)this.tableOpts$1.$minus((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), this.df$1, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tableOpts$1 = tableOpts$1;
                this.df$1 = df$1;
            }
        }, ClassTag$.MODULE$.apply(IOException.class), new Position("TestHoodieSparkSqlWriter.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 440));
    }

    @Test
    public void testBulkInsertDatasetWithDatasourceImplMultipleRounds() {
        scala.collection.immutable.Map fooTableModifier = this.commonTableModifier().updated((Object)"hoodie.bulkinsert.shuffle.parallelism", (Object)"4").updated((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key(), (Object)DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL()).updated((Object)DataSourceWriteOptions$.MODULE$.ENABLE_ROW_WRITER().key(), (Object)"true");
        Seq partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2016/03/15", "2015/03/16", "2015/03/17"}));
        String[] fullPartitionPaths = new String[3];
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)new Serializable(this, partitions, fullPartitionPaths){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestHoodieSparkSqlWriter $outer;
            private final Seq partitions$3;
            private final String[] fullPartitionPaths$3;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.fullPartitionPaths$3[i] = String.format("%s/%s/*", this.$outer.tempBasePath(), this.partitions$3.apply(i));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitions$3 = partitions$3;
                this.fullPartitionPaths$3 = fullPartitionPaths$3;
            }
        });
        Schema schema = DataSourceTestUtils.getStructTypeExampleSchema();
        StructType structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema);
        ObjectRef totalExpectedDf = ObjectRef.create((Object)this.spark().createDataFrame(this.sc().emptyRDD(ClassTag$.MODULE$.apply(Row.class)), structType));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)new Serializable(this, fooTableModifier, fullPartitionPaths, structType, totalExpectedDf){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestHoodieSparkSqlWriter $outer;
            private final scala.collection.immutable.Map fooTableModifier$1;
            private final String[] fullPartitionPaths$3;
            private final StructType structType$1;
            private final ObjectRef totalExpectedDf$1;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                java.util.List<Row> records = DataSourceTestUtils.generateRandomRows(200);
                Seq<Row> recordsSeq = this.$outer.convertRowListToSeq(records);
                SparkContext qual$6 = this.$outer.sc();
                Seq<Row> x$24 = recordsSeq;
                int x$25 = qual$6.parallelize$default$2();
                Dataset df = this.$outer.spark().createDataFrame(qual$6.parallelize(x$24, x$25, ClassTag$.MODULE$.apply(Row.class)), this.structType$1);
                HoodieSparkSqlWriter$.MODULE$.write(this.$outer.sqlContext(), SaveMode.Append, this.fooTableModifier$1, df, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8());
                Dataset actualDf = this.$outer.sqlContext().read().parquet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.fullPartitionPaths$3[0], this.fullPartitionPaths$3[1], this.fullPartitionPaths$3[2]}));
                Dataset<Row> trimmedDf = this.$outer.dropMetaFields((Dataset<Row>)actualDf);
                this.totalExpectedDf$1.elem = ((Dataset)this.totalExpectedDf$1.elem).union(df);
                Predef$.MODULE$.assert(((Dataset)this.totalExpectedDf$1.elem).except(trimmedDf).count() == 0L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fooTableModifier$1 = fooTableModifier$1;
                this.fullPartitionPaths$3 = fullPartitionPaths$3;
                this.structType$1 = structType$1;
                this.totalExpectedDf$1 = totalExpectedDf$1;
            }
        });
    }

    @ParameterizedTest
    @MethodSource(value={"testDatasourceInsert"})
    public void testDatasourceInsertForTableTypeBaseFileMetaFields(String tableType, boolean populateMetaFields, String baseFileFormat) {
        String hoodieFooTableName = "hoodie_foo_tbl";
        scala.collection.immutable.Map fooTableModifier = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)this.tempBasePath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)hoodieFooTableName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.BASE_FILE_FORMAT.key()), (Object)baseFileFormat), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.INSERT_PARALLELISM_VALUE.key()), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()), (Object)DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieTableConfig.POPULATE_META_FIELDS.key()), (Object)String.valueOf(populateMetaFields)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()), (Object)SimpleKeyGenerator.class.getCanonicalName())}));
        scala.collection.immutable.Map fooTableParams = HoodieWriterUtils$.MODULE$.parametersWithWriteDefaults(fooTableModifier);
        Schema schema = DataSourceTestUtils.getStructTypeExampleSchema();
        StructType structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema);
        Schema modifiedSchema = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)structType, "trip", "example.schema");
        java.util.List<Row> records = DataSourceTestUtils.generateRandomRows(100);
        Seq<Row> recordsSeq = this.convertRowListToSeq(records);
        SparkContext qual$7 = this.sc();
        Seq<Row> x$26 = recordsSeq;
        int x$27 = qual$7.parallelize$default$2();
        Dataset df = this.spark().createDataFrame(qual$7.parallelize(x$26, x$27, ClassTag$.MODULE$.apply(Row.class)), structType);
        this.initializeMetaClientForBootstrap((scala.collection.immutable.Map<String, String>)fooTableParams, tableType, false, true);
        SparkRDDWriteClient client = (SparkRDDWriteClient)Mockito.spy((Object)DataSourceUtils.createHoodieClient((JavaSparkContext)new JavaSparkContext(this.sc()), (String)modifiedSchema.toString(), (String)this.tempBasePath(), (String)hoodieFooTableName, (java.util.Map)JavaConversions$.MODULE$.mapAsJavaMap((Map)fooTableParams)));
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, fooTableModifier, df, Option$.MODULE$.empty(), Option$.MODULE$.apply((Object)client), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8());
        ((BaseHoodieWriteClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)0))).scheduleCompaction((Option)ArgumentMatchers.any());
        ((BaseHoodieWriteClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)1))).close();
        Seq partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2016/03/15", "2015/03/16", "2015/03/17"}));
        String[] fullPartitionPaths = new String[3];
        Predef$.MODULE$.refArrayOps((Object[])fullPartitionPaths).indices().foreach$mVc$sp((Function1)new Serializable(this, partitions, fullPartitionPaths){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestHoodieSparkSqlWriter $outer;
            private final Seq partitions$4;
            private final String[] fullPartitionPaths$4;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.fullPartitionPaths$4[i] = String.format("%s/%s/*", this.$outer.tempBasePath(), this.partitions$4.apply(i));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitions$4 = partitions$4;
                this.fullPartitionPaths$4 = fullPartitionPaths$4;
            }
        });
        Dataset actualDf = null;
        if (baseFileFormat.equalsIgnoreCase(HoodieFileFormat.PARQUET.name())) {
            actualDf = this.sqlContext().read().parquet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{fullPartitionPaths[0], fullPartitionPaths[1], fullPartitionPaths[2]}));
        } else if (baseFileFormat.equalsIgnoreCase(HoodieFileFormat.ORC.name())) {
            actualDf = this.sqlContext().read().orc((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{fullPartitionPaths[0], fullPartitionPaths[1], fullPartitionPaths[2]}));
        }
        Dataset<Row> trimmedDf = this.dropMetaFields(actualDf);
        Predef$.MODULE$.assert(df.except(trimmedDf).count() == 0L);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"COPY_ON_WRITE", "MERGE_ON_READ"})
    public void testWithDatasourceBootstrapForTableType(String tableType) {
        Path srcPath = Files.createTempDirectory("hoodie_bootstrap_source_path", new FileAttribute[0]);
        try {
            Dataset<Row> sourceDF = TestBootstrap.generateTestRawTripDataset(Instant.now().toEpochMilli(), 0, 100, Collections.emptyList(), JavaSparkContext$.MODULE$.fromSparkContext(this.sc()), this.spark().sqlContext());
            sourceDF.write().format("parquet").mode(SaveMode.Overwrite).save(((Object)srcPath.toAbsolutePath()).toString());
            scala.collection.immutable.Map fooTableModifier = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)this.tempBasePath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieBootstrapConfig.BASE_PATH.key()), (Object)((Object)srcPath.toAbsolutePath()).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)this.hoodieFooTableName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieBootstrapConfig.PARALLELISM_VALUE.key()), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()), (Object)DataSourceWriteOptions$.MODULE$.BOOTSTRAP_OPERATION_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieBootstrapConfig.KEYGEN_CLASS_NAME.key()), (Object)NonpartitionedKeyGenerator.class.getCanonicalName())}));
            scala.collection.immutable.Map fooTableParams = HoodieWriterUtils$.MODULE$.parametersWithWriteDefaults(fooTableModifier);
            this.initializeMetaClientForBootstrap((scala.collection.immutable.Map<String, String>)fooTableParams, tableType, true, false);
            SparkRDDWriteClient client = (SparkRDDWriteClient)Mockito.spy((Object)DataSourceUtils.createHoodieClient((JavaSparkContext)new JavaSparkContext(this.sc()), null, (String)this.tempBasePath(), (String)this.hoodieFooTableName(), (java.util.Map)JavaConversions$.MODULE$.mapAsJavaMap((Map)fooTableParams)));
            HoodieSparkSqlWriter$.MODULE$.bootstrap(this.sqlContext(), SaveMode.Append, fooTableModifier, this.spark().emptyDataFrame(), Option$.MODULE$.empty(), Option$.MODULE$.apply((Object)client));
            ((BaseHoodieWriteClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)1))).close();
            boolean ignoreResult = HoodieSparkSqlWriter$.MODULE$.bootstrap(this.sqlContext(), SaveMode.Ignore, fooTableModifier, this.spark().emptyDataFrame(), Option$.MODULE$.empty(), Option$.MODULE$.apply((Object)client));
            Assertions.assertFalse((boolean)ignoreResult);
            ((BaseHoodieWriteClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)2))).close();
            Dataset actualDf = this.sqlContext().read().parquet(this.tempBasePath());
            Predef$.MODULE$.assert(actualDf.count() == 100L);
        }
        catch (Throwable throwable) {
            void var2_2;
            FileUtils.deleteDirectory((File)var2_2.toFile());
            throw throwable;
        }
        FileUtils.deleteDirectory((File)srcPath.toFile());
    }

    public void initializeMetaClientForBootstrap(scala.collection.immutable.Map<String, String> fooTableParams, String tableType, boolean addBootstrapPath, boolean initBasePath) {
        HoodieTableMetaClient.PropertyBuilder tableMetaClientBuilder = HoodieTableMetaClient.withPropertyBuilder().setTableType(tableType).setTableName(this.hoodieFooTableName()).setRecordKeyFields((String)fooTableParams.apply((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key())).setBaseFileFormat((String)fooTableParams.getOrElse((Object)HoodieWriteConfig.BASE_FILE_FORMAT.key(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return ((Enum)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).name();
            }
        })).setArchiveLogFolder((String)HoodieTableConfig.ARCHIVELOG_FOLDER.defaultValue()).setPayloadClassName((String)fooTableParams.apply((Object)DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_NAME().key())).setPreCombineField((String)fooTableParams.apply((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key())).setPartitionFields((String)fooTableParams.apply((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key())).setKeyGeneratorClassProp((String)fooTableParams.apply((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()));
        Object object = addBootstrapPath ? tableMetaClientBuilder.setBootstrapBasePath((String)fooTableParams.apply((Object)HoodieBootstrapConfig.BASE_PATH.key())) : BoxedUnit.UNIT;
        if (initBasePath) {
            tableMetaClientBuilder.initTable(this.sc().hadoopConfiguration(), this.tempBasePath());
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"COPY_ON_WRITE", "MERGE_ON_READ"})
    public void testSchemaEvolutionForTableType(String tableType) {
        scala.collection.immutable.Map fooTableModifier = this.getCommonParams(this.tempPath(), this.hoodieFooTableName(), tableType).updated((Object)DataSourceWriteOptions$.MODULE$.RECONCILE_SCHEMA().key(), (Object)"true");
        Schema schema = DataSourceTestUtils.getStructTypeExampleSchema();
        StructType structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema);
        java.util.List<Row> records = DataSourceTestUtils.generateRandomRows(10);
        Seq<Row> recordsSeq = this.convertRowListToSeq(records);
        SparkContext qual$8 = this.sc();
        Seq<Row> x$28 = recordsSeq;
        int x$29 = qual$8.parallelize$default$2();
        Dataset df1 = this.spark().createDataFrame(qual$8.parallelize(x$28, x$29, ClassTag$.MODULE$.apply(Row.class)), structType);
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Overwrite, fooTableModifier, df1, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8());
        Dataset snapshotDF1 = this.spark().read().format("org.apache.hudi").load(new StringBuilder().append((Object)this.tempBasePath()).append((Object)"/*/*/*/*").toString());
        Assertions.assertEquals((long)10L, (long)snapshotDF1.count());
        Dataset<Row> trimmedDf1 = this.dropMetaFields((Dataset<Row>)snapshotDF1);
        Predef$.MODULE$.assert(df1.except(trimmedDf1).count() == 0L);
        Seq<Row> updatesSeq = this.convertRowListToSeq(DataSourceTestUtils.generateUpdates(records, 5));
        SparkContext qual$9 = this.sc();
        Seq<Row> x$30 = updatesSeq;
        int x$31 = qual$9.parallelize$default$2();
        Dataset updatesDf = this.spark().createDataFrame(qual$9.parallelize(x$30, x$31, ClassTag$.MODULE$.apply(Row.class)), structType);
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, fooTableModifier, updatesDf, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8());
        Dataset snapshotDF2 = this.spark().read().format("org.apache.hudi").load(new StringBuilder().append((Object)this.tempBasePath()).append((Object)"/*/*/*/*").toString());
        Assertions.assertEquals((long)10L, (long)snapshotDF2.count());
        Dataset<Row> trimmedDf2 = this.dropMetaFields((Dataset<Row>)snapshotDF2);
        Predef$.MODULE$.assert(updatesDf.intersect(trimmedDf2).except(updatesDf).count() == 0L);
        Schema evolSchema = DataSourceTestUtils.getStructTypeExampleEvolvedSchema();
        StructType evolStructType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(evolSchema);
        records = DataSourceTestUtils.generateRandomRowsEvolvedSchema(5);
        recordsSeq = this.convertRowListToSeq(records);
        SparkContext qual$10 = this.sc();
        Seq<Row> x$32 = recordsSeq;
        int x$33 = qual$10.parallelize$default$2();
        Dataset df3 = this.spark().createDataFrame(qual$10.parallelize(x$32, x$33, ClassTag$.MODULE$.apply(Row.class)), evolStructType);
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, fooTableModifier, df3, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8());
        Dataset snapshotDF3 = this.spark().read().format("org.apache.hudi").load(new StringBuilder().append((Object)this.tempBasePath()).append((Object)"/*/*/*/*").toString());
        Assertions.assertEquals((long)15L, (long)snapshotDF3.count());
        Dataset<Row> trimmedDf3 = this.dropMetaFields((Dataset<Row>)snapshotDF3);
        Predef$.MODULE$.assert(df3.intersect(trimmedDf3).except(df3).count() == 0L);
        records = DataSourceTestUtils.generateRandomRows(10);
        recordsSeq = this.convertRowListToSeq(records);
        SparkContext qual$11 = this.sc();
        Seq<Row> x$34 = recordsSeq;
        int x$35 = qual$11.parallelize$default$2();
        Dataset df4 = this.spark().createDataFrame(qual$11.parallelize(x$34, x$35, ClassTag$.MODULE$.apply(Row.class)), structType);
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, fooTableModifier, df4, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8());
        Dataset snapshotDF4 = this.spark().read().format("org.apache.hudi").load(new StringBuilder().append((Object)this.tempBasePath()).append((Object)"/*/*/*/*").toString());
        Assertions.assertEquals((long)25L, (long)snapshotDF4.count());
        HoodieTableMetaClient tableMetaClient = HoodieTableMetaClient.builder().setConf(this.spark().sparkContext().hadoopConfiguration()).setBasePath(this.tempBasePath()).build();
        Schema actualSchema = new TableSchemaResolver(tableMetaClient).getTableAvroSchemaWithoutMetadataFields();
        Assertions.assertTrue((actualSchema != null ? 1 : 0) != 0);
        Tuple2 tuple2 = AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace(this.hoodieFooTableName());
        if (tuple2 != null) {
            Tuple2 tuple22;
            String structName = (String)tuple2._1();
            String nameSpace = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)structName, (Object)nameSpace);
            String structName2 = (String)tuple23._1();
            String nameSpace2 = (String)tuple23._2();
            Schema expectedSchema = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)evolStructType, structName2, nameSpace2);
            Assertions.assertEquals((Object)expectedSchema, (Object)actualSchema);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testIncrementalViewWithReplacement() {
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()})).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestHoodieSparkSqlWriter $outer;

            public final void apply(String tableType) {
                String baseBootStrapPath = ((Object)this.$outer.tempBootStrapPath().toAbsolutePath()).toString();
                scala.collection.immutable.Map options = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"col3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"keyid"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()), (Object)"org.apache.hudi.keygen.NonpartitionedKeyGenerator"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test")}));
                Dataset df = this.$outer.spark().range(0L, 1000L).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keyid"})).withColumn("col3", functions$.MODULE$.expr("keyid")).withColumn("age", functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1))).withColumn("p", functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2)));
                df.write().format("hudi").options((Map)options).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), "insert").option("hoodie.insert.shuffle.parallelism", "4").mode(SaveMode.Overwrite).save(this.$outer.tempBasePath());
                df.write().format("hudi").options((Map)options).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), "insert_overwrite_table").option("hoodie.insert.shuffle.parallelism", "4").mode(SaveMode.Append).save(this.$outer.tempBasePath());
                String[] currentCommits = (String[])Predef$.MODULE$.refArrayOps((Object[])this.$outer.spark().read().format("hudi").load(this.$outer.tempBasePath()).select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).take(1)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Row x$2) {
                        return x$2.getString(0);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                long incrementalKeyIdNum = this.$outer.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), "0000").option(DataSourceReadOptions$.MODULE$.END_INSTANTTIME().key(), currentCommits[0]).load(this.$outer.tempBasePath()).select("keyid", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).orderBy("keyid", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count();
                Predef$.MODULE$.assert(incrementalKeyIdNum == 1000L);
                df.write().mode(SaveMode.Overwrite).save(baseBootStrapPath);
                this.$outer.spark().emptyDataFrame().write().format("hudi").options((Map)options).option(HoodieBootstrapConfig.BASE_PATH.key(), baseBootStrapPath).option(HoodieBootstrapConfig.KEYGEN_CLASS_NAME.key(), NonpartitionedKeyGenerator.class.getCanonicalName()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.BOOTSTRAP_OPERATION_OPT_VAL()).option(HoodieBootstrapConfig.PARALLELISM_VALUE.key(), "4").mode(SaveMode.Overwrite).save(this.$outer.tempBasePath());
                df.write().format("hudi").options((Map)options).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), "insert_overwrite_table").option("hoodie.insert.shuffle.parallelism", "4").mode(SaveMode.Append).save(this.$outer.tempBasePath());
                String[] currentCommitsBootstrap = (String[])Predef$.MODULE$.refArrayOps((Object[])this.$outer.spark().read().format("hudi").load(this.$outer.tempBasePath()).select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).take(1)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Row x$3) {
                        return x$3.getString(0);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                long incrementalKeyIdNumBootstrap = this.$outer.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), "0000").option(DataSourceReadOptions$.MODULE$.END_INSTANTTIME().key(), currentCommitsBootstrap[0]).load(this.$outer.tempBasePath()).select("keyid", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).orderBy("keyid", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count();
                Predef$.MODULE$.assert(incrementalKeyIdNumBootstrap == 1000L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDeletePartitionsV2(boolean usePartitionsToDeleteConfig) {
        scala.collection.immutable.Map<String, String> fooTableModifier = this.getCommonParams(this.tempPath(), this.hoodieFooTableName(), HoodieTableType.COPY_ON_WRITE.name());
        Schema schema = DataSourceTestUtils.getStructTypeExampleSchema();
        StructType structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema);
        java.util.List<Row> records = DataSourceTestUtils.generateRandomRows(10);
        Seq<Row> recordsSeq = this.convertRowListToSeq(records);
        SparkContext qual$12 = this.sc();
        Seq<Row> x$36 = recordsSeq;
        int x$37 = qual$12.parallelize$default$2();
        Dataset df1 = this.spark().createDataFrame(qual$12.parallelize(x$36, x$37, ClassTag$.MODULE$.apply(Row.class)), structType);
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Overwrite, fooTableModifier, df1, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8());
        Dataset snapshotDF1 = this.spark().read().format("org.apache.hudi").load(new StringBuilder().append((Object)this.tempBasePath()).append((Object)"/*/*/*/*").toString());
        Assertions.assertEquals((long)10L, (long)snapshotDF1.count());
        Dataset<Row> trimmedDf1 = this.dropMetaFields((Dataset<Row>)snapshotDF1);
        Predef$.MODULE$.assert(df1.except(trimmedDf1).count() == 0L);
        Seq<Row> updatesSeq = this.convertRowListToSeq(DataSourceTestUtils.generateUpdates(records, 5));
        SparkContext qual$13 = this.sc();
        Seq<Row> x$38 = updatesSeq;
        int x$39 = qual$13.parallelize$default$2();
        Dataset updatesDf = this.spark().createDataFrame(qual$13.parallelize(x$38, x$39, ClassTag$.MODULE$.apply(Row.class)), structType);
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, fooTableModifier, updatesDf, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8());
        Dataset snapshotDF2 = this.spark().read().format("org.apache.hudi").load(new StringBuilder().append((Object)this.tempBasePath()).append((Object)"/*/*/*/*").toString());
        Assertions.assertEquals((long)10L, (long)snapshotDF2.count());
        Dataset<Row> trimmedDf2 = this.dropMetaFields((Dataset<Row>)snapshotDF2);
        Predef$.MODULE$.assert(updatesDf.intersect(trimmedDf2).except(updatesDf).count() == 0L);
        Object object = usePartitionsToDeleteConfig ? fooTableModifier.updated((Object)DataSourceWriteOptions$.MODULE$.PARTITIONS_TO_DELETE().key(), (Object)"2016/03/15") : BoxedUnit.UNIT;
        Dataset recordsToDelete = df1.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Row entry) {
                String partitionPath = entry.getString(1);
                return partitionPath.equals("2016/03/15") || partitionPath.equals("2015/03/16");
            }
        });
        scala.collection.immutable.Map updatedParams = fooTableModifier.updated((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key(), (Object)WriteOperationType.DELETE_PARTITION.name());
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, updatedParams, recordsToDelete, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8());
        Dataset snapshotDF3 = this.spark().read().format("org.apache.hudi").load(new StringBuilder().append((Object)this.tempBasePath()).append((Object)"/*/*/*/*").toString());
        Assertions.assertEquals((long)0L, (long)snapshotDF3.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Row entry) {
                String partitionPath = entry.getString(3);
                return !partitionPath.equals("2015/03/17");
            }
        }).count());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testNonPartitionTableWithMetatableSupport(HoodieTableType tableType) {
        scala.collection.immutable.Map options = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"col3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"keyid"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()), (Object)"org.apache.hudi.keygen.NonpartitionedKeyGenerator"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.metadata.enable"), (Object)"true")}));
        Dataset df = this.spark().range(0L, 10L).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keyid"})).withColumn("col3", functions$.MODULE$.expr("keyid")).withColumn("age", functions$.MODULE$.expr("keyid + 1000"));
        df.write().format("hudi").options((Map)options.updated((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key(), (Object)"insert")).mode(SaveMode.Overwrite).save(this.tempBasePath());
        Dataset df_update = this.spark().range(0L, 10L).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keyid"})).withColumn("col3", functions$.MODULE$.expr("keyid")).withColumn("age", functions$.MODULE$.expr("keyid + 2000"));
        df_update.write().format("hudi").options((Map)options.updated((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key(), (Object)"upsert")).mode(SaveMode.Append).save(this.tempBasePath());
        Predef$.MODULE$.assert(this.spark().read().format("hudi").load(this.tempBasePath()).count() == 10L);
        Predef$.MODULE$.assert(this.spark().read().format("hudi").load(this.tempBasePath()).where("age >= 2000").count() == 10L);
    }

    @Test
    public void testToWriteWithoutParametersIncludedInHoodieTableConfig() {
        SparkSession _spark = this.spark();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator9$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor()})));
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator9$1(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset df = _spark.implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)1000), (Object)"2021-10-16")})), _spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator9$1(this)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts", "dt"}));
        scala.collection.immutable.Map options = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"ts"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"dt")}));
        Tuple2 tuple2 = new Tuple2((Object)"hoodie_test_params_1", (Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tempBasePath()}))).append((Object)"_1").toString());
        if (tuple2 != null) {
            Tuple2 tuple22;
            String tableName1 = (String)tuple2._1();
            String tablePath1 = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)tableName1, (Object)tablePath1);
            String tableName12 = (String)tuple23._1();
            String tablePath12 = (String)tuple23._2();
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | create table ", " (\n         |   id int,\n         |   name string,\n         |   price double,\n         |   ts long,\n         |   dt string\n         | ) using hudi\n         | partitioned by (dt)\n         | options (\n         |  primaryKey = 'id'\n         | )\n         | location '", "'\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName12, tablePath12})))).stripMargin());
            HoodieTableConfig tableConfig1 = HoodieTableMetaClient.builder().setConf(this.spark().sparkContext().hadoopConfiguration()).setBasePath(tablePath12).build().getTableConfig();
            String string = tableConfig1.getHiveStylePartitioningEnable();
            String string2 = "true";
            Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null));
            String string3 = tableConfig1.getUrlEncodePartitioning();
            String string4 = "false";
            Predef$.MODULE$.assert(!(string3 != null ? !string3.equals(string4) : string4 != null));
            String string5 = tableConfig1.getKeyGeneratorClassName();
            String string6 = SimpleKeyGenerator.class.getName();
            Predef$.MODULE$.assert(!(string5 != null ? !string5.equals(string6) : string6 != null));
            df.write().format("hudi").options((Map)options).option(HoodieWriteConfig.TBL_NAME.key(), tableName12).mode(SaveMode.Append).save(tablePath12);
            Predef$.MODULE$.assert(this.spark().read().format("hudi").load(new StringBuilder().append((Object)tablePath12).append((Object)"/*").toString()).count() == 1L);
            Tuple2 tuple24 = new Tuple2((Object)"hoodie_test_params_2", (Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tempBasePath()}))).append((Object)"_2").toString());
            if (tuple24 != null) {
                Tuple2 tuple25;
                String tableName2 = (String)tuple24._1();
                String tablePath2 = (String)tuple24._2();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)tableName2, (Object)tablePath2);
                String tableName22 = (String)tuple26._1();
                String tablePath22 = (String)tuple26._2();
                df.write().format("hudi").options((Map)options).option(HoodieWriteConfig.TBL_NAME.key(), tableName22).option(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING().key(), "true").option(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), SimpleKeyGenerator.class.getName()).mode(SaveMode.Overwrite).save(tablePath22);
                HoodieTableConfig tableConfig2 = HoodieTableMetaClient.builder().setConf(this.spark().sparkContext().hadoopConfiguration()).setBasePath(tablePath22).build().getTableConfig();
                String string7 = tableConfig2.getHiveStylePartitioningEnable();
                String string8 = "false";
                Predef$.MODULE$.assert(!(string7 != null ? !string7.equals(string8) : string8 != null));
                String string9 = tableConfig2.getUrlEncodePartitioning();
                String string10 = "true";
                Predef$.MODULE$.assert(!(string9 != null ? !string9.equals(string10) : string10 != null));
                String string11 = tableConfig2.getKeyGeneratorClassName();
                String string12 = SimpleKeyGenerator.class.getName();
                Predef$.MODULE$.assert(!(string11 != null ? !string11.equals(string12) : string12 != null));
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
                public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator17$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor()})));
                    }

                    public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator17$1(TestHoodieSparkSqlWriter $outer) {
                    }
                }
                Dataset df2 = _spark.implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)BoxesRunTime.boxToInteger((int)2), (Object)"a2", (Object)BoxesRunTime.boxToInteger((int)20), (Object)BoxesRunTime.boxToInteger((int)1000), (Object)"2021-10-16")})), _spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator17$1(this)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts", "dt"}));
                HoodieException configConflictException = (HoodieException)((Object)Matchers$.MODULE$.intercept((Function0)new Serializable(this, options, tableName22, tablePath22, df2){
                    public static final long serialVersionUID = 0L;
                    private final scala.collection.immutable.Map options$2;
                    private final String tableName2$1;
                    private final String tablePath2$1;
                    private final Dataset df2$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.df2$1.write().format("hudi").options((Map)this.options$2).option(HoodieWriteConfig.TBL_NAME.key(), this.tableName2$1).option(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), ComplexKeyGenerator.class.getName()).mode(SaveMode.Append).save(this.tablePath2$1);
                    }
                    {
                        this.options$2 = options$2;
                        this.tableName2$1 = tableName2$1;
                        this.tablePath2$1 = tablePath2$1;
                        this.df2$1 = df2$1;
                    }
                }, ClassTag$.MODULE$.apply(HoodieException.class), new Position("TestHoodieSparkSqlWriter.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 902)));
                Predef$.MODULE$.assert(configConflictException.getMessage().contains("Config conflict"));
                Predef$.MODULE$.assert(configConflictException.getMessage().contains(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KeyGenerator:\\t", "\\t", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ComplexKeyGenerator.class.getName(), SimpleKeyGenerator.class.getName()}))));
                df2.write().format("hudi").options((Map)options).option(HoodieWriteConfig.TBL_NAME.key(), tableName22).mode(SaveMode.Append).save(tablePath22);
                Dataset data = this.spark().read().format("hudi").load(new StringBuilder().append((Object)tablePath22).append((Object)"/*").toString());
                Predef$.MODULE$.assert(data.count() == 2L);
                Object object = Predef$.MODULE$.refArrayOps((Object[])data.select("_hoodie_partition_path", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Row x$6) {
                        return x$6.getString(0);
                    }
                }, _spark.implicits().newStringEncoder()).distinct().collect()).head();
                String string13 = "2021-10-16";
                Predef$.MODULE$.assert(!(object != null ? !object.equals(string13) : string13 != null));
                return;
            }
            throw new MatchError((Object)tuple24);
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testNonpartitonedToDefaultKeyGen() {
        SparkSession _spark = this.spark();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator28$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor()})));
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator28$1(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset df = _spark.implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)1000), (Object)"2021-10-16")})), _spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator28$1(this)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts", "dt"}));
        scala.collection.immutable.Map options = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"ts"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"dt")}));
        Tuple2 tuple2 = new Tuple2((Object)"hoodie_test_params_1", (Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tempBasePath()}))).append((Object)"_1").toString());
        if (tuple2 != null) {
            Tuple2 tuple22;
            String tableName1 = (String)tuple2._1();
            String tablePath1 = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)tableName1, (Object)tablePath1);
            String tableName12 = (String)tuple23._1();
            String tablePath12 = (String)tuple23._2();
            df.write().format("hudi").options((Map)options).option(HoodieWriteConfig.TBL_NAME.key(), tableName12).option(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), NonpartitionedKeyGenerator.class.getName()).mode(SaveMode.Overwrite).save(tablePath12);
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
            public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator36$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor()})));
                }

                public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator36$1(TestHoodieSparkSqlWriter $outer) {
                }
            }
            Dataset df2 = _spark.implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)BoxesRunTime.boxToInteger((int)2), (Object)"a2", (Object)BoxesRunTime.boxToInteger((int)20), (Object)BoxesRunTime.boxToInteger((int)1000), (Object)"2021-10-16")})), _spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator36$1(this)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts", "dt"}));
            HoodieException configConflictException = (HoodieException)((Object)Matchers$.MODULE$.intercept((Function0)new Serializable(this, options, tableName12, tablePath12, df2){
                public static final long serialVersionUID = 0L;
                private final scala.collection.immutable.Map options$3;
                private final String tableName1$1;
                private final String tablePath1$1;
                private final Dataset df2$2;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.df2$2.write().format("hudi").options((Map)this.options$3).option(HoodieWriteConfig.TBL_NAME.key(), this.tableName1$1).mode(SaveMode.Append).save(this.tablePath1$1);
                }
                {
                    this.options$3 = options$3;
                    this.tableName1$1 = tableName1$1;
                    this.tablePath1$1 = tablePath1$1;
                    this.df2$2 = df2$2;
                }
            }, ClassTag$.MODULE$.apply(HoodieException.class), new Position("TestHoodieSparkSqlWriter.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 945)));
            Predef$.MODULE$.assert(configConflictException.getMessage().contains("Config conflict"));
            Predef$.MODULE$.assert(configConflictException.getMessage().contains(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KeyGenerator:\\t", "\\t", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SimpleKeyGenerator.class.getName(), NonpartitionedKeyGenerator.class.getName()}))));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testDefaultKeyGenToNonpartitoned() {
        SparkSession _spark = this.spark();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator44$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor()})));
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator44$1(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset df = _spark.implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)1000), (Object)"2021-10-16")})), _spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator44$1(this)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts", "dt"}));
        scala.collection.immutable.Map options = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"ts"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"dt")}));
        Tuple2 tuple2 = new Tuple2((Object)"hoodie_test_params_1", (Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tempBasePath()}))).append((Object)"_1").toString());
        if (tuple2 != null) {
            Tuple2 tuple22;
            String tableName1 = (String)tuple2._1();
            String tablePath1 = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)tableName1, (Object)tablePath1);
            String tableName12 = (String)tuple23._1();
            String tablePath12 = (String)tuple23._2();
            df.write().format("hudi").options((Map)options).option(HoodieWriteConfig.TBL_NAME.key(), tableName12).mode(SaveMode.Overwrite).save(tablePath12);
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
            public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator52$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor()})));
                }

                public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator52$1(TestHoodieSparkSqlWriter $outer) {
                }
            }
            Dataset df2 = _spark.implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)BoxesRunTime.boxToInteger((int)2), (Object)"a2", (Object)BoxesRunTime.boxToInteger((int)20), (Object)BoxesRunTime.boxToInteger((int)1000), (Object)"2021-10-16")})), _spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator52$1(this)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts", "dt"}));
            HoodieException configConflictException = (HoodieException)((Object)Matchers$.MODULE$.intercept((Function0)new Serializable(this, options, tableName12, tablePath12, df2){
                public static final long serialVersionUID = 0L;
                private final scala.collection.immutable.Map options$4;
                private final String tableName1$2;
                private final String tablePath1$2;
                private final Dataset df2$3;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.df2$3.write().format("hudi").options((Map)this.options$4).option(HoodieWriteConfig.TBL_NAME.key(), this.tableName1$2).option(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), NonpartitionedKeyGenerator.class.getName()).mode(SaveMode.Append).save(this.tablePath1$2);
                }
                {
                    this.options$4 = options$4;
                    this.tableName1$2 = tableName1$2;
                    this.tablePath1$2 = tablePath1$2;
                    this.df2$3 = df2$3;
                }
            }, ClassTag$.MODULE$.apply(HoodieException.class), new Position("TestHoodieSparkSqlWriter.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 977)));
            Predef$.MODULE$.assert(configConflictException.getMessage().contains("Config conflict"));
            Predef$.MODULE$.assert(configConflictException.getMessage().contains(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KeyGenerator:\\t", "\\t", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{NonpartitionedKeyGenerator.class.getName(), SimpleKeyGenerator.class.getName()}))));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testNoKeyGenToSimpleKeyGen() {
        Tuple2 tuple22;
        SparkSession _spark = this.spark();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator60$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor()})));
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator60$1(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset df = _spark.implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)1000), (Object)"2021-10-16")})), _spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator60$1(this)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts", "dt"}));
        scala.collection.immutable.Map options = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"ts"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"dt")}));
        Tuple2 tuple2 = new Tuple2((Object)"hoodie_test_params_1", (Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tempBasePath()}))).append((Object)"_1").toString());
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String tableName1 = (String)tuple2._1();
        String tablePath1 = (String)tuple2._2();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)tableName1, (Object)tablePath1);
        String tableName12 = (String)tuple23._1();
        String tablePath12 = (String)tuple23._2();
        df.write().format("hudi").options((Map)options).option(HoodieWriteConfig.TBL_NAME.key(), tableName12).mode(SaveMode.Overwrite).save(tablePath12);
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator68$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor()})));
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator68$1(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset df2 = _spark.implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)BoxesRunTime.boxToInteger((int)2), (Object)"a2", (Object)BoxesRunTime.boxToInteger((int)20), (Object)BoxesRunTime.boxToInteger((int)1000), (Object)"2021-10-16")})), _spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator68$1(this)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts", "dt"}));
        try {
            df2.write().format("hudi").options((Map)options).option(HoodieWriteConfig.TBL_NAME.key(), tableName12).option(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), SimpleKeyGenerator.class.getName()).mode(SaveMode.Append).save(tablePath12);
            return;
        }
        catch (Throwable throwable) {
            Assertions.fail((String)"Switching from no keygen to explicit SimpleKeyGenerator should not fail");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testSimpleKeyGenToNoKeyGen() {
        Tuple2 tuple22;
        SparkSession _spark = this.spark();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator76$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor()})));
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator76$1(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset df = _spark.implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)1000), (Object)"2021-10-16")})), _spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator76$1(this)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts", "dt"}));
        scala.collection.immutable.Map options = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"ts"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"dt")}));
        Tuple2 tuple2 = new Tuple2((Object)"hoodie_test_params_1", (Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tempBasePath()}))).append((Object)"_1").toString());
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String tableName1 = (String)tuple2._1();
        String tablePath1 = (String)tuple2._2();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)tableName1, (Object)tablePath1);
        String tableName12 = (String)tuple23._1();
        String tablePath12 = (String)tuple23._2();
        df.write().format("hudi").options((Map)options).option(HoodieWriteConfig.TBL_NAME.key(), tableName12).option(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), SimpleKeyGenerator.class.getName()).mode(SaveMode.Overwrite).save(tablePath12);
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator84$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor()})));
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator84$1(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset df2 = _spark.implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)BoxesRunTime.boxToInteger((int)2), (Object)"a2", (Object)BoxesRunTime.boxToInteger((int)20), (Object)BoxesRunTime.boxToInteger((int)1000), (Object)"2021-10-16")})), _spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator84$1(this)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts", "dt"}));
        try {
            df2.write().format("hudi").options((Map)options).option(HoodieWriteConfig.TBL_NAME.key(), tableName12).mode(SaveMode.Append).save(tablePath12);
            return;
        }
        catch (Throwable throwable) {
            Assertions.fail((String)"Switching from  explicit SimpleKeyGenerator to default keygen should not fail");
        }
    }

    @Test
    public void testGetOriginKeyGenerator() {
        String kg2;
        String kg1;
        scala.collection.immutable.Map m1 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key()), (Object)ComplexKeyGenerator.class.getName())}));
        String string = kg1 = HoodieWriterUtils$.MODULE$.getOriginKeyGenerator(m1);
        String string2 = ComplexKeyGenerator.class.getName();
        Assertions.assertTrue((!(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0);
        scala.collection.immutable.Map m2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key()), (Object)SqlKeyGenerator.class.getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SqlKeyGenerator$.MODULE$.ORIGINAL_KEYGEN_CLASS_NAME()), (Object)SimpleKeyGenerator.class.getName())}));
        String string3 = kg2 = HoodieWriterUtils$.MODULE$.getOriginKeyGenerator(m2);
        String string4 = SimpleKeyGenerator.class.getName();
        Assertions.assertTrue((!(string3 != null ? !string3.equals(string4) : string4 != null) ? 1 : 0) != 0);
    }

    public class StringLongTest
    implements Product,
    Serializable {
        private final String uuid;
        private final long ts;
        public final /* synthetic */ TestHoodieSparkSqlWriter $outer;

        public String uuid() {
            return this.uuid;
        }

        public long ts() {
            return this.ts;
        }

        public StringLongTest copy(String uuid, long ts) {
            return new StringLongTest(this.org$apache$hudi$TestHoodieSparkSqlWriter$StringLongTest$$$outer(), uuid, ts);
        }

        public String copy$default$1() {
            return this.uuid();
        }

        public long copy$default$2() {
            return this.ts();
        }

        public String productPrefix() {
            return "StringLongTest";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.ts());
                    break;
                }
                case 0: {
                    object = this.uuid();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof StringLongTest;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.uuid()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.ts()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof StringLongTest)) return false;
            if (((StringLongTest)object).org$apache$hudi$TestHoodieSparkSqlWriter$StringLongTest$$$outer() != this.org$apache$hudi$TestHoodieSparkSqlWriter$StringLongTest$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            StringLongTest stringLongTest = (StringLongTest)x$1;
            String string = this.uuid();
            String string2 = stringLongTest.uuid();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.ts() != stringLongTest.ts()) return false;
            if (!stringLongTest.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ TestHoodieSparkSqlWriter org$apache$hudi$TestHoodieSparkSqlWriter$StringLongTest$$$outer() {
            return this.$outer;
        }

        public StringLongTest(TestHoodieSparkSqlWriter $outer, String uuid, long ts) {
            this.uuid = uuid;
            this.ts = ts;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }
    }
}

