/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.SparkVersionsSupport;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.testutils.DataSourceTestUtils;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000194A!\u0001\u0002\u0001\u0013\t!B+Z:u\u0011>|G-[3Ta\u0006\u00148.\u0016;jYNT!a\u0001\u0003\u0002\t!,H-\u001b\u0006\u0003\u000b\u0019\ta!\u00199bG\",'\"A\u0004\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001Q\u0001CA\u0006\u000f\u001b\u0005a!\"A\u0007\u0002\u000bM\u001c\u0017\r\\1\n\u0005=a!AB!osJ+g\rC\u0003\u0012\u0001\u0011\u0005!#\u0001\u0004=S:LGO\u0010\u000b\u0002'A\u0011A\u0003A\u0007\u0002\u0005!)a\u0003\u0001C\u0001/\u0005AB/Z:u'B\f'o\u001b,feNLwN\\\"iK\u000e\\WM]:\u0015\u0005aY\u0002CA\u0006\u001a\u0013\tQBB\u0001\u0003V]&$\b\"\u0002\u000f\u0016\u0001\u0004i\u0012\u0001D:qCJ\\g+\u001a:tS>t\u0007C\u0001\u0010\"\u001d\tYq$\u0003\u0002!\u0019\u00051\u0001K]3eK\u001aL!AI\u0012\u0003\rM#(/\u001b8h\u0015\t\u0001C\u0002\u000b\u0003\u0016KE\u0012\u0004C\u0001\u00140\u001b\u00059#B\u0001\u0015*\u0003!\u0001(o\u001c<jI\u0016\u0014(B\u0001\u0016,\u0003\u0019\u0001\u0018M]1ng*\u0011A&L\u0001\bUV\u0004\u0018\u000e^3s\u0015\tqc!A\u0003kk:LG/\u0003\u00021O\tYa+\u00197vKN{WO]2f\u0003\u001d\u0019HO]5oONdCaM\u001b8s\u0005\nA'A\u00033]QrC'I\u00017\u0003\u0015\u0019d&\r\u00181C\u0005A\u0014!B\u001a/e9\u0002\u0014%\u0001\u001e\u0002\u000bMr3G\f\u0019)\u0005Ua\u0004CA\u001f?\u001b\u0005I\u0013BA *\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f\u001e\u0005\u0006\u0003\u0002!\tAQ\u0001\u0018i\u0016\u001cHo\u0011:fCR,'\u000b\u001a3TG\",W.Y#w_2$\u0012\u0001\u0007\u0015\u0003\u0001\u0012\u0003\"!\u0012%\u000e\u0003\u0019S!aR\u0016\u0002\u0007\u0005\u0004\u0018.\u0003\u0002J\r\n!A+Z:u\u0011\u0015Y\u0005\u0001\"\u0001C\u0003y!Xm\u001d;De\u0016\fG/\u001a*eI^KG\u000f\u001b(fgR,GmU2iK6\f7\u000f\u000b\u0002K\t\")a\n\u0001C\u0001\u001f\u0006\u00192m\u001c8wKJ$(k\\<MSN$Hk\\*fcR\u0011\u0001\u000b\u001a\t\u0004#fcfB\u0001*X\u001d\t\u0019f+D\u0001U\u0015\t)\u0006\"\u0001\u0004=e>|GOP\u0005\u0002\u001b%\u0011\u0001\fD\u0001\ba\u0006\u001c7.Y4f\u0013\tQ6LA\u0002TKFT!\u0001\u0017\u0007\u0011\u0005u\u0013W\"\u00010\u000b\u0005}\u0003\u0017aA:rY*\u0011\u0011\rB\u0001\u0006gB\f'o[\u0005\u0003Gz\u00131AU8x\u0011\u0015)W\n1\u0001g\u0003%Ig\u000e];u\u0019&\u001cH\u000fE\u0002hYrk\u0011\u0001\u001b\u0006\u0003S*\fA!\u001e;jY*\t1.\u0001\u0003kCZ\f\u0017BA7i\u0005\u0011a\u0015n\u001d;")
public class TestHoodieSparkUtils {
    @ParameterizedTest
    @ValueSource(strings={"2.4.4", "3.1.0", "3.2.0", "3.3.0"})
    public void testSparkVersionCheckers(String sparkVersion) {
        String string;
        block6: {
            block3: {
                SparkVersionsSupport vsMock;
                block5: {
                    block4: {
                        block2: {
                            vsMock = new SparkVersionsSupport(this, sparkVersion){
                                private final String sparkVersion$1;

                                public boolean isSpark2() {
                                    return SparkVersionsSupport.class.isSpark2((SparkVersionsSupport)this);
                                }

                                public boolean isSpark3() {
                                    return SparkVersionsSupport.class.isSpark3((SparkVersionsSupport)this);
                                }

                                public boolean isSpark3_0() {
                                    return SparkVersionsSupport.class.isSpark3_0((SparkVersionsSupport)this);
                                }

                                public boolean isSpark3_1() {
                                    return SparkVersionsSupport.class.isSpark3_1((SparkVersionsSupport)this);
                                }

                                public boolean isSpark3_2() {
                                    return SparkVersionsSupport.class.isSpark3_2((SparkVersionsSupport)this);
                                }

                                public boolean isSpark3_3() {
                                    return SparkVersionsSupport.class.isSpark3_3((SparkVersionsSupport)this);
                                }

                                public boolean gteqSpark3_0() {
                                    return SparkVersionsSupport.class.gteqSpark3_0((SparkVersionsSupport)this);
                                }

                                public boolean gteqSpark3_1() {
                                    return SparkVersionsSupport.class.gteqSpark3_1((SparkVersionsSupport)this);
                                }

                                public boolean gteqSpark3_1_3() {
                                    return SparkVersionsSupport.class.gteqSpark3_1_3((SparkVersionsSupport)this);
                                }

                                public boolean gteqSpark3_2() {
                                    return SparkVersionsSupport.class.gteqSpark3_2((SparkVersionsSupport)this);
                                }

                                public boolean gteqSpark3_2_1() {
                                    return SparkVersionsSupport.class.gteqSpark3_2_1((SparkVersionsSupport)this);
                                }

                                public boolean gteqSpark3_2_2() {
                                    return SparkVersionsSupport.class.gteqSpark3_2_2((SparkVersionsSupport)this);
                                }

                                public boolean gteqSpark3_3() {
                                    return SparkVersionsSupport.class.gteqSpark3_3((SparkVersionsSupport)this);
                                }

                                public String getSparkVersion() {
                                    return this.sparkVersion$1;
                                }
                                {
                                    this.sparkVersion$1 = sparkVersion$1;
                                    SparkVersionsSupport.class.$init$((SparkVersionsSupport)this);
                                }
                            };
                            string = sparkVersion;
                            if (!"2.4.4".equals(string)) break block2;
                            Assertions.assertTrue((boolean)vsMock.isSpark2());
                            Assertions.assertFalse((boolean)vsMock.isSpark3());
                            Assertions.assertFalse((boolean)vsMock.isSpark3_1());
                            Assertions.assertFalse((boolean)vsMock.isSpark3_0());
                            Assertions.assertFalse((boolean)vsMock.isSpark3_2());
                            Assertions.assertFalse((boolean)vsMock.gteqSpark3_1());
                            Assertions.assertFalse((boolean)vsMock.gteqSpark3_1_3());
                            Assertions.assertFalse((boolean)vsMock.gteqSpark3_2());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!"3.1.0".equals(string)) break block4;
                        Assertions.assertTrue((boolean)vsMock.isSpark3());
                        Assertions.assertTrue((boolean)vsMock.isSpark3_1());
                        Assertions.assertTrue((boolean)vsMock.gteqSpark3_1());
                        Assertions.assertFalse((boolean)vsMock.isSpark2());
                        Assertions.assertFalse((boolean)vsMock.isSpark3_0());
                        Assertions.assertFalse((boolean)vsMock.isSpark3_2());
                        Assertions.assertFalse((boolean)vsMock.gteqSpark3_1_3());
                        Assertions.assertFalse((boolean)vsMock.gteqSpark3_2());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (!"3.2.0".equals(string)) break block5;
                    Assertions.assertTrue((boolean)vsMock.isSpark3());
                    Assertions.assertTrue((boolean)vsMock.isSpark3_2());
                    Assertions.assertTrue((boolean)vsMock.gteqSpark3_1());
                    Assertions.assertTrue((boolean)vsMock.gteqSpark3_1_3());
                    Assertions.assertTrue((boolean)vsMock.gteqSpark3_2());
                    Assertions.assertFalse((boolean)vsMock.isSpark2());
                    Assertions.assertFalse((boolean)vsMock.isSpark3_0());
                    Assertions.assertFalse((boolean)vsMock.isSpark3_1());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!"3.3.0".equals(string)) break block6;
                Assertions.assertTrue((boolean)vsMock.isSpark3());
                Assertions.assertTrue((boolean)vsMock.gteqSpark3_1());
                Assertions.assertTrue((boolean)vsMock.gteqSpark3_1_3());
                Assertions.assertTrue((boolean)vsMock.gteqSpark3_2());
                Assertions.assertFalse((boolean)vsMock.isSpark3_2());
                Assertions.assertFalse((boolean)vsMock.isSpark2());
                Assertions.assertFalse((boolean)vsMock.isSpark3_0());
                Assertions.assertFalse((boolean)vsMock.isSpark3_1());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)string);
    }

    @Test
    public void testCreateRddSchemaEvol() {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("Hoodie Datasource test").master("local[2]").config("spark.serializer", "org.apache.spark.serializer.KryoSerializer").getOrCreate();
        Schema schema = DataSourceTestUtils.getStructTypeExampleSchema();
        StructType structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema);
        List<Row> records = DataSourceTestUtils.generateRandomRows(5);
        Seq<Row> recordsSeq = this.convertRowListToSeq(records);
        Dataset df1 = spark.createDataFrame(spark.sparkContext().parallelize(recordsSeq, spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Row.class)), structType);
        RDD genRecRDD = HoodieSparkUtils$.MODULE$.createRdd(df1, "test_struct_name", "test_namespace", true, Option.of((Object)schema));
        genRecRDD.collect();
        Schema evolSchema = DataSourceTestUtils.getStructTypeExampleEvolvedSchema();
        records = DataSourceTestUtils.generateRandomRowsEvolvedSchema(5);
        recordsSeq = this.convertRowListToSeq(records);
        genRecRDD = HoodieSparkUtils$.MODULE$.createRdd(df1, "test_struct_name", "test_namespace", true, Option.of((Object)evolSchema));
        genRecRDD.collect();
        genRecRDD = HoodieSparkUtils$.MODULE$.createRdd(df1, "test_struct_name", "test_namespace", true, Option.of((Object)evolSchema));
        GenericRecord[] genRecs = (GenericRecord[])genRecRDD.collect();
        Assertions.assertEquals((int)Predef$.MODULE$.refArrayOps((Object[])genRecs).size(), (int)5);
        spark.stop();
    }

    @Test
    public void testCreateRddWithNestedSchemas() {
        Object object;
        SparkSession spark = SparkSession$.MODULE$.builder().appName("Hoodie Datasource test").master("local[2]").config("spark.serializer", "org.apache.spark.serializer.KryoSerializer").getOrCreate();
        StructType innerStruct1 = new StructType().add("innerKey", "string", false).add("innerValue", "long", true);
        StructType structType1 = new StructType().add("key", "string", false).add("nonNullableInnerStruct", (DataType)innerStruct1, false).add("nullableInnerStruct", (DataType)innerStruct1, true);
        Schema schema1 = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)structType1, "test_struct_name", "test_namespace");
        Seq records1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"key1", Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"innerKey1_1", BoxesRunTime.boxToLong((long)1L)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"innerKey1_2", BoxesRunTime.boxToLong((long)2L)}))}))}));
        Dataset df1 = spark.createDataFrame(spark.sparkContext().parallelize(records1, spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Row.class)), structType1);
        RDD genRecRDD1 = HoodieSparkUtils$.MODULE$.createRdd(df1, "test_struct_name", "test_namespace", true, Option.of((Object)schema1));
        Predef$.MODULE$.assert(schema1.equals((Object)((GenericRecord[])genRecRDD1.collect())[0].getSchema()));
        StructType structType2 = new StructType().add("key", "string", false).add("nonNullableInnerStruct", (DataType)innerStruct1, false).add("nullableInnerStruct", (DataType)innerStruct1, true).add("nullableInnerStruct2", (DataType)innerStruct1, true);
        Schema schema2 = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)structType2, "test_struct_name", "test_namespace");
        Seq records2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"key2", Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"innerKey2_1", BoxesRunTime.boxToLong((long)2L)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"innerKey2_2", BoxesRunTime.boxToLong((long)2L)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"innerKey2_3", BoxesRunTime.boxToLong((long)2L)}))}))}));
        Dataset df2 = spark.createDataFrame(spark.sparkContext().parallelize(records2, spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Row.class)), structType2);
        RDD genRecRDD2 = HoodieSparkUtils$.MODULE$.createRdd(df2, "test_struct_name", "test_namespace", true, Option.of((Object)schema2));
        Predef$.MODULE$.assert(schema2.equals((Object)((GenericRecord[])genRecRDD2.collect())[0].getSchema()));
        RDD genRecRDD3 = HoodieSparkUtils$.MODULE$.createRdd(df1, "test_struct_name", "test_namespace", true, Option.of((Object)schema2));
        Predef$.MODULE$.assert(((GenericRecord[])genRecRDD3.collect())[0].getSchema().equals((Object)schema2));
        genRecRDD3.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(GenericRecord entry) {
                Assertions.assertNull((Object)entry.get("nullableInnerStruct2"));
            }
        });
        StructType innerStruct3 = new StructType().add("innerKey", "string", false).add("innerValue", "long", true).add("new_nested_col", "string", true);
        StructType structType4 = new StructType().add("key", "string", false).add("nonNullableInnerStruct", (DataType)innerStruct1, false).add("nullableInnerStruct", (DataType)innerStruct3, true);
        Schema schema4 = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)structType4, "test_struct_name", "test_namespace");
        Seq records4 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"key2", Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"innerKey2_1", BoxesRunTime.boxToLong((long)2L)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"innerKey2_2", BoxesRunTime.boxToLong((long)2L), "new_nested_col_val1"}))}))}));
        Dataset df4 = spark.createDataFrame(spark.sparkContext().parallelize(records4, spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Row.class)), structType4);
        RDD genRecRDD4 = HoodieSparkUtils$.MODULE$.createRdd(df4, "test_struct_name", "test_namespace", true, Option.of((Object)schema4));
        Predef$.MODULE$.assert(schema4.equals((Object)((GenericRecord[])genRecRDD4.collect())[0].getSchema()));
        RDD genRecRDD5 = HoodieSparkUtils$.MODULE$.createRdd(df1, "test_struct_name", "test_namespace", true, Option.of((Object)schema4));
        Predef$.MODULE$.assert(schema4.equals((Object)((GenericRecord[])genRecRDD4.collect())[0].getSchema()));
        GenericRecord genRec = ((GenericRecord[])genRecRDD5.collect())[0];
        GenericRecord nestedRec = (GenericRecord)genRec.get("nullableInnerStruct");
        Assertions.assertNull((Object)nestedRec.get("new_nested_col"));
        Assertions.assertNotNull((Object)nestedRec.get("innerKey"));
        Assertions.assertNotNull((Object)nestedRec.get("innerValue"));
        StructType innerStruct4 = new StructType().add("innerKey", "string", false).add("innerValue", "long", true).add("new_nested_col", "string", false);
        StructType structType6 = new StructType().add("key", "string", false).add("nonNullableInnerStruct", (DataType)innerStruct1, false).add("nullableInnerStruct", (DataType)innerStruct4, true);
        Schema schema6 = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)structType6, "test_struct_name", "test_namespace");
        try {
            RDD genRecRDD6 = HoodieSparkUtils$.MODULE$.createRdd(df1, "test_struct_name", "test_namespace", true, Option.of((Object)schema6));
            genRecRDD6.collect();
            object = Assertions.fail((String)"createRdd should fail, because records don't have a column which is not nullable in the passed in schema");
        }
        catch (Exception exception) {
            if (HoodieSparkUtils$.MODULE$.gteqSpark3_3()) {
                Assertions.assertTrue((boolean)exception.getMessage().contains("null value for (non-nullable) string at test_struct_name.nullableInnerStruct[nullableInnerStruct].new_nested_col"));
            } else {
                Assertions.assertTrue((boolean)exception.getMessage().contains("null of string in field new_nested_col of test_namespace.test_struct_name.nullableInnerStruct of union"));
            }
            object = BoxedUnit.UNIT;
        }
        spark.stop();
    }

    public Seq<Row> convertRowListToSeq(List<Row> inputList) {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(inputList.iterator()).asScala()).toSeq();
    }
}

