/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.function.Consumer;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieConversionUtils$;
import org.apache.hudi.HoodieDataSourceHelpers;
import org.apache.hudi.QuickstartUtils;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieUpsertException;
import org.apache.hudi.functional.TestCOWDataSource$;
import org.apache.hudi.keygen.ComplexKeyGenerator;
import org.apache.hudi.keygen.CustomKeyGenerator;
import org.apache.hudi.keygen.GlobalDeleteKeyGenerator;
import org.apache.hudi.keygen.NonpartitionedKeyGenerator;
import org.apache.hudi.keygen.SimpleKeyGenerator;
import org.apache.hudi.keygen.TimestampBasedKeyGenerator;
import org.apache.hudi.metrics.Metrics;
import org.apache.hudi.testutils.HoodieClientTestBase;
import org.apache.hudi.testutils.HoodieClientTestHarness;
import org.apache.hudi.util.JFunction$;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSessionExtensions;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.hudi.HoodieSparkSessionExtension;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\teb\u0001B\u0001\u0003\u0001-\u0011\u0011\u0003V3ti\u000e{u\u000bR1uCN{WO]2f\u0015\t\u0019A!\u0001\u0006gk:\u001cG/[8oC2T!!\u0002\u0004\u0002\t!,H-\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u0011\u001b\u0005q!BA\b\u0005\u0003%!Xm\u001d;vi&d7/\u0003\u0002\u0012\u001d\t!\u0002j\\8eS\u0016\u001cE.[3oiR+7\u000f\u001e\"bg\u0016DQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"\u0001\u0002\t\u000fa\u0001\u0001\u0019!C\u00013\u0005)1\u000f]1sWV\t!\u0004\u0005\u0002\u001c?5\tAD\u0003\u0002\u001e=\u0005\u00191/\u001d7\u000b\u0005a1\u0011B\u0001\u0011\u001d\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0011\u001d\u0011\u0003\u00011A\u0005\u0002\r\n\u0011b\u001d9be.|F%Z9\u0015\u0005\u0011R\u0003CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#\u0001B+oSRDqaK\u0011\u0002\u0002\u0003\u0007!$A\u0002yIEBa!\f\u0001!B\u0013Q\u0012AB:qCJ\\\u0007\u0005C\u00040\u0001\t\u0007I\u0011\u0001\u0019\u0002\u0015\r|W.\\8o\u001fB$8/F\u00012!\u0011\u0011t'O\u001d\u000e\u0003MR!\u0001N\u001b\u0002\u0013%lW.\u001e;bE2,'B\u0001\u001c'\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003qM\u00121!T1q!\tQt(D\u0001<\u0015\taT(\u0001\u0003mC:<'\"\u0001 \u0002\t)\fg/Y\u0005\u0003\u0001n\u0012aa\u0015;sS:<\u0007B\u0002\"\u0001A\u0003%\u0011'A\u0006d_6lwN\\(qiN\u0004\u0003b\u0002#\u0001\u0005\u0004%\t!R\u0001\u0010m\u0016\u0014\u0018NZ5dCRLwN\\\"pYV\ta\t\u0005\u0002H\u0015:\u0011Q\u0005S\u0005\u0003\u0013\u001a\na\u0001\u0015:fI\u00164\u0017B\u0001!L\u0015\tIe\u0005\u0003\u0004N\u0001\u0001\u0006IAR\u0001\u0011m\u0016\u0014\u0018NZ5dCRLwN\\\"pY\u0002Bqa\u0014\u0001C\u0002\u0013\u0005Q)\u0001\fva\u0012\fG/\u001a3WKJLg-[2bi&|gNV1m\u0011\u0019\t\u0006\u0001)A\u0005\r\u00069R\u000f\u001d3bi\u0016$g+\u001a:jM&\u001c\u0017\r^5p]Z\u000bG\u000e\t\u0005\u0006'\u0002!\t\u0005V\u0001\"O\u0016$8\u000b]1sWN+7o]5p]\u0016CH/\u001a8tS>t7/\u00138kK\u000e$xN\u001d\u000b\u0002+B\u0019akW/\u000e\u0003]S!\u0001W-\u0002\tU$\u0018\u000e\u001c\u0006\u00035\u0012\taaY8n[>t\u0017B\u0001/X\u0005\u0019y\u0005\u000f^5p]B\u0019aL\u00193\u000e\u0003}S!\u0001Y1\u0002\u0011\u0019,hn\u0019;j_:T!\u0001W\u001f\n\u0005\r|&\u0001C\"p]N,X.\u001a:\u0011\u0005m)\u0017B\u00014\u001d\u0005Y\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u000bb$XM\\:j_:\u001c\b\"\u00025\u0001\t\u0003J\u0017!B:fiV\u0003H#\u0001\u0013)\u0005\u001d\\\u0007C\u00017t\u001b\u0005i'B\u00018p\u0003\r\t\u0007/\u001b\u0006\u0003aF\fqA[;qSR,'O\u0003\u0002s\u0011\u0005)!.\u001e8ji&\u0011A/\u001c\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0007\"\u0002<\u0001\t\u0003J\u0017\u0001\u0003;fCJ$un\u001e8)\u0005UD\bC\u00017z\u0013\tQXNA\u0005BMR,'/R1dQ\")A\u0010\u0001C\u0001S\u0006!B/Z:u'\"|'\u000f\u001e(b[\u0016\u001cFo\u001c:bO\u0016D#a\u001f@\u0011\u00051|\u0018bAA\u0001[\n!A+Z:u\u0011\u0019\t)\u0001\u0001C\u0001S\u0006\u0001B/Z:u\u001d>\u0004&/Z2p[\nLg.\u001a\u0015\u0004\u0003\u0007q\bBBA\u0006\u0001\u0011\u0005\u0011.\u0001\u0012uKN$\bj\\8eS\u0016L5\u000fR3mKR,GMT8o\u0005>|G.Z1o\r&,G\u000e\u001a\u0015\u0004\u0003\u0013q\bBBA\t\u0001\u0011\u0005\u0011.A\u0018uKN$\bK];oKB\u000b'\u000f^5uS>tgi\u001c:US6,7\u000f^1na\n\u000b7/\u001a3LKf<UM\\3sCR|'\u000fK\u0002\u0002\u0010yDa!a\u0006\u0001\t\u0003I\u0017A\u0007;fgR\f%o\u00195jm\u0006dw+\u001b;i\u0005Vd7.\u00138tKJ$\bfAA\u000b}\"1\u0011Q\u0004\u0001\u0005\u0002%\fa\u0003^3ti\u000e{\u0007/_(o/JLG/\u001a#fY\u0016$Xm\u001d\u0015\u0004\u00037q\bBBA\u0012\u0001\u0011\u0005\u0011.A\u0011uKN$xJ^3s/JLG/Z'pI\u0016,6/\u001a*fa2\f7-Z!di&|g\u000eK\u0002\u0002\"yDa!!\u000b\u0001\t\u0003I\u0017a\b;fgR\u0014V-\u00193QCRD7o\u00148D_BLxJ\\,sSR,G+\u00192mK\"\u001a\u0011q\u0005@\t\r\u0005=\u0002\u0001\"\u0001j\u0003\u0019\"Xm\u001d;Pm\u0016\u0014xK]5uKR\u000b'\r\\3N_\u0012,Wk]3SKBd\u0017mY3BGRLwN\u001c\u0015\u0004\u0003[q\bBBA\u001b\u0001\u0011\u0005\u0011.A\u001buKN$xJ^3s/JLG/Z'pI\u0016,6/\u001a*fa2\f7-Z!di&|gn\u00148ESNTu.\u001b8u!\u0006\u0014H/\u001b;j_:\u001c\bfAA\u001a}\"1\u00111\b\u0001\u0005\u0002%\f!\b^3ti>3XM],sSR,G+\u00192mK6{G-Z+tKJ+\u0007\u000f\\1dK\u0006\u001bG/[8o\u001f:$\u0015n\u001d&pS:$\b+\u0019:uSRLwN\\:)\u0007\u0005eb\u0010\u0003\u0004\u0002B\u0001!\t![\u0001\u0012i\u0016\u001cH\u000f\u0012:pa&s7/\u001a:u\tV\u0004\bfAA }\"1\u0011q\t\u0001\u0005\u0002%\f!\u0006^3ti\u000e{W\u000e\u001d7fq\u0012\u000bG/\u0019+za\u0016<&/\u001b;f\u0003:$'+Z1e\u0007>t7/[:uK:\u001c\u0017\u0010K\u0002\u0002FyDa!!\u0014\u0001\t\u0003I\u0017\u0001\u0006;fgR<\u0016\u000e\u001e5BkR|7i\\7nSR|e\u000eK\u0002\u0002LyDq!a\u0015\u0001\t\u0013\t)&\u0001\nhKR$\u0015\r^1Ge\u0006lWm\u0016:ji\u0016\u0014H\u0003BA,\u0003G\u0002RaGA-\u0003;J1!a\u0017\u001d\u0005=!\u0015\r^1Ge\u0006lWm\u0016:ji\u0016\u0014\bcA\u000e\u0002`%\u0019\u0011\u0011\r\u000f\u0003\u0007I{w\u000fC\u0004\u0002f\u0005E\u0003\u0019\u0001$\u0002\u0019-,\u0017pR3oKJ\fGo\u001c:\t\r\u0005%\u0004\u0001\"\u0001j\u0003)\"Xm\u001d;Ta\u0006\u00148\u000eU1si&$\u0018n\u001c8Cs^KG\u000f[\"vgR|WnS3z\u000f\u0016tWM]1u_JD3!a\u001a\u007f\u0011\u0019\ty\u0007\u0001C\u0001S\u0006QC/Z:u'B\f'o\u001b)beRLG/[8o\u0005f<\u0016\u000e\u001e5TS6\u0004H.Z&fs\u001e+g.\u001a:bi>\u0014\bfAA7}\"1\u0011Q\u000f\u0001\u0005\u0002%\f1\u0006^3tiN\u0003\u0018M]6QCJ$\u0018\u000e^5p]\nKx+\u001b;i\u0007>l\u0007\u000f\\3y\u0017\u0016Lx)\u001a8fe\u0006$xN\u001d\u0015\u0004\u0003gr\bBBA>\u0001\u0011\u0005\u0011.\u0001\u001auKN$8\u000b]1sWB\u000b'\u000f^5uS>t')_,ji\"$\u0016.\\3ti\u0006l\u0007OQ1tK\u0012\\U-_$f]\u0016\u0014\u0018\r^8sQ\r\tIH \u0005\u0007\u0003\u0003\u0003A\u0011A5\u0002aQ,7\u000f^*qCJ\\\u0007+\u0019:uSRLwN\u001c\"z/&$\bn\u00127pE\u0006dG)\u001a7fi\u0016\\U-_$f]\u0016\u0014\u0018\r^8sQ\r\tyH \u0005\u0007\u0003\u000f\u0003A\u0011A5\u0002eQ,7\u000f^*qCJ\\\u0007+\u0019:uSRLwN\u001c\"z/&$\bNT8oa\u0006\u0014H/\u001b;j_:,GmS3z\u000f\u0016tWM]1u_JD3!!\"\u007f\u0011\u001d\ti\t\u0001C\u0001\u0003\u001f\u000bA\u0005^3tiF+XM]=D\u001f^;\u0016\u000e\u001e5CCN,\u0007+\u0019;i\u0003:$g)\u001b7f\u0013:$W\r\u001f\u000b\u0006I\u0005E\u00151\u0014\u0005\t\u0003'\u000bY\t1\u0001\u0002\u0016\u0006y\u0001/\u0019:uSRLwN\\#oG>$W\rE\u0002&\u0003/K1!!''\u0005\u001d\u0011un\u001c7fC:D\u0001\"!(\u0002\f\u0002\u0007\u0011QS\u0001\u0012SNlU\r^1eCR\fWI\\1cY\u0016$\u0007\u0006CAF\u0003C\u000b\t,a-\u0011\t\u0005\r\u0016QV\u0007\u0003\u0003KSA!a*\u0002*\u0006A\u0001O]8wS\u0012,'OC\u0002\u0002,>\fa\u0001]1sC6\u001c\u0018\u0002BAX\u0003K\u0013\u0011bQ:w'>,(oY3\u0002\u000bY\fG.^3-\u0011\u0005U\u0016\u0011XA_\u0003\u0003\f#!a.\u0002\u0015Q\u0014X/\u001a\u0017gC2\u001cX-\t\u0002\u0002<\u0006IAO];fYQ\u0014X/Z\u0011\u0003\u0003\u007f\u000b!BZ1mg\u0016dCO];fC\t\t\u0019-A\u0006gC2\u001cX\r\f4bYN,\u0007\u0006BAF\u0003\u000f\u0004B!!3\u0002L6\u0011\u0011\u0011V\u0005\u0005\u0003\u001b\fIKA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgRDa!!5\u0001\t\u0003I\u0017a\u0005;fgR\u001c6\r[3nC\u00163x\u000e\\;uS>t\u0007fAAh}\"1\u0011q\u001b\u0001\u0005\u0002%\fa\u0003^3tiN\u001b\u0007.Z7b\u001d>$X)];bY\u0012\u000bG/\u0019\u0015\u0004\u0003+t\bbBAo\u0001\u0011\u0005\u0011q\\\u0001+i\u0016\u001cHoQ8qs>swK]5uK^KG\u000f\u001b#s_B\u0004X\r\u001a)beRLG/[8o\u0007>dW/\u001c8t)\r!\u0013\u0011\u001d\u0005\t\u0003G\fY\u000e1\u0001\u0002\u0016\u0006QRM\\1cY\u0016$%o\u001c9QCJ$\u0018\u000e^5p]\u000e{G.^7og\"B\u00111\\At\u0003[\fy\u000f\u0005\u0003\u0002$\u0006%\u0018\u0002BAv\u0003K\u00131BV1mk\u0016\u001cv.\u001e:dK\u0006A!m\\8mK\u0006t7\u000f\f\u0003\u0002r\u0006M\u0018$A\u0001\u001a\u0003\u0001AC!a7\u0002H\"1\u0011\u0011 \u0001\u0005\u0002%\fa\u0003^3ti\"{w\u000eZ5f\u0013N$U\r\\3uK\u0012\u001cuj\u0016\u0015\u0004\u0003ot\bBBA\u0000\u0001\u0011\u0005\u0011.A\u0012uKN$xK]5uKNk\u0017\r\u001c7Qe\u0016\u001c\u0017n]5p]\u0012+7-[7bYR\u000b'\r\\3)\u0007\u0005uh\u0010C\u0004\u0003\u0006\u0001!\tAa\u0002\u0002EQ,7\u000f\u001e)beRLG/[8o\u0007>dW/\u001c8t!J|\u0007/\u001a:IC:$G.\u001b8h)\r!#\u0011\u0002\u0005\t\u0005\u0017\u0011\u0019\u00011\u0001\u0002\u0016\u0006YQo]3HY>\u0014'-\u001b8hQ!\u0011\u0019!a:\u0002n\n=A\u0006BAy\u0003gDCAa\u0001\u0002H\"1!Q\u0003\u0001\u0005\u0002%\fq\u0004^3tiN\u000bg/Z!t)\u0006\u0014G.Z%o\t&4g-\u001a:f]Rlu\u000eZ3tQ\r\u0011\u0019B \u0005\u0007\u00057\u0001A\u0011A5\u0002AQ,7\u000f^'fiJL7m\u001d*fa>\u0014H/\u001a:WS\u0006$\u0015\r^1T_V\u00148-\u001a\u0015\u0004\u00053q\b\u0002\u0004B\u0011\u0001A\u0005\t\u0011!A\u0005\u0002\t\r\u0012A\u00059s_R,7\r^3eI\t\f7/\u001a)bi\"$2!\u000fB\u0013\u0011!Y#qDA\u0001\u0002\u0004)\u0002\u0002\u0004B\u0015\u0001A\u0005\t\u0011!A\u0005\u0002\t-\u0012!\u00059s_R,7\r^3eI\u0011\fG/Y$f]R!!Q\u0006B\u001c!\u0011\u0011yCa\r\u000e\u0005\tE\"BA\bZ\u0013\u0011\u0011)D!\r\u0003/!{w\u000eZ5f)\u0016\u001cH\u000fR1uC\u001e+g.\u001a:bi>\u0014\b\u0002C\u0016\u0003(\u0005\u0005\t\u0019A\u000b")
public class TestCOWDataSource
extends HoodieClientTestBase {
    private SparkSession spark = null;
    private final scala.collection.immutable.Map<String, String> commonOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.bulkinsert.shuffle.parallelism"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.delete.shuffle.parallelism"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieTableConfig.PARTITION_METAFILE_USE_BASE_FORMAT.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.COMPACT_NUM_DELTA_COMMITS.key()), (Object)"1")}));
    private final String verificationCol;
    private final String updatedVerificationVal;

    public /* synthetic */ String protected$basePath(TestCOWDataSource x$1) {
        return x$1.basePath;
    }

    public /* synthetic */ HoodieTestDataGenerator protected$dataGen(TestCOWDataSource x$1) {
        return x$1.dataGen;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    public scala.collection.immutable.Map<String, String> commonOpts() {
        return this.commonOpts;
    }

    public String verificationCol() {
        return this.verificationCol;
    }

    public String updatedVerificationVal() {
        return this.updatedVerificationVal;
    }

    public Option<Consumer<SparkSessionExtensions>> getSparkSessionExtensionsInjector() {
        return HoodieConversionUtils$.MODULE$.toJavaOption((scala.Option)new Some((Object)JFunction$.MODULE$.toJava((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(SparkSessionExtensions receiver) {
                new HoodieSparkSessionExtension().apply(receiver);
            }
        })));
    }

    @BeforeEach
    public void setUp() {
        this.initPath();
        this.initSparkContexts();
        this.spark_$eq(this.sqlContext.sparkSession());
        this.initTestDataGenerator();
        this.initFileSystem();
    }

    @AfterEach
    public void tearDown() {
        this.cleanupSparkContexts();
        this.cleanupTestDataGenerator();
        this.cleanupFileSystem();
        FileSystem.closeAll();
        System.gc();
    }

    @Test
    public void testShortNameStorage() {
        List records = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("000", Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath);
        Assertions.assertTrue((boolean)HoodieDataSourceHelpers.hasNewCommits((FileSystem)this.fs, (String)this.basePath, (String)"000"));
    }

    @Test
    public void testNoPrecombine() {
        List records = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("000", Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records, 2, ClassTag$.MODULE$.apply(String.class)));
        scala.collection.immutable.Map commonOptsNoPreCombine = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test")}));
        inputDF.write().format("hudi").options((Map)commonOptsNoPreCombine).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath);
        this.spark().read().format("org.apache.hudi").load(this.basePath).count();
    }

    @Test
    public void testHoodieIsDeletedNonBooleanField() {
        List records = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("000", Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records, 2, ClassTag$.MODULE$.apply(String.class)));
        Dataset df = inputDF.withColumn("_hoodie_is_deleted", functions$.MODULE$.lit((Object)"abc"));
        Assertions.assertThrows(HoodieException.class, (Executable)new Executable(this, df){
            private final /* synthetic */ TestCOWDataSource $outer;
            private final Dataset df$1;

            public void execute() {
                this.df$1.write().format("hudi").options(this.$outer.commonOpts()).mode(SaveMode.Overwrite).save(this.$outer.protected$basePath(this.$outer));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.df$1 = df$1;
            }
        }, (String)"Should have failed since _hoodie_is_deleted is not a BOOLEAN data type");
    }

    @Test
    public void testPrunePartitionForTimestampBasedKeyGenerator() {
        scala.collection.immutable.Map options = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.compact.inline"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()), (Object)"org.apache.hudi.keygen.TimestampBasedKeyGenerator"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.deltastreamer.keygen.timebased.timestamp.type"), (Object)"DATE_STRING"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.deltastreamer.keygen.timebased.output.dateformat"), (Object)"yyyy/MM/dd"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.deltastreamer.keygen.timebased.timezone"), (Object)"GMT+8:00"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.deltastreamer.keygen.timebased.input.dateformat"), (Object)"yyyy-MM-dd")})));
        HoodieTestDataGenerator dataGen1 = new HoodieTestDataGenerator((String[])((Object[])new String[]{"2022-01-01"}));
        List records1 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)dataGen1.generateInserts("001", Predef$.MODULE$.int2Integer(20)))).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options((Map)options).mode(SaveMode.Overwrite).save(this.basePath);
        ((HoodieClientTestHarness)this).metaClient = HoodieTableMetaClient.builder().setBasePath(this.basePath).setConf(this.spark().sessionState().newHadoopConf()).build();
        String commit1Time = ((HoodieInstant)this.metaClient.getActiveTimeline().lastInstant().get()).getTimestamp();
        HoodieTestDataGenerator dataGen2 = new HoodieTestDataGenerator((String[])((Object[])new String[]{"2022-01-02"}));
        List records2 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)dataGen2.generateInserts("002", Predef$.MODULE$.int2Integer(30)))).toList();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options((Map)options).mode(SaveMode.Append).save(this.basePath);
        String commit2Time = ((HoodieInstant)this.metaClient.reloadActiveTimeline().lastInstant().get()).getTimestamp();
        Dataset snapshotQueryRes = this.spark().read().format("hudi").load(this.basePath);
        Assertions.assertEquals((long)snapshotQueryRes.where("partition = '2022/01/01'").count(), (long)20L);
        Assertions.assertEquals((long)snapshotQueryRes.where("partition = '2022/01/02'").count(), (long)30L);
        Dataset incrementalQueryRes = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), commit1Time).option(DataSourceReadOptions$.MODULE$.END_INSTANTTIME().key(), commit2Time).load(this.basePath);
        Assertions.assertEquals((long)incrementalQueryRes.where("partition = '2022-01-01'").count(), (long)0L);
        Assertions.assertEquals((long)incrementalQueryRes.where("partition = '2022-01-02'").count(), (long)30L);
    }

    @Test
    public void testArchivalWithBulkInsert() {
        ObjectRef structType = ObjectRef.create(null);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 4).foreach$mVc$sp((Function1)new Serializable(this, structType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestCOWDataSource $outer;
            private final ObjectRef structType$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                List records = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.$outer.protected$dataGen(this.$outer).generateInserts(new StringOps(Predef$.MODULE$.augmentString("%05d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), Predef$.MODULE$.int2Integer(100)))).toList();
                Dataset inputDF = this.$outer.spark().read().json(this.$outer.spark().sparkContext().parallelize((Seq)records, 2, ClassTag$.MODULE$.apply(String.class)));
                this.structType$1.elem = inputDF.schema();
                inputDF.write().format("hudi").options(this.$outer.commonOpts()).option("hoodie.keep.min.commits", "1").option("hoodie.keep.max.commits", "2").option("hoodie.cleaner.commits.retained", "0").option("hoodie.datasource.write.row.writer.enable", "true").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL()).mode(i == 0 ? SaveMode.Overwrite : SaveMode.Append).save(this.$outer.protected$basePath(this.$outer));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.structType$1 = structType$1;
            }
        });
        HoodieTableMetaClient tableMetaClient = HoodieTableMetaClient.builder().setConf(this.spark().sparkContext().hadoopConfiguration()).setBasePath(this.basePath).build();
        Schema actualSchema = new TableSchemaResolver(tableMetaClient).getTableAvroSchemaWithoutMetadataFields();
        Tuple2 tuple2 = AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace((String)this.commonOpts().apply((Object)HoodieWriteConfig.TBL_NAME.key()));
        if (tuple2 != null) {
            Tuple2 tuple22;
            String structName = (String)tuple2._1();
            String nameSpace = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)structName, (Object)nameSpace);
            String structName2 = (String)tuple23._1();
            String nameSpace2 = (String)tuple23._2();
            this.spark().sparkContext().getConf().registerKryoClasses((Class[])((Object[])new Class[]{GenericData.class, Schema.class}));
            Schema schema = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)((StructType)structType.elem), structName2, nameSpace2);
            Assertions.assertTrue((actualSchema != null ? 1 : 0) != 0);
            Assertions.assertEquals((Object)schema, (Object)actualSchema);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testCopyOnWriteDeletes() {
        List records1 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("000", Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Overwrite).save(this.basePath);
        Assertions.assertTrue((boolean)HoodieDataSourceHelpers.hasNewCommits((FileSystem)this.fs, (String)this.basePath, (String)"000"));
        Dataset snapshotDF1 = this.spark().read().format("org.apache.hudi").load(new StringBuilder().append((Object)this.basePath).append((Object)"/*/*/*/*").toString());
        Assertions.assertEquals((long)100L, (long)snapshotDF1.count());
        List records2 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.deleteRecordsToStrings((java.util.List)this.dataGen.generateUniqueDeletes(Predef$.MODULE$.int2Integer(20)))).toList();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.DELETE_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        Dataset snapshotDF2 = this.spark().read().format("org.apache.hudi").load(new StringBuilder().append((Object)this.basePath).append((Object)"/*/*/*/*").toString());
        Assertions.assertEquals((long)snapshotDF2.count(), (long)80L);
    }

    @Test
    public void testOverWriteModeUseReplaceAction() {
        List records1 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(5)))).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        List records2 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("002", Predef$.MODULE$.int2Integer(5)))).toList();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OVERWRITE_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.spark().sparkContext().hadoopConfiguration()).setBasePath(this.basePath).setLoadActiveTimelineOnLoad(true).build();
        String[] commits = (String[])Predef$.MODULE$.refArrayOps(metaClient.getActiveTimeline().filterCompletedInstants().getInstants().toArray()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Object instant) {
                return ((HoodieInstant)instant).getAction();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Assertions.assertEquals((int)2, (int)Predef$.MODULE$.refArrayOps((Object[])commits).size());
        Assertions.assertEquals((Object)"commit", (Object)commits[0]);
        Assertions.assertEquals((Object)"replacecommit", (Object)commits[1]);
    }

    @Test
    public void testReadPathsOnCopyOnWriteTable() {
        java.util.List records1 = this.dataGen.generateInsertsContainsAllPartitions("001", Predef$.MODULE$.int2Integer(20));
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)records1)), 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.spark().sparkContext().hadoopConfiguration()).setBasePath(this.basePath).setLoadActiveTimelineOnLoad(true).build();
        String instantTime = ((HoodieInstant)metaClient.getActiveTimeline().filterCompletedInstants().getInstants().findFirst().get()).getTimestamp();
        String record1FilePaths = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.fs.listStatus(new Path(this.basePath, (String)Predef$.MODULE$.refArrayOps((Object[])this.dataGen.getPartitionPaths()).head()))).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus x$2) {
                return !x$2.getPath().getName().contains("hoodie_partition_metadata");
            }
        })).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus x$3) {
                return x$3.getPath().getName().endsWith("parquet");
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(FileStatus x$4) {
                return x$4.getPath().toString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(",");
        java.util.List records2 = this.dataGen.generateInsertsContainsAllPartitions("002", Predef$.MODULE$.int2Integer(20));
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)records2)), 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        Dataset inputDF3 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)records2)), 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF3.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        Dataset hudiReadPathDF = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.TIME_TRAVEL_AS_OF_INSTANT().key(), instantTime).option(DataSourceReadOptions$.MODULE$.READ_PATHS().key(), record1FilePaths).load();
        int expectedCount = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(records1).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestCOWDataSource $outer;

            public final boolean apply(HoodieRecord<?> record) {
                String string = record.getPartitionPath();
                Object object = Predef$.MODULE$.refArrayOps((Object[])this.$outer.protected$dataGen(this.$outer).getPartitionPaths()).head();
                return !(string != null ? !string.equals(object) : object != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assertions.assertEquals((long)expectedCount, (long)hudiReadPathDF.count());
    }

    @Test
    public void testOverWriteTableModeUseReplaceAction() {
        List records1 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(5)))).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        List records2 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("002", Predef$.MODULE$.int2Integer(5)))).toList();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OVERWRITE_TABLE_OPERATION_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath);
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.spark().sparkContext().hadoopConfiguration()).setBasePath(this.basePath).setLoadActiveTimelineOnLoad(true).build();
        String[] commits = (String[])Predef$.MODULE$.refArrayOps(metaClient.getActiveTimeline().filterCompletedInstants().getInstants().toArray()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Object instant) {
                return ((HoodieInstant)instant).getAction();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Assertions.assertEquals((int)2, (int)Predef$.MODULE$.refArrayOps((Object[])commits).size());
        Assertions.assertEquals((Object)"commit", (Object)commits[0]);
        Assertions.assertEquals((Object)"replacecommit", (Object)commits[1]);
    }

    @Test
    public void testOverWriteModeUseReplaceActionOnDisJointPartitions() {
        List records1 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInsertsForPartition("001", Predef$.MODULE$.int2Integer(5), "2016/03/15"))).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        List records2 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInsertsForPartition("002", Predef$.MODULE$.int2Integer(7), "2015/03/16"))).toList();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        List records3 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInsertsForPartition("001", Predef$.MODULE$.int2Integer(6), "2016/03/15"))).toList();
        Dataset inputDF3 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records3, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF3.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OVERWRITE_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        Dataset allRecords = this.spark().read().format("org.apache.hudi").load(new StringBuilder().append((Object)this.basePath).append((Object)"/*/*/*").toString());
        allRecords.registerTempTable("tmpTable");
        this.spark().sql(String.format("select count(*) from tmpTable", new Object[0])).show();
        Row[] recordCountForPartition1 = (Row[])this.spark().sql(String.format("select count(*) from tmpTable where partition = '%s'", "2016/03/15")).collect();
        Assertions.assertEquals((Object)"6", (Object)recordCountForPartition1[0].get(0).toString());
        Row[] recordCountForPartition2 = (Row[])this.spark().sql(String.format("select count(*) from tmpTable where partition = '%s'", "2015/03/16")).collect();
        Assertions.assertEquals((Object)"7", (Object)recordCountForPartition2[0].get(0).toString());
        Row[] recordsForPartitionColumn = (Row[])this.spark().sql(String.format("select partition from tmpTable", new Object[0])).collect();
        int filterSecondPartitionCount = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])recordsForPartitionColumn).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Row row) {
                return row.get(0).equals("2015/03/16");
            }
        })).size();
        Assertions.assertEquals((int)7, (int)filterSecondPartitionCount);
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.spark().sparkContext().hadoopConfiguration()).setBasePath(this.basePath).setLoadActiveTimelineOnLoad(true).build();
        String[] commits = (String[])Predef$.MODULE$.refArrayOps(metaClient.getActiveTimeline().filterCompletedInstants().getInstants().toArray()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Object instant) {
                return ((HoodieInstant)instant).getAction();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Assertions.assertEquals((int)3, (int)Predef$.MODULE$.refArrayOps((Object[])commits).size());
        Assertions.assertEquals((Object)"commit", (Object)commits[0]);
        Assertions.assertEquals((Object)"commit", (Object)commits[1]);
        Assertions.assertEquals((Object)"replacecommit", (Object)commits[2]);
    }

    @Test
    public void testOverWriteTableModeUseReplaceActionOnDisJointPartitions() {
        List records1 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInsertsForPartition("001", Predef$.MODULE$.int2Integer(5), "2016/03/15"))).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        List records2 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInsertsForPartition("002", Predef$.MODULE$.int2Integer(7), "2015/03/16"))).toList();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OVERWRITE_TABLE_OPERATION_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath);
        Dataset allRecords = this.spark().read().format("org.apache.hudi").load(new StringBuilder().append((Object)this.basePath).append((Object)"/*/*/*").toString());
        allRecords.registerTempTable("tmpTable");
        this.spark().sql(String.format("select count(*) from tmpTable", new Object[0])).show();
        Row[] recordCountForPartition1 = (Row[])this.spark().sql(String.format("select count(*) from tmpTable where partition = '%s'", "2016/03/15")).collect();
        Assertions.assertEquals((Object)"0", (Object)recordCountForPartition1[0].get(0).toString());
        Row[] recordCountForPartition2 = (Row[])this.spark().sql(String.format("select count(*) from tmpTable where partition = '%s'", "2015/03/16")).collect();
        Assertions.assertEquals((Object)"7", (Object)recordCountForPartition2[0].get(0).toString());
        Row[] recordCount = (Row[])this.spark().sql(String.format("select count(*) from tmpTable", new Object[0])).collect();
        Assertions.assertEquals((Object)"7", (Object)recordCount[0].get(0).toString());
        Row[] recordsForPartitionColumn = (Row[])this.spark().sql(String.format("select partition from tmpTable", new Object[0])).collect();
        int filterSecondPartitionCount = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])recordsForPartitionColumn).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Row row) {
                return row.get(0).equals("2015/03/16");
            }
        })).size();
        Assertions.assertEquals((int)7, (int)filterSecondPartitionCount);
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.spark().sparkContext().hadoopConfiguration()).setBasePath(this.basePath).setLoadActiveTimelineOnLoad(true).build();
        String[] commits = (String[])Predef$.MODULE$.refArrayOps(metaClient.getActiveTimeline().filterCompletedInstants().getInstants().toArray()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Object instant) {
                return ((HoodieInstant)instant).getAction();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Assertions.assertEquals((int)2, (int)Predef$.MODULE$.refArrayOps((Object[])commits).size());
        Assertions.assertEquals((Object)"commit", (Object)commits[0]);
        Assertions.assertEquals((Object)"replacecommit", (Object)commits[1]);
    }

    @Test
    public void testDropInsertDup() {
        int insert1Cnt = 10;
        int insert2DupKeyCnt = 9;
        int insert2NewKeyCnt = 2;
        int totalUniqueKeyToGenerate = insert1Cnt + insert2NewKeyCnt;
        java.util.List allRecords = this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(totalUniqueKeyToGenerate));
        java.util.List inserts1 = allRecords.subList(0, insert1Cnt);
        java.util.List inserts2New = this.dataGen.generateSameKeyInserts("002", allRecords.subList(insert1Cnt, insert1Cnt + insert2NewKeyCnt));
        java.util.List inserts2Dup = this.dataGen.generateSameKeyInserts("002", inserts1.subList(0, insert2DupKeyCnt));
        List records1 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings(inserts1)).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath);
        Dataset hoodieROViewDF1 = this.spark().read().format("org.apache.hudi").load(new StringBuilder().append((Object)this.basePath).append((Object)"/*/*/*/*").toString());
        Assertions.assertEquals((long)insert1Cnt, (long)hoodieROViewDF1.count());
        String commitInstantTime1 = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs, (String)this.basePath);
        List records2 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)JavaConversions$.MODULE$.bufferAsJavaList(JavaConversions$.MODULE$.asScalaBuffer(inserts2Dup).$plus$plus((GenTraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(inserts2New))))).toList();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS().key(), "true").mode(SaveMode.Append).save(this.basePath);
        Dataset hoodieROViewDF2 = this.spark().read().format("org.apache.hudi").load(new StringBuilder().append((Object)this.basePath).append((Object)"/*/*/*/*").toString());
        Assertions.assertEquals((long)hoodieROViewDF2.count(), (long)totalUniqueKeyToGenerate);
        Dataset hoodieIncViewDF2 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), commitInstantTime1).load(this.basePath);
        Assertions.assertEquals((long)hoodieIncViewDF2.count(), (long)insert2NewKeyCnt);
    }

    @Test
    public void testComplexDataTypeWriteAndReadConsistency() {
        StructField structField = new StructField("_row_key", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("name", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField3 = new StructField("timeStampValue", (DataType)TimestampType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField4 = new StructField("dateValue", (DataType)DateType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField5 = new StructField("decimalValue", (DataType)DataTypes.createDecimalType((int)15, (int)10), true, StructField$.MODULE$.apply$default$4());
        StructField structField6 = new StructField("timestamp", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField7 = new StructField("partition", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructType schema = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField7).$colon$colon((Object)structField6).$colon$colon((Object)structField5).$colon$colon((Object)structField4).$colon$colon((Object)structField3).$colon$colon((Object)structField2).$colon$colon((Object)structField));
        Seq records = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"11", "Andy", Timestamp.valueOf("1970-01-01 13:31:24"), Date.valueOf("1991-11-07"), scala.package$.MODULE$.BigDecimal().valueOf(1.0), BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"22", "lisi", Timestamp.valueOf("1970-01-02 13:31:24"), Date.valueOf("1991-11-08"), scala.package$.MODULE$.BigDecimal().valueOf(2.0), BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"33", "zhangsan", Timestamp.valueOf("1970-01-03 13:31:24"), Date.valueOf("1991-11-09"), scala.package$.MODULE$.BigDecimal().valueOf(3.0), BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1)}))}));
        JavaRDD rdd = this.jsc.parallelize(JavaConversions$.MODULE$.seqAsJavaList(records));
        Dataset recordsDF = this.spark().createDataFrame(rdd, schema);
        recordsDF.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Overwrite).save(this.basePath);
        Dataset recordsReadDF = this.spark().read().format("org.apache.hudi").load(new StringBuilder().append((Object)this.basePath).append((Object)"/*/*").toString());
        recordsReadDF.printSchema();
        recordsReadDF.schema().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(StructField f) {
                String string = f.name();
                if ("timeStampValue".equals(string)) {
                    Assertions.assertEquals((Object)f.dataType(), (Object)TimestampType$.MODULE$);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if ("dateValue".equals(string)) {
                    Assertions.assertEquals((Object)f.dataType(), (Object)DateType$.MODULE$);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if ("decimalValue".equals(string)) {
                    Assertions.assertEquals((Object)f.dataType(), (Object)new DecimalType(15, 10));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
        });
    }

    @Test
    public void testWithAutoCommitOn() {
        List records1 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("000", Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(HoodieWriteConfig.AUTO_COMMIT_ENABLE.key(), "true").mode(SaveMode.Overwrite).save(this.basePath);
        Assertions.assertTrue((boolean)HoodieDataSourceHelpers.hasNewCommits((FileSystem)this.fs, (String)this.basePath, (String)"000"));
    }

    private DataFrameWriter<Row> getDataFrameWriter(String keyGenerator) {
        List records = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("000", Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records, 2, ClassTag$.MODULE$.apply(String.class)));
        return inputDF.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key(), keyGenerator).mode(SaveMode.Overwrite);
    }

    @Test
    public void testSparkPartitionByWithCustomKeyGenerator() {
        DataFrameWriter writer = this.getDataFrameWriter(CustomKeyGenerator.class.getName());
        writer.partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"current_ts"})).mode(SaveMode.Overwrite).save(this.basePath);
        Dataset recordsReadDF = this.spark().read().format("org.apache.hudi").load(new StringBuilder().append((Object)this.basePath).append((Object)"/*/*").toString());
        Assertions.assertTrue((recordsReadDF.filter(functions$.MODULE$.col("_hoodie_partition_path").$eq$bang$eq((Object)functions$.MODULE$.col("current_ts").cast("string"))).count() == 0L ? 1 : 0) != 0);
        writer = this.getDataFrameWriter(CustomKeyGenerator.class.getName());
        writer.partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"current_ts:TIMESTAMP"})).option("hoodie.deltastreamer.keygen.timebased.timestamp.type", "EPOCHMILLISECONDS").option("hoodie.deltastreamer.keygen.timebased.output.dateformat", "yyyyMMdd").mode(SaveMode.Overwrite).save(this.basePath);
        recordsReadDF = this.spark().read().format("org.apache.hudi").load(new StringBuilder().append((Object)this.basePath).append((Object)"/*/*").toString());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestCOWDataSource.class.getClassLoader());
        public final class Org_apache_hudi_functional_TestCOWDataSource$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.lang.String").asType().toTypeConstructor();
            }

            public Org_apache_hudi_functional_TestCOWDataSource$$typecreator1$1(TestCOWDataSource $outer) {
            }
        }
        UserDefinedFunction udf_date_format = functions$.MODULE$.udf((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(long data) {
                return new DateTime(data).toString(DateTimeFormat.forPattern((String)"yyyyMMdd"));
            }
        }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_functional_TestCOWDataSource$$typecreator1$1(this)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Long());
        Assertions.assertTrue((recordsReadDF.filter(functions$.MODULE$.col("_hoodie_partition_path").$eq$bang$eq((Object)udf_date_format.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("current_ts")})))).count() == 0L ? 1 : 0) != 0);
        writer = this.getDataFrameWriter(CustomKeyGenerator.class.getName());
        writer.partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"driver", "rider:SIMPLE", "current_ts:TIMESTAMP"})).option("hoodie.deltastreamer.keygen.timebased.timestamp.type", "EPOCHMILLISECONDS").option("hoodie.deltastreamer.keygen.timebased.output.dateformat", "yyyyMMdd").mode(SaveMode.Overwrite).save(this.basePath);
        recordsReadDF = this.spark().read().format("org.apache.hudi").load(new StringBuilder().append((Object)this.basePath).append((Object)"/*/*/*").toString());
        Assertions.assertTrue((recordsReadDF.filter(functions$.MODULE$.col("_hoodie_partition_path").$eq$bang$eq((Object)functions$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("driver"), functions$.MODULE$.lit((Object)"/"), functions$.MODULE$.col("rider"), functions$.MODULE$.lit((Object)"/"), udf_date_format.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("current_ts")}))})))).count() == 0L ? 1 : 0) != 0);
        writer = this.getDataFrameWriter(CustomKeyGenerator.class.getName());
        writer = writer.partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"current_ts:DUMMY"})).option("hoodie.deltastreamer.keygen.timebased.timestamp.type", "EPOCHMILLISECONDS").option("hoodie.deltastreamer.keygen.timebased.output.dateformat", "yyyyMMdd");
        try {
            writer.save(this.basePath);
            Assertions.fail((String)"should fail when invalid PartitionKeyType is provided!");
        }
        catch (Exception exception) {
            Assertions.assertTrue((boolean)exception.getCause().getMessage().contains("No enum constant org.apache.hudi.keygen.CustomAvroKeyGenerator.PartitionKeyType.DUMMY"));
        }
    }

    @Test
    public void testSparkPartitionByWithSimpleKeyGenerator() {
        DataFrameWriter<Row> writer = this.getDataFrameWriter(SimpleKeyGenerator.class.getName());
        writer.partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"driver"})).mode(SaveMode.Overwrite).save(this.basePath);
        Dataset recordsReadDF = this.spark().read().format("org.apache.hudi").load(this.basePath);
        Assertions.assertTrue((recordsReadDF.filter(functions$.MODULE$.col("_hoodie_partition_path").$eq$bang$eq((Object)functions$.MODULE$.col("driver"))).count() == 0L ? 1 : 0) != 0);
        writer = this.getDataFrameWriter(SimpleKeyGenerator.class.getName());
        writer.partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"driver", "rider"})).save(this.basePath);
        recordsReadDF = this.spark().read().format("org.apache.hudi").load(this.basePath);
        Assertions.assertTrue((recordsReadDF.filter(functions$.MODULE$.col("_hoodie_partition_path").$eq$bang$eq((Object)functions$.MODULE$.lit((Object)"__HIVE_DEFAULT_PARTITION__"))).count() == 0L ? 1 : 0) != 0);
    }

    @Test
    public void testSparkPartitionByWithComplexKeyGenerator() {
        DataFrameWriter<Row> writer = this.getDataFrameWriter(ComplexKeyGenerator.class.getName());
        writer.partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"driver"})).mode(SaveMode.Overwrite).save(this.basePath);
        Dataset recordsReadDF = this.spark().read().format("org.apache.hudi").load(this.basePath);
        Assertions.assertTrue((recordsReadDF.filter(functions$.MODULE$.col("_hoodie_partition_path").$eq$bang$eq((Object)functions$.MODULE$.col("driver"))).count() == 0L ? 1 : 0) != 0);
        writer = this.getDataFrameWriter(ComplexKeyGenerator.class.getName());
        writer.partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"driver", "rider"})).save(this.basePath);
        recordsReadDF = this.spark().read().format("org.apache.hudi").load(this.basePath);
        Assertions.assertTrue((recordsReadDF.filter(functions$.MODULE$.col("_hoodie_partition_path").$eq$bang$eq((Object)functions$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("driver"), functions$.MODULE$.lit((Object)"/"), functions$.MODULE$.col("rider")})))).count() == 0L ? 1 : 0) != 0);
    }

    @Test
    public void testSparkPartitionByWithTimestampBasedKeyGenerator() {
        DataFrameWriter<Row> writer = this.getDataFrameWriter(TimestampBasedKeyGenerator.class.getName());
        writer.partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"current_ts"})).option("hoodie.deltastreamer.keygen.timebased.timestamp.type", "EPOCHMILLISECONDS").option("hoodie.deltastreamer.keygen.timebased.output.dateformat", "yyyyMMdd").mode(SaveMode.Overwrite).save(this.basePath);
        Dataset recordsReadDF = this.spark().read().format("org.apache.hudi").load(new StringBuilder().append((Object)this.basePath).append((Object)"/*/*").toString());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestCOWDataSource.class.getClassLoader());
        public final class Org_apache_hudi_functional_TestCOWDataSource$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.lang.String").asType().toTypeConstructor();
            }

            public Org_apache_hudi_functional_TestCOWDataSource$$typecreator2$1(TestCOWDataSource $outer) {
            }
        }
        UserDefinedFunction udf_date_format = functions$.MODULE$.udf((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(long data) {
                return new DateTime(data).toString(DateTimeFormat.forPattern((String)"yyyyMMdd"));
            }
        }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_functional_TestCOWDataSource$$typecreator2$1(this)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Long());
        Assertions.assertTrue((recordsReadDF.filter(functions$.MODULE$.col("_hoodie_partition_path").$eq$bang$eq((Object)udf_date_format.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("current_ts")})))).count() == 0L ? 1 : 0) != 0);
    }

    @Test
    public void testSparkPartitionByWithGlobalDeleteKeyGenerator() {
        DataFrameWriter<Row> writer = this.getDataFrameWriter(GlobalDeleteKeyGenerator.class.getName());
        writer.partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"driver"})).mode(SaveMode.Overwrite).save(this.basePath);
        Dataset recordsReadDF = this.spark().read().format("org.apache.hudi").load(this.basePath);
        Assertions.assertTrue((recordsReadDF.filter(functions$.MODULE$.col("_hoodie_partition_path").$eq$bang$eq((Object)functions$.MODULE$.lit((Object)""))).count() == 0L ? 1 : 0) != 0);
    }

    @Test
    public void testSparkPartitionByWithNonpartitionedKeyGenerator() {
        DataFrameWriter<Row> writer = this.getDataFrameWriter(NonpartitionedKeyGenerator.class.getName());
        writer.partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""})).mode(SaveMode.Overwrite).save(this.basePath);
        Dataset recordsReadDF = this.spark().read().format("org.apache.hudi").load(this.basePath);
        Assertions.assertTrue((recordsReadDF.filter(functions$.MODULE$.col("_hoodie_partition_path").$eq$bang$eq((Object)functions$.MODULE$.lit((Object)""))).count() == 0L ? 1 : 0) != 0);
        writer = this.getDataFrameWriter(NonpartitionedKeyGenerator.class.getName());
        writer.partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"abc"})).mode(SaveMode.Overwrite).save(this.basePath);
        recordsReadDF = this.spark().read().format("org.apache.hudi").load(this.basePath);
        Assertions.assertTrue((recordsReadDF.filter(functions$.MODULE$.col("_hoodie_partition_path").$eq$bang$eq((Object)functions$.MODULE$.lit((Object)""))).count() == 0L ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @CsvSource(value={"true,false", "true,true", "false,true", "false,false"})
    public void testQueryCOWWithBasePathAndFileIndex(boolean partitionEncode, boolean isMetadataEnabled) {
        int N = 20;
        java.util.List records1 = this.dataGen.generateInsertsContainsAllPartitions("000", Predef$.MODULE$.int2Integer(N));
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)records1)), 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING().key(), partitionEncode).option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabled).mode(SaveMode.Overwrite).save(this.basePath);
        String commitInstantTime1 = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs, (String)this.basePath);
        int countIn20160315 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(records1).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(HoodieRecord<?> record) {
                String string = record.getPartitionPath();
                String string2 = "2016/03/15";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        });
        long count1 = this.spark().read().format("hudi").option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabled).load(this.basePath).filter("partition = '2016/03/15'").count();
        Assertions.assertEquals((long)countIn20160315, (long)count1);
        String partitionPath = partitionEncode ? "2016%2F03%2F15" : "2016/03/15";
        long count2 = this.spark().read().format("hudi").option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabled).load(new StringBuilder().append((Object)this.basePath).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionPath}))).toString()).count();
        Assertions.assertEquals((long)countIn20160315, (long)count2);
        java.util.List records2 = this.dataGen.generateInsertsContainsAllPartitions("000", Predef$.MODULE$.int2Integer(N + 1));
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)records2)), 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING().key(), partitionEncode).option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabled).mode(SaveMode.Append).save(this.basePath);
        Dataset hoodieIncViewDF1 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), commitInstantTime1).load(this.basePath);
        Assertions.assertEquals((long)(N + 1), (long)hoodieIncViewDF1.count());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)Metrics.isInitialized()));
    }

    @Test
    public void testSchemaEvolution() {
        scala.collection.immutable.Map opts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.avro.schema.validate"), (Object)"true")}))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECONCILE_SCHEMA().key()), (Object)"true")})));
        StructField structField = new StructField("_row_key", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("name", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField3 = new StructField("timestamp", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField4 = new StructField("partition", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructType schema1 = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField4).$colon$colon((Object)structField3).$colon$colon((Object)structField2).$colon$colon((Object)structField));
        Seq records1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", "Andy", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", "lisi", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"3", "zhangsan", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)}))}));
        JavaRDD rdd = this.jsc.parallelize(JavaConversions$.MODULE$.seqAsJavaList(records1));
        Dataset recordsDF = this.spark().createDataFrame(rdd, schema1);
        recordsDF.write().format("org.apache.hudi").options((Map)opts).mode(SaveMode.Overwrite).save(this.basePath);
        StructField structField5 = new StructField("_row_key", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField6 = new StructField("name", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField7 = new StructField("age", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField8 = new StructField("timestamp", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField9 = new StructField("partition", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructType schema2 = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField9).$colon$colon((Object)structField8).$colon$colon((Object)structField7).$colon$colon((Object)structField6).$colon$colon((Object)structField5));
        Seq records2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"11", "Andy", "10", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"22", "lisi", "11", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"33", "zhangsan", "12", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)}))}));
        JavaRDD rdd2 = this.jsc.parallelize(JavaConversions$.MODULE$.seqAsJavaList(records2));
        Dataset recordsDF2 = this.spark().createDataFrame(rdd2, schema2);
        recordsDF2.write().format("org.apache.hudi").options((Map)opts).mode(SaveMode.Append).save(this.basePath);
        Dataset recordsReadDF = this.spark().read().format("org.apache.hudi").load(new StringBuilder().append((Object)this.basePath).append((Object)"/*/*").toString());
        HoodieTableMetaClient tableMetaClient = HoodieTableMetaClient.builder().setConf(this.spark().sparkContext().hadoopConfiguration()).setBasePath(this.basePath).build();
        Schema actualSchema = new TableSchemaResolver(tableMetaClient).getTableAvroSchemaWithoutMetadataFields();
        Assertions.assertTrue((actualSchema != null ? 1 : 0) != 0);
        StructType actualStructType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(actualSchema);
        Assertions.assertEquals((Object)actualStructType, (Object)schema2);
        try {
            StructField structField10 = new StructField("_row_key", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
            StructField structField11 = new StructField("age", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
            StructField structField12 = new StructField("timestamp", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
            StructField structField13 = new StructField("partition", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
            StructType schema4 = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField13).$colon$colon((Object)structField12).$colon$colon((Object)structField11).$colon$colon((Object)structField10));
            Seq records4 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"11", "10", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"22", "11", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"33", "12", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)}))}));
            JavaRDD rdd4 = this.jsc.parallelize(JavaConversions$.MODULE$.seqAsJavaList(records4));
            Dataset recordsDF4 = this.spark().createDataFrame(rdd4, schema4);
            recordsDF4.write().format("org.apache.hudi").options((Map)opts).mode(SaveMode.Append).save(this.basePath);
            Assertions.fail((String)"Delete column should fail");
        }
        catch (HoodieUpsertException hoodieUpsertException) {
            Assertions.assertTrue((boolean)hoodieUpsertException.getMessage().equals("Failed upsert schema compatibility check."));
        }
    }

    @Test
    public void testSchemaNotEqualData() {
        scala.collection.immutable.Map opts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.avro.schema.validate"), (Object)"true")})));
        StructField structField = new StructField("_row_key", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("name", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField3 = new StructField("timestamp", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField4 = new StructField("age", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField5 = new StructField("partition", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructType schema1 = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField5).$colon$colon((Object)structField4).$colon$colon((Object)structField3).$colon$colon((Object)structField2).$colon$colon((Object)structField));
        String[] records = (String[])((Object[])new String[]{"{\"_row_key\":\"1\",\"name\":\"lisi\",\"timestamp\":1,\"partition\":1}", "{\"_row_key\":\"1\",\"name\":\"lisi\",\"timestamp\":1,\"partition\":1}"});
        Dataset inputDF = this.spark().read().schema(schema1.toDDL()).json(this.spark().sparkContext().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])records), 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF.write().format("org.apache.hudi").options((Map)opts).mode(SaveMode.Overwrite).save(this.basePath);
        Dataset recordsReadDF = this.spark().read().format("org.apache.hudi").load(this.basePath);
        StructType resultSchema = new StructType((StructField[])((TraversableOnce)recordsReadDF.schema().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField p) {
                return !p.name().startsWith("_hoodie");
            }
        })).toArray(ClassTag$.MODULE$.apply(StructField.class)));
        Assertions.assertEquals((Object)resultSchema, (Object)schema1);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testCopyOnWriteWithDroppedPartitionColumns(boolean enableDropPartitionColumns) {
        List records1 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInsertsContainsAllPartitions("000", Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.DROP_PARTITION_COLUMNS().key(), enableDropPartitionColumns).mode(SaveMode.Overwrite).save(this.basePath);
        Dataset snapshotDF1 = this.spark().read().format("org.apache.hudi").load(this.basePath);
        Assertions.assertEquals((long)snapshotDF1.count(), (long)100L);
        Assertions.assertEquals((long)3L, (long)snapshotDF1.select("partition", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().count());
    }

    @Test
    public void testHoodieIsDeletedCOW() {
        int numRecords = 100;
        int numRecordsToDelete = 2;
        List records0 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("000", Predef$.MODULE$.int2Integer(numRecords)))).toList();
        Dataset df0 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records0, 2, ClassTag$.MODULE$.apply(String.class)));
        df0.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Overwrite).save(this.basePath);
        Dataset snapshotDF0 = this.spark().read().format("org.apache.hudi").load(new StringBuilder().append((Object)this.basePath).append((Object)"/*/*/*/*").toString());
        Assertions.assertEquals((long)numRecords, (long)snapshotDF0.count());
        Dataset df1 = snapshotDF0.limit(numRecordsToDelete);
        Dataset dropDf = df1.drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])df1.columns()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$30) {
                return x$30.startsWith("_hoodie_");
            }
        })));
        Dataset df2 = dropDf.withColumn("_hoodie_is_deleted", functions$.MODULE$.lit((Object)BoxesRunTime.boxToBoolean((boolean)true)).cast((DataType)BooleanType$.MODULE$));
        df2.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Append).save(this.basePath);
        Dataset snapshotDF2 = this.spark().read().format("org.apache.hudi").load(new StringBuilder().append((Object)this.basePath).append((Object)"/*/*/*/*").toString());
        Assertions.assertEquals((long)(numRecords - numRecordsToDelete), (long)snapshotDF2.count());
    }

    @Test
    public void testWriteSmallPrecisionDecimalTable() {
        List records1 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(5)))).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class))).withColumn("shortDecimal", functions$.MODULE$.lit((Object)new BigDecimal(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2090.0000"})).s((Seq)Nil$.MODULE$))));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath);
        Dataset inputDF2 = inputDF1.withColumn("shortDecimal", functions$.MODULE$.lit((Object)new BigDecimal(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3090.0000"})).s((Seq)Nil$.MODULE$))));
        inputDF2.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        Dataset readResult = this.spark().read().format("hudi").load(this.basePath);
        Predef$.MODULE$.assert(readResult.count() == 5L);
        Assertions.assertEquals((Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])inputDF2.sort("_row_key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).select("shortDecimal", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Row x$31) {
                return x$31.getDecimal(0).toPlainString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(","), (Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])readResult.sort("_row_key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).select("shortDecimal", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Row x$32) {
                return x$32.getDecimal(0).toPlainString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(","));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testPartitionColumnsProperHandling(boolean useGlobbing) {
        SparkSession _spark = this.spark();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestCOWDataSource.class.getClassLoader());
        public final class Org_apache_hudi_functional_TestCOWDataSource$$typecreator7$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor()})));
            }

            public Org_apache_hudi_functional_TestCOWDataSource$$typecreator7$1(TestCOWDataSource $outer) {
            }
        }
        Dataset df = _spark.implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"z3", (Object)BoxesRunTime.boxToInteger((int)30), (Object)"v1", (Object)"2018-09-23"), new Tuple5((Object)BoxesRunTime.boxToInteger((int)2), (Object)"z3", (Object)BoxesRunTime.boxToInteger((int)35), (Object)"v1", (Object)"2018-09-24")})), _spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_functional_TestCOWDataSource$$typecreator7$1(this)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "age", "ts", "data_date"}));
        df.write().format("hudi").options(this.commonOpts()).option("hoodie.insert.shuffle.parallelism", "4").option("hoodie.upsert.shuffle.parallelism", "4").option("hoodie.bulkinsert.shuffle.parallelism", "2").option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "id").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "data_date").option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "ts").option(DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key(), "org.apache.hudi.keygen.TimestampBasedKeyGenerator").option("hoodie.deltastreamer.keygen.timebased.timestamp.type", "DATE_STRING").option("hoodie.deltastreamer.keygen.timebased.input.dateformat", "yyyy-MM-dd").option("hoodie.deltastreamer.keygen.timebased.output.dateformat", "yyyy/MM/dd").option("hoodie.deltastreamer.keygen.timebased.timezone", "GMT+8:00").mode(SaveMode.Append).save(this.basePath);
        String path = useGlobbing ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/*/*/*/*"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.basePath})) : this.basePath;
        Dataset firstDF = this.spark().read().format("hudi").load(path);
        Predef$.MODULE$.assert(firstDF.count() == 2L);
        Seq expectedValues = useGlobbing ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2018-09-23", "2018-09-24"})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2018/09/23", "2018/09/24"}));
        Assertions.assertEquals((Object)expectedValues, (Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])firstDF.select("data_date", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Row x$33) {
                return x$33.get(0).toString();
            }
        }, _spark.implicits().newStringEncoder()).collect()).sorted((Ordering)Ordering.String$.MODULE$)).toSeq());
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2018/09/23", "2018/09/24"})), (Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])firstDF.select("_hoodie_partition_path", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Row x$34) {
                return x$34.get(0).toString();
            }
        }, _spark.implicits().newStringEncoder()).collect()).sorted((Ordering)Ordering.String$.MODULE$)).toSeq());
        if (!useGlobbing) {
            Dataset secondDF = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.EXTRACT_PARTITION_VALUES_FROM_PARTITION_PATH().key(), "true").load(path);
            Predef$.MODULE$.assert(secondDF.count() == 2L);
            Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2018/09/23", "2018/09/24"})), (Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])secondDF.select("data_date", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Row x$35) {
                    return x$35.get(0).toString();
                }
            }, _spark.implicits().newStringEncoder()).collect()).sorted((Ordering)Ordering.String$.MODULE$)).toSeq());
            Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2018/09/23", "2018/09/24"})), (Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])secondDF.select("_hoodie_partition_path", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Row x$36) {
                    return x$36.get(0).toString();
                }
            }, _spark.implicits().newStringEncoder()).collect()).sorted((Ordering)Ordering.String$.MODULE$)).toSeq());
        }
    }

    @Test
    public void testSaveAsTableInDifferentModes() {
        scala.collection.mutable.Map options = Map$.MODULE$.empty().$plus$plus(this.commonOpts()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)this.basePath)})));
        List records1 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(5)))).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition"})).options((Map)options).mode(SaveMode.Append).saveAsTable("hoodie_test");
        ((HoodieClientTestHarness)this).metaClient = HoodieTableMetaClient.builder().setBasePath(this.basePath).setConf(this.spark().sessionState().newHadoopConf()).build();
        Assertions.assertEquals((long)this.spark().read().format("hudi").load(this.basePath).count(), (long)5L);
        List records2 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("002", Predef$.MODULE$.int2Integer(6)))).toList();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition"})).options((Map)options).mode(SaveMode.Append).saveAsTable("hoodie_test");
        Assertions.assertEquals((long)this.spark().read().format("hudi").load(this.basePath).count(), (long)11L);
        List records3 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("003", Predef$.MODULE$.int2Integer(7)))).toList();
        Dataset inputDF3 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records3, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF3.write().format("org.apache.hudi").partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition"})).options((Map)options).mode(SaveMode.Ignore).saveAsTable("hoodie_test");
        Assertions.assertEquals((long)this.spark().read().format("hudi").load(this.basePath).count(), (long)11L);
        List records4 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("004", Predef$.MODULE$.int2Integer(8)))).toList();
        Dataset inputDF4 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records4, 2, ClassTag$.MODULE$.apply(String.class)));
        try {
            inputDF4.write().format("org.apache.hudi").partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition"})).options((Map)options).mode(SaveMode.ErrorIfExists).saveAsTable("hoodie_test");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        List records5 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("005", Predef$.MODULE$.int2Integer(9)))).toList();
        Dataset inputDF5 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records5, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF5.write().format("org.apache.hudi").partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition"})).options((Map)options).mode(SaveMode.Overwrite).saveAsTable("hoodie_test");
        Assertions.assertEquals((long)this.spark().read().format("hudi").load(this.basePath).count(), (long)9L);
    }

    @Test
    public void testMetricsReporterViaDataSource() {
        QuickstartUtils.DataGenerator dataGenerator = new QuickstartUtils.DataGenerator();
        java.util.List records = QuickstartUtils.convertToStringList((java.util.List)dataGenerator.generateInserts(Predef$.MODULE$.int2Integer(10)));
        RDD recordsRDD = this.spark().sparkContext().parallelize((Seq)JavaConversions$.MODULE$.asScalaBuffer(records), 2, ClassTag$.MODULE$.apply(String.class));
        Dataset inputDF = this.spark().read().json(this.sparkSession.createDataset(recordsRDD, Encoders$.MODULE$.STRING()));
        inputDF.write().format("hudi").options(QuickstartUtils.getQuickstartWriteConfigs()).option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "uuid").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "partitionpath").option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "ts").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(HoodieWriteConfig.TBL_NAME.key(), "hoodie_test").option(HoodieMetricsConfig.TURN_METRICS_ON.key(), "true").option(HoodieMetricsConfig.METRICS_REPORTER_TYPE_VALUE.key(), "CONSOLE").mode(SaveMode.Overwrite).save(this.basePath);
        Assertions.assertTrue((boolean)HoodieDataSourceHelpers.hasNewCommits((FileSystem)this.fs, (String)this.basePath, (String)"000"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)Metrics.isInitialized()), (String)"Metrics should be shutdown");
    }

    public TestCOWDataSource() {
        this.verificationCol = "driver";
        this.updatedVerificationVal = "driver_update";
    }
}

