/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieDataSourceHelpers;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieArchivedTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.keygen.TimestampBasedKeyGenerator;
import org.apache.hudi.testutils.SparkClientFunctionalTestHarness;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.functions$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Array$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@Tag(value="functional")
@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001B\u0001\u0003\u0001-\u0011\u0001\u0004V3ti\u000e{u\u000bR1uCN{WO]2f'R|'/Y4f\u0015\t\u0019A!\u0001\u0006gk:\u001cG/[8oC2T!!\u0002\u0004\u0002\t!,H-\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u0011\u001b\u0005q!BA\b\u0005\u0003%!Xm\u001d;vi&d7/\u0003\u0002\u0012\u001d\t\u00013\u000b]1sW\u000ec\u0017.\u001a8u\rVt7\r^5p]\u0006dG+Z:u\u0011\u0006\u0014h.Z:t\u0011\u0015\u0019\u0002\u0001\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\u0017\u00015\t!\u0001C\u0004\u0019\u0001\u0001\u0007I\u0011A\r\u0002\u0015\r|W.\\8o\u001fB$8/F\u0001\u001b!\u0011Y\"\u0005\n\u0013\u000e\u0003qQ!!\b\u0010\u0002\u0013%lW.\u001e;bE2,'BA\u0010!\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\b\u0002\u0004\u001b\u0006\u0004\bCA\u0013+\u001b\u00051#BA\u0014)\u0003\u0011a\u0017M\\4\u000b\u0003%\nAA[1wC&\u00111F\n\u0002\u0007'R\u0014\u0018N\\4\t\u000f5\u0002\u0001\u0019!C\u0001]\u0005q1m\\7n_:|\u0005\u000f^:`I\u0015\fHCA\u00184!\t\u0001\u0014'D\u0001!\u0013\t\u0011\u0004E\u0001\u0003V]&$\bb\u0002\u001b-\u0003\u0003\u0005\rAG\u0001\u0004q\u0012\n\u0004B\u0002\u001c\u0001A\u0003&!$A\u0006d_6lwN\\(qiN\u0004\u0003b\u0002\u001d\u0001\u0005\u0004%\t!O\u0001\u0010m\u0016\u0014\u0018NZ5dCRLwN\\\"pYV\t!\b\u0005\u0002<}9\u0011\u0001\u0007P\u0005\u0003{\u0001\na\u0001\u0015:fI\u00164\u0017BA\u0016@\u0015\ti\u0004\u0005\u0003\u0004B\u0001\u0001\u0006IAO\u0001\u0011m\u0016\u0014\u0018NZ5dCRLwN\\\"pY\u0002Bqa\u0011\u0001C\u0002\u0013\u0005\u0011(\u0001\fva\u0012\fG/\u001a3WKJLg-[2bi&|gNV1m\u0011\u0019)\u0005\u0001)A\u0005u\u00059R\u000f\u001d3bi\u0016$g+\u001a:jM&\u001c\u0017\r^5p]Z\u000bG\u000e\t\u0005\u0006\u000f\u0002!\t\u0001S\u0001\u0017i\u0016\u001cHoQ8qs>swK]5uKN#xN]1hKR!q&\u0013(Q\u0011\u0015Qe\t1\u0001L\u0003EI7/T3uC\u0012\fG/Y#oC\ndW\r\u001a\t\u0003a1K!!\u0014\u0011\u0003\u000f\t{w\u000e\\3b]\")qJ\u0012a\u0001u\u0005Y1.Z=HK:\u001cE.Y:t\u0011\u0015\tf\t1\u0001;\u0003)\u0011XmY8sI.+\u0017p\u001d\u0015\u0007\rN{\u0006-\u001c8\u0011\u0005QkV\"A+\u000b\u0005Y;\u0016\u0001\u00039s_ZLG-\u001a:\u000b\u0005aK\u0016A\u00029be\u0006l7O\u0003\u0002[7\u00069!.\u001e9ji\u0016\u0014(B\u0001/\t\u0003\u0015QWO\\5u\u0013\tqVKA\u0005DgZ\u001cv.\u001e:dK\u0006)a/\u00197vK22\u0011mY3hS.\f\u0013AY\u00018iJ,X\r`8sO:\n\u0007/Y2iK:BW\u000fZ5/W\u0016Lx-\u001a8/'&l\u0007\u000f\\3LKf<UM\\3sCR|'\u000f`0s_^|6.Z=\"\u0003\u0011\fQ\t\u001e:vKr|'o\u001a\u0018ba\u0006\u001c\u0007.\u001a\u0018ik\u0012Lgf[3zO\u0016tgfQ8na2,\u0007pS3z\u000f\u0016tWM]1u_JdxL]8x?.,\u0017\u0010\f8bi&|gN\f2zi\u0016\u001c\u0018%\u00014\u0002\u007fQ\u0014X/\u001a?pe\u001et\u0013\r]1dQ\u0016t\u0003.\u001e3j]-,\u0017pZ3o]QKW.Z:uC6\u0004()Y:fI.+\u0017pR3oKJ\fGo\u001c:}?J|woX6fs\u0006\n\u0001.\u0001\u001dgC2\u001cX\r`8sO:\n\u0007/Y2iK:BW\u000fZ5/W\u0016Lx-\u001a8/'&l\u0007\u000f\\3LKf<UM\\3sCR|'\u000f`0s_^|6.Z=\"\u0003)\faIZ1mg\u0016dxN]4/CB\f7\r[3/QV$\u0017NL6fs\u001e,gNL\"p[BdW\r_&fs\u001e+g.\u001a:bi>\u0014Hp\u0018:po~[W-\u001f\u0017oCRLwN\u001c\u0018csR,7/I\u0001m\u0003\u00013\u0017\r\\:fy>\u0014xML1qC\u000eDWM\f5vI&t3.Z=hK:tC+[7fgR\fW\u000e\u001d\"bg\u0016$7*Z=HK:,'/\u0019;per|&o\\<`W\u0016L\u0018!\u00033fY&l\u0017\u000e^3s9\u0005a\bF\u0001$q!\t\t(/D\u0001X\u0013\t\u0019xKA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgRDQ!\u001e\u0001\u0005\u0002Y\fA\u0005^3ti\u0006\u00138\r[5wC2<\u0016\u000e\u001e5SKBd\u0017mY3D_6l\u0017\u000e^!di&|gn\u001d\u000b\u0003_]DQ\u0001\u001f;A\u0002i\nab\u001e:ji\u0016|\u0005/\u001a:bi&|g\u000e\u000b\u0003uuvt\bC\u0001+|\u0013\taXKA\u0006WC2,XmU8ve\u000e,\u0017aB:ue&twm\u001d\u0017\u0004\u007f\u0006\r\u0011EAA\u0001\u0003AIgn]3si~{g/\u001a:xe&$X-\t\u0002\u0002\u0006\u0005\u0001B-\u001a7fi\u0016|\u0006/\u0019:uSRLwN\u001c\u0015\u0003iBDq!a\u0003\u0001\t\u0003\ti!\u0001\u0007xe&$XMU3d_J$7\u000fF\u00050\u0003\u001f\tI\"a\u000b\u0002.!A\u0011\u0011CA\u0005\u0001\u0004\t\u0019\"\u0001\u0006d_6l\u0017\u000e\u001e+j[\u0016\u00042\u0001MA\u000b\u0013\r\t9\u0002\t\u0002\u0004\u0013:$\b\u0002CA\u000e\u0003\u0013\u0001\r!!\b\u0002\u000f\u0011\fG/Y$f]B!\u0011qDA\u0014\u001b\t\t\tCC\u0002\u0010\u0003GQ1!!\n\u0005\u0003\u0019\u0019w.\\7p]&!\u0011\u0011FA\u0011\u0005]Aun\u001c3jKR+7\u000f\u001e#bi\u0006<UM\\3sCR|'\u000f\u0003\u0004y\u0003\u0013\u0001\rA\u000f\u0005\b\u0003_\tI\u00011\u0001;\u0003!\u0011\u0017m]3QCRD\u0007bBA\u001a\u0001\u0011\u0005\u0011QG\u0001\u0012CN\u001cXM\u001d;SK\u000e|'\u000fZ\"pk:$H#B\u0018\u00028\u0005e\u0002bBA\u0018\u0003c\u0001\rA\u000f\u0005\t\u0003w\t\t\u00041\u0001\u0002>\u0005\u0019R\r\u001f9fGR,GMU3d_J$7i\\;oiB\u0019\u0001'a\u0010\n\u0007\u0005\u0005\u0003E\u0001\u0003M_:<\u0007F\u0002\u0001\u0002F}\u000b\t\u0006\u0005\u0003\u0002H\u00055SBAA%\u0015\r\tY%W\u0001\u0004CBL\u0017\u0002BA(\u0003\u0013\u00121\u0001V1hC\u0005\u0019\u0001")
public class TestCOWDataSourceStorage
extends SparkClientFunctionalTestHarness {
    private scala.collection.immutable.Map<String, String> commonOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.bulkinsert.shuffle.parallelism"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.delete.shuffle.parallelism"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING().key()), (Object)"false")}));
    private final String verificationCol;
    private final String updatedVerificationVal;

    public scala.collection.immutable.Map<String, String> commonOpts() {
        return this.commonOpts;
    }

    public void commonOpts_$eq(scala.collection.immutable.Map<String, String> x$1) {
        this.commonOpts = x$1;
    }

    public String verificationCol() {
        return this.verificationCol;
    }

    public String updatedVerificationVal() {
        return this.updatedVerificationVal;
    }

    @ParameterizedTest
    @CsvSource(value={"true|org.apache.hudi.keygen.SimpleKeyGenerator|_row_key", "true|org.apache.hudi.keygen.ComplexKeyGenerator|_row_key,nation.bytes", "true|org.apache.hudi.keygen.TimestampBasedKeyGenerator|_row_key", "false|org.apache.hudi.keygen.SimpleKeyGenerator|_row_key", "false|org.apache.hudi.keygen.ComplexKeyGenerator|_row_key,nation.bytes", "false|org.apache.hudi.keygen.TimestampBasedKeyGenerator|_row_key"}, delimiter=124)
    public void testCopyOnWriteStorage(boolean isMetadataEnabled, String keyGenClass, String recordKeys) {
        scala.collection.immutable.Map options = this.commonOpts().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)String.valueOf(isMetadataEnabled))).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()), (Object)keyGenClass)).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)recordKeys));
        boolean isTimestampBasedKeyGen = TimestampBasedKeyGenerator.class.getName().equals(keyGenClass);
        if (isTimestampBasedKeyGen) {
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"));
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.deltastreamer.keygen.timebased.timestamp.type"), (Object)"DATE_STRING"));
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.deltastreamer.keygen.timebased.input.dateformat"), (Object)"yyyy/MM/dd"));
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.deltastreamer.keygen.timebased.output.dateformat"), (Object)"yyyyMMdd"));
        }
        HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator(57069L);
        FileSystem fs = FSUtils.getFs((String)this.basePath(), (Configuration)this.spark().sparkContext().hadoopConfiguration());
        List records0 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateInserts("000", Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF0 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records0, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF0.write().format("org.apache.hudi").options((Map)options).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath());
        Assertions.assertTrue((boolean)HoodieDataSourceHelpers.hasNewCommits((FileSystem)fs, (String)this.basePath(), (String)"000"));
        Dataset snapshotDF1 = this.spark().read().format("org.apache.hudi").option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabled).load(this.basePath());
        Assertions.assertEquals((long)100L, (long)snapshotDF1.count());
        List records1 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateUpdates("001", Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        String verificationRowKey = ((Row)inputDF1.limit(1).select("_row_key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).first()).getString(0);
        Dataset updateDf = null;
        if (isTimestampBasedKeyGen) {
            Row originalRow = (Row)snapshotDF1.filter(functions$.MODULE$.col("_row_key").$eq$eq$eq((Object)verificationRowKey)).collectAsList().get(0);
            updateDf = inputDF1.filter(functions$.MODULE$.col("_row_key").$eq$eq$eq((Object)verificationRowKey)).withColumn(this.verificationCol(), functions$.MODULE$.lit((Object)this.updatedVerificationVal())).withColumn("current_ts", functions$.MODULE$.lit(originalRow.getAs("current_ts"))).limit(1);
            Row updatedRow = (Row)updateDf.collectAsList().get(0);
            Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)originalRow.getAs("current_ts")), (long)BoxesRunTime.unboxToLong((Object)updatedRow.getAs("current_ts")));
        } else {
            updateDf = snapshotDF1.filter(functions$.MODULE$.col("_row_key").$eq$eq$eq((Object)verificationRowKey)).withColumn(this.verificationCol(), functions$.MODULE$.lit((Object)this.updatedVerificationVal()));
        }
        updateDf.write().format("org.apache.hudi").options((Map)options).mode(SaveMode.Append).save(this.basePath());
        String commitInstantTime2 = HoodieDataSourceHelpers.latestCommit((FileSystem)fs, (String)this.basePath());
        Dataset snapshotDF2 = this.spark().read().format("hudi").option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabled).load(this.basePath());
        Assertions.assertEquals((long)100L, (long)snapshotDF2.count());
        Assertions.assertEquals((Object)this.updatedVerificationVal(), (Object)((Row)snapshotDF2.filter(functions$.MODULE$.col("_row_key").$eq$eq$eq((Object)verificationRowKey)).select(this.verificationCol(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).first()).getString(0));
        List records2 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateUpdates("002", Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        if (isTimestampBasedKeyGen) {
            Dataset inputDF2WithTempCols = inputDF2.withColumn("current_ts_temp", functions$.MODULE$.col("current_ts")).withColumn("_row_key_temp", functions$.MODULE$.col("_row_key"));
            Dataset originalRowCurrentTsDf = inputDF0.select("_row_key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"current_ts"}));
            Dataset joinedDf = inputDF2WithTempCols.drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_row_key", "current_ts"})).join(originalRowCurrentTsDf, inputDF2WithTempCols.apply("_row_key_temp").$eq$eq$eq((Object)originalRowCurrentTsDf.apply("_row_key")));
            inputDF2 = joinedDf.withColumn("current_ts_temp", functions$.MODULE$.col("current_ts")).drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"current_ts", "_row_key_temp"})).withColumn("current_ts", functions$.MODULE$.col("current_ts_temp")).drop("current_ts_temp");
        }
        long uniqueKeyCnt = inputDF2.select("_row_key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().count();
        inputDF2.write().format("org.apache.hudi").options((Map)options).mode(SaveMode.Append).save(this.basePath());
        String commitInstantTime3 = HoodieDataSourceHelpers.latestCommit((FileSystem)fs, (String)this.basePath());
        Assertions.assertEquals((int)3, (int)HoodieDataSourceHelpers.listCommitsSince((FileSystem)fs, (String)this.basePath(), (String)"000").size());
        Dataset snapshotDF3 = this.spark().read().format("org.apache.hudi").option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabled).load(this.basePath());
        Assertions.assertEquals((long)100L, (long)snapshotDF3.count());
        String firstCommit = (String)HoodieDataSourceHelpers.listCommitsSince((FileSystem)fs, (String)this.basePath(), (String)"000").get(0);
        Dataset hoodieIncViewDF1 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), "000").option(DataSourceReadOptions$.MODULE$.END_INSTANTTIME().key(), firstCommit).load(this.basePath());
        Assertions.assertEquals((long)100L, (long)hoodieIncViewDF1.count());
        Row[] countsPerCommit = (Row[])hoodieIncViewDF1.groupBy("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count().collect();
        Assertions.assertEquals((int)1, (int)countsPerCommit.length);
        Assertions.assertEquals((Object)firstCommit, (Object)countsPerCommit[0].get(0));
        Dataset emptyIncDF = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), "000").option(DataSourceReadOptions$.MODULE$.END_INSTANTTIME().key(), "002").load(this.basePath());
        Assertions.assertEquals((long)0L, (long)emptyIncDF.count());
        List emptyRecords = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateUpdates("003", Predef$.MODULE$.int2Integer(0)))).toList();
        Dataset emptyDF = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)emptyRecords, 1, ClassTag$.MODULE$.apply(String.class)));
        emptyDF.write().format("org.apache.hudi").options((Map)options).mode(SaveMode.Append).save(this.basePath());
        Dataset hoodieIncViewDF2 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), commitInstantTime2).load(this.basePath());
        Assertions.assertEquals((long)uniqueKeyCnt, (long)hoodieIncViewDF2.count());
        countsPerCommit = (Row[])hoodieIncViewDF2.groupBy("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count().collect();
        Assertions.assertEquals((int)1, (int)countsPerCommit.length);
        Assertions.assertEquals((Object)commitInstantTime3, (Object)countsPerCommit[0].get(0));
        Dataset hoodieIncViewDF3 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), commitInstantTime2).option(DataSourceReadOptions$.MODULE$.INCR_PATH_GLOB().key(), isTimestampBasedKeyGen ? "/2016*/*" : "/2016/*/*/*").load(this.basePath());
        Assertions.assertEquals((long)hoodieIncViewDF2.filter(functions$.MODULE$.col("_hoodie_partition_path").startsWith("2016")).count(), (long)hoodieIncViewDF3.count());
        Dataset timeTravelDF = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), "000").option(DataSourceReadOptions$.MODULE$.END_INSTANTTIME().key(), firstCommit).load(this.basePath());
        Assertions.assertEquals((long)100L, (long)timeTravelDF.count());
    }

    @ParameterizedTest
    @ValueSource(strings={"insert_overwrite", "delete_partition"})
    public void testArchivalWithReplaceCommitActions(String writeOperation) {
        HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator();
        HoodieTestDataGenerator dataGenPartition1 = new HoodieTestDataGenerator((String[])((Object[])new String[]{"2016/03/15"}));
        HoodieTestDataGenerator dataGenPartition2 = new HoodieTestDataGenerator((String[])((Object[])new String[]{"2015/03/16"}));
        List records = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateInserts(new StringOps(Predef$.MODULE$.augmentString("%05d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records, 2, ClassTag$.MODULE$.apply(String.class)));
        long partition1RecordCount = inputDF.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Row row) {
                return row.getAs("partition_path").equals("2016/03/15");
            }
        }).count();
        inputDF.write().format("hudi").options(this.commonOpts()).option("hoodie.keep.min.commits", "2").option("hoodie.keep.max.commits", "3").option("hoodie.cleaner.commits.retained", "1").option("hoodie.metadata.enable", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath());
        this.assertRecordCount(this.basePath(), 100L);
        this.writeRecords(2, dataGenPartition1, writeOperation, this.basePath());
        long expectedRecCount = writeOperation.equals(DataSourceWriteOptions$.MODULE$.INSERT_OVERWRITE_OPERATION_OPT_VAL()) ? 200L - partition1RecordCount : 100L - partition1RecordCount;
        this.assertRecordCount(this.basePath(), expectedRecCount);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(3), 7).foreach$mVc$sp((Function1)new Serializable(this, dataGenPartition2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestCOWDataSourceStorage $outer;
            private final HoodieTestDataGenerator dataGenPartition2$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.$outer.writeRecords(i, this.dataGenPartition2$1, DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL(), this.$outer.basePath());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dataGenPartition2$1 = dataGenPartition2$1;
            }
        });
        this.assertRecordCount(this.basePath(), expectedRecCount + 500L);
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.spark().sparkContext().hadoopConfiguration()).setBasePath(this.basePath()).setLoadActiveTimelineOnLoad(true).build();
        String[] commits = (String[])Predef$.MODULE$.refArrayOps(metaClient.getActiveTimeline().filterCompletedInstants().getInstants().toArray()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Object instant) {
                return ((HoodieInstant)instant).getAction();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Assertions.assertFalse((boolean)Predef$.MODULE$.refArrayOps((Object[])commits).contains((Object)"replacecommit"));
        HoodieArchivedTimeline archivedTimeline = metaClient.getArchivedTimeline();
        Assertions.assertTrue((Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(archivedTimeline.getInstants().toArray()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Object instant) {
                return ((HoodieInstant)instant).getAction();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String action) {
                return action.equals("replacecommit");
            }
        })).size() > 0 ? 1 : 0) != 0);
    }

    public void writeRecords(int commitTime, HoodieTestDataGenerator dataGen, String writeOperation, String basePath) {
        List records = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateInserts(new StringOps(Predef$.MODULE$.augmentString("%05d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)commitTime)})), Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF.write().format("hudi").options(this.commonOpts()).option("hoodie.keep.min.commits", "2").option("hoodie.keep.max.commits", "3").option("hoodie.cleaner.commits.retained", "1").option("hoodie.metadata.enable", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), writeOperation).mode(SaveMode.Append).save(basePath);
    }

    public void assertRecordCount(String basePath, long expectedRecordCount) {
        Dataset snapshotDF = this.spark().read().format("org.apache.hudi").load(new StringBuilder().append((Object)basePath).append((Object)"/*/*/*/*").toString());
        Assertions.assertEquals((long)expectedRecordCount, (long)snapshotDF.count());
    }

    public TestCOWDataSourceStorage() {
        this.verificationCol = "driver";
        this.updatedVerificationVal = "driver_update";
    }
}

