/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hudi.ColumnStatsIndexSupport;
import org.apache.hudi.ColumnStatsIndexSupport$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieConversionUtils$;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.model.HoodieColumnRangeMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.ParquetUtils;
import org.apache.hudi.config.HoodieStorageConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.functional.TestColumnStatsIndex$;
import org.apache.hudi.functional.TestColumnStatsIndex$$anonfun$org$apache$hudi$functional$TestColumnStatsIndex$;
import org.apache.hudi.functional.TestColumnStatsIndex$$anonfun$org$apache$hudi$functional$TestColumnStatsIndex$$buildColumnStatsTableManually$1$;
import org.apache.hudi.testutils.HoodieClientTestBase;
import org.apache.hudi.testutils.HoodieClientTestHarness;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Array$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Random$;

@Tag(value="functional")
@ScalaSignature(bytes="\u0006\u0001\r}a\u0001B\u0001\u0003\u0001-\u0011A\u0003V3ti\u000e{G.^7o'R\fGo]%oI\u0016D(BA\u0002\u0005\u0003)1WO\\2uS>t\u0017\r\u001c\u0006\u0003\u000b\u0019\tA\u0001[;eS*\u0011q\u0001C\u0001\u0007CB\f7\r[3\u000b\u0003%\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0007\u0011\u00055\u0001R\"\u0001\b\u000b\u0005=!\u0011!\u0003;fgR,H/\u001b7t\u0013\t\tbB\u0001\u000bI_>$\u0017.Z\"mS\u0016tG\u000fV3ti\n\u000b7/\u001a\u0005\u0006'\u0001!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"A\u0006\u0001\u000e\u0003\tA\u0011\u0002\u0007\u0001A\u0002\u0003\u0007I\u0011A\r\u0002\u000bM\u0004\u0018M]6\u0016\u0003i\u0001\"aG\u0010\u000e\u0003qQ!!\b\u0010\u0002\u0007M\fHN\u0003\u0002\u0019\r%\u0011\u0001\u0005\b\u0002\r'B\f'o[*fgNLwN\u001c\u0005\nE\u0001\u0001\r\u00111A\u0005\u0002\r\n\u0011b\u001d9be.|F%Z9\u0015\u0005\u0011R\u0003CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#\u0001B+oSRDqaK\u0011\u0002\u0002\u0003\u0007!$A\u0002yIEBa!\f\u0001!B\u0013Q\u0012AB:qCJ\\\u0007\u0005C\u00040\u0001\t\u0007I\u0011\u0001\u0019\u0002#M|WO]2f)\u0006\u0014G.Z*dQ\u0016l\u0017-F\u00012!\t\u0011T'D\u00014\u0015\t!D$A\u0003usB,7/\u0003\u00027g\tQ1\u000b\u001e:vGR$\u0016\u0010]3\t\ra\u0002\u0001\u0015!\u00032\u0003I\u0019x.\u001e:dKR\u000b'\r\\3TG\",W.\u0019\u0011\t\u000bi\u0002A\u0011I\u001e\u0002\u000bM,G/\u00169\u0015\u0003\u0011B#!O\u001f\u0011\u0005y*U\"A \u000b\u0005\u0001\u000b\u0015aA1qS*\u0011!iQ\u0001\bUV\u0004\u0018\u000e^3s\u0015\t!\u0005\"A\u0003kk:LG/\u0003\u0002G\u007f\tQ!)\u001a4pe\u0016,\u0015m\u00195\t\u000b!\u0003A\u0011I\u001e\u0002\u0011Q,\u0017M\u001d#po:D#a\u0012&\u0011\u0005yZ\u0015B\u0001'@\u0005%\te\r^3s\u000b\u0006\u001c\u0007\u000eC\u0003O\u0001\u0011\u0005q*\u0001\u000fuKN$X*\u001a;bI\u0006$\u0018mQ8mk6t7\u000b^1ug&sG-\u001a=\u0015\u0005\u0011\u0002\u0006\"B)N\u0001\u0004\u0011\u0016\u0001\u0003;fgR\u001c\u0015m]3\u0011\u0005McgB\u0001+`\u001d\t)fL\u0004\u0002W;:\u0011q\u000b\u0018\b\u00031nk\u0011!\u0017\u0006\u00035*\ta\u0001\u0010:p_Rt\u0014\"A\u0005\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\t\u0019AaB\u0003a\u0005!\u0005\u0011-\u0001\u000bUKN$8i\u001c7v[:\u001cF/\u0019;t\u0013:$W\r\u001f\t\u0003-\t4Q!\u0001\u0002\t\u0002\r\u001c2A\u00193h!\t)S-\u0003\u0002gM\t1\u0011I\\=SK\u001a\u0004\"!\n5\n\u0005%4#\u0001D*fe&\fG.\u001b>bE2,\u0007\"B\nc\t\u0003YG#A1\u0007\t5\u0014\u0007I\u001c\u0002\u0014\u0007>dW/\u001c8Ti\u0006$8\u000fV3ti\u000e\u000b7/Z\n\u0005Y\u0012|w\r\u0005\u0002&a&\u0011\u0011O\n\u0002\b!J|G-^2u\u0011!\u0019HN!f\u0001\n\u0003!\u0018!\u0003;bE2,G+\u001f9f+\u0005)\bC\u0001<|\u001b\u00059(B\u0001=z\u0003\u0015iw\u000eZ3m\u0015\tQH!\u0001\u0004d_6lwN\\\u0005\u0003y^\u0014q\u0002S8pI&,G+\u00192mKRK\b/\u001a\u0005\t}2\u0014\t\u0012)A\u0005k\u0006QA/\u00192mKRK\b/\u001a\u0011\t\u0015\u0005\u0005AN!f\u0001\n\u0003\t\u0019!\u0001\tg_J\u001cWMR;mY2{wmU2b]V\u0011\u0011Q\u0001\t\u0004K\u0005\u001d\u0011bAA\u0005M\t9!i\\8mK\u0006t\u0007BCA\u0007Y\nE\t\u0015!\u0003\u0002\u0006\u0005\tbm\u001c:dK\u001a+H\u000e\u001c'pON\u001b\u0017M\u001c\u0011\t\u0015\u0005EAN!f\u0001\n\u0003\t\u0019!\u0001\ntQ>,H\u000e\u001a*fC\u0012Le.T3n_JL\bBCA\u000bY\nE\t\u0015!\u0003\u0002\u0006\u0005\u00192\u000f[8vY\u0012\u0014V-\u00193J]6+Wn\u001c:zA!11\u0003\u001cC\u0001\u00033!\u0002\"a\u0007\u0002 \u0005\u0005\u00121\u0005\t\u0004\u0003;aW\"\u00012\t\rM\f9\u00021\u0001v\u0011!\t\t!a\u0006A\u0002\u0005\u0015\u0001\u0002CA\t\u0003/\u0001\r!!\u0002\t\u0013\u0005\u001dB.!A\u0005\u0002\u0005%\u0012\u0001B2paf$\u0002\"a\u0007\u0002,\u00055\u0012q\u0006\u0005\tg\u0006\u0015\u0002\u0013!a\u0001k\"Q\u0011\u0011AA\u0013!\u0003\u0005\r!!\u0002\t\u0015\u0005E\u0011Q\u0005I\u0001\u0002\u0004\t)\u0001C\u0005\u000241\f\n\u0011\"\u0001\u00026\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u001cU\r)\u0018\u0011H\u0016\u0003\u0003w\u0001B!!\u0010\u0002H5\u0011\u0011q\b\u0006\u0005\u0003\u0003\n\u0019%A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\t\u0014\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002J\u0005}\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011Q\n7\u0012\u0002\u0013\u0005\u0011qJ\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t\tF\u000b\u0003\u0002\u0006\u0005e\u0002\"CA+YF\u0005I\u0011AA(\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIMB\u0011\"!\u0017m\u0003\u0003%\t%a\u0017\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ti\u0006\u0005\u0003\u0002`\u0005%TBAA1\u0015\u0011\t\u0019'!\u001a\u0002\t1\fgn\u001a\u0006\u0003\u0003O\nAA[1wC&!\u00111NA1\u0005\u0019\u0019FO]5oO\"I\u0011q\u000e7\u0002\u0002\u0013\u0005\u0011\u0011O\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003g\u00022!JA;\u0013\r\t9H\n\u0002\u0004\u0013:$\b\"CA>Y\u0006\u0005I\u0011AA?\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a \u0002\u0006B\u0019Q%!!\n\u0007\u0005\reEA\u0002B]fD\u0011bKA=\u0003\u0003\u0005\r!a\u001d\t\u0013\u0005%E.!A\u0005B\u0005-\u0015a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u00055\u0005CBAH\u0003+\u000by(\u0004\u0002\u0002\u0012*\u0019\u00111\u0013\u0014\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0018\u0006E%\u0001C%uKJ\fGo\u001c:\t\u0013\u0005mE.!A\u0005\u0002\u0005u\u0015\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\u0015\u0011q\u0014\u0005\nW\u0005e\u0015\u0011!a\u0001\u0003\u007fB\u0011\"a)m\u0003\u0003%\t%!*\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a\u001d\t\u0013\u0005%F.!A\u0005B\u0005-\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005u\u0003\"CAXY\u0006\u0005I\u0011IAY\u0003\u0019)\u0017/^1mgR!\u0011QAAZ\u0011%Y\u0013QVA\u0001\u0002\u0004\tyhB\u0005\u00028\n\f\t\u0011#\u0001\u0002:\u0006\u00192i\u001c7v[:\u001cF/\u0019;t)\u0016\u001cHoQ1tKB!\u0011QDA^\r!i'-!A\t\u0002\u0005u6#BA^\u0003\u007f;\u0007cCAa\u0003\u000f,\u0018QAA\u0003\u00037i!!a1\u000b\u0007\u0005\u0015g%A\u0004sk:$\u0018.\\3\n\t\u0005%\u00171\u0019\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001c\u0004bB\n\u0002<\u0012\u0005\u0011Q\u001a\u000b\u0003\u0003sC!\"!+\u0002<\u0006\u0005IQIAV\u0011)\t\u0019.a/\u0002\u0002\u0013\u0005\u0015Q[\u0001\u0006CB\u0004H.\u001f\u000b\t\u00037\t9.!7\u0002\\\"11/!5A\u0002UD\u0001\"!\u0001\u0002R\u0002\u0007\u0011Q\u0001\u0005\t\u0003#\t\t\u000e1\u0001\u0002\u0006!Q\u0011q\\A^\u0003\u0003%\t)!9\u0002\u000fUt\u0017\r\u001d9msR!\u00111]Ax!\u0015)\u0013Q]Au\u0013\r\t9O\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0011\u0015\nY/^A\u0003\u0003\u000bI1!!<'\u0005\u0019!V\u000f\u001d7fg!Q\u0011\u0011_Ao\u0003\u0003\u0005\r!a\u0007\u0002\u0007a$\u0003\u0007\u0003\u0006\u0002v\u0006m\u0016\u0011!C\u0005\u0003o\f1B]3bIJ+7o\u001c7wKR\u0011\u0011\u0011 \t\u0005\u0003?\nY0\u0003\u0003\u0002~\u0006\u0005$AB(cU\u0016\u001cG\u000fC\u0004\u0003\u0002\t$\tAa\u0001\u0002EQ,7\u000f^'fi\u0006$\u0017\r^1D_2,XN\\*uCR\u001c\u0018J\u001c3fqB\u000b'/Y7t+\t\u0011)\u0001\u0005\u0004\u0003\b\tE!QC\u0007\u0003\u0005\u0013QAAa\u0003\u0003\u000e\u000511\u000f\u001e:fC6TAAa\u0004\u0002f\u0005!Q\u000f^5m\u0013\u0011\u0011\u0019B!\u0003\u0003\rM#(/Z1n!\u0011\u00119B!\t\u000e\u0005\te!\u0002\u0002B\u000e\u0005;\t\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0004\u0005?\t\u0015A\u00029be\u0006l7/\u0003\u0003\u0003$\te!!C!sOVlWM\u001c;t\u0011%\t)PYA\u0001\n\u0013\t9\u0010K\u0004N\u0005S\u0011yC!\r\u0011\t\t]!1F\u0005\u0005\u0005[\u0011IB\u0001\u0007NKRDw\u000eZ*pkJ\u001cW-A\u0003wC2,X\r\f\u0002\u00034\u0005\u0012!\u0011\u0001\u0015\u0004\u001b\n]\u0002\u0003\u0002B\u001d\u0005wi!A!\b\n\t\tu\"Q\u0004\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\bb\u0002B!\u0001\u0011\u0005!1I\u0001.i\u0016\u001cH/T3uC\u0012\fG/Y\"pYVlgn\u0015;biNLe\u000eZ3y!\u0006\u0014H/[1m!J|'.Z2uS>tGc\u0001\u0013\u0003F!A\u0011\u0011\u0003B \u0001\u0004\t)\u0001\u000b\u0005\u0003@\t%#q\nB)!\u0011\u00119Ba\u0013\n\t\t5#\u0011\u0004\u0002\f-\u0006dW/Z*pkJ\u001cW-\u0001\u0005c_>dW-\u00198tY\u0011\u0011\u0019F!\u0016\u001a\u0003\u0005I\u0012\u0001\u0001\u0015\u0005\u0005\u007f\u00119\u0004\u0003\u0004\u0003\\\u0001!\taO\u0001#i\u0016\u001cH\u000fU1scV,G/T3uC\u0012\fG/\u0019*b]\u001e,W\t\u001f;sC\u000e$\u0018n\u001c8)\t\te#q\f\t\u0004}\t\u0005\u0014b\u0001B2\u007f\t!A+Z:u\u0011\u001d\u00119\u0007\u0001C\u0005\u0005S\nQ\u0004Z8Xe&$X-\u00118e-\u0006d\u0017\u000eZ1uK\u000e{G.^7o'R\fGo\u001d\u000b\u0010I\t-$Q\u000eBB\u0005\u000f\u0013YIa$\u0003\u0014\"1\u0011K!\u001aA\u0002IC\u0001Ba\u001c\u0003f\u0001\u0007!\u0011O\u0001\r[\u0016$\u0018\rZ1uC>\u0003Ho\u001d\t\t\u0005g\u0012IHa \u0003\u00009\u0019QE!\u001e\n\u0007\t]d%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005w\u0012iHA\u0002NCBT1Aa\u001e'!\u0011\u0011\u0019H!!\n\t\u0005-$Q\u0010\u0005\t\u0005\u000b\u0013)\u00071\u0001\u0003r\u0005A\u0001.\u001e3j\u001fB$8\u000f\u0003\u0005\u0003\n\n\u0015\u0004\u0019\u0001B@\u00039!\u0017\r^1T_V\u00148-\u001a)bi\"D\u0001B!$\u0003f\u0001\u0007!qP\u0001\u001bKb\u0004Xm\u0019;fI\u000e{Gn\u0015;biN\u001cv.\u001e:dKB\u000bG\u000f\u001b\u0005\t\u0005#\u0013)\u00071\u0001\u0003\u0000\u0005Iq\u000e]3sCRLwN\u001c\u0005\t\u0005+\u0013)\u00071\u0001\u0003\u0018\u0006A1/\u0019<f\u001b>$W\rE\u0002\u001c\u00053K1Aa'\u001d\u0005!\u0019\u0016M^3N_\u0012,\u0007b\u0002BP\u0001\u0011%!\u0011U\u0001\u001eEVLG\u000eZ\"pYVlgn\u0015;biN$\u0016M\u00197f\u001b\u0006tW/\u00197msRQ!1\u0015B]\u0005{\u0013\tN!6\u0011\t\t\u0015&1\u0017\b\u0005\u0005O\u0013yK\u0004\u0003\u0003*\n5fb\u0001,\u0003,&\u0011\u0001DB\u0005\u0003;yI1A!-\u001d\u0003\u001d\u0001\u0018mY6bO\u0016LAA!.\u00038\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0004\u0005cc\u0002\u0002\u0003B^\u0005;\u0003\rAa \u0002\u0013Q\f'\r\\3QCRD\u0007\u0002\u0003B`\u0005;\u0003\rA!1\u0002\u0019%t7\r\\;eK\u0012\u001cu\u000e\\:\u0011\r\t\r'1\u001aB@\u001d\u0011\u0011)M!3\u000f\u0007a\u00139-C\u0001(\u0013\r\u0011\tLJ\u0005\u0005\u0005\u001b\u0014yMA\u0002TKFT1A!-'\u0011!\u0011\u0019N!(A\u0002\t\u0005\u0017aC5oI\u0016DX\rZ\"pYNDqAa6\u0003\u001e\u0002\u0007\u0011'A\u0006j]\u0012,\u0007pU2iK6\f\u0007b\u0002Bn\u0001\u0011%!Q\\\u0001\u0019m\u0006d\u0017\u000eZ1uK\u000e{G.^7o'R\fGo]%oI\u0016DH#\u0003\u0013\u0003`\n\u0005(1\u001dBs\u0011\u0019\t&\u0011\u001ca\u0001%\"A!q\u000eBm\u0001\u0004\u0011\t\b\u0003\u0005\u0003\u000e\ne\u0007\u0019\u0001B@\u0011!\u00119O!7A\u0002\u0005\u0015\u0011a\t<bY&$\u0017\r^3D_2,XN\\*uCR\u001c\u0018iZ1j]N$H)\u0019;b\r&dWm\u001d\u0005\b\u0005W\u0004A\u0011\u0002Bw\u0003]9WM\\3sCR,'+\u00198e_6$\u0015\r^1Ge\u0006lW\r\u0006\u0003\u0003$\n=\bB\u0002\r\u0003j\u0002\u0007!\u0004C\u0004\u0003t\u0002!IA!>\u0002\r\u0005\u001c(j]8o)\u0011\u0011yHa>\t\u0011\te(\u0011\u001fa\u0001\u0005G\u000b!\u0001\u001a4\t\u000f\tu\b\u0001\"\u0003\u0003\u0000\u0006!1o\u001c:u)\u0011\u0011\u0019k!\u0001\t\u0011\te(1 a\u0001\u0005GCqA!@\u0001\t\u0013\u0019)\u0001\u0006\u0004\u0003$\u000e\u001d1\u0011\u0002\u0005\t\u0005s\u001c\u0019\u00011\u0001\u0003$\"A11BB\u0002\u0001\u0004\u0011\t-A\u0006t_J$8i\u001c7v[:\u001c\b\u0002DB\b\u0001A\u0005\t\u0011!A\u0005\u0002\rE\u0011A\u00059s_R,7\r^3eI\t\f7/\u001a)bi\"$B!!\u0018\u0004\u0014!A1f!\u0004\u0002\u0002\u0003\u0007Q\u0003K\u0004\u0001\u0007/\u0011yc!\b\u0011\u0007y\u001aI\"C\u0002\u0004\u001c}\u00121\u0001V1hC\u0005\u0019\u0001")
public class TestColumnStatsIndex
extends HoodieClientTestBase {
    private SparkSession spark;
    private final StructType sourceTableSchema = new StructType().add("c1", (DataType)IntegerType$.MODULE$).add("c2", (DataType)StringType$.MODULE$).add("c3", (DataType)new DecimalType(9, 3)).add("c4", (DataType)TimestampType$.MODULE$).add("c5", (DataType)ShortType$.MODULE$).add("c6", (DataType)DateType$.MODULE$).add("c7", (DataType)BinaryType$.MODULE$).add("c8", (DataType)ByteType$.MODULE$);

    public static Stream<Arguments> testMetadataColumnStatsIndexParams() {
        return TestColumnStatsIndex$.MODULE$.testMetadataColumnStatsIndexParams();
    }

    public /* synthetic */ String protected$basePath(TestColumnStatsIndex x$1) {
        return x$1.basePath;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    public StructType sourceTableSchema() {
        return this.sourceTableSchema;
    }

    @BeforeEach
    public void setUp() {
        this.initPath();
        this.initSparkContexts();
        this.initFileSystem();
        this.setTableName("hoodie_test");
        this.initMetaClient();
        this.spark_$eq(this.sqlContext.sparkSession());
    }

    @AfterEach
    public void tearDown() {
        this.cleanupFileSystem();
        this.cleanupSparkContexts();
    }

    @ParameterizedTest
    @MethodSource(value={"testMetadataColumnStatsIndexParams"})
    public void testMetadataColumnStatsIndex(ColumnStatsTestCase testCase) {
        scala.collection.immutable.Map metadataOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key()), (Object)"true")}));
        scala.collection.immutable.Map commonOpts = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)testCase.tableType().toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"c1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"c1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_FULL_SCAN_LOG_FILES.key()), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)testCase.forceFullLogScan())).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieTableConfig.POPULATE_META_FIELDS.key()), (Object)"true")}))).$plus$plus((GenTraversableOnce)metadataOpts);
        this.doWriteAndValidateColumnStats(testCase, (scala.collection.immutable.Map<String, String>)metadataOpts, (scala.collection.immutable.Map<String, String>)commonOpts, "index/colstats/input-table-json", "index/colstats/column-stats-index-table.json", DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite);
        this.doWriteAndValidateColumnStats(testCase, (scala.collection.immutable.Map<String, String>)metadataOpts, (scala.collection.immutable.Map<String, String>)commonOpts, "index/colstats/another-input-table-json", "index/colstats/updated-column-stats-index-table.json", DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Append);
        HoodieTableType hoodieTableType = testCase.tableType();
        HoodieTableType hoodieTableType2 = HoodieTableType.COPY_ON_WRITE;
        String expectedColStatsSourcePath = !(hoodieTableType != null ? !hoodieTableType.equals(hoodieTableType2) : hoodieTableType2 != null) ? "index/colstats/cow-updated2-column-stats-index-table.json" : "index/colstats/mor-updated2-column-stats-index-table.json";
        this.doWriteAndValidateColumnStats(testCase, (scala.collection.immutable.Map<String, String>)metadataOpts, (scala.collection.immutable.Map<String, String>)commonOpts, "index/colstats/update-input-table-json", expectedColStatsSourcePath, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testMetadataColumnStatsIndexPartialProjection(boolean shouldReadInMemory) {
        Seq targetColumnsToIndex = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2", "c3"}));
        scala.collection.immutable.Map metadataOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.COLUMN_STATS_INDEX_FOR_COLUMNS.key()), (Object)targetColumnsToIndex.mkString(","))}));
        scala.collection.immutable.Map opts = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"c1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"c1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieTableConfig.POPULATE_META_FIELDS.key()), (Object)"true")}))).$plus$plus((GenTraversableOnce)metadataOpts);
        String sourceJSONTablePath = ((Object)((Object)this)).getClass().getClassLoader().getResource("index/colstats/input-table-json").toString();
        Dataset inputDF = this.spark().read().schema(this.sourceTableSchema()).json(sourceJSONTablePath);
        inputDF.sort("c1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).repartition(4, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{new Column("c1")})).write().format("hudi").options((Map)opts).option(HoodieStorageConfig.PARQUET_MAX_FILE_SIZE.key(), 10240L).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath);
        ((HoodieClientTestHarness)this).metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().fromProperties((Properties)HoodieConversionUtils$.MODULE$.toProperties(metadataOpts)).build();
        Seq requestedColumns = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c4"}));
        ColumnStatsIndexSupport columnStatsIndex = new ColumnStatsIndexSupport(this.spark(), this.sourceTableSchema(), metadataConfig, this.metaClient, ColumnStatsIndexSupport$.MODULE$.$lessinit$greater$default$5());
        columnStatsIndex.loadTransposed(requestedColumns, shouldReadInMemory, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Dataset<Row> emptyTransposedColStatsDF) {
                Assertions.assertEquals((int)0, (int)((Row[])emptyTransposedColStatsDF.collect()).length);
            }
        });
        Seq requestedColumns2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c4", "c1"}));
        StructType expectedColStatsSchema = ColumnStatsIndexSupport$.MODULE$.composeIndexSchema((Seq)requestedColumns2.sorted((Ordering)Ordering.String$.MODULE$), this.sourceTableSchema());
        Dataset expectedColStatsIndexTableDf = this.spark().read().schema(expectedColStatsSchema).json(((Object)((Object)this)).getClass().getClassLoader().getResource("index/colstats/partial-column-stats-index-table.json").toString());
        Dataset<Row> manualColStatsTableDF = this.org$apache$hudi$functional$TestColumnStatsIndex$$buildColumnStatsTableManually(this.basePath, (Seq<String>)requestedColumns2, (Seq<String>)targetColumnsToIndex, expectedColStatsSchema);
        ColumnStatsIndexSupport columnStatsIndex2 = new ColumnStatsIndexSupport(this.spark(), this.sourceTableSchema(), metadataConfig, this.metaClient, ColumnStatsIndexSupport$.MODULE$.$lessinit$greater$default$5());
        columnStatsIndex2.loadTransposed(requestedColumns2, shouldReadInMemory, (Function1)new Serializable(this, expectedColStatsIndexTableDf, manualColStatsTableDF){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestColumnStatsIndex $outer;
            private final Dataset expectedColStatsIndexTableDf$1;
            private final Dataset manualColStatsTableDF$1;

            public final void apply(Dataset<Row> partialTransposedColStatsDF) {
                Assertions.assertEquals((Object)this.expectedColStatsIndexTableDf$1.schema(), (Object)partialTransposedColStatsDF.schema());
                Assertions.assertEquals((Object)this.$outer.org$apache$hudi$functional$TestColumnStatsIndex$$asJson(this.$outer.org$apache$hudi$functional$TestColumnStatsIndex$$sort((Dataset<Row>)this.expectedColStatsIndexTableDf$1)), (Object)this.$outer.org$apache$hudi$functional$TestColumnStatsIndex$$asJson(this.$outer.org$apache$hudi$functional$TestColumnStatsIndex$$sort((Dataset<Row>)partialTransposedColStatsDF.drop("fileName"))));
                Assertions.assertEquals((Object)this.$outer.org$apache$hudi$functional$TestColumnStatsIndex$$asJson(this.$outer.org$apache$hudi$functional$TestColumnStatsIndex$$sort((Dataset<Row>)this.manualColStatsTableDF$1)), (Object)this.$outer.org$apache$hudi$functional$TestColumnStatsIndex$$asJson(this.$outer.org$apache$hudi$functional$TestColumnStatsIndex$$sort(partialTransposedColStatsDF)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expectedColStatsIndexTableDf$1 = expectedColStatsIndexTableDf$1;
                this.manualColStatsTableDF$1 = manualColStatsTableDF$1;
            }
        });
        Seq missingCols = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c2", "c3"}));
        StructType partialSourceTableSchema = new StructType((StructField[])Predef$.MODULE$.refArrayOps((Object[])this.sourceTableSchema().fields()).filterNot((Function1)new Serializable(this, missingCols){
            public static final long serialVersionUID = 0L;
            private final Seq missingCols$1;

            public final boolean apply(StructField f) {
                return this.missingCols$1.contains((Object)f.name());
            }
            {
                this.missingCols$1 = missingCols$1;
            }
        }));
        String updateJSONTablePath = ((Object)((Object)this)).getClass().getClassLoader().getResource("index/colstats/partial-another-input-table-json").toString();
        Dataset updateDF = this.spark().read().schema(partialSourceTableSchema).json(updateJSONTablePath);
        updateDF.repartition(4).write().format("hudi").options((Map)opts).option(HoodieStorageConfig.PARQUET_MAX_FILE_SIZE.key(), 10240L).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        ((HoodieClientTestHarness)this).metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        String[] requestedColumns3 = this.sourceTableSchema().fieldNames();
        StructType expectedColStatsSchema2 = ColumnStatsIndexSupport$.MODULE$.composeIndexSchema((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])requestedColumns3).sorted((Ordering)Ordering.String$.MODULE$)), this.sourceTableSchema());
        Dataset expectedColStatsIndexUpdatedDF = this.spark().read().schema(expectedColStatsSchema2).json(((Object)((Object)this)).getClass().getClassLoader().getResource("index/colstats/updated-partial-column-stats-index-table.json").toString());
        Dataset<Row> manualUpdatedColStatsTableDF = this.org$apache$hudi$functional$TestColumnStatsIndex$$buildColumnStatsTableManually(this.basePath, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])requestedColumns3), (Seq<String>)targetColumnsToIndex, expectedColStatsSchema2);
        ColumnStatsIndexSupport columnStatsIndex3 = new ColumnStatsIndexSupport(this.spark(), this.sourceTableSchema(), metadataConfig, this.metaClient, ColumnStatsIndexSupport$.MODULE$.$lessinit$greater$default$5());
        columnStatsIndex3.loadTransposed((Seq)Predef$.MODULE$.wrapRefArray((Object[])requestedColumns3), shouldReadInMemory, (Function1)new Serializable(this, expectedColStatsIndexUpdatedDF, manualUpdatedColStatsTableDF){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestColumnStatsIndex $outer;
            private final Dataset expectedColStatsIndexUpdatedDF$1;
            private final Dataset manualUpdatedColStatsTableDF$1;

            public final void apply(Dataset<Row> transposedUpdatedColStatsDF) {
                Assertions.assertEquals((Object)this.expectedColStatsIndexUpdatedDF$1.schema(), (Object)transposedUpdatedColStatsDF.schema());
                Assertions.assertEquals((Object)this.$outer.org$apache$hudi$functional$TestColumnStatsIndex$$asJson(this.$outer.org$apache$hudi$functional$TestColumnStatsIndex$$sort((Dataset<Row>)this.expectedColStatsIndexUpdatedDF$1)), (Object)this.$outer.org$apache$hudi$functional$TestColumnStatsIndex$$asJson(this.$outer.org$apache$hudi$functional$TestColumnStatsIndex$$sort((Dataset<Row>)transposedUpdatedColStatsDF.drop("fileName"))));
                Assertions.assertEquals((Object)this.$outer.org$apache$hudi$functional$TestColumnStatsIndex$$asJson(this.$outer.org$apache$hudi$functional$TestColumnStatsIndex$$sort((Dataset<Row>)this.manualUpdatedColStatsTableDF$1)), (Object)this.$outer.org$apache$hudi$functional$TestColumnStatsIndex$$asJson(this.$outer.org$apache$hudi$functional$TestColumnStatsIndex$$sort(transposedUpdatedColStatsDF)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expectedColStatsIndexUpdatedDF$1 = expectedColStatsIndexUpdatedDF$1;
                this.manualUpdatedColStatsTableDF$1 = manualUpdatedColStatsTableDF$1;
            }
        });
    }

    @Test
    public void testParquetMetadataRangeExtraction() {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            Object object = new Object();
            try {
                Dataset<Row> df = this.generateRandomDataFrame(this.spark());
                String pathStr = ((Object)this.tempDir.resolve("min-max").toAbsolutePath()).toString();
                df.write().format("parquet").mode(SaveMode.Overwrite).save(pathStr);
                ParquetUtils utils = new ParquetUtils();
                Configuration conf = new Configuration();
                Path path = new Path(pathStr);
                FileSystem fs = path.getFileSystem(conf);
                Path parquetFilePath = ((FileStatus)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(path)).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(FileStatus fs) {
                        return fs.getPath().getName().endsWith(".parquet");
                    }
                })).toSeq().head()).getPath();
                List ranges = utils.readRangeFromParquetMetadata(conf, parquetFilePath, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2", "c3a", "c3b", "c3c", "c4", "c5", "c6", "c7", "c8"}))).asJava());
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ranges).asScala()).foreach((Function1)new Serializable(this, object){
                    public static final long serialVersionUID = 0L;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(HoodieColumnRangeMetadata<Comparable<?>> r) {
                        if (r.getColumnName().equals("c4")) {
                            throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                        }
                        Comparable min = r.getMinValue();
                        Comparable max = r.getMaxValue();
                        Assertions.assertNotNull((Object)min);
                        Assertions.assertNotNull((Object)max);
                        Assertions.assertTrue((r.getMinValue().compareTo(r.getMaxValue()) <= 0 ? 1 : 0) != 0);
                    }
                    {
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                nonLocalReturnControl2.value$mcV$sp();
            }
            return;
        }
        throw nonLocalReturnControl2;
    }

    private void doWriteAndValidateColumnStats(ColumnStatsTestCase testCase, scala.collection.immutable.Map<String, String> metadataOpts, scala.collection.immutable.Map<String, String> hudiOpts, String dataSourcePath, String expectedColStatsSourcePath, String operation, SaveMode saveMode) {
        String sourceJSONTablePath = ((Object)((Object)this)).getClass().getClassLoader().getResource(dataSourcePath).toString();
        Dataset inputDF = this.spark().read().schema(this.sourceTableSchema()).json(sourceJSONTablePath);
        inputDF.sort("c1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).repartition(4, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{new Column("c1")})).write().format("hudi").options(hudiOpts).option(HoodieStorageConfig.PARQUET_MAX_FILE_SIZE.key(), 10240L).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), operation).mode(saveMode).save(this.basePath);
        ((HoodieClientTestHarness)this).metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieTableType hoodieTableType = testCase.tableType();
        HoodieTableType hoodieTableType2 = HoodieTableType.COPY_ON_WRITE;
        boolean validateColumnStatsAgainstDataFiles = !(hoodieTableType == null ? hoodieTableType2 != null : !hoodieTableType.equals(hoodieTableType2)) || operation.equals(DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL());
        this.validateColumnStatsIndex(testCase, metadataOpts, expectedColStatsSourcePath, validateColumnStatsAgainstDataFiles);
    }

    public Dataset<Row> org$apache$hudi$functional$TestColumnStatsIndex$$buildColumnStatsTableManually(String tablePath, Seq<String> includedCols, Seq<String> indexedCols, StructType indexSchema) {
        RemoteIterator it = this.fs.listFiles(new Path(tablePath), true);
        Seq seq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (it.hasNext()) {
            seq = (Seq)seq.$colon$plus(it.next(), Seq$.MODULE$.canBuildFrom());
        }
        Seq files = (Seq)seq.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(LocatedFileStatus fs) {
                return fs.getPath().getName().endsWith(".parquet");
            }
        });
        return this.spark().createDataFrame((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)files.flatMap((Function1)new Serializable(this, includedCols, indexedCols){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestColumnStatsIndex $outer;
            public final Seq includedCols$1;
            public final Seq indexedCols$1;

            public final ArrayOps<Row> apply(LocatedFileStatus file) {
                Dataset df = this.$outer.spark().read().schema(this.$outer.sourceTableSchema()).parquet(file.getPath().toString());
                Object[] objectArray = new Object[1];
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestColumnStatsIndex.class.getClassLoader());
                public final class Org_apache_hudi_functional_TestColumnStatsIndex$$anonfun$org$apache$hudi$functional$TestColumnStatsIndex$$buildColumnStatsTableManually$1$$typecreator1$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("java.lang.String").asType().toTypeConstructor();
                    }

                    public Org_apache_hudi_functional_TestColumnStatsIndex$$anonfun$org$apache$hudi$functional$TestColumnStatsIndex$$buildColumnStatsTableManually$1$$typecreator1$1($anonfun$org$apache$hudi$functional$TestColumnStatsIndex$$buildColumnStatsTableManually$1 $outer) {
                    }
                }
                objectArray[0] = functions$.MODULE$.typedLit((Object)file.getPath().getName(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_functional_TestColumnStatsIndex$$anonfun$org$apache$hudi$functional$TestColumnStatsIndex$$buildColumnStatsTableManually$1$$typecreator1$1(this)));
                String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' AS file"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray));
                String string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sum(1) AS valueCount"})).s((Seq)Nil$.MODULE$);
                Seq exprs = (Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])df.columns()).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$org$apache$hudi$functional$TestColumnStatsIndex$$buildColumnStatsTableManually$1 $outer;

                    public final boolean apply(String col) {
                        return this.$outer.includedCols$1.contains((Object)col);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                })).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$org$apache$hudi$functional$TestColumnStatsIndex$$buildColumnStatsTableManually$1 $outer;

                    public final Seq<String> apply(String col) {
                        String minColName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_minValue"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{col}));
                        String maxColName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_maxValue"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{col}));
                        return this.$outer.indexedCols$1.contains((Object)col) ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"min(", ") AS ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{col, minColName})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"max(", ") AS ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{col, maxColName})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sum(cast(isnull(", ") AS long)) AS ", "_nullCount"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{col, col}))})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"null AS ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{minColName})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"null AS ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{maxColName})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"null AS ", "_nullCount"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{col}))}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).$plus$colon((Object)string2, ClassTag$.MODULE$.apply(String.class))).$plus$colon((Object)string, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
                return Predef$.MODULE$.refArrayOps((Object[])df.selectExpr(exprs).collect());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.includedCols$1 = includedCols$1;
                this.indexedCols$1 = indexedCols$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).asJava(), indexSchema);
    }

    private void validateColumnStatsIndex(ColumnStatsTestCase testCase, scala.collection.immutable.Map<String, String> metadataOpts, String expectedColStatsSourcePath, boolean validateColumnStatsAgainstDataFiles) {
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().fromProperties((Properties)HoodieConversionUtils$.MODULE$.toProperties(metadataOpts)).build();
        ColumnStatsIndexSupport columnStatsIndex = new ColumnStatsIndexSupport(this.spark(), this.sourceTableSchema(), metadataConfig, this.metaClient, ColumnStatsIndexSupport$.MODULE$.$lessinit$greater$default$5());
        StructType expectedColStatsSchema = ColumnStatsIndexSupport$.MODULE$.composeIndexSchema((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.sourceTableSchema().fieldNames()), this.sourceTableSchema());
        Seq validationSortColumns = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c1_maxValue", "c1_minValue", "c2_maxValue", "c2_minValue"}));
        columnStatsIndex.loadTransposed((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.sourceTableSchema().fieldNames()), testCase.shouldReadInMemory(), (Function1)new Serializable(this, expectedColStatsSourcePath, validateColumnStatsAgainstDataFiles, expectedColStatsSchema, validationSortColumns){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestColumnStatsIndex $outer;
            private final String expectedColStatsSourcePath$1;
            private final boolean validateColumnStatsAgainstDataFiles$1;
            private final StructType expectedColStatsSchema$1;
            private final Seq validationSortColumns$1;

            public final void apply(Dataset<Row> transposedColStatsDF) {
                Dataset expectedColStatsIndexTableDf = this.$outer.spark().read().schema(this.expectedColStatsSchema$1).json(((Object)((Object)this.$outer)).getClass().getClassLoader().getResource(this.expectedColStatsSourcePath$1).toString());
                Assertions.assertEquals((Object)expectedColStatsIndexTableDf.schema(), (Object)transposedColStatsDF.schema());
                Assertions.assertEquals((Object)this.$outer.org$apache$hudi$functional$TestColumnStatsIndex$$asJson(this.$outer.org$apache$hudi$functional$TestColumnStatsIndex$$sort((Dataset<Row>)expectedColStatsIndexTableDf, (Seq<String>)this.validationSortColumns$1)), (Object)this.$outer.org$apache$hudi$functional$TestColumnStatsIndex$$asJson(this.$outer.org$apache$hudi$functional$TestColumnStatsIndex$$sort((Dataset<Row>)transposedColStatsDF.drop("fileName"), (Seq<String>)this.validationSortColumns$1)));
                if (this.validateColumnStatsAgainstDataFiles$1) {
                    Dataset<Row> manualColStatsTableDF = this.$outer.org$apache$hudi$functional$TestColumnStatsIndex$$buildColumnStatsTableManually(this.$outer.protected$basePath(this.$outer), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])this.$outer.sourceTableSchema().fieldNames()), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])this.$outer.sourceTableSchema().fieldNames()), this.expectedColStatsSchema$1);
                    Assertions.assertEquals((Object)this.$outer.org$apache$hudi$functional$TestColumnStatsIndex$$asJson(this.$outer.org$apache$hudi$functional$TestColumnStatsIndex$$sort(manualColStatsTableDF, (Seq<String>)this.validationSortColumns$1)), (Object)this.$outer.org$apache$hudi$functional$TestColumnStatsIndex$$asJson(this.$outer.org$apache$hudi$functional$TestColumnStatsIndex$$sort(transposedColStatsDF, (Seq<String>)this.validationSortColumns$1)));
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expectedColStatsSourcePath$1 = expectedColStatsSourcePath$1;
                this.validateColumnStatsAgainstDataFiles$1 = validateColumnStatsAgainstDataFiles$1;
                this.expectedColStatsSchema$1 = expectedColStatsSchema$1;
                this.validationSortColumns$1 = validationSortColumns$1;
            }
        });
    }

    private Dataset<Row> generateRandomDataFrame(SparkSession spark) {
        StructType sourceTableSchema = new StructType().add("c1", (DataType)IntegerType$.MODULE$).add("c2", (DataType)StringType$.MODULE$).add("c3a", (DataType)new DecimalType(9, 3)).add("c3b", (DataType)new DecimalType(10, 3)).add("c3c", (DataType)new DecimalType(20, 3)).add("c4", (DataType)TimestampType$.MODULE$).add("c5", (DataType)ShortType$.MODULE$).add("c6", (DataType)DateType$.MODULE$).add("c7", (DataType)BinaryType$.MODULE$).add("c8", (DataType)ByteType$.MODULE$);
        RDD rdd = spark.sparkContext().parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 1000), 1, ClassTag$.MODULE$.Int()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(int item) {
                Integer c1 = item;
                String c2 = Random$.MODULE$.nextString(10);
                BigDecimal c3a = BigDecimal.valueOf(Random$.MODULE$.nextInt() % 0x1000000, 3);
                BigDecimal c3b = BigDecimal.valueOf(Random$.MODULE$.nextLong() % 0x100000000L, 3);
                BigDecimal c3c = new BigDecimal(new BigInteger(64, new Random()), 3);
                Timestamp c4 = new Timestamp(System.currentTimeMillis());
                Short c5 = Short.valueOf(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((item + 16) / 10))})));
                Date c6 = Date.valueOf(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2020), BoxesRunTime.boxToInteger((int)(item % 11 + 1)), BoxesRunTime.boxToInteger((int)(item % 28 + 1))})));
                byte[] c7 = (byte[])Predef$.MODULE$.intArrayOps(new int[]{item}).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final byte apply(int x$3) {
                        return (byte)x$3;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
                Byte c8 = Byte.valueOf("9");
                return RowFactory.create((Object[])new Object[]{c1, c2, c3a, c3b, c3c, c4, c5, c6, c7, c8});
            }
        }, ClassTag$.MODULE$.apply(Row.class));
        return spark.createDataFrame(rdd, sourceTableSchema);
    }

    public String org$apache$hudi$functional$TestColumnStatsIndex$$asJson(Dataset<Row> df) {
        return ((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])df.toJSON().select("value", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect()).toSeq().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Row x$4) {
                return x$4.getString(0);
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
    }

    public Dataset<Row> org$apache$hudi$functional$TestColumnStatsIndex$$sort(Dataset<Row> df) {
        return this.org$apache$hudi$functional$TestColumnStatsIndex$$sort(df, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c1_maxValue", "c1_minValue"}))));
    }

    public Dataset<Row> org$apache$hudi$functional$TestColumnStatsIndex$$sort(Dataset<Row> df, Seq<String> sortColumns) {
        String[] sortedCols = (String[])Predef$.MODULE$.refArrayOps((Object[])df.columns()).sorted((Ordering)Ordering.String$.MODULE$);
        return df.select((String)Predef$.MODULE$.refArrayOps((Object[])sortedCols).head(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])sortedCols).tail())).sort((String)sortColumns.head(), (Seq)sortColumns.tail());
    }

    public static class ColumnStatsTestCase
    implements Product,
    Serializable {
        private final HoodieTableType tableType;
        private final boolean forceFullLogScan;
        private final boolean shouldReadInMemory;

        public HoodieTableType tableType() {
            return this.tableType;
        }

        public boolean forceFullLogScan() {
            return this.forceFullLogScan;
        }

        public boolean shouldReadInMemory() {
            return this.shouldReadInMemory;
        }

        public ColumnStatsTestCase copy(HoodieTableType tableType, boolean forceFullLogScan, boolean shouldReadInMemory) {
            return new ColumnStatsTestCase(tableType, forceFullLogScan, shouldReadInMemory);
        }

        public HoodieTableType copy$default$1() {
            return this.tableType();
        }

        public boolean copy$default$2() {
            return this.forceFullLogScan();
        }

        public boolean copy$default$3() {
            return this.shouldReadInMemory();
        }

        public String productPrefix() {
            return "ColumnStatsTestCase";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 2: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.shouldReadInMemory());
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.forceFullLogScan());
                    break;
                }
                case 0: {
                    object = this.tableType();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ColumnStatsTestCase;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.tableType()));
            n = Statics.mix((int)n, (int)(this.forceFullLogScan() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.shouldReadInMemory() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ColumnStatsTestCase)) return false;
            boolean bl = true;
            if (!bl) return false;
            ColumnStatsTestCase columnStatsTestCase = (ColumnStatsTestCase)x$1;
            HoodieTableType hoodieTableType = this.tableType();
            HoodieTableType hoodieTableType2 = columnStatsTestCase.tableType();
            if (hoodieTableType == null) {
                if (hoodieTableType2 != null) {
                    return false;
                }
            } else if (!hoodieTableType.equals(hoodieTableType2)) return false;
            if (this.forceFullLogScan() != columnStatsTestCase.forceFullLogScan()) return false;
            if (this.shouldReadInMemory() != columnStatsTestCase.shouldReadInMemory()) return false;
            if (!columnStatsTestCase.canEqual(this)) return false;
            return true;
        }

        public ColumnStatsTestCase(HoodieTableType tableType, boolean forceFullLogScan, boolean shouldReadInMemory) {
            this.tableType = tableType;
            this.forceFullLogScan = forceFullLogScan;
            this.shouldReadInMemory = shouldReadInMemory;
            Product.class.$init$((Product)this);
        }
    }
}

