/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.time.Instant;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieDataSourceHelpers;
import org.apache.hudi.bootstrap.SparkParquetBootstrapDataProvider;
import org.apache.hudi.client.bootstrap.selector.FullRecordBootstrapModeSelector;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.config.HoodieBootstrapConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.functional.TestBootstrap;
import org.apache.hudi.keygen.NonpartitionedKeyGenerator;
import org.apache.hudi.keygen.SimpleKeyGenerator;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}h\u0001B\u0001\u0003\u0001-\u0011!\u0004V3ti\u0012\u000bG/Y*pkJ\u001cWMR8s\u0005>|Go\u001d;sCBT!a\u0001\u0003\u0002\u0015\u0019,hn\u0019;j_:\fGN\u0003\u0002\u0006\r\u0005!\u0001.\u001e3j\u0015\t9\u0001\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0004\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\f\u0001\u001b\u0005\u0011\u0001\"\u0003\r\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u001a\u0003\u0015\u0019\b/\u0019:l+\u0005Q\u0002CA\u000e \u001b\u0005a\"BA\u000f\u001f\u0003\r\u0019\u0018\u000f\u001c\u0006\u00031\u0019I!\u0001\t\u000f\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\u0013\t\u0002\u0001\u0019!a\u0001\n\u0003\u0019\u0013!C:qCJ\\w\fJ3r)\t!s\u0005\u0005\u0002\u000eK%\u0011aE\u0004\u0002\u0005+:LG\u000fC\u0004)C\u0005\u0005\t\u0019\u0001\u000e\u0002\u0007a$\u0013\u0007\u0003\u0004+\u0001\u0001\u0006KAG\u0001\u0007gB\f'o\u001b\u0011\t\u000f1\u0002!\u0019!C\u0001[\u0005Q1m\\7n_:|\u0005\u000f^:\u0016\u00039\u0002Ba\f\u001a6k9\u0011Q\u0002M\u0005\u0003c9\ta\u0001\u0015:fI\u00164\u0017BA\u001a5\u0005\ri\u0015\r\u001d\u0006\u0003c9\u0001\"a\f\u001c\n\u0005]\"$AB*ue&tw\r\u0003\u0004:\u0001\u0001\u0006IAL\u0001\fG>lWn\u001c8PaR\u001c\b\u0005C\u0005<\u0001\u0001\u0007\t\u0019!C\u0001y\u0005A!-Y:f!\u0006$\b.F\u00016\u0011%q\u0004\u00011AA\u0002\u0013\u0005q(\u0001\u0007cCN,\u0007+\u0019;i?\u0012*\u0017\u000f\u0006\u0002%\u0001\"9\u0001&PA\u0001\u0002\u0004)\u0004B\u0002\"\u0001A\u0003&Q'A\u0005cCN,\u0007+\u0019;iA!IA\t\u0001a\u0001\u0002\u0004%\t\u0001P\u0001\bgJ\u001c\u0007+\u0019;i\u0011%1\u0005\u00011AA\u0002\u0013\u0005q)A\u0006te\u000e\u0004\u0016\r\u001e5`I\u0015\fHC\u0001\u0013I\u0011\u001dAS)!AA\u0002UBaA\u0013\u0001!B\u0013)\u0014\u0001C:sGB\u000bG\u000f\u001b\u0011\t\u00131\u0003\u0001\u0019!a\u0001\n\u0003i\u0015A\u00014t+\u0005q\u0005CA(T\u001b\u0005\u0001&B\u0001'R\u0015\t\u0011f!\u0001\u0004iC\u0012|w\u000e]\u0005\u0003)B\u0013!BR5mKNK8\u000f^3n\u0011%1\u0006\u00011AA\u0002\u0013\u0005q+\u0001\u0004gg~#S-\u001d\u000b\u0003IaCq\u0001K+\u0002\u0002\u0003\u0007a\n\u0003\u0004[\u0001\u0001\u0006KAT\u0001\u0004MN\u0004\u0003b\u0002/\u0001\u0005\u0004%\t!X\u0001\u000fa\u0006\u0014H/\u001b;j_:\u0004\u0016\r\u001e5t+\u0005q\u0006cA0hk9\u0011\u0001-\u001a\b\u0003C\u0012l\u0011A\u0019\u0006\u0003G*\ta\u0001\u0010:p_Rt\u0014\"A\b\n\u0005\u0019t\u0011a\u00029bG.\fw-Z\u0005\u0003Q&\u0014A\u0001T5ti*\u0011aM\u0004\u0005\u0007W\u0002\u0001\u000b\u0011\u00020\u0002\u001fA\f'\u000f^5uS>t\u0007+\u0019;ig\u0002Bq!\u001c\u0001C\u0002\u0013\u0005a.\u0001\u0006ok6\u0014VmY8sIN,\u0012a\u001c\t\u0003\u001bAL!!\u001d\b\u0003\u0007%sG\u000f\u0003\u0004t\u0001\u0001\u0006Ia\\\u0001\f]Vl'+Z2pe\u0012\u001c\b\u0005C\u0004v\u0001\t\u0007I\u0011\u00018\u0002!9,XNU3d_J$7/\u00169eCR,\u0007BB<\u0001A\u0003%q.A\tok6\u0014VmY8sIN,\u0006\u000fZ1uK\u0002Bq!\u001f\u0001C\u0002\u0013\u0005A(\u0001\nwKJLg-[2bi&|gNU8x\u0017\u0016L\bBB>\u0001A\u0003%Q'A\nwKJLg-[2bi&|gNU8x\u0017\u0016L\b\u0005C\u0004~\u0001\t\u0007I\u0011\u0001\u001f\u0002\u001fY,'/\u001b4jG\u0006$\u0018n\u001c8D_2Daa \u0001!\u0002\u0013)\u0014\u0001\u0005<fe&4\u0017nY1uS>t7i\u001c7!\u0011!\t\u0019\u0001\u0001b\u0001\n\u0003a\u0014aF8sS\u001eLg.\u00197WKJLg-[2bi&|gNV1m\u0011\u001d\t9\u0001\u0001Q\u0001\nU\n\u0001d\u001c:jO&t\u0017\r\u001c,fe&4\u0017nY1uS>tg+\u00197!\u0011!\tY\u0001\u0001b\u0001\n\u0003a\u0014AF;qI\u0006$X\r\u001a,fe&4\u0017nY1uS>tg+\u00197\t\u000f\u0005=\u0001\u0001)A\u0005k\u00059R\u000f\u001d3bi\u0016$g+\u001a:jM&\u001c\u0017\r^5p]Z\u000bG\u000e\t\u0005\b\u0003'\u0001A\u0011AA\u000b\u0003)Ig.\u001b;jC2L'0\u001a\u000b\u0004I\u0005]\u0001\u0002CA\r\u0003#\u0001\r!a\u0007\u0002\u000fQ,W\u000e\u001d#jeB!\u0011QDA\u0016\u001b\t\tyB\u0003\u0003\u0002\"\u0005\r\u0012\u0001\u00024jY\u0016TA!!\n\u0002(\u0005\u0019a.[8\u000b\u0005\u0005%\u0012\u0001\u00026bm\u0006LA!!\f\u0002 \t!\u0001+\u0019;iQ\u0011\t9\"!\r\u0011\t\u0005M\u0012QI\u0007\u0003\u0003kQA!a\u000e\u0002:\u0005\u0011\u0011n\u001c\u0006\u0005\u0003w\ti$A\u0002ba&TA!a\u0010\u0002B\u00059!.\u001e9ji\u0016\u0014(bAA\"\u0011\u0005)!.\u001e8ji&!\u0011qIA\u001b\u0005\u001d!V-\u001c9ESJDC!!\u0005\u0002LA!\u0011QJA(\u001b\t\tI$\u0003\u0003\u0002R\u0005e\"A\u0003\"fM>\u0014X-R1dQ\"9\u0011Q\u000b\u0001\u0005\u0002\u0005]\u0013\u0001\u0003;fCJ$un\u001e8\u0015\u0003\u0011BC!a\u0015\u0002\\A!\u0011QJA/\u0013\u0011\ty&!\u000f\u0003\u0013\u00053G/\u001a:FC\u000eD\u0007bBA2\u0001\u0011\u0005\u0011qK\u0001'i\u0016\u001cH/T3uC\u0012\fG/\u0019\"p_R\u001cHO]1q\u0007>;fj\u001c8QCJ$\u0018\u000e^5p]\u0016$\u0007\u0006BA1\u0003O\u0002B!!\u0014\u0002j%!\u00111NA\u001d\u0005\u0011!Vm\u001d;\t\u000f\u0005=\u0004\u0001\"\u0001\u0002r\u0005aC/Z:u\u001b\u0016$\u0018\rZ1uC\n{w\u000e^:ue\u0006\u00048iT,ISZ,7\u000b^=mKB\u000b'\u000f^5uS>tW\r\u001a\u000b\u0004I\u0005M\u0004bBA;\u0003[\u0002\r!N\u0001\u000eE>|Go\u001d;sCBlu\u000eZ3)\u0011\u00055\u0014\u0011PAE\u0003\u0017\u0003B!a\u001f\u0002\u00066\u0011\u0011Q\u0010\u0006\u0005\u0003\u007f\n\t)\u0001\u0005qe>4\u0018\u000eZ3s\u0015\u0011\t\u0019)!\u0010\u0002\rA\f'/Y7t\u0013\u0011\t9)! \u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\u0011\ti)!%\"\u0005\u0005=\u0015!D'F)\u0006#\u0015\tV!`\u001f:c\u0015,\t\u0002\u0002\u0014\u0006Ya)\u0016'M?J+5i\u0014*EQ\u0011\ti'a&\u0011\t\u0005e\u00151T\u0007\u0003\u0003\u0003KA!!(\u0002\u0002\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\t\u000f\u0005\u0005\u0006\u0001\"\u0001\u0002X\u0005\u0019C/Z:u\u001b\u0016$\u0018\rZ1uC\n{w\u000e^:ue\u0006\u00048iT,QCJ$\u0018\u000e^5p]\u0016$\u0007\u0006BAP\u0003OBq!a*\u0001\t\u0003\t9&A\u001buKN$X*\u001a;bI\u0006$\u0018MQ8piN$(/\u00199N\u001fJ\u0003\u0016M\u001d;ji&|g.\u001a3J]2Lg.Z\"p[B\f7\r^5p]>s\u0007\u0006BAS\u0003OBq!!,\u0001\t\u0003\t9&A\u0012uKN$X*\u001a;bI\u0006$\u0018MQ8piN$(/\u00199N\u001fJ\u0003\u0016M\u001d;ji&|g.\u001a3)\t\u0005-\u0016q\r\u0005\b\u0003g\u0003A\u0011AA,\u0003}!Xm\u001d;Gk2d'i\\8ugR\u0014\u0018\r]\"P/B\u000b'\u000f^5uS>tW\r\u001a\u0015\u0005\u0003c\u000b9\u0007C\u0004\u0002:\u0002!\t!a/\u0002GI,h.T3uC\u0012\fG/\u0019\"p_R\u001cHO]1q\u0003:$g+\u001a:jMf\u001cu.\\7jiR9Q'!0\u0002B\u0006\u0015\u0007bBA`\u0003o\u0003\r!N\u0001\ni\u0006\u0014G.\u001a+za\u0016D\u0011\"a1\u00028B\u0005\t\u0019\u0001\u0018\u0002\u0013\u0015DHO]1PaR\u001c\bbBAd\u0003o\u0003\r!N\u0001\u0015E>|Go\u001d;sCB\\U-_4f]\u000ec\u0017m]:\t\u000f\u0005-\u0007\u0001\"\u0001\u0002N\u0006Yb/\u001a:jMfLen\u0019:f[\u0016tG/\u00197WS\u0016<(+Z:vYR$\u0012\u0002JAh\u0003'\f9.!9\t\u000f\u0005E\u0017\u0011\u001aa\u0001k\u0005Q\"m\\8ugR\u0014\u0018\r]\"p[6LG/\u00138ti\u0006tG\u000fV5nK\"9\u0011Q[Ae\u0001\u0004)\u0014a\u00067bi\u0016\u001cHoQ8n[&$\u0018J\\:uC:$H+[7f\u0011!\tI.!3A\u0002\u0005m\u0017!D5t!\u0006\u0014H/\u001b;j_:,G\rE\u0002\u000e\u0003;L1!a8\u000f\u0005\u001d\u0011un\u001c7fC:D\u0001\"a9\u0002J\u0002\u0007\u00111\\\u0001\u0017SND\u0015N^3TifdW\rU1si&$\u0018n\u001c8fI\"I\u0011q\u001d\u0001\u0012\u0002\u0013\u0005\u0011\u0011^\u0001.eVtW*\u001a;bI\u0006$\u0018MQ8piN$(/\u00199B]\u00124VM]5gs\u000e{W.\\5uI\u0011,g-Y;mi\u0012\u0012TCAAvU\rq\u0013Q^\u0016\u0003\u0003_\u0004B!!=\u0002|6\u0011\u00111\u001f\u0006\u0005\u0003k\f90A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011 \b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002~\u0006M(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class TestDataSourceForBootstrap {
    private SparkSession spark;
    private final scala.collection.immutable.Map<String, String> commonOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.INSERT_PARALLELISM_VALUE.key()), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.UPSERT_PARALLELISM_VALUE.key()), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.DELETE_PARALLELISM_VALUE.key()), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.BULKINSERT_PARALLELISM_VALUE.key()), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.FINALIZE_WRITE_PARALLELISM_VALUE.key()), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieBootstrapConfig.PARALLELISM_VALUE.key()), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test")}));
    private String basePath;
    private String srcPath;
    private FileSystem fs;
    private final List<String> partitionPaths = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2020-04-01", "2020-04-02", "2020-04-03"}));
    private final int numRecords;
    private final int numRecordsUpdate;
    private final String verificationRowKey;
    private final String verificationCol;
    private final String originalVerificationVal;
    private final String updatedVerificationVal;

    public SparkSession spark() {
        return this.spark;
    }

    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    public scala.collection.immutable.Map<String, String> commonOpts() {
        return this.commonOpts;
    }

    public String basePath() {
        return this.basePath;
    }

    public void basePath_$eq(String x$1) {
        this.basePath = x$1;
    }

    public String srcPath() {
        return this.srcPath;
    }

    public void srcPath_$eq(String x$1) {
        this.srcPath = x$1;
    }

    public FileSystem fs() {
        return this.fs;
    }

    public void fs_$eq(FileSystem x$1) {
        this.fs = x$1;
    }

    public List<String> partitionPaths() {
        return this.partitionPaths;
    }

    public int numRecords() {
        return this.numRecords;
    }

    public int numRecordsUpdate() {
        return this.numRecordsUpdate;
    }

    public String verificationRowKey() {
        return this.verificationRowKey;
    }

    public String verificationCol() {
        return this.verificationCol;
    }

    public String originalVerificationVal() {
        return this.originalVerificationVal;
    }

    public String updatedVerificationVal() {
        return this.updatedVerificationVal;
    }

    @BeforeEach
    public void initialize(@TempDir java.nio.file.Path tempDir) {
        this.spark_$eq(SparkSession$.MODULE$.builder().appName("Hoodie Datasource test").master("local[2]").config("spark.serializer", "org.apache.spark.serializer.KryoSerializer").getOrCreate());
        this.basePath_$eq(new StringBuilder().append((Object)((Object)tempDir.toAbsolutePath()).toString()).append((Object)"/base").toString());
        this.srcPath_$eq(new StringBuilder().append((Object)((Object)tempDir.toAbsolutePath()).toString()).append((Object)"/src").toString());
        this.fs_$eq(FSUtils.getFs((String)this.basePath(), (Configuration)this.spark().sparkContext().hadoopConfiguration()));
    }

    @AfterEach
    public void tearDown() {
        if (this.spark() != null) {
            this.spark().stop();
            this.spark_$eq(null);
        }
        if (this.fs() != null) {
            this.fs().close();
            this.fs_$eq(null);
        }
    }

    @Test
    public void testMetadataBootstrapCOWNonPartitioned() {
        long timestamp = Instant.now().toEpochMilli();
        JavaSparkContext jsc = JavaSparkContext$.MODULE$.fromSparkContext(this.spark().sparkContext());
        Dataset<Row> sourceDF = TestBootstrap.generateTestRawTripDataset(timestamp, 0, this.numRecords(), Collections.emptyList(), jsc, this.spark().sqlContext());
        sourceDF.write().format("parquet").mode(SaveMode.Overwrite).save(this.srcPath());
        String bootstrapKeygenClass = NonpartitionedKeyGenerator.class.getName();
        scala.collection.immutable.Map options = (scala.collection.immutable.Map)this.commonOpts().$minus((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key());
        String commitInstantTime1 = this.runMetadataBootstrapAndVerifyCommit(DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL(), (scala.collection.immutable.Map<String, String>)options.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()), (Object)bootstrapKeygenClass)}))), bootstrapKeygenClass);
        Predef$.MODULE$.assert(!this.fs().exists(new Path(this.basePath(), ".hoodie/.temp/00000000000001")));
        Dataset hoodieROViewDF1 = this.spark().read().format("hudi").load(new StringBuilder().append((Object)this.basePath()).append((Object)"/*").toString());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF1.count());
        Dataset hoodieROViewDF2 = this.spark().read().format("hudi").load(this.basePath());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF2.count());
        long updateTimestamp = Instant.now().toEpochMilli();
        Dataset<Row> updateDF = TestBootstrap.generateTestRawTripDataset(updateTimestamp, 0, this.numRecordsUpdate(), Collections.emptyList(), jsc, this.spark().sqlContext());
        updateDF.write().format("hudi").options((Map)options).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key(), bootstrapKeygenClass).mode(SaveMode.Append).save(this.basePath());
        String commitInstantTime2 = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs(), (String)this.basePath());
        Assertions.assertEquals((int)1, (int)HoodieDataSourceHelpers.listCommitsSince((FileSystem)this.fs(), (String)this.basePath(), (String)commitInstantTime1).size());
        Dataset hoodieROViewDF3 = this.spark().read().format("hudi").load(new StringBuilder().append((Object)this.basePath()).append((Object)"/*").toString());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF3.count());
        Assertions.assertEquals((long)this.numRecordsUpdate(), (long)hoodieROViewDF3.filter(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timestamp == ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)updateTimestamp)}))).count());
        Dataset hoodieROViewDF1WithBasePath = this.spark().read().format("hudi").load(this.basePath());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF1WithBasePath.count());
        Assertions.assertEquals((long)this.numRecordsUpdate(), (long)hoodieROViewDF1WithBasePath.filter(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timestamp == ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)updateTimestamp)}))).count());
        this.verifyIncrementalViewResult(commitInstantTime1, commitInstantTime2, false, false);
    }

    @ParameterizedTest
    @ValueSource(strings={"METADATA_ONLY", "FULL_RECORD"})
    public void testMetadataBootstrapCOWHiveStylePartitioned(String bootstrapMode) {
        long timestamp = Instant.now().toEpochMilli();
        JavaSparkContext jsc = JavaSparkContext$.MODULE$.fromSparkContext(this.spark().sparkContext());
        Dataset<Row> sourceDF = TestBootstrap.generateTestRawTripDataset(timestamp, 0, this.numRecords(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.partitionPaths()).asJava(), jsc, this.spark().sqlContext());
        sourceDF.write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"datestr"})).format("parquet").mode(SaveMode.Overwrite).save(this.srcPath());
        String commitInstantTime1 = this.runMetadataBootstrapAndVerifyCommit(DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL(), (scala.collection.immutable.Map<String, String>)this.commonOpts().updated((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), (Object)"datestr").$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieBootstrapConfig.PARTITION_SELECTOR_REGEX_MODE.key()), (Object)bootstrapMode)}))), SimpleKeyGenerator.class.getName());
        Predef$.MODULE$.assert(!this.fs().exists(new Path(this.basePath(), ".hoodie/.temp/00000000000001")));
        Dataset hoodieROViewDF1 = this.spark().read().format("hudi").load(new StringBuilder().append((Object)this.basePath()).append((Object)"/*").toString());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF1.count());
        Dataset hoodieROViewDF2 = this.spark().read().format("hudi").load(this.basePath());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF2.count());
        long updateTimestamp = Instant.now().toEpochMilli();
        Dataset<Row> updateDF = TestBootstrap.generateTestRawTripDataset(updateTimestamp, 0, this.numRecordsUpdate(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.partitionPaths()).asJava(), jsc, this.spark().sqlContext());
        updateDF.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "datestr").option(DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING().key(), "true").mode(SaveMode.Append).save(this.basePath());
        String commitInstantTime2 = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs(), (String)this.basePath());
        Assertions.assertEquals((int)1, (int)HoodieDataSourceHelpers.listCommitsSince((FileSystem)this.fs(), (String)this.basePath(), (String)commitInstantTime1).size());
        Dataset hoodieROViewDF3 = this.spark().read().format("hudi").load(new StringBuilder().append((Object)this.basePath()).append((Object)"/*").toString());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF3.count());
        Assertions.assertEquals((long)this.numRecordsUpdate(), (long)hoodieROViewDF3.filter(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timestamp == ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)updateTimestamp)}))).count());
        Dataset hoodieROViewDF4 = this.spark().read().format("hudi").load(this.basePath());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF4.count());
        Assertions.assertEquals((long)this.numRecordsUpdate(), (long)hoodieROViewDF3.filter(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timestamp == ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)updateTimestamp)}))).count());
        this.verifyIncrementalViewResult(commitInstantTime1, commitInstantTime2, true, true);
    }

    @Test
    public void testMetadataBootstrapCOWPartitioned() {
        long timestamp = Instant.now().toEpochMilli();
        JavaSparkContext jsc = JavaSparkContext$.MODULE$.fromSparkContext(this.spark().sparkContext());
        Dataset<Row> sourceDF = TestBootstrap.generateTestRawTripDataset(timestamp, 0, this.numRecords(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.partitionPaths()).asJava(), jsc, this.spark().sqlContext());
        this.partitionPaths().foreach((Function1)new Serializable(this, sourceDF){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDataSourceForBootstrap $outer;
            private final Dataset sourceDF$1;

            public final void apply(String partitionPath) {
                this.sourceDF$1.filter(this.sourceDF$1.apply("datestr").equalTo((Object)functions$.MODULE$.lit((Object)partitionPath))).write().format("parquet").mode(SaveMode.Overwrite).save(new StringBuilder().append((Object)this.$outer.srcPath()).append((Object)"/").append((Object)partitionPath).toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sourceDF$1 = sourceDF$1;
            }
        });
        String commitInstantTime1 = this.runMetadataBootstrapAndVerifyCommit(DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL(), (scala.collection.immutable.Map<String, String>)this.commonOpts().updated((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), (Object)"datestr"), SimpleKeyGenerator.class.getName());
        Dataset hoodieROViewDF1 = this.spark().read().format("hudi").load(new StringBuilder().append((Object)this.basePath()).append((Object)"/*").toString());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF1.count());
        Dataset hoodieROViewWithBasePathDF1 = this.spark().read().format("hudi").load(this.basePath());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewWithBasePathDF1.count());
        Dataset updateDf1 = hoodieROViewDF1.filter(functions$.MODULE$.col("_row_key").$eq$eq$eq((Object)this.verificationRowKey())).withColumn(this.verificationCol(), functions$.MODULE$.lit((Object)this.updatedVerificationVal()));
        updateDf1.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "datestr").mode(SaveMode.Append).save(this.basePath());
        Assertions.assertEquals((int)1, (int)HoodieDataSourceHelpers.listCommitsSince((FileSystem)this.fs(), (String)this.basePath(), (String)commitInstantTime1).size());
        Dataset hoodieROViewDF2 = this.spark().read().format("hudi").load(new StringBuilder().append((Object)this.basePath()).append((Object)"/*").toString());
        hoodieROViewDF2.collect();
        Assertions.assertEquals((Object)this.updatedVerificationVal(), (Object)((Row)hoodieROViewDF2.filter(functions$.MODULE$.col("_row_key").$eq$eq$eq((Object)this.verificationRowKey())).select(this.verificationCol(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).first()).getString(0));
        long updateTimestamp = Instant.now().toEpochMilli();
        Dataset<Row> updateDF2 = TestBootstrap.generateTestRawTripDataset(updateTimestamp, 0, this.numRecordsUpdate(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.partitionPaths()).asJava(), jsc, this.spark().sqlContext());
        updateDF2.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "datestr").mode(SaveMode.Append).save(this.basePath());
        String commitInstantTime3 = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs(), (String)this.basePath());
        Assertions.assertEquals((int)2, (int)HoodieDataSourceHelpers.listCommitsSince((FileSystem)this.fs(), (String)this.basePath(), (String)commitInstantTime1).size());
        Dataset hoodieROViewDF3 = this.spark().read().format("hudi").load(new StringBuilder().append((Object)this.basePath()).append((Object)"/*").toString());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF3.count());
        Assertions.assertEquals((long)this.numRecordsUpdate(), (long)hoodieROViewDF3.filter(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timestamp == ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)updateTimestamp)}))).count());
        Dataset hoodieROViewDF4 = this.spark().read().format("hudi").load(this.basePath());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF4.count());
        Assertions.assertEquals((long)this.numRecordsUpdate(), (long)hoodieROViewDF4.filter(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timestamp == ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)updateTimestamp)}))).count());
        this.verifyIncrementalViewResult(commitInstantTime1, commitInstantTime3, true, false);
    }

    @Test
    public void testMetadataBootstrapMORPartitionedInlineCompactionOn() {
        long timestamp = Instant.now().toEpochMilli();
        JavaSparkContext jsc = JavaSparkContext$.MODULE$.fromSparkContext(this.spark().sparkContext());
        Dataset<Row> sourceDF = TestBootstrap.generateTestRawTripDataset(timestamp, 0, this.numRecords(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.partitionPaths()).asJava(), jsc, this.spark().sqlContext());
        this.partitionPaths().foreach((Function1)new Serializable(this, sourceDF){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDataSourceForBootstrap $outer;
            private final Dataset sourceDF$2;

            public final void apply(String partitionPath) {
                this.sourceDF$2.filter(this.sourceDF$2.apply("datestr").equalTo((Object)functions$.MODULE$.lit((Object)partitionPath))).write().format("parquet").mode(SaveMode.Overwrite).save(new StringBuilder().append((Object)this.$outer.srcPath()).append((Object)"/").append((Object)partitionPath).toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sourceDF$2 = sourceDF$2;
            }
        });
        String commitInstantTime1 = this.runMetadataBootstrapAndVerifyCommit(DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL(), (scala.collection.immutable.Map<String, String>)this.commonOpts().updated((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), (Object)"datestr"), SimpleKeyGenerator.class.getName());
        Dataset hoodieROViewDF1 = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).load(new StringBuilder().append((Object)this.basePath()).append((Object)"/*").toString());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF1.count());
        long updateTimestamp = Instant.now().toEpochMilli();
        Dataset<Row> updateDF = TestBootstrap.generateTestRawTripDataset(updateTimestamp, 0, this.numRecordsUpdate(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.partitionPaths()).asJava(), jsc, this.spark().sqlContext());
        updateDF.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "datestr").option(HoodieCompactionConfig.INLINE_COMPACT.key(), "true").option(HoodieCompactionConfig.INLINE_COMPACT_NUM_DELTA_COMMITS.key(), "1").mode(SaveMode.Append).save(this.basePath());
        Assertions.assertEquals((int)2, (int)HoodieDataSourceHelpers.listCommitsSince((FileSystem)this.fs(), (String)this.basePath(), (String)commitInstantTime1).size());
        Dataset hoodieROViewDF2 = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).load(new StringBuilder().append((Object)this.basePath()).append((Object)"/*").toString());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF2.count());
        Assertions.assertEquals((long)this.numRecordsUpdate(), (long)hoodieROViewDF2.filter(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timestamp == ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)updateTimestamp)}))).count());
        Dataset hoodieROViewDFWithBasePath = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).load(this.basePath());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDFWithBasePath.count());
        Assertions.assertEquals((long)this.numRecordsUpdate(), (long)hoodieROViewDFWithBasePath.filter(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timestamp == ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)updateTimestamp)}))).count());
    }

    @Test
    public void testMetadataBootstrapMORPartitioned() {
        long timestamp = Instant.now().toEpochMilli();
        JavaSparkContext jsc = JavaSparkContext$.MODULE$.fromSparkContext(this.spark().sparkContext());
        Dataset<Row> sourceDF = TestBootstrap.generateTestRawTripDataset(timestamp, 0, this.numRecords(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.partitionPaths()).asJava(), jsc, this.spark().sqlContext());
        this.partitionPaths().foreach((Function1)new Serializable(this, sourceDF){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDataSourceForBootstrap $outer;
            private final Dataset sourceDF$3;

            public final void apply(String partitionPath) {
                this.sourceDF$3.filter(this.sourceDF$3.apply("datestr").equalTo((Object)functions$.MODULE$.lit((Object)partitionPath))).write().format("parquet").mode(SaveMode.Overwrite).save(new StringBuilder().append((Object)this.$outer.srcPath()).append((Object)"/").append((Object)partitionPath).toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sourceDF$3 = sourceDF$3;
            }
        });
        String commitInstantTime1 = this.runMetadataBootstrapAndVerifyCommit(DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL(), (scala.collection.immutable.Map<String, String>)this.commonOpts().updated((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), (Object)"datestr"), SimpleKeyGenerator.class.getName());
        Dataset hoodieROViewDF1 = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).load(new StringBuilder().append((Object)this.basePath()).append((Object)"/*").toString());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF1.count());
        Dataset hoodieROViewDFWithBasePath = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).load(this.basePath());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDFWithBasePath.count());
        Dataset updateDf1 = hoodieROViewDF1.filter(functions$.MODULE$.col("_row_key").$eq$eq$eq((Object)this.verificationRowKey())).withColumn(this.verificationCol(), functions$.MODULE$.lit((Object)this.updatedVerificationVal()));
        updateDf1.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "datestr").mode(SaveMode.Append).save(this.basePath());
        Assertions.assertEquals((int)1, (int)HoodieDataSourceHelpers.listCommitsSince((FileSystem)this.fs(), (String)this.basePath(), (String)commitInstantTime1).size());
        Dataset hoodieROViewDF2 = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).load(new StringBuilder().append((Object)this.basePath()).append((Object)"/*").toString());
        hoodieROViewDF2.collect();
        Assertions.assertEquals((Object)this.originalVerificationVal(), (Object)((Row)hoodieROViewDF2.filter(functions$.MODULE$.col("_row_key").$eq$eq$eq((Object)this.verificationRowKey())).select(this.verificationCol(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).first()).getString(0));
        long updateTimestamp = Instant.now().toEpochMilli();
        Dataset<Row> updateDF2 = TestBootstrap.generateTestRawTripDataset(updateTimestamp, 0, this.numRecordsUpdate(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.partitionPaths()).asJava(), jsc, this.spark().sqlContext());
        updateDF2.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "datestr").mode(SaveMode.Append).save(this.basePath());
        Assertions.assertEquals((int)2, (int)HoodieDataSourceHelpers.listCommitsSince((FileSystem)this.fs(), (String)this.basePath(), (String)commitInstantTime1).size());
        Dataset hoodieROViewDF3 = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).load(new StringBuilder().append((Object)this.basePath()).append((Object)"/*").toString());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF3.count());
        Assertions.assertEquals((long)0L, (long)hoodieROViewDF3.filter(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timestamp == ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)updateTimestamp)}))).count());
    }

    @Test
    public void testFullBootstrapCOWPartitioned() {
        long timestamp = Instant.now().toEpochMilli();
        JavaSparkContext jsc = JavaSparkContext$.MODULE$.fromSparkContext(this.spark().sparkContext());
        Dataset<Row> sourceDF = TestBootstrap.generateTestRawTripDataset(timestamp, 0, this.numRecords(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.partitionPaths()).asJava(), jsc, this.spark().sqlContext());
        this.partitionPaths().foreach((Function1)new Serializable(this, sourceDF){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDataSourceForBootstrap $outer;
            private final Dataset sourceDF$4;

            public final void apply(String partitionPath) {
                this.sourceDF$4.filter(this.sourceDF$4.apply("datestr").equalTo((Object)functions$.MODULE$.lit((Object)partitionPath))).write().format("parquet").mode(SaveMode.Overwrite).save(new StringBuilder().append((Object)this.$outer.srcPath()).append((Object)"/").append((Object)partitionPath).toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sourceDF$4 = sourceDF$4;
            }
        });
        Dataset bootstrapDF = this.spark().emptyDataFrame();
        bootstrapDF.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.BOOTSTRAP_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "datestr").option(HoodieBootstrapConfig.BASE_PATH.key(), this.srcPath()).option(HoodieBootstrapConfig.KEYGEN_CLASS_NAME.key(), SimpleKeyGenerator.class.getName()).option(HoodieBootstrapConfig.MODE_SELECTOR_CLASS_NAME.key(), FullRecordBootstrapModeSelector.class.getName()).option(HoodieBootstrapConfig.FULL_BOOTSTRAP_INPUT_PROVIDER_CLASS_NAME.key(), SparkParquetBootstrapDataProvider.class.getName()).mode(SaveMode.Overwrite).save(this.basePath());
        String commitInstantTime1 = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs(), (String)this.basePath());
        Assertions.assertEquals((Object)"00000000000002", (Object)commitInstantTime1);
        Dataset hoodieROViewDF1 = this.spark().read().format("hudi").load(new StringBuilder().append((Object)this.basePath()).append((Object)"/*").toString());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF1.count());
        Dataset hoodieROViewDFWithBasePath = this.spark().read().format("hudi").load(this.basePath());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDFWithBasePath.count());
        long updateTimestamp = Instant.now().toEpochMilli();
        Dataset<Row> updateDF = TestBootstrap.generateTestRawTripDataset(updateTimestamp, 0, this.numRecordsUpdate(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.partitionPaths()).asJava(), jsc, this.spark().sqlContext());
        updateDF.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "datestr").mode(SaveMode.Append).save(this.basePath());
        String commitInstantTime2 = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs(), (String)this.basePath());
        Assertions.assertEquals((int)1, (int)HoodieDataSourceHelpers.listCommitsSince((FileSystem)this.fs(), (String)this.basePath(), (String)commitInstantTime1).size());
        Dataset hoodieROViewDF2 = this.spark().read().format("hudi").load(new StringBuilder().append((Object)this.basePath()).append((Object)"/*").toString());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF2.count());
        Assertions.assertEquals((long)this.numRecordsUpdate(), (long)hoodieROViewDF2.filter(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timestamp == ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)updateTimestamp)}))).count());
        this.verifyIncrementalViewResult(commitInstantTime1, commitInstantTime2, true, false);
    }

    public String runMetadataBootstrapAndVerifyCommit(String tableType, scala.collection.immutable.Map<String, String> extraOpts, String bootstrapKeygenClass) {
        Dataset bootstrapDF = this.spark().emptyDataFrame();
        bootstrapDF.write().format("hudi").options(extraOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.BOOTSTRAP_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), tableType).option(HoodieBootstrapConfig.BASE_PATH.key(), this.srcPath()).option(HoodieBootstrapConfig.KEYGEN_CLASS_NAME.key(), bootstrapKeygenClass).mode(SaveMode.Overwrite).save(this.basePath());
        String commitInstantTime1 = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs(), (String)this.basePath());
        String expectedBootstrapInstant = "FULL_RECORD".equals(extraOpts.getOrElse((Object)HoodieBootstrapConfig.PARTITION_SELECTOR_REGEX_MODE.key(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return (String)HoodieBootstrapConfig.PARTITION_SELECTOR_REGEX_MODE.defaultValue();
            }
        })) ? "00000000000002" : "00000000000001";
        Assertions.assertEquals((Object)expectedBootstrapInstant, (Object)commitInstantTime1);
        return commitInstantTime1;
    }

    public scala.collection.immutable.Map<String, String> runMetadataBootstrapAndVerifyCommit$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    public void verifyIncrementalViewResult(String bootstrapCommitInstantTime, String latestCommitInstantTime, boolean isPartitioned, boolean isHiveStylePartitioned) {
        Dataset hoodieIncViewDF1 = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), "000").option(DataSourceReadOptions$.MODULE$.END_INSTANTTIME().key(), bootstrapCommitInstantTime).load(this.basePath());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieIncViewDF1.count());
        Row[] countsPerCommit = (Row[])hoodieIncViewDF1.groupBy("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count().collect();
        Assertions.assertEquals((int)1, (int)countsPerCommit.length);
        Assertions.assertEquals((Object)bootstrapCommitInstantTime, (Object)countsPerCommit[0].get(0));
        Dataset hoodieIncViewDF2 = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), bootstrapCommitInstantTime).load(this.basePath());
        Assertions.assertEquals((long)this.numRecordsUpdate(), (long)hoodieIncViewDF2.count());
        countsPerCommit = (Row[])hoodieIncViewDF2.groupBy("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count().collect();
        Assertions.assertEquals((int)1, (int)countsPerCommit.length);
        Assertions.assertEquals((Object)latestCommitInstantTime, (Object)countsPerCommit[0].get(0));
        if (isPartitioned) {
            String relativePartitionPath = isHiveStylePartitioned ? "/datestr=2020-04-02/*" : "/2020-04-02/*";
            Dataset hoodieIncViewDF3 = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), bootstrapCommitInstantTime).option(DataSourceReadOptions$.MODULE$.INCR_PATH_GLOB().key(), relativePartitionPath).load(this.basePath());
            Assertions.assertEquals((long)hoodieIncViewDF2.filter(functions$.MODULE$.col("_hoodie_partition_path").contains((Object)"2020-04-02")).count(), (long)hoodieIncViewDF3.count());
        }
    }

    public TestDataSourceForBootstrap() {
        this.numRecords = 100;
        this.numRecordsUpdate = 10;
        this.verificationRowKey = "trip_0";
        this.verificationCol = "driver";
        this.originalVerificationVal = "driver_0";
        this.updatedVerificationVal = "driver_update";
    }
}

