/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieDataSourceHelpers;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieLayoutConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.table.action.commit.SparkBucketIndexPartitioner;
import org.apache.hudi.table.storage.HoodieStorageLayout;
import org.apache.hudi.testutils.HoodieClientTestBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0001\u0002\u0001\u0017\taB+Z:u\t\u0006$\u0018mU8ve\u000e,gi\u001c:Ck\u000e\\W\r^%oI\u0016D(BA\u0002\u0005\u0003)1WO\\2uS>t\u0017\r\u001c\u0006\u0003\u000b\u0019\tA\u0001[;eS*\u0011q\u0001C\u0001\u0007CB\f7\r[3\u000b\u0003%\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0007\u0011\u00055\u0001R\"\u0001\b\u000b\u0005=!\u0011!\u0003;fgR,H/\u001b7t\u0013\t\tbB\u0001\u000bI_>$\u0017.Z\"mS\u0016tG\u000fV3ti\n\u000b7/\u001a\u0005\u0006'\u0001!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"A\u0006\u0001\u000e\u0003\tAq\u0001\u0007\u0001A\u0002\u0013\u0005\u0011$A\u0003ta\u0006\u00148.F\u0001\u001b!\tYr$D\u0001\u001d\u0015\tib$A\u0002tc2T!\u0001\u0007\u0004\n\u0005\u0001b\"\u0001D*qCJ\\7+Z:tS>t\u0007b\u0002\u0012\u0001\u0001\u0004%\taI\u0001\ngB\f'o[0%KF$\"\u0001\n\u0016\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0003\tUs\u0017\u000e\u001e\u0005\bW\u0005\n\t\u00111\u0001\u001b\u0003\rAH%\r\u0005\u0007[\u0001\u0001\u000b\u0015\u0002\u000e\u0002\rM\u0004\u0018M]6!\u0011\u001dy\u0003A1A\u0005\u0002A\n!bY8n[>tw\n\u001d;t+\u0005\t\u0004\u0003\u0002\u001a8sej\u0011a\r\u0006\u0003iU\n\u0011\"[7nkR\f'\r\\3\u000b\u0005Y2\u0013AC2pY2,7\r^5p]&\u0011\u0001h\r\u0002\u0004\u001b\u0006\u0004\bC\u0001\u001e@\u001b\u0005Y$B\u0001\u001f>\u0003\u0011a\u0017M\\4\u000b\u0003y\nAA[1wC&\u0011\u0001i\u000f\u0002\u0007'R\u0014\u0018N\\4\t\r\t\u0003\u0001\u0015!\u00032\u0003-\u0019w.\\7p]>\u0003Ho\u001d\u0011\t\u000b\u0011\u0003A\u0011I#\u0002\u000bM,G/\u00169\u0015\u0003\u0011B#aQ$\u0011\u0005!{U\"A%\u000b\u0005)[\u0015aA1qS*\u0011A*T\u0001\bUV\u0004\u0018\u000e^3s\u0015\tq\u0005\"A\u0003kk:LG/\u0003\u0002Q\u0013\nQ!)\u001a4pe\u0016,\u0015m\u00195\t\u000bI\u0003A\u0011I#\u0002\u0011Q,\u0017M\u001d#po:D#!\u0015+\u0011\u0005!+\u0016B\u0001,J\u0005%\te\r^3s\u000b\u0006\u001c\u0007\u000eC\u0003Y\u0001\u0011\u0005Q)\u0001\tuKN$Hi\\;cY\u0016Len]3si\"\u0012qK\u0017\t\u0003\u0011nK!\u0001X%\u0003\tQ+7\u000f\u001e\u0005\u0006=\u0002!\t!R\u0001\u0019i\u0016\u001cHoQ8v]R<\u0016\u000e\u001e5Ck\u000e\\W\r^%oI\u0016D\bFA/[\u0001")
public class TestDataSourceForBucketIndex
extends HoodieClientTestBase {
    private SparkSession spark = null;
    private final Map<String, String> commonOpts = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.bulkinsert.shuffle.parallelism"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieIndexConfig.INDEX_TYPE.key()), (Object)HoodieIndex.IndexType.BUCKET.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieIndexConfig.BUCKET_INDEX_NUM_BUCKETS.key()), (Object)"8"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieLayoutConfig.LAYOUT_TYPE.key()), (Object)HoodieStorageLayout.LayoutType.BUCKET.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieLayoutConfig.LAYOUT_PARTITIONER_CLASS_NAME.key()), (Object)SparkBucketIndexPartitioner.class.getName())}));

    public SparkSession spark() {
        return this.spark;
    }

    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    public Map<String, String> commonOpts() {
        return this.commonOpts;
    }

    @BeforeEach
    public void setUp() {
        this.initPath();
        this.initSparkContexts();
        this.spark_$eq(this.sqlContext.sparkSession());
        this.initTestDataGenerator();
        this.initFileSystem();
    }

    @AfterEach
    public void tearDown() {
        this.cleanupSparkContexts();
        this.cleanupTestDataGenerator();
        this.cleanupFileSystem();
    }

    @Test
    public void testDoubleInsert() {
        List records1 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option("hoodie.compact.inline", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        Assertions.assertTrue((boolean)HoodieDataSourceHelpers.hasNewCommits((FileSystem)this.fs, (String)this.basePath, (String)"000"));
        List records2 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("002", Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options(this.commonOpts()).option("hoodie.compact.inline", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        Dataset hudiSnapshotDF1 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder().append((Object)this.basePath).append((Object)"/*/*/*/*").toString());
        Assertions.assertEquals((long)200L, (long)hudiSnapshotDF1.count());
    }

    @Test
    public void testCountWithBucketIndex() {
        List records1 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option("hoodie.compact.inline", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OVERWRITE_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        Assertions.assertTrue((boolean)HoodieDataSourceHelpers.hasNewCommits((FileSystem)this.fs, (String)this.basePath, (String)"000"));
        Dataset hudiSnapshotDF1 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder().append((Object)this.basePath).append((Object)"/*/*/*/*").toString());
        Assertions.assertEquals((long)100L, (long)hudiSnapshotDF1.count());
        List records2 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateUniqueUpdates("002", Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Append).save(this.basePath);
        Dataset hudiSnapshotDF2 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder().append((Object)this.basePath).append((Object)"/*/*/*/*").toString());
        Assertions.assertEquals((long)100L, (long)hudiSnapshotDF2.count());
        String commit1Time = ((Row)hudiSnapshotDF1.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).head()).get(0).toString();
        String commit2Time = ((Row)hudiSnapshotDF2.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).head()).get(0).toString();
        Assertions.assertEquals((long)hudiSnapshotDF2.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().count(), (long)1L);
        Assertions.assertTrue((boolean)new StringOps(Predef$.MODULE$.augmentString(commit2Time)).$greater((Object)commit1Time));
        Assertions.assertEquals((long)100L, (long)hudiSnapshotDF2.join(hudiSnapshotDF1, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_hoodie_record_key"})), "left").count());
        String[] partitionPaths = new String[]{"2020/01/10"};
        HoodieTestDataGenerator newDataGen = new HoodieTestDataGenerator(partitionPaths);
        List records4 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)newDataGen.generateInserts("004", Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF4 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records4, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF4.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Append).save(this.basePath);
        Dataset hudiSnapshotDF4 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder().append((Object)this.basePath).append((Object)"/*/*/*/*").toString());
        Assertions.assertEquals((long)200L, (long)hudiSnapshotDF4.count());
        Assertions.assertEquals((long)100L, (long)hudiSnapshotDF1.join(hudiSnapshotDF4, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_hoodie_record_key"})), "inner").count());
    }
}

