/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieDataSourceHelpers;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.testutils.HoodieClientTestBase;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001-4A!\u0001\u0002\u0001\u0017\tAB+Z:u\u0011>|G-[3BGRLg/\u001a+j[\u0016d\u0017N\\3\u000b\u0005\r!\u0011A\u00034v]\u000e$\u0018n\u001c8bY*\u0011QAB\u0001\u0005QV$\u0017N\u0003\u0002\b\u0011\u00051\u0011\r]1dQ\u0016T\u0011!C\u0001\u0004_J<7\u0001A\n\u0003\u00011\u0001\"!\u0004\t\u000e\u00039Q!a\u0004\u0003\u0002\u0013Q,7\u000f^;uS2\u001c\u0018BA\t\u000f\u0005QAun\u001c3jK\u000ec\u0017.\u001a8u)\u0016\u001cHOQ1tK\")1\u0003\u0001C\u0001)\u00051A(\u001b8jiz\"\u0012!\u0006\t\u0003-\u0001i\u0011A\u0001\u0005\b1\u0001\u0001\r\u0011\"\u0001\u001a\u0003\u0015\u0019\b/\u0019:l+\u0005Q\u0002CA\u000e \u001b\u0005a\"BA\u000f\u001f\u0003\r\u0019\u0018\u000f\u001c\u0006\u00031\u0019I!\u0001\t\u000f\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\u000f\t\u0002\u0001\u0019!C\u0001G\u0005I1\u000f]1sW~#S-\u001d\u000b\u0003I)\u0002\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u0012A!\u00168ji\"91&IA\u0001\u0002\u0004Q\u0012a\u0001=%c!1Q\u0006\u0001Q!\ni\taa\u001d9be.\u0004\u0003bB\u0018\u0001\u0005\u0004%I\u0001M\u0001\u0004Y><W#A\u0019\u0011\u0005I*T\"A\u001a\u000b\u0005Q2\u0011!\u00027pORR\u0017B\u0001\u001c4\u0005\u0019aunZ4fe\"1\u0001\b\u0001Q\u0001\nE\nA\u0001\\8hA!9!\b\u0001b\u0001\n\u0003Y\u0014AC2p[6|gn\u00149ugV\tA\b\u0005\u0003>\u0005\u0012#U\"\u0001 \u000b\u0005}\u0002\u0015!C5n[V$\u0018M\u00197f\u0015\t\te%\u0001\u0006d_2dWm\u0019;j_:L!a\u0011 \u0003\u00075\u000b\u0007\u000f\u0005\u0002F\u00156\taI\u0003\u0002H\u0011\u0006!A.\u00198h\u0015\u0005I\u0015\u0001\u00026bm\u0006L!a\u0013$\u0003\rM#(/\u001b8h\u0011\u0019i\u0005\u0001)A\u0005y\u0005Y1m\\7n_:|\u0005\u000f^:!\u0011\u0015y\u0005\u0001\"\u0011Q\u0003\u0015\u0019X\r^+q)\u0005!\u0003F\u0001(S!\t\u0019&,D\u0001U\u0015\t)f+A\u0002ba&T!a\u0016-\u0002\u000f),\b/\u001b;fe*\u0011\u0011\fC\u0001\u0006UVt\u0017\u000e^\u0005\u00037R\u0013!BQ3g_J,W)Y2i\u0011\u0015i\u0006\u0001\"\u0011Q\u0003!!X-\u0019:E_^t\u0007F\u0001/`!\t\u0019\u0006-\u0003\u0002b)\nI\u0011I\u001a;fe\u0016\u000b7\r\u001b\u0005\u0006G\u0002!\t\u0001U\u0001-i\u0016\u001cHoR3u\u0019\u0006\u001cHoQ8n[&$X*\u001a;bI\u0006$\u0018mV5uQZ\u000bG.\u001b3ECR\fgi\u001c:D\u001f^C#AY3\u0011\u0005M3\u0017BA4U\u0005\u0011!Vm\u001d;\t\u000b%\u0004A\u0011\u0001)\u0002YQ,7\u000f^$fi2\u000b7\u000f^\"p[6LG/T3uC\u0012\fG/Y,ji\"4\u0016\r\\5e\t\u0006$\u0018MR8s\u001b>\u0013\u0006F\u00015f\u0001")
public class TestHoodieActiveTimeline
extends HoodieClientTestBase {
    private SparkSession spark = null;
    private final Logger log = LogManager.getLogger(TestHoodieActiveTimeline.class);
    private final Map<String, String> commonOpts = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test")}));

    public SparkSession spark() {
        return this.spark;
    }

    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    private Logger log() {
        return this.log;
    }

    public Map<String, String> commonOpts() {
        return this.commonOpts;
    }

    @BeforeEach
    public void setUp() {
        this.setTableName("hoodie_test");
        this.initPath();
        this.initSparkContexts();
        this.spark_$eq(this.sqlContext.sparkSession());
        this.initTestDataGenerator();
        this.initFileSystem();
    }

    @AfterEach
    public void tearDown() {
        this.cleanupSparkContexts();
        this.cleanupTestDataGenerator();
        this.cleanupFileSystem();
    }

    @Test
    public void testGetLastCommitMetadataWithValidDataForCOW() {
        List records1 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath);
        String commit1Time = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs, (String)this.basePath);
        String[] partitionsForCommit1 = (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.spark().read().format("org.apache.hudi").load(this.basePath).select("_hoodie_partition_path", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().collect()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Row x$1) {
                return x$1.get(0).toString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).sorted((Ordering)Ordering.String$.MODULE$);
        Predef$.MODULE$.assert(Predef$.MODULE$.refArrayOps((Object[])new String[]{"2015/03/16", "2015/03/17", "2016/03/15"}).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])partitionsForCommit1)));
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(this.basePath).setConf(this.hadoopConf).build();
        HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
        Option ret1 = activeTimeline.getLastCommitMetadataWithValidData();
        Predef$.MODULE$.assert(ret1.isPresent());
        Tuple2 tuple2 = new Tuple2(((Pair)ret1.get()).getLeft(), ((Pair)ret1.get()).getRight());
        if (tuple2 != null) {
            Tuple2 tuple22;
            HoodieInstant instant1 = (HoodieInstant)tuple2._1();
            HoodieCommitMetadata commitMetadata1 = (HoodieCommitMetadata)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)instant1, (Object)commitMetadata1);
            HoodieInstant instant12 = (HoodieInstant)tuple23._1();
            HoodieCommitMetadata commitMetadata12 = (HoodieCommitMetadata)tuple23._2();
            Assertions.assertEquals((Object)instant12.getTimestamp(), (Object)commit1Time);
            String relativePath1 = (String)commitMetadata12.getFileIdAndRelativePaths().values().stream().findAny().get();
            Predef$.MODULE$.assert(relativePath1.contains(commit1Time));
            Predef$.MODULE$.assert(relativePath1.contains(HoodieFileFormat.PARQUET.getFileExtension()));
            this.spark().emptyDataFrame().write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.DELETE_PARTITION_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.PARTITIONS_TO_DELETE().key(), "2015/03/16").mode(SaveMode.Append).save(this.basePath);
            String commit2Time = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs, (String)this.basePath);
            long countPartitionDropped = this.spark().read().format("org.apache.hudi").load(this.basePath).where("_hoodie_partition_path = '2015/03/16'").count();
            Assertions.assertEquals((long)countPartitionDropped, (long)0L);
            activeTimeline = activeTimeline.reload();
            Option ret2 = activeTimeline.getLastCommitMetadataWithValidData();
            Predef$.MODULE$.assert(ret2.isPresent());
            Tuple2 tuple24 = new Tuple2(((Pair)ret2.get()).getLeft(), ((Pair)ret2.get()).getRight());
            if (tuple24 != null) {
                Tuple2 tuple25;
                HoodieInstant instant2 = (HoodieInstant)tuple24._1();
                HoodieCommitMetadata commitMetadata2 = (HoodieCommitMetadata)tuple24._2();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)instant2, (Object)commitMetadata2);
                HoodieInstant instant22 = (HoodieInstant)tuple26._1();
                HoodieCommitMetadata commitMetadata22 = (HoodieCommitMetadata)tuple26._2();
                Assertions.assertEquals((Object)instant22.getTimestamp(), (Object)commit1Time);
                String relativePath2 = (String)commitMetadata22.getFileIdAndRelativePaths().values().stream().findAny().get();
                Predef$.MODULE$.assert(relativePath2.contains(commit1Time));
                Predef$.MODULE$.assert(relativePath2.contains(HoodieFileFormat.PARQUET.getFileExtension()));
                List records3 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateUniqueUpdates("003", Predef$.MODULE$.int2Integer(50)))).toList();
                Dataset inputDF3 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records3, 2, ClassTag$.MODULE$.apply(String.class)));
                inputDF3.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Append).save(this.basePath);
                String commit3Time = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs, (String)this.basePath);
                activeTimeline = activeTimeline.reload();
                Option ret3 = activeTimeline.getLastCommitMetadataWithValidData();
                Predef$.MODULE$.assert(ret3.isPresent());
                Tuple2 tuple27 = new Tuple2(((Pair)ret3.get()).getLeft(), ((Pair)ret3.get()).getRight());
                if (tuple27 != null) {
                    Tuple2 tuple28;
                    HoodieInstant instant3 = (HoodieInstant)tuple27._1();
                    HoodieCommitMetadata commitMetadata3 = (HoodieCommitMetadata)tuple27._2();
                    Tuple2 tuple29 = tuple28 = new Tuple2((Object)instant3, (Object)commitMetadata3);
                    HoodieInstant instant32 = (HoodieInstant)tuple29._1();
                    HoodieCommitMetadata commitMetadata32 = (HoodieCommitMetadata)tuple29._2();
                    Assertions.assertEquals((Object)instant32.getTimestamp(), (Object)commit3Time);
                    String relativePath3 = (String)commitMetadata32.getFileIdAndRelativePaths().values().stream().findAny().get();
                    Predef$.MODULE$.assert(relativePath3.contains(commit3Time));
                    Predef$.MODULE$.assert(relativePath3.contains(HoodieFileFormat.PARQUET.getFileExtension()));
                    return;
                }
                throw new MatchError((Object)tuple27);
            }
            throw new MatchError((Object)tuple24);
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testGetLastCommitMetadataWithValidDataForMOR() {
        List records1 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option("hoodie.compact.inline", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath);
        String commit1Time = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs, (String)this.basePath);
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(this.basePath).setConf(this.hadoopConf).build();
        HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
        Option ret1 = activeTimeline.getLastCommitMetadataWithValidData();
        Predef$.MODULE$.assert(ret1.isPresent());
        Tuple2 tuple2 = new Tuple2(((Pair)ret1.get()).getLeft(), ((Pair)ret1.get()).getRight());
        if (tuple2 != null) {
            Tuple2 tuple22;
            HoodieInstant instant1 = (HoodieInstant)tuple2._1();
            HoodieCommitMetadata commitMetadata1 = (HoodieCommitMetadata)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)instant1, (Object)commitMetadata1);
            HoodieInstant instant12 = (HoodieInstant)tuple23._1();
            HoodieCommitMetadata commitMetadata12 = (HoodieCommitMetadata)tuple23._2();
            Assertions.assertEquals((Object)instant12.getTimestamp(), (Object)commit1Time);
            String relativePath1 = (String)commitMetadata12.getFileIdAndRelativePaths().values().stream().findAny().get();
            Predef$.MODULE$.assert(relativePath1.contains(commit1Time));
            Predef$.MODULE$.assert(relativePath1.contains(HoodieFileFormat.PARQUET.getFileExtension()));
            List records2 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateUniqueUpdates("002", Predef$.MODULE$.int2Integer(100)))).toList();
            Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
            inputDF2.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Append).save(this.basePath);
            String commit2Time = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs, (String)this.basePath);
            activeTimeline = activeTimeline.reload();
            Option ret2 = activeTimeline.getLastCommitMetadataWithValidData();
            Predef$.MODULE$.assert(ret2.isPresent());
            Tuple2 tuple24 = new Tuple2(((Pair)ret2.get()).getLeft(), ((Pair)ret2.get()).getRight());
            if (tuple24 != null) {
                Tuple2 tuple25;
                HoodieInstant instant2 = (HoodieInstant)tuple24._1();
                HoodieCommitMetadata commitMetadata2 = (HoodieCommitMetadata)tuple24._2();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)instant2, (Object)commitMetadata2);
                HoodieInstant instant22 = (HoodieInstant)tuple26._1();
                HoodieCommitMetadata commitMetadata22 = (HoodieCommitMetadata)tuple26._2();
                Assertions.assertEquals((Object)instant22.getTimestamp(), (Object)commit2Time);
                String relativePath2 = (String)commitMetadata22.getFileIdAndRelativePaths().values().stream().findAny().get();
                Predef$.MODULE$.assert(relativePath2.contains(commit1Time));
                Predef$.MODULE$.assert(relativePath2.contains(HoodieFileFormat.HOODIE_LOG.getFileExtension()));
                List records3 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateUniqueUpdates("003", Predef$.MODULE$.int2Integer(50)))).toList();
                Dataset inputDF3 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records3, 2, ClassTag$.MODULE$.apply(String.class)));
                inputDF3.write().format("org.apache.hudi").options(this.commonOpts()).option("hoodie.compact.inline", "true").option("hoodie.compact.inline.max.delta.commits", "1").mode(SaveMode.Append).save(this.basePath);
                String commit3Time = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs, (String)this.basePath);
                activeTimeline = activeTimeline.reload();
                Option ret3 = activeTimeline.getLastCommitMetadataWithValidData();
                Predef$.MODULE$.assert(ret3.isPresent());
                Tuple2 tuple27 = new Tuple2(((Pair)ret3.get()).getLeft(), ((Pair)ret3.get()).getRight());
                if (tuple27 != null) {
                    Tuple2 tuple28;
                    HoodieInstant instant3 = (HoodieInstant)tuple27._1();
                    HoodieCommitMetadata commitMetadata3 = (HoodieCommitMetadata)tuple27._2();
                    Tuple2 tuple29 = tuple28 = new Tuple2((Object)instant3, (Object)commitMetadata3);
                    HoodieInstant instant32 = (HoodieInstant)tuple29._1();
                    HoodieCommitMetadata commitMetadata32 = (HoodieCommitMetadata)tuple29._2();
                    Assertions.assertEquals((Object)instant32.getTimestamp(), (Object)commit3Time);
                    String relativePath3 = (String)commitMetadata32.getFileIdAndRelativePaths().values().stream().findAny().get();
                    Predef$.MODULE$.assert(relativePath3.contains(commit3Time));
                    Predef$.MODULE$.assert(relativePath3.contains(HoodieFileFormat.PARQUET.getFileExtension()));
                    List records4 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateUniqueUpdates("004", Predef$.MODULE$.int2Integer(50)))).toList();
                    Dataset inputDF4 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records4, 2, ClassTag$.MODULE$.apply(String.class)));
                    inputDF4.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Append).save(this.basePath);
                    String commit4Time = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs, (String)this.basePath);
                    activeTimeline = activeTimeline.reload();
                    Option ret4 = activeTimeline.getLastCommitMetadataWithValidData();
                    Predef$.MODULE$.assert(ret4.isPresent());
                    Tuple2 tuple210 = new Tuple2(((Pair)ret4.get()).getLeft(), ((Pair)ret4.get()).getRight());
                    if (tuple210 != null) {
                        Tuple2 tuple211;
                        HoodieInstant instant4 = (HoodieInstant)tuple210._1();
                        HoodieCommitMetadata commitMetadata4 = (HoodieCommitMetadata)tuple210._2();
                        Tuple2 tuple212 = tuple211 = new Tuple2((Object)instant4, (Object)commitMetadata4);
                        HoodieInstant instant42 = (HoodieInstant)tuple212._1();
                        HoodieCommitMetadata commitMetadata42 = (HoodieCommitMetadata)tuple212._2();
                        Assertions.assertEquals((Object)instant42.getTimestamp(), (Object)commit4Time);
                        String relativePath4 = (String)commitMetadata42.getFileIdAndRelativePaths().values().stream().findAny().get();
                        Predef$.MODULE$.assert(relativePath4.contains(commit3Time));
                        Predef$.MODULE$.assert(relativePath4.contains(HoodieFileFormat.HOODIE_LOG.getFileExtension()));
                        return;
                    }
                    throw new MatchError((Object)tuple210);
                }
                throw new MatchError((Object)tuple27);
            }
            throw new MatchError((Object)tuple24);
        }
        throw new MatchError((Object)tuple2);
    }
}

