/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.util.stream.Stream;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieFileIndex;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.functional.TestLayoutOptimization$;
import org.apache.hudi.testutils.HoodieClientTestBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function0;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Tag(value="functional")
@ScalaSignature(bytes="\u0006\u0001\u0005=e\u0001B\u0001\u0003\u0001-\u0011a\u0003V3ti2\u000b\u0017p\\;u\u001fB$\u0018.\\5{CRLwN\u001c\u0006\u0003\u0007\u0011\t!BZ;oGRLwN\\1m\u0015\t)a!\u0001\u0003ik\u0012L'BA\u0004\t\u0003\u0019\t\u0007/Y2iK*\t\u0011\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u0019A\u0011Q\u0002E\u0007\u0002\u001d)\u0011q\u0002B\u0001\ni\u0016\u001cH/\u001e;jYNL!!\u0005\b\u0003)!{w\u000eZ5f\u00072LWM\u001c;UKN$()Y:f\u0011\u0015\u0019\u0002\u0001\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\u0017\u00015\t!\u0001C\u0005\u0019\u0001\u0001\u0007\t\u0019!C\u00013\u0005)1\u000f]1sWV\t!\u0004\u0005\u0002\u001c?5\tAD\u0003\u0002\u001e=\u0005\u00191/\u001d7\u000b\u0005a1\u0011B\u0001\u0011\u001d\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0011%\u0011\u0003\u00011AA\u0002\u0013\u00051%A\u0005ta\u0006\u00148n\u0018\u0013fcR\u0011AE\u000b\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\u0005+:LG\u000fC\u0004,C\u0005\u0005\t\u0019\u0001\u000e\u0002\u0007a$\u0013\u0007\u0003\u0004.\u0001\u0001\u0006KAG\u0001\u0007gB\f'o\u001b\u0011\t\u000f=\u0002!\u0019!C\u0001a\u0005\t2o\\;sG\u0016$\u0016M\u00197f'\u000eDW-\\1\u0016\u0003E\u0002\"AM\u001b\u000e\u0003MR!\u0001\u000e\u000f\u0002\u000bQL\b/Z:\n\u0005Y\u001a$AC*ueV\u001cG\u000fV=qK\"1\u0001\b\u0001Q\u0001\nE\n!c]8ve\u000e,G+\u00192mKN\u001b\u0007.Z7bA!9!\b\u0001b\u0001\n\u0003Y\u0014\u0001D7fi\u0006$\u0017\r^1PaR\u001cX#\u0001\u001f\u0011\tu\u0012E\tR\u0007\u0002})\u0011q\bQ\u0001\nS6lW\u000f^1cY\u0016T!!\u0011\u0014\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002D}\t\u0019Q*\u00199\u0011\u0005\u0015SU\"\u0001$\u000b\u0005\u001dC\u0015\u0001\u00027b]\u001eT\u0011!S\u0001\u0005U\u00064\u0018-\u0003\u0002L\r\n11\u000b\u001e:j]\u001eDa!\u0014\u0001!\u0002\u0013a\u0014!D7fi\u0006$\u0017\r^1PaR\u001c\b\u0005C\u0004P\u0001\t\u0007I\u0011A\u001e\u0002\u0015\r|W.\\8o\u001fB$8\u000f\u0003\u0004R\u0001\u0001\u0006I\u0001P\u0001\fG>lWn\u001c8PaR\u001c\b\u0005C\u0003T\u0001\u0011\u0005C+A\u0003tKR,\u0006\u000fF\u0001%Q\t\u0011f\u000b\u0005\u0002X=6\t\u0001L\u0003\u0002Z5\u0006\u0019\u0011\r]5\u000b\u0005mc\u0016a\u00026va&$XM\u001d\u0006\u0003;\"\tQA[;oSRL!a\u0018-\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007\u000eC\u0003b\u0001\u0011\u0005C+\u0001\u0005uK\u0006\u0014Hi\\<oQ\t\u00017\r\u0005\u0002XI&\u0011Q\r\u0017\u0002\n\u0003\u001a$XM]#bG\"DQa\u001a\u0001\u0005\u0002!\f\u0001\u0005^3ti2\u000b\u0017p\\;u\u001fB$\u0018.\\5{CRLwN\u001c$v]\u000e$\u0018n\u001c8bYR)A%[9tk\")!N\u001aa\u0001W\u0006IA/\u00192mKRK\b/\u001a\t\u0003Y>t!!J7\n\u000594\u0013A\u0002)sK\u0012,g-\u0003\u0002La*\u0011aN\n\u0005\u0006e\u001a\u0004\ra[\u0001\u0010G2,8\u000f^3sS:<\u0017i\u001d*po\")AO\u001aa\u0001W\u0006QB.Y=pkR|\u0005\u000f^5nSj\fG/[8o'R\u0014\u0018\r^3hs\")aO\u001aa\u0001W\u0006y2\u000f]1uS\u0006d7)\u001e:wK\u000e{W\u000e]8tSRLwN\\*ue\u0006$XmZ=)\r\u0019D\u0018\u0011AA\u0002!\tIh0D\u0001{\u0015\tYH0\u0001\u0005qe>4\u0018\u000eZ3s\u0015\ti(,\u0001\u0004qCJ\fWn]\u0005\u0003\u007fj\u0014A\"T3uQ>$7k\\;sG\u0016\fQA^1mk\u0016d#!!\u0002\"\u0005\u0005\u001d\u0011\u0001\t;fgRd\u0015-_8vi>\u0003H/[7ju\u0006$\u0018n\u001c8QCJ\fW.\u001a;feND3AZA\u0006!\u0011\ti!a\u0004\u000e\u0003qL1!!\u0005}\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f\u001e\u0005\b\u0003+\u0001A\u0011BA\f\u0003=\t7o]3siJ{wo]'bi\u000eDG#\u0002\u0013\u0002\u001a\u0005\u0005\u0003\u0002CA\u000e\u0003'\u0001\r!!\b\u0002\u0007=tW\r\u0005\u0003\u0002 \u0005mb\u0002BA\u0011\u0003oqA!a\t\u000269!\u0011QEA\u001a\u001d\u0011\t9#!\r\u000f\t\u0005%\u0012qF\u0007\u0003\u0003WQ1!!\f\u000b\u0003\u0019a$o\\8u}%\t\u0011\"\u0003\u0002\b\u0011%\u0011\u0001DB\u0005\u0003;yI1!!\u000f\u001d\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0010\u0002@\tIA)\u0019;b\rJ\fW.\u001a\u0006\u0004\u0003sa\u0002\u0002CA\"\u0003'\u0001\r!!\b\u0002\u000b=$\b.\u001a:)\u000f\u0001\t9%!\u0001\u0002NA\u0019q+!\u0013\n\u0007\u0005-\u0003LA\u0002UC\u001e\f\u0013aA\u0004\b\u0003#\u0012\u0001\u0012AA*\u0003Y!Vm\u001d;MCf|W\u000f^(qi&l\u0017N_1uS>t\u0007c\u0001\f\u0002V\u00191\u0011A\u0001E\u0001\u0003/\u001ab!!\u0016\u0002Z\u0005}\u0003cA\u0013\u0002\\%\u0019\u0011Q\f\u0014\u0003\r\u0005s\u0017PU3g!\r)\u0013\u0011M\u0005\u0004\u0003G2#\u0001D*fe&\fG.\u001b>bE2,\u0007bB\n\u0002V\u0011\u0005\u0011q\r\u000b\u0003\u0003'B\u0001\"a\u0002\u0002V\u0011\u0005\u00111\u000e\u000b\u0003\u0003[\u0002b!a\u001c\u0002z\u0005uTBAA9\u0015\u0011\t\u0019(!\u001e\u0002\rM$(/Z1n\u0015\r\t9\bS\u0001\u0005kRLG.\u0003\u0003\u0002|\u0005E$AB*ue\u0016\fW\u000eE\u0002z\u0003\u007fJ1!!!{\u0005%\t%oZ;nK:$8\u000f\u0003\u0006\u0002\u0006\u0006U\u0013\u0011!C\u0005\u0003\u000f\u000b1B]3bIJ+7o\u001c7wKR\u0011\u0011\u0011\u0012\t\u0004\u000b\u0006-\u0015bAAG\r\n1qJ\u00196fGR\u0004")
public class TestLayoutOptimization
extends HoodieClientTestBase {
    private SparkSession spark;
    private final StructType sourceTableSchema = new StructType().add("c1", (DataType)IntegerType$.MODULE$).add("c2", (DataType)StringType$.MODULE$).add("c3", (DataType)new DecimalType(9, 3)).add("c4", (DataType)TimestampType$.MODULE$).add("c5", (DataType)ShortType$.MODULE$).add("c6", (DataType)DateType$.MODULE$).add("c7", (DataType)BinaryType$.MODULE$).add("c8", (DataType)ByteType$.MODULE$);
    private final Map<String, String> metadataOpts = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key()), (Object)"true")}));
    private final Map<String, String> commonOpts = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.bulkinsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test")}))).$plus$plus(this.metadataOpts());

    public static Stream<Arguments> testLayoutOptimizationParameters() {
        return TestLayoutOptimization$.MODULE$.testLayoutOptimizationParameters();
    }

    public SparkSession spark() {
        return this.spark;
    }

    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    public StructType sourceTableSchema() {
        return this.sourceTableSchema;
    }

    public Map<String, String> metadataOpts() {
        return this.metadataOpts;
    }

    public Map<String, String> commonOpts() {
        return this.commonOpts;
    }

    @BeforeEach
    public void setUp() {
        this.initPath();
        this.initSparkContexts();
        this.spark_$eq(this.sqlContext.sparkSession());
        this.initTestDataGenerator();
        this.initFileSystem();
    }

    @AfterEach
    public void tearDown() {
        this.cleanupSparkContexts();
        this.cleanupTestDataGenerator();
        this.cleanupFileSystem();
    }

    @ParameterizedTest
    @MethodSource(value={"testLayoutOptimizationParameters"})
    public void testLayoutOptimizationFunctional(String tableType, String clusteringAsRow, String layoutOptimizationStrategy, String spatialCurveCompositionStrategy) {
        String curveCompositionStrategy = (String)Option$.MODULE$.apply((Object)spatialCurveCompositionStrategy).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return (String)HoodieClusteringConfig.LAYOUT_OPTIMIZE_SPATIAL_CURVE_BUILD_METHOD.defaultValue();
            }
        });
        int targetRecordsCount = 10000;
        List records = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(targetRecordsCount)))).toList();
        Dataset writeDf = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records, 2, ClassTag$.MODULE$.apply(String.class)));
        this.spark().sqlContext().setConf(HoodieFileIndex.DataSkippingFailureMode$.MODULE$.configName(), HoodieFileIndex.DataSkippingFailureMode$.MODULE$.Strict().value());
        writeDf.write().format("org.apache.hudi").options(this.commonOpts()).option("hoodie.compact.inline", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), tableType).option("hoodie.parquet.small.file.limit", "0").option("hoodie.clustering.inline", "true").option("hoodie.clustering.inline.max.commits", "1").option("hoodie.clustering.plan.strategy.target.file.max.bytes", "1073741824").option("hoodie.clustering.plan.strategy.small.file.limit", "629145600").option("hoodie.clustering.plan.strategy.max.bytes.per.group", ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString()).option("hoodie.clustering.plan.strategy.target.file.max.bytes", String.valueOf(0x4000000L)).option(DataSourceWriteOptions$.MODULE$.ENABLE_ROW_WRITER().key(), clusteringAsRow).option(HoodieClusteringConfig.LAYOUT_OPTIMIZE_STRATEGY.key(), layoutOptimizationStrategy).option(HoodieClusteringConfig.LAYOUT_OPTIMIZE_SPATIAL_CURVE_BUILD_METHOD.key(), curveCompositionStrategy).option(HoodieClusteringConfig.PLAN_STRATEGY_SORT_COLUMNS.key(), "begin_lat,begin_lon").mode(SaveMode.Overwrite).save(this.basePath);
        HoodieTableMetaClient hudiMetaClient = HoodieTableMetaClient.builder().setConf(this.hadoopConf).setBasePath(this.basePath).setLoadActiveTimelineOnLoad(true).build();
        HoodieInstant lastCommit = (HoodieInstant)hudiMetaClient.getActiveTimeline().getAllCommitsTimeline().lastInstant().get();
        Assertions.assertEquals((Object)"replacecommit", (Object)lastCommit.getAction());
        Assertions.assertEquals((Object)HoodieInstant.State.COMPLETED, (Object)lastCommit.getState());
        Dataset readDf = this.spark().read().format("hudi").load(this.basePath);
        Dataset readDfSkip = this.spark().read().option(DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key(), "true").options(this.metadataOpts()).format("hudi").load(this.basePath);
        Assertions.assertEquals((long)targetRecordsCount, (long)readDf.count());
        Assertions.assertEquals((long)targetRecordsCount, (long)readDfSkip.count());
        readDf.createOrReplaceTempView("hudi_snapshot_raw");
        readDfSkip.createOrReplaceTempView("hudi_snapshot_skipping");
        this.assertRowsMatch((Dataset<Row>)this.select$1("hudi_snapshot_raw"), (Dataset<Row>)this.select$1("hudi_snapshot_skipping"));
    }

    private void assertRowsMatch(Dataset<Row> one, Dataset<Row> other) {
        long rows = one.count();
        Predef$.MODULE$.assert(rows == other.count() && one.intersect(other).count() == rows);
    }

    private final Dataset select$1(String tableName) {
        return this.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM ", " WHERE begin_lat >= 0.49 AND begin_lat < 0.51 AND begin_lon >= 0.49 AND begin_lon < 0.51"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
    }
}

