/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.util.function.Consumer;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieConversionUtils$;
import org.apache.hudi.HoodieDataSourceHelpers;
import org.apache.hudi.SparkDatasetMixin;
import org.apache.hudi.SparkDatasetMixin$class;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.functional.TestMORDataSource$;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.keygen.NonpartitionedKeyGenerator;
import org.apache.hudi.table.action.compact.CompactionTriggerStrategy;
import org.apache.hudi.testutils.DataSourceTestUtils;
import org.apache.hudi.testutils.HoodieClientTestBase;
import org.apache.hudi.testutils.HoodieClientTestHarness;
import org.apache.hudi.util.JFunction$;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSessionExtensions;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.hudi.HoodieSparkSessionExtension;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tub\u0001B\u0001\u0003\u0001-\u0011\u0011\u0003V3ti6{%\u000bR1uCN{WO]2f\u0015\t\u0019A!\u0001\u0006gk:\u001cG/[8oC2T!!\u0002\u0004\u0002\t!,H-\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001a!\u0003\u0005\u0002\u000e!5\taB\u0003\u0002\u0010\t\u0005IA/Z:ukRLGn]\u0005\u0003#9\u0011A\u0003S8pI&,7\t\\5f]R$Vm\u001d;CCN,\u0007CA\n\u0015\u001b\u0005!\u0011BA\u000b\u0005\u0005E\u0019\u0006/\u0019:l\t\u0006$\u0018m]3u\u001b&D\u0018N\u001c\u0005\u0006/\u0001!\t\u0001G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0001\"A\u0007\u0001\u000e\u0003\tAq\u0001\b\u0001A\u0002\u0013\u0005Q$A\u0003ta\u0006\u00148.F\u0001\u001f!\ty2%D\u0001!\u0015\t\t#%A\u0002tc2T!\u0001\b\u0004\n\u0005\u0011\u0002#\u0001D*qCJ\\7+Z:tS>t\u0007b\u0002\u0014\u0001\u0001\u0004%\taJ\u0001\ngB\f'o[0%KF$\"\u0001\u000b\u0018\u0011\u0005%bS\"\u0001\u0016\u000b\u0003-\nQa]2bY\u0006L!!\f\u0016\u0003\tUs\u0017\u000e\u001e\u0005\b_\u0015\n\t\u00111\u0001\u001f\u0003\rAH%\r\u0005\u0007c\u0001\u0001\u000b\u0015\u0002\u0010\u0002\rM\u0004\u0018M]6!\u0011\u001d\u0019\u0004A1A\u0005\nQ\n1\u0001\\8h+\u0005)\u0004C\u0001\u001c:\u001b\u00059$B\u0001\u001d\u0007\u0003\u0015awn\u001a\u001bk\u0013\tQtG\u0001\u0004M_\u001e<WM\u001d\u0005\u0007y\u0001\u0001\u000b\u0011B\u001b\u0002\t1|w\r\t\u0005\b}\u0001\u0011\r\u0011\"\u0001@\u0003)\u0019w.\\7p]>\u0003Ho]\u000b\u0002\u0001B!\u0011I\u0012%I\u001b\u0005\u0011%BA\"E\u0003%IW.\\;uC\ndWM\u0003\u0002FU\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u001d\u0013%aA'baB\u0011\u0011JT\u0007\u0002\u0015*\u00111\nT\u0001\u0005Y\u0006twMC\u0001N\u0003\u0011Q\u0017M^1\n\u0005=S%AB*ue&tw\r\u0003\u0004R\u0001\u0001\u0006I\u0001Q\u0001\fG>lWn\u001c8PaR\u001c\b\u0005C\u0004T\u0001\t\u0007I\u0011\u0001+\u0002\u001fY,'/\u001b4jG\u0006$\u0018n\u001c8D_2,\u0012!\u0016\t\u0003-fs!!K,\n\u0005aS\u0013A\u0002)sK\u0012,g-\u0003\u0002P5*\u0011\u0001L\u000b\u0005\u00079\u0002\u0001\u000b\u0011B+\u0002!Y,'/\u001b4jG\u0006$\u0018n\u001c8D_2\u0004\u0003b\u00020\u0001\u0005\u0004%\t\u0001V\u0001\u0017kB$\u0017\r^3e-\u0016\u0014\u0018NZ5dCRLwN\u001c,bY\"1\u0001\r\u0001Q\u0001\nU\u000bq#\u001e9eCR,GMV3sS\u001aL7-\u0019;j_:4\u0016\r\u001c\u0011\t\u000b\t\u0004A\u0011I2\u0002\u000bM,G/\u00169\u0015\u0003!B#!Y3\u0011\u0005\u0019lW\"A4\u000b\u0005!L\u0017aA1qS*\u0011!n[\u0001\bUV\u0004\u0018\u000e^3s\u0015\ta\u0007\"A\u0003kk:LG/\u0003\u0002oO\nQ!)\u001a4pe\u0016,\u0015m\u00195\t\u000bA\u0004A\u0011I2\u0002\u0011Q,\u0017M\u001d#po:D#a\u001c:\u0011\u0005\u0019\u001c\u0018B\u0001;h\u0005%\te\r^3s\u000b\u0006\u001c\u0007\u000eC\u0003w\u0001\u0011\u0005s/A\u0011hKR\u001c\u0006/\u0019:l'\u0016\u001c8/[8o\u000bb$XM\\:j_:\u001c\u0018J\u001c6fGR|'\u000fF\u0001y!\u0011Ih0!\u0001\u000e\u0003iT!a\u001f?\u0002\tU$\u0018\u000e\u001c\u0006\u0003{\u0012\taaY8n[>t\u0017BA@{\u0005\u0019y\u0005\u000f^5p]B1\u00111AA\u0006\u0003\u001fi!!!\u0002\u000b\t\u0005\u001d\u0011\u0011B\u0001\tMVt7\r^5p]*\u00111\u0010T\u0005\u0005\u0003\u001b\t)A\u0001\u0005D_:\u001cX/\\3s!\ry\u0012\u0011C\u0005\u0004\u0003'\u0001#AF*qCJ\\7+Z:tS>tW\t\u001f;f]NLwN\\:\t\r\u0005]\u0001\u0001\"\u0001d\u0003%!Xm\u001d;D_VtG\u000f\u000b\u0003\u0002\u0016\u0005m\u0001c\u00014\u0002\u001e%\u0019\u0011qD4\u0003\tQ+7\u000f\u001e\u0005\u0007\u0003G\u0001A\u0011A2\u0002#Q,7\u000f\u001e)bs2|\u0017\r\u001a#fY\u0016$X\r\u000b\u0003\u0002\"\u0005m\u0001BBA\u0015\u0001\u0011\u00051-\u0001\nuKN$\bK];oK\u00124\u0015\u000e\u001c;fe\u0016$\u0007\u0006BA\u0014\u00037Aa!a\f\u0001\t\u0003\u0019\u0017\u0001\u0006;fgR4Vm\u0019;pe&TX\r\u001a*fC\u0012,'\u000f\u000b\u0003\u0002.\u0005m\u0001BBA\u001b\u0001\u0011\u00051-\u0001\tuKN$hj\u001c)sK\u000e|WNY5oK\"\"\u00111GA\u000e\u0011\u0019\tY\u0004\u0001C\u0001G\u0006iB/Z:u!J,7i\\7cS:,g)\u001b7fI\u001a{'OU3bI6{%\u000b\u000b\u0003\u0002:\u0005m\u0001bBA!\u0001\u0011%\u00111I\u0001\noJLG/\u001a#bi\u0006$2\u0001KA#\u0011!\t9%a\u0010A\u0002\u0005%\u0013\u0001\u00023bi\u0006\u0004B\"KA&\u0003\u001f*\u0016qJA(\u0003+J1!!\u0014+\u0005\u0019!V\u000f\u001d7fkA\u0019\u0011&!\u0015\n\u0007\u0005M#FA\u0002J]R\u00042!KA,\u0013\r\tIF\u000b\u0002\b\u0005>|G.Z1o\u0011\u001d\ti\u0006\u0001C\u0005\u0003?\n1b\u00195fG.\fen]<feR\u0019\u0001&!\u0019\t\u0011\u0005\r\u00141\fa\u0001\u0003\u0013\na!\u001a=qK\u000e$\bbBA4\u0001\u0011\u0005\u0011\u0011N\u0001\u0015m\u0016\u0014\u0018NZ=TG\",W.Y!oIRK\b/Z:\u0015\u0007!\nY\u0007\u0003\u0005\u0002n\u0005\u0015\u0004\u0019AA8\u0003\t!g\r\u0005\u0003\u0002r\u00055e\u0002BA:\u0003\u0013sA!!\u001e\u0002\b:!\u0011qOAC\u001d\u0011\tI(a!\u000f\t\u0005m\u0014\u0011Q\u0007\u0003\u0003{R1!a \u000b\u0003\u0019a$o\\8u}%\t\u0011\"\u0003\u0002\b\u0011%\u0011ADB\u0005\u0003C\tJ1!a#!\u0003\u001d\u0001\u0018mY6bO\u0016LA!a$\u0002\u0012\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0004\u0003\u0017\u0003\u0003bBAK\u0001\u0011\u0005\u0011qS\u0001\u000bm\u0016\u0014\u0018NZ=TQ><Hc\u0001\u0015\u0002\u001a\"A\u0011QNAJ\u0001\u0004\ty\u0007C\u0004\u0002\u001e\u0002!\t!a(\u0002IQ,7\u000f^)vKJLXj\u0014*XSRD')Y:f!\u0006$\b.\u00118e\r&dW-\u00138eKb$R\u0001KAQ\u0003KC\u0001\"a)\u0002\u001c\u0002\u0007\u0011QK\u0001\u0010a\u0006\u0014H/\u001b;j_:,enY8eK\"A\u0011qUAN\u0001\u0004\t)&A\tjg6+G/\u00193bi\u0006,e.\u00192mK\u0012D\u0003\"a'\u0002,\u0006m\u0016Q\u0018\t\u0005\u0003[\u000b9,\u0004\u0002\u00020*!\u0011\u0011WAZ\u0003!\u0001(o\u001c<jI\u0016\u0014(bAA[S\u00061\u0001/\u0019:b[NLA!!/\u00020\nI1i\u001d<T_V\u00148-Z\u0001\u0006m\u0006dW/\u001a\u0017\t\u0003\u007f\u000b\u0019-a2\u0002L\u0006\u0012\u0011\u0011Y\u0001\u000biJ,X\r\f4bYN,\u0017EAAc\u0003%!(/^3-iJ,X-\t\u0002\u0002J\u0006Qa-\u00197tK2\"(/^3\"\u0005\u00055\u0017a\u00034bYN,GFZ1mg\u0016DC!a'\u0002RB!\u00111[Ak\u001b\t\t\u0019,\u0003\u0003\u0002X\u0006M&!\u0005)be\u0006lW\r^3sSj,G\rV3ti\"9\u00111\u001c\u0001\u0005\u0002\u0005u\u0017!\u0006;fgRluJ\u0015)beRLG/[8o!J,h.\u001a\u000b\u0006Q\u0005}\u0017\u0011\u001d\u0005\t\u0003G\u000bI\u000e1\u0001\u0002V!A\u00111]Am\u0001\u0004\t)&\u0001\niSZ,7\u000b^=mKB\u000b'\u000f^5uS>t\u0007\u0006CAm\u0003W\u000bY,a:-\u0011\u0005%\u0018Q^Ay\u0003k\f#!a;\u0002\u0017Q\u0014X/\u001a\u0017!M\u0006d7/Z\u0011\u0003\u0003_\f1BZ1mg\u0016d\u0003\u0005\u001e:vK\u0006\u0012\u00111_\u0001\rM\u0006d7/\u001a\u0017!M\u0006d7/Z\u0011\u0003\u0003o\f!\u0002\u001e:vK2\u0002CO];fQ\u0011\tI.!5\t\r\u0005u\b\u0001\"\u0001d\u0003\u0001\"Xm\u001d;SK\u0006$\u0007+\u0019;ig\u001a{'/T3sO\u0016|eNU3bIR\u000b'\r\\3)\t\u0005m\u00181\u0004\u0005\u0007\u0005\u0007\u0001A\u0011A2\u00029Q,7\u000f\u001e*fC\u0012\u0004\u0016\r\u001e5t\r>\u0014xJ\u001c7z\u0019><g)\u001b7fg\"\"!\u0011AA\u000e\u0011\u0019\u0011I\u0001\u0001C\u0001G\u0006yB/Z:u%\u0016\fG\rT8h\u001f:d\u00170T3sO\u0016|eNU3bIR\u000b'\r\\3)\t\t\u001d\u00111\u0004\u0005\u0007\u0005\u001f\u0001A\u0011A2\u0002?Q,7\u000f\u001e+f[B4\u0015\u000e\\3t\u00072,\u0017M\u001c$pe\u000ecWo\u001d;fe&tw\r\u000b\u0003\u0003\u000e\u0005m\u0001B\u0002B\u000b\u0001\u0011\u00051-\u0001\u0010uKN$8\t\\;ti\u0016\u0014\u0018N\\4P]:+H\u000e\\1cY\u0016\u001cu\u000e\\;n]\"\"!1CA\u000e\u0011\u0019\u0011Y\u0002\u0001C\u0001G\u00061B/Z:u\u0011>|G-[3Jg\u0012+G.\u001a;fI6{%\u000b\u000b\u0003\u0003\u001a\u0005m\u0001B\u0002B\u0011\u0001\u0011\u00051-A\u0018uKN$\bK];oKB\u000b'\u000f^5uS>tgi\u001c:US6,7\u000f^1na\n\u000b7/\u001a3LKf<UM\\3sCR|'\u000f\u000b\u0003\u0003 \u0005m\u0001B\u0002B\u0014\u0001\u0011\u00051-\u0001#uKN$(+Z1e\u001fB$\u0018.\\5{K\u0012\fV/\u001a:z\u0003\u001a$XM]%oM2Lw\r\u001b;D_6\u0004\u0018m\u0019;j_:\fe\u000eZ\"p[BdW\r^3e\t\u0016dG/Y\"p[6LG\u000f\u000b\u0003\u0003&\u0005m\u0001\u0002\u0004B\u0017\u0001A\u0005\t\u0011!A\u0005\u0002\t=\u0012!\u00059s_R,7\r^3eI\u0011\fG/Y$f]R!!\u0011\u0007B\u001e!\u0011\u0011\u0019Da\u000e\u000e\u0005\tU\"BA\b}\u0013\u0011\u0011ID!\u000e\u0003/!{w\u000eZ5f)\u0016\u001cH\u000fR1uC\u001e+g.\u001a:bi>\u0014\b\u0002C\u0018\u0003,\u0005\u0005\t\u0019A\r")
public class TestMORDataSource
extends HoodieClientTestBase
implements SparkDatasetMixin {
    private SparkSession spark;
    private final Logger log;
    private final scala.collection.immutable.Map<String, String> commonOpts;
    private final String verificationCol;
    private final String updatedVerificationVal;

    @Override
    public Dataset<Row> toDataset(SparkSession spark, java.util.List<HoodieRecord<?>> records) {
        return SparkDatasetMixin$class.toDataset(this, spark, records);
    }

    public /* synthetic */ HoodieTestDataGenerator protected$dataGen(TestMORDataSource x$1) {
        return x$1.dataGen;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    private Logger log() {
        return this.log;
    }

    public scala.collection.immutable.Map<String, String> commonOpts() {
        return this.commonOpts;
    }

    public String verificationCol() {
        return this.verificationCol;
    }

    public String updatedVerificationVal() {
        return this.updatedVerificationVal;
    }

    @BeforeEach
    public void setUp() {
        this.setTableName("hoodie_test");
        this.initPath();
        this.initSparkContexts();
        this.spark_$eq(this.sqlContext.sparkSession());
        this.initTestDataGenerator();
        this.initFileSystem();
    }

    @AfterEach
    public void tearDown() {
        this.cleanupSparkContexts();
        this.cleanupTestDataGenerator();
        this.cleanupFileSystem();
    }

    public Option<Consumer<SparkSessionExtensions>> getSparkSessionExtensionsInjector() {
        return HoodieConversionUtils$.MODULE$.toJavaOption((scala.Option)new Some((Object)JFunction$.MODULE$.toJava((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(SparkSessionExtensions receiver) {
                new HoodieSparkSessionExtension().apply(receiver);
            }
        })));
    }

    @Test
    public void testCount() {
        Buffer records1 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(100)))).asScala();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option("hoodie.compact.inline", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath);
        Assertions.assertTrue((boolean)HoodieDataSourceHelpers.hasNewCommits((FileSystem)this.fs, (String)this.basePath, (String)"000"));
        Dataset hudiSnapshotDF1 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder().append((Object)this.basePath).append((Object)"/*/*/*/*").toString());
        Assertions.assertEquals((long)100L, (long)hudiSnapshotDF1.count());
        Buffer records2 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateUniqueUpdates("002", Predef$.MODULE$.int2Integer(100)))).asScala();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Append).save(this.basePath);
        Dataset hudiSnapshotDF2 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder().append((Object)this.basePath).append((Object)"/*/*/*/*").toString());
        Assertions.assertEquals((long)100L, (long)hudiSnapshotDF2.count());
        String commit1Time = ((Row)hudiSnapshotDF1.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).head()).get(0).toString();
        String commit2Time = ((Row)hudiSnapshotDF2.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).head()).get(0).toString();
        Assertions.assertEquals((long)hudiSnapshotDF2.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().count(), (long)1L);
        Assertions.assertTrue((boolean)new StringOps(Predef$.MODULE$.augmentString(commit2Time)).$greater((Object)commit1Time));
        Assertions.assertEquals((long)100L, (long)hudiSnapshotDF2.join(hudiSnapshotDF1, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_hoodie_record_key"})), "left").count());
        Dataset hudiIncDF1 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), "000").option(DataSourceReadOptions$.MODULE$.END_INSTANTTIME().key(), commit1Time).load(this.basePath);
        Assertions.assertEquals((long)100L, (long)hudiIncDF1.count());
        Assertions.assertEquals((long)1L, (long)hudiIncDF1.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().count());
        Assertions.assertEquals((Object)commit1Time, (Object)((Row)hudiIncDF1.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).head()).get(0).toString());
        hudiIncDF1.show(1);
        Dataset hudiIncDF2 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), commit1Time).option(DataSourceReadOptions$.MODULE$.END_INSTANTTIME().key(), commit2Time).load(this.basePath);
        Assertions.assertEquals((long)100L, (long)hudiIncDF2.count());
        Assertions.assertEquals((long)1L, (long)hudiIncDF2.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().count());
        Assertions.assertEquals((Object)commit2Time, (Object)((Row)hudiIncDF2.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).head()).get(0).toString());
        hudiIncDF2.show(1);
        Dataset hudiIncDF3 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), "000").option(DataSourceReadOptions$.MODULE$.END_INSTANTTIME().key(), commit2Time).load(this.basePath);
        Assertions.assertEquals((long)100L, (long)hudiIncDF3.count());
        Assertions.assertEquals((long)1L, (long)hudiIncDF3.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().count());
        Assertions.assertEquals((Object)commit2Time, (Object)((Row)hudiIncDF3.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).head()).get(0).toString());
        Dataset emptyIncDF = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), "000").option(DataSourceReadOptions$.MODULE$.END_INSTANTTIME().key(), "001").load(this.basePath);
        Assertions.assertEquals((long)0L, (long)emptyIncDF.count());
        Dataset hudiSnapshotSkipMergeDF2 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.REALTIME_MERGE().key(), DataSourceReadOptions$.MODULE$.REALTIME_SKIP_MERGE_OPT_VAL()).load(new StringBuilder().append((Object)this.basePath).append((Object)"/*/*/*/*").toString());
        Assertions.assertEquals((long)200L, (long)hudiSnapshotSkipMergeDF2.count());
        Assertions.assertEquals((long)100L, (long)hudiSnapshotSkipMergeDF2.select("_hoodie_record_key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().count());
        Assertions.assertEquals((long)200L, (long)hudiSnapshotSkipMergeDF2.join(hudiSnapshotDF2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_hoodie_record_key"})), "left").count());
        Dataset hudiRODF2 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).load(new StringBuilder().append((Object)this.basePath).append((Object)"/*/*/*/*").toString());
        Assertions.assertEquals((long)100L, (long)hudiRODF2.count());
        Buffer records3 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateUniqueUpdates("003", Predef$.MODULE$.int2Integer(50)))).asScala();
        Dataset inputDF3 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records3, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF3.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Append).save(this.basePath);
        Dataset hudiSnapshotDF3 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder().append((Object)this.basePath).append((Object)"/*/*/*/*").toString());
        Assertions.assertEquals((long)100L, (long)hudiSnapshotDF3.count());
        Assertions.assertEquals((long)hudiSnapshotDF3.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().count(), (long)2L);
        Assertions.assertEquals((long)50L, (long)hudiSnapshotDF3.filter(functions$.MODULE$.col("_hoodie_commit_time").$greater((Object)commit2Time)).count());
        Assertions.assertEquals((long)50L, (long)hudiSnapshotDF3.join(hudiSnapshotDF2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_hoodie_record_key", "_hoodie_commit_time"})), "inner").count());
        Dataset hudiIncDF4 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), commit2Time).load(this.basePath);
        Assertions.assertEquals((long)50L, (long)hudiIncDF4.count());
        Dataset hudiIncDF4SkipMerge = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), "000").option(DataSourceReadOptions$.MODULE$.REALTIME_MERGE().key(), DataSourceReadOptions$.MODULE$.REALTIME_SKIP_MERGE_OPT_VAL()).load(this.basePath);
        Assertions.assertEquals((long)200L, (long)hudiIncDF4SkipMerge.count());
        String[] partitionPaths = new String[]{"2020/01/10"};
        HoodieTestDataGenerator newDataGen = new HoodieTestDataGenerator(partitionPaths);
        Buffer records4 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)newDataGen.generateInserts("004", Predef$.MODULE$.int2Integer(100)))).asScala();
        Dataset inputDF4 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records4, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF4.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Append).save(this.basePath);
        Dataset hudiSnapshotDF4 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder().append((Object)this.basePath).append((Object)"/*/*/*/*").toString());
        Assertions.assertEquals((long)200L, (long)hudiSnapshotDF4.count());
        Assertions.assertEquals((long)100L, (long)hudiSnapshotDF1.join(hudiSnapshotDF4, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_hoodie_record_key"})), "inner").count());
        Dataset hudiIncDF5 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), commit2Time).load(this.basePath);
        Assertions.assertEquals((long)150L, (long)hudiIncDF5.count());
        Buffer records5 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)newDataGen.generateUniqueUpdates("005", Predef$.MODULE$.int2Integer(50)))).asScala();
        Dataset inputDF5 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records5, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF5.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Append).save(this.basePath);
        String commit5Time = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs, (String)this.basePath);
        Dataset hudiSnapshotDF5 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder().append((Object)this.basePath).append((Object)"/*/*/*/*").toString());
        Assertions.assertEquals((long)200L, (long)hudiSnapshotDF5.count());
        Buffer records6 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)newDataGen.generateInserts("006", Predef$.MODULE$.int2Integer(2)))).asScala();
        Dataset inputDF6 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records6, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF6.write().format("org.apache.hudi").options(this.commonOpts()).option("hoodie.compact.inline", "true").mode(SaveMode.Append).save(this.basePath);
        String commit6Time = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs, (String)this.basePath);
        Dataset hudiSnapshotDF6 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder().append((Object)this.basePath).append((Object)"/2020/01/10/*").toString());
        Assertions.assertEquals((long)102L, (long)hudiSnapshotDF6.count());
        Dataset hudiIncDF6 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), commit5Time).option(DataSourceReadOptions$.MODULE$.END_INSTANTTIME().key(), commit6Time).load(this.basePath);
        Assertions.assertEquals((long)2L, (long)hudiIncDF6.count());
    }

    @Test
    public void testPayloadDelete() {
        Buffer records1 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(100)))).asScala();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option("hoodie.compact.inline", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath);
        Assertions.assertTrue((boolean)HoodieDataSourceHelpers.hasNewCommits((FileSystem)this.fs, (String)this.basePath, (String)"000"));
        Dataset hudiSnapshotDF1 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder().append((Object)this.basePath).append((Object)"/*/*/*/*").toString());
        Assertions.assertEquals((long)100L, (long)hudiSnapshotDF1.count());
        Buffer records2 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateUniqueDeleteRecords("002", Predef$.MODULE$.int2Integer(50)))).asScala();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Append).save(this.basePath);
        Dataset hudiSnapshotDF2 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder().append((Object)this.basePath).append((Object)"/*/*/*/*").toString());
        Assertions.assertEquals((long)50L, (long)hudiSnapshotDF2.count());
        Assertions.assertEquals((long)hudiSnapshotDF2.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().count(), (long)1L);
        String commit1Time = ((Row)hudiSnapshotDF1.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).head()).get(0).toString();
        String commit2Time = ((Row)hudiSnapshotDF2.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).head()).get(0).toString();
        Assertions.assertTrue((boolean)commit1Time.equals(commit2Time));
        Assertions.assertEquals((long)50L, (long)hudiSnapshotDF2.join(hudiSnapshotDF1, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_hoodie_record_key"})), "left").count());
        Dataset hudiSnapshotDF2Unmerge = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.REALTIME_MERGE().key(), DataSourceReadOptions$.MODULE$.REALTIME_SKIP_MERGE_OPT_VAL()).load(new StringBuilder().append((Object)this.basePath).append((Object)"/*/*/*/*").toString());
        Assertions.assertEquals((long)100L, (long)hudiSnapshotDF2Unmerge.count());
        Dataset hudiIncDF1 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), commit2Time).load(this.basePath);
        Assertions.assertEquals((long)0L, (long)hudiIncDF1.count());
        Buffer records3 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateUniqueDeleteRecords("003", Predef$.MODULE$.int2Integer(50)))).asScala();
        Dataset inputDF3 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records3, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF3.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Append).save(this.basePath);
        Dataset hudiSnapshotDF3 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder().append((Object)this.basePath).append((Object)"/*/*/*/*").toString());
        Assertions.assertEquals((long)0L, (long)hudiSnapshotDF3.count());
    }

    @Test
    public void testPrunedFiltered() {
        scala.collection.immutable.Map opts = this.commonOpts().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition_path"));
        java.util.List hoodieRecords1 = this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(100));
        Dataset<Row> inputDF1 = this.toDataset(this.spark(), hoodieRecords1);
        inputDF1.write().format("org.apache.hudi").options((Map)opts).option("hoodie.compact.inline", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_NAME().key(), DefaultHoodieRecordPayload.class.getName()).mode(SaveMode.Overwrite).save(this.basePath);
        Dataset hudiSnapshotDF1 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder().append((Object)this.basePath).append((Object)"/*/*/*/*").toString());
        String commit1Time = ((Row)hudiSnapshotDF1.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).head()).get(0).toString();
        Assertions.assertEquals((long)100L, (long)hudiSnapshotDF1.count());
        Assertions.assertEquals((Object)"amount,currency,tip_history,_hoodie_commit_seqno", (Object)Predef$.MODULE$.refArrayOps((Object[])hudiSnapshotDF1.select("fare.amount", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fare.currency", "tip_history", "_hoodie_commit_seqno"})).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.desc("_hoodie_commit_seqno")})).columns()).mkString(","));
        java.util.List records2 = this.dataGen.generateUniqueUpdates("002", Predef$.MODULE$.int2Integer(50));
        Dataset<Row> inputDF2 = this.toDataset(this.spark(), records2);
        inputDF2.write().format("org.apache.hudi").options((Map)opts).mode(SaveMode.Append).save(this.basePath);
        Dataset hudiSnapshotDF2 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder().append((Object)this.basePath).append((Object)"/*/*/*/*").toString());
        Dataset hudiIncDF1 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), "000").load(this.basePath);
        Dataset hudiIncDF1Skipmerge = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.REALTIME_MERGE().key(), DataSourceReadOptions$.MODULE$.REALTIME_SKIP_MERGE_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), "000").load(this.basePath);
        Dataset hudiIncDF2 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), commit1Time).load(this.basePath);
        Assertions.assertEquals((long)50L, (long)hudiSnapshotDF2.select("_hoodie_commit_seqno", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fare.amount", "fare.currency", "tip_history"})).filter(functions$.MODULE$.col("_hoodie_commit_time").$greater((Object)commit1Time)).count());
        Assertions.assertEquals((long)50L, (long)hudiIncDF1.select("_hoodie_commit_seqno", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fare.amount", "fare.currency", "tip_history"})).filter(functions$.MODULE$.col("_hoodie_commit_time").$greater((Object)commit1Time)).count());
        Assertions.assertEquals((long)50L, (long)hudiIncDF2.select("_hoodie_commit_seqno", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fare.amount", "fare.currency", "tip_history"})).count());
        Assertions.assertEquals((long)150L, (long)hudiIncDF1Skipmerge.select("_hoodie_commit_seqno", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fare.amount", "fare.currency", "tip_history"})).count());
        this.verifySchemaAndTypes((Dataset<Row>)hudiSnapshotDF1);
        this.verifySchemaAndTypes((Dataset<Row>)hudiSnapshotDF2);
        this.verifySchemaAndTypes((Dataset<Row>)hudiIncDF1);
        this.verifySchemaAndTypes((Dataset<Row>)hudiIncDF2);
        this.verifySchemaAndTypes((Dataset<Row>)hudiIncDF1Skipmerge);
        this.verifyShow((Dataset<Row>)hudiSnapshotDF1);
        this.verifyShow((Dataset<Row>)hudiSnapshotDF2);
        this.verifyShow((Dataset<Row>)hudiIncDF1);
        this.verifyShow((Dataset<Row>)hudiIncDF2);
        this.verifyShow((Dataset<Row>)hudiIncDF1Skipmerge);
        java.util.List record3 = this.dataGen.generateUpdatesWithTS("003", hoodieRecords1, -1);
        Dataset<Row> inputDF3 = this.toDataset(this.spark(), record3);
        inputDF3.write().format("org.apache.hudi").options((Map)opts).mode(SaveMode.Append).save(this.basePath);
        Dataset hudiSnapshotDF3 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder().append((Object)this.basePath).append((Object)"/*/*/*/*").toString());
        this.verifyShow((Dataset<Row>)hudiSnapshotDF3);
        Assertions.assertEquals((long)100L, (long)hudiSnapshotDF3.count());
        Assertions.assertEquals((long)0L, (long)hudiSnapshotDF3.filter("rider = 'rider-003'").count());
    }

    @Test
    public void testVectorizedReader() {
        this.spark().conf().set("spark.sql.parquet.enableVectorizedReader", true);
        Assertions.assertTrue((boolean)new StringOps(Predef$.MODULE$.augmentString(this.spark().conf().get("spark.sql.parquet.enableVectorizedReader"))).toBoolean());
        String schema = "{\"type\":\"record\",\"name\":\"shortTripRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false}]}";
        Buffer records1 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInsertsAsPerSchema("001", Predef$.MODULE$.int2Integer(100), schema))).asScala();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option("hoodie.compact.inline", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath);
        Dataset hudiSnapshotDF1 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder().append((Object)this.basePath).append((Object)"/*/*/*/*").toString());
        Assertions.assertEquals((long)100L, (long)hudiSnapshotDF1.count());
        Buffer records2 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateUniqueUpdatesAsPerSchema("002", Predef$.MODULE$.int2Integer(50), schema))).asScala();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Append).save(this.basePath);
        Dataset hudiSnapshotDF2 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder().append((Object)this.basePath).append((Object)"/*/*/*/*").toString());
        Assertions.assertEquals((long)100L, (long)hudiSnapshotDF2.count());
        Row sampleRow = (Row)hudiSnapshotDF2.select("fare", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"driver", "_hoodie_is_deleted"})).head();
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)sampleRow.getDouble(0)), (Object)sampleRow.get(0));
        Assertions.assertEquals((Object)sampleRow.getString(1), (Object)sampleRow.get(1));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)sampleRow.getBoolean(2)), (Object)sampleRow.get(2));
        hudiSnapshotDF1.show(1);
        hudiSnapshotDF2.show(1);
    }

    @Test
    public void testNoPrecombine() {
        Buffer records = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("000", Predef$.MODULE$.int2Integer(100)))).asScala();
        Dataset inputDF = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records, 2, ClassTag$.MODULE$.apply(String.class)));
        scala.collection.immutable.Map commonOptsNoPreCombine = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test")}));
        inputDF.write().format("hudi").options((Map)commonOptsNoPreCombine).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), "MERGE_ON_READ").mode(SaveMode.Overwrite).save(this.basePath);
        this.spark().read().format("org.apache.hudi").load(this.basePath).count();
    }

    @Test
    public void testPreCombineFiledForReadMOR() {
        this.writeData((Tuple5<Object, String, Object, Object, Object>)new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a0", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)100), (Object)BoxesRunTime.boxToBoolean((boolean)false)));
        this.checkAnswer((Tuple5<Object, String, Object, Object, Object>)new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a0", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)100), (Object)BoxesRunTime.boxToBoolean((boolean)false)));
        this.writeData((Tuple5<Object, String, Object, Object, Object>)new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a0", (Object)BoxesRunTime.boxToInteger((int)12), (Object)BoxesRunTime.boxToInteger((int)99), (Object)BoxesRunTime.boxToBoolean((boolean)false)));
        this.checkAnswer((Tuple5<Object, String, Object, Object, Object>)new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a0", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)100), (Object)BoxesRunTime.boxToBoolean((boolean)false)));
        this.writeData((Tuple5<Object, String, Object, Object, Object>)new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a0", (Object)BoxesRunTime.boxToInteger((int)12), (Object)BoxesRunTime.boxToInteger((int)101), (Object)BoxesRunTime.boxToBoolean((boolean)false)));
        this.checkAnswer((Tuple5<Object, String, Object, Object, Object>)new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a0", (Object)BoxesRunTime.boxToInteger((int)12), (Object)BoxesRunTime.boxToInteger((int)101), (Object)BoxesRunTime.boxToBoolean((boolean)false)));
        this.writeData((Tuple5<Object, String, Object, Object, Object>)new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a0", (Object)BoxesRunTime.boxToInteger((int)14), (Object)BoxesRunTime.boxToInteger((int)98), (Object)BoxesRunTime.boxToBoolean((boolean)false)));
        this.checkAnswer((Tuple5<Object, String, Object, Object, Object>)new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a0", (Object)BoxesRunTime.boxToInteger((int)12), (Object)BoxesRunTime.boxToInteger((int)101), (Object)BoxesRunTime.boxToBoolean((boolean)false)));
        this.writeData((Tuple5<Object, String, Object, Object, Object>)new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a0", (Object)BoxesRunTime.boxToInteger((int)16), (Object)BoxesRunTime.boxToInteger((int)97), (Object)BoxesRunTime.boxToBoolean((boolean)true)));
        this.checkAnswer((Tuple5<Object, String, Object, Object, Object>)new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a0", (Object)BoxesRunTime.boxToInteger((int)12), (Object)BoxesRunTime.boxToInteger((int)101), (Object)BoxesRunTime.boxToBoolean((boolean)false)));
        this.writeData((Tuple5<Object, String, Object, Object, Object>)new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a0", (Object)BoxesRunTime.boxToInteger((int)18), (Object)BoxesRunTime.boxToInteger((int)96), (Object)BoxesRunTime.boxToBoolean((boolean)false)));
        this.checkAnswer((Tuple5<Object, String, Object, Object, Object>)new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a0", (Object)BoxesRunTime.boxToInteger((int)12), (Object)BoxesRunTime.boxToInteger((int)101), (Object)BoxesRunTime.boxToBoolean((boolean)false)));
    }

    private void writeData(Tuple5<Object, String, Object, Object, Object> data) {
        SparkSession _spark = this.spark();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestMORDataSource.class.getClassLoader());
        public final class Org_apache_hudi_functional_TestMORDataSource$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Int").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("scala.Boolean").asType().toTypeConstructor()})));
            }

            public Org_apache_hudi_functional_TestMORDataSource$$typecreator5$1(TestMORDataSource $outer) {
            }
        }
        Dataset df = _spark.implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{data})), _spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_functional_TestMORDataSource$$typecreator5$1(this)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "version", "_hoodie_is_deleted"}));
        df.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_NAME().key(), DefaultHoodieRecordPayload.class.getCanonicalName()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "id").option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "version").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "").option(DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key(), NonpartitionedKeyGenerator.class.getName()).mode(SaveMode.Append).save(this.basePath);
    }

    private void checkAnswer(Tuple5<Object, String, Object, Object, Object> expect) {
        Dataset readDf = this.spark().read().format("org.apache.hudi").load(new StringBuilder().append((Object)this.basePath).append((Object)"/*").toString());
        if (BoxesRunTime.unboxToBoolean((Object)expect._5())) {
            if (!readDf.isEmpty()) {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Found df ").append((Object)((Row)readDf.collectAsList().get(0)).mkString(",")).toString());
            }
            Assertions.assertTrue((boolean)readDf.isEmpty());
        } else {
            Row row1 = ((Row[])readDf.select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name", "value", "version", "_hoodie_is_deleted"})).take(1))[0];
            Assertions.assertEquals((Object)Row$.MODULE$.apply(expect.productIterator().toSeq()), (Object)row1);
        }
    }

    public void verifySchemaAndTypes(Dataset<Row> df) {
        Assertions.assertEquals((Object)"amount,currency,tip_history,_hoodie_commit_seqno", (Object)Predef$.MODULE$.refArrayOps((Object[])df.select("fare.amount", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fare.currency", "tip_history", "_hoodie_commit_seqno"})).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.desc("_hoodie_commit_seqno")})).columns()).mkString(","));
        Row sampleRow = (Row)df.select("begin_lat", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"current_date", "fare.currency", "tip_history", "nation"})).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.desc("_hoodie_commit_time")})).head();
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)sampleRow.getDouble(0)), (Object)sampleRow.get(0));
        Assertions.assertEquals((Object)sampleRow.getDate(1), (Object)sampleRow.get(1));
        Assertions.assertEquals((Object)sampleRow.getString(2), (Object)sampleRow.get(2));
        Assertions.assertEquals((Object)sampleRow.getSeq(3), (Object)sampleRow.get(3));
        Assertions.assertEquals((Object)sampleRow.getAs(4), (Object)sampleRow.get(4));
    }

    public void verifyShow(Dataset<Row> df) {
        df.show(1);
        df.select("_hoodie_commit_seqno", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fare.amount", "fare.currency", "tip_history"})).show(1);
    }

    @ParameterizedTest
    @CsvSource(value={"true,false", "true,true", "false,true", "false,false"})
    public void testQueryMORWithBasePathAndFileIndex(boolean partitionEncode, boolean isMetadataEnabled) {
        int N = 20;
        java.util.List records1 = this.dataGen.generateInsertsContainsAllPartitions("000", Predef$.MODULE$.int2Integer(N));
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)records1)).asScala(), 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING().key(), partitionEncode).option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabled).mode(SaveMode.Overwrite).save(this.basePath);
        String commitInstantTime1 = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs, (String)this.basePath);
        int countIn20160315 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(records1).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(HoodieRecord<?> record) {
                String string = record.getPartitionPath();
                String string2 = "2016/03/15";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        });
        long count1 = this.spark().read().format("hudi").option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabled).load(this.basePath).filter("partition = '2016/03/15'").count();
        Assertions.assertEquals((long)countIn20160315, (long)count1);
        String partitionPath = partitionEncode ? "2016%2F03%2F15" : "2016/03/15";
        long count2 = this.spark().read().format("hudi").option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabled).load(new StringBuilder().append((Object)this.basePath).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionPath}))).toString()).count();
        Assertions.assertEquals((long)countIn20160315, (long)count2);
        java.util.List records2 = this.dataGen.generateInsertsContainsAllPartitions("000", Predef$.MODULE$.int2Integer(N + 1));
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)records2)).asScala(), 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING().key(), partitionEncode).option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabled).mode(SaveMode.Append).save(this.basePath);
        Dataset hoodieIncViewDF1 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), commitInstantTime1).load(this.basePath);
        Assertions.assertEquals((long)(N + 1), (long)hoodieIncViewDF1.count());
    }

    @ParameterizedTest
    @CsvSource(value={"true, false", "false, true", "false, false", "true, true"})
    public void testMORPartitionPrune(boolean partitionEncode, boolean hiveStylePartition) {
        String[] partitions = (String[])((Object[])new String[]{"2021/03/01", "2021/03/02", "2021/03/03", "2021/03/04", "2021/03/05"});
        HoodieTestDataGenerator newDataGen = new HoodieTestDataGenerator(partitions);
        Buffer records1 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(newDataGen.generateInsertsContainsAllPartitions("000", Predef$.MODULE$.int2Integer(100))).asScala();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter(records1).asJava()))).asScala(), 2, ClassTag$.MODULE$.apply(String.class)));
        scala.collection.immutable.Map partitionCounts = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])partitions).map((Function1)new Serializable(this, records1){
            public static final long serialVersionUID = 0L;
            private final Buffer records1$1;

            public final Tuple2<String, Object> apply(String p) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)p), (Object)BoxesRunTime.boxToInteger((int)this.records1$1.count((Function1)new Serializable(this, p){
                    public static final long serialVersionUID = 0L;
                    private final String p$1;

                    public final boolean apply(HoodieRecord<?> r) {
                        String string = r.getPartitionPath();
                        String string2 = this.p$1;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        this.p$1 = p$1;
                    }
                })));
            }
            {
                this.records1$1 = records1$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
        inputDF1.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING().key(), partitionEncode).option(DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING().key(), hiveStylePartition).mode(SaveMode.Overwrite).save(this.basePath);
        long count1 = this.spark().read().format("hudi").load(this.basePath).filter("partition = '2021/03/01'").count();
        Assertions.assertEquals((long)BoxesRunTime.unboxToInt((Object)partitionCounts.apply((Object)"2021/03/01")), (long)count1);
        long count2 = this.spark().read().format("hudi").load(this.basePath).filter("partition > '2021/03/01' and partition < '2021/03/03'").count();
        Assertions.assertEquals((long)BoxesRunTime.unboxToInt((Object)partitionCounts.apply((Object)"2021/03/02")), (long)count2);
        long count3 = this.spark().read().format("hudi").load(this.basePath).filter("partition != '2021/03/01'").count();
        Assertions.assertEquals((long)(records1.size() - BoxesRunTime.unboxToInt((Object)partitionCounts.apply((Object)"2021/03/01"))), (long)count3);
        long count4 = this.spark().read().format("hudi").load(this.basePath).filter("partition like '2021/03/03%'").count();
        Assertions.assertEquals((long)BoxesRunTime.unboxToInt((Object)partitionCounts.apply((Object)"2021/03/03")), (long)count4);
        long count5 = this.spark().read().format("hudi").load(this.basePath).filter("partition like '%2021/03/%'").count();
        Assertions.assertEquals((long)records1.size(), (long)count5);
        long count6 = this.spark().read().format("hudi").load(this.basePath).filter("partition = '2021/03/01' or partition = '2021/03/05'").count();
        Assertions.assertEquals((long)(BoxesRunTime.unboxToInt((Object)partitionCounts.apply((Object)"2021/03/01")) + BoxesRunTime.unboxToInt((Object)partitionCounts.apply((Object)"2021/03/05"))), (long)count6);
        long count7 = this.spark().read().format("hudi").load(this.basePath).filter("substr(partition, 9, 10) = '03'").count();
        Assertions.assertEquals((long)BoxesRunTime.unboxToInt((Object)partitionCounts.apply((Object)"2021/03/03")), (long)count7);
    }

    @Test
    public void testReadPathsForMergeOnReadTable() {
        java.util.List records1 = this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(100));
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)records1)).asScala(), 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option("hoodie.compact.inline", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath);
        Assertions.assertTrue((boolean)HoodieDataSourceHelpers.hasNewCommits((FileSystem)this.fs, (String)this.basePath, (String)"000"));
        String baseFilePath = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.fs.listStatus(new Path(this.basePath, (String)Predef$.MODULE$.refArrayOps((Object[])this.dataGen.getPartitionPaths()).head()))).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus x$1) {
                return x$1.getPath().getName().endsWith("parquet");
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(FileStatus x$2) {
                return x$2.getPath().toString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(",");
        java.util.List records2 = this.dataGen.generateUniqueDeleteRecords("002", Predef$.MODULE$.int2Integer(100));
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)records2)).asScala(), 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Append).save(this.basePath);
        Dataset hudiReadPathDF1 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.READ_PATHS().key(), baseFilePath).load();
        int expectedCount1 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(records1).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestMORDataSource $outer;

            public final boolean apply(HoodieRecord<?> record) {
                String string = record.getPartitionPath();
                Object object = Predef$.MODULE$.refArrayOps((Object[])this.$outer.protected$dataGen(this.$outer).getPartitionPaths()).head();
                return !(string != null ? !string.equals(object) : object != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assertions.assertEquals((long)expectedCount1, (long)hudiReadPathDF1.count());
        String logFilePath = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.fs.listStatus(new Path(this.basePath, (String)Predef$.MODULE$.refArrayOps((Object[])this.dataGen.getPartitionPaths()).head()))).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus x$3) {
                return x$3.getPath().getName().contains("log");
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(FileStatus x$4) {
                return x$4.getPath().toString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(",");
        String readPaths = new StringBuilder().append((Object)baseFilePath).append((Object)",").append((Object)logFilePath).toString();
        Dataset hudiReadPathDF2 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.READ_PATHS().key(), readPaths).load();
        Assertions.assertEquals((long)0L, (long)hudiReadPathDF2.count());
    }

    @Test
    public void testReadPathsForOnlyLogFiles() {
        this.initMetaClient(HoodieTableType.MERGE_ON_READ);
        java.util.List records1 = this.dataGen.generateInsertsContainsAllPartitions("000", Predef$.MODULE$.int2Integer(20));
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)records1)).asScala(), 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).option(HoodieIndexConfig.INDEX_TYPE.key(), HoodieIndex.IndexType.INMEMORY.toString()).mode(SaveMode.Overwrite).save(this.basePath);
        Assertions.assertTrue((boolean)DataSourceTestUtils.isLogFileOnly(this.basePath));
        String logFilePath = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.fs.listStatus(new Path(this.basePath, (String)Predef$.MODULE$.refArrayOps((Object[])this.dataGen.getPartitionPaths()).head()))).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus x$5) {
                return x$5.getPath().getName().contains("log");
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(FileStatus x$6) {
                return x$6.getPath().toString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(",");
        java.util.List records2 = this.dataGen.generateInsertsContainsAllPartitions("000", Predef$.MODULE$.int2Integer(20));
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)records2)).asScala(), 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).option(HoodieIndexConfig.INDEX_TYPE.key(), HoodieIndex.IndexType.INMEMORY.toString()).mode(SaveMode.Append).save(this.basePath);
        Assertions.assertTrue((boolean)DataSourceTestUtils.isLogFileOnly(this.basePath));
        int expectedCount1 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(records1).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestMORDataSource $outer;

            public final boolean apply(HoodieRecord<?> record) {
                String string = record.getPartitionPath();
                Object object = Predef$.MODULE$.refArrayOps((Object[])this.$outer.protected$dataGen(this.$outer).getPartitionPaths()).head();
                return !(string != null ? !string.equals(object) : object != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Dataset hudiReadPathDF = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.READ_PATHS().key(), logFilePath).load();
        Assertions.assertEquals((long)expectedCount1, (long)hudiReadPathDF.count());
    }

    @Test
    public void testReadLogOnlyMergeOnReadTable() {
        this.initMetaClient(HoodieTableType.MERGE_ON_READ);
        java.util.List records1 = this.dataGen.generateInsertsContainsAllPartitions("000", Predef$.MODULE$.int2Integer(20));
        Dataset inputDF = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)records1)).asScala(), 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).option(HoodieIndexConfig.INDEX_TYPE.key(), HoodieIndex.IndexType.INMEMORY.toString()).mode(SaveMode.Overwrite).save(this.basePath);
        Assertions.assertTrue((boolean)DataSourceTestUtils.isLogFileOnly(this.basePath));
        Assertions.assertEquals((long)20L, (long)this.spark().read().format("hudi").load(new StringBuilder().append((Object)this.basePath).append((Object)"/*/*/*/*").toString()).count());
        Assertions.assertEquals((long)20L, (long)this.spark().read().format("hudi").load(this.basePath).count());
    }

    @Test
    public void testTempFilesCleanForClustering() {
        Buffer records1 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(1000)))).asScala();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).option("hoodie.clustering.inline", "true").option("hoodie.clustering.plan.strategy.sort.columns", "begin_lat, begin_lon").mode(SaveMode.Overwrite).save(this.basePath);
        Path tempPath = new Path(this.basePath, ".hoodie/.temp");
        FileSystem fs = tempPath.getFileSystem(this.spark().sparkContext().hadoopConfiguration());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(tempPath)).isEmpty()));
    }

    @Test
    public void testClusteringOnNullableColumn() {
        Buffer records1 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(1000)))).asScala();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class))).withColumn("cluster_id", functions$.MODULE$.when(functions$.MODULE$.expr("end_lon < 0.2 "), (Object)functions$.MODULE$.lit(null).cast("string")).otherwise((Object)functions$.MODULE$.col("_row_key"))).withColumn("struct_cluster_col", functions$.MODULE$.when(functions$.MODULE$.expr("end_lon < 0.1"), (Object)functions$.MODULE$.lit(null)).otherwise((Object)functions$.MODULE$.struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("cluster_id"), functions$.MODULE$.col("_row_key")}))));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).option("hoodie.clustering.inline", "true").option("hoodie.clustering.inline.max.commits", "1").option("hoodie.clustering.plan.strategy.target.file.max.bytes", "1073741824").option("hoodie.clustering.plan.strategy.small.file.limit", "629145600").option("hoodie.clustering.plan.strategy.sort.columns", "struct_cluster_col").mode(SaveMode.Overwrite).save(this.basePath);
    }

    @Test
    public void testHoodieIsDeletedMOR() {
        int numRecords = 100;
        int numRecordsToDelete = 2;
        String schema = "{\"type\":\"record\",\"name\":\"shortTripRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false}]}";
        Buffer records0 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInsertsAsPerSchema("000", Predef$.MODULE$.int2Integer(numRecords), schema))).asScala();
        Dataset inputDF0 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records0, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF0.write().format("org.apache.hudi").options(this.commonOpts()).option("hoodie.compact.inline", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath);
        Dataset snapshotDF0 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder().append((Object)this.basePath).append((Object)"/*/*/*/*").toString());
        Assertions.assertEquals((long)numRecords, (long)snapshotDF0.count());
        Dataset df1 = snapshotDF0.limit(numRecordsToDelete);
        Dataset dropDf = df1.drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])df1.columns()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$7) {
                return x$7.startsWith("_hoodie_");
            }
        })));
        Dataset df2 = dropDf.withColumn("_hoodie_is_deleted", functions$.MODULE$.lit((Object)BoxesRunTime.boxToBoolean((boolean)true)).cast((DataType)BooleanType$.MODULE$));
        df2.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        Dataset snapshotDF2 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(new StringBuilder().append((Object)this.basePath).append((Object)"/*/*/*/*").toString());
        Assertions.assertEquals((long)(numRecords - numRecordsToDelete), (long)snapshotDF2.count());
    }

    @Test
    public void testPrunePartitionForTimestampBasedKeyGenerator() {
        scala.collection.immutable.Map options = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.compact.inline"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()), (Object)"org.apache.hudi.keygen.TimestampBasedKeyGenerator"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.deltastreamer.keygen.timebased.timestamp.type"), (Object)"DATE_STRING"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.deltastreamer.keygen.timebased.output.dateformat"), (Object)"yyyy/MM/dd"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.deltastreamer.keygen.timebased.timezone"), (Object)"GMT+8:00"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.deltastreamer.keygen.timebased.input.dateformat"), (Object)"yyyy-MM-dd")})));
        HoodieTestDataGenerator dataGen1 = new HoodieTestDataGenerator((String[])((Object[])new String[]{"2022-01-01"}));
        Buffer records1 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen1.generateInserts("001", Predef$.MODULE$.int2Integer(50)))).asScala();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options((Map)options).mode(SaveMode.Overwrite).save(this.basePath);
        ((HoodieClientTestHarness)this).metaClient = HoodieTableMetaClient.builder().setBasePath(this.basePath).setConf(this.spark().sessionState().newHadoopConf()).build();
        String commit1Time = ((HoodieInstant)this.metaClient.getActiveTimeline().lastInstant().get()).getTimestamp();
        HoodieTestDataGenerator dataGen2 = new HoodieTestDataGenerator((String[])((Object[])new String[]{"2022-01-02"}));
        Buffer records2 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen2.generateInserts("002", Predef$.MODULE$.int2Integer(60)))).asScala();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options((Map)options).mode(SaveMode.Append).save(this.basePath);
        String commit2Time = ((HoodieInstant)this.metaClient.reloadActiveTimeline().lastInstant().get()).getTimestamp();
        Buffer records3 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen2.generateUniqueUpdates("003", Predef$.MODULE$.int2Integer(20)))).asScala();
        Dataset inputDF3 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records3, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF3.write().format("org.apache.hudi").options((Map)options).mode(SaveMode.Append).save(this.basePath);
        String commit3Time = ((HoodieInstant)this.metaClient.reloadActiveTimeline().lastInstant().get()).getTimestamp();
        Dataset snapshotQueryRes = this.spark().read().format("hudi").load(this.basePath);
        Assertions.assertEquals((long)snapshotQueryRes.where(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_hoodie_commit_time = '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{commit1Time}))).count(), (long)50L);
        Assertions.assertEquals((long)snapshotQueryRes.where(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_hoodie_commit_time = '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{commit2Time}))).count(), (long)40L);
        Assertions.assertEquals((long)snapshotQueryRes.where(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_hoodie_commit_time = '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{commit3Time}))).count(), (long)20L);
        Assertions.assertEquals((long)snapshotQueryRes.where("partition = '2022-01-01'").count(), (long)50L);
        Assertions.assertEquals((long)snapshotQueryRes.where("partition = '2022-01-02'").count(), (long)60L);
        Dataset readOptimizedQueryRes = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).load(this.basePath);
        Assertions.assertEquals((long)readOptimizedQueryRes.where("partition = '2022/01/01'").count(), (long)50L);
        Assertions.assertEquals((long)readOptimizedQueryRes.where("partition = '2022/01/02'").count(), (long)60L);
        Dataset incrementalQueryRes = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), commit2Time).option(DataSourceReadOptions$.MODULE$.END_INSTANTTIME().key(), commit3Time).load(this.basePath);
        Assertions.assertEquals((long)incrementalQueryRes.where("partition = '2022-01-01'").count(), (long)0L);
        Assertions.assertEquals((long)incrementalQueryRes.where("partition = '2022-01-02'").count(), (long)20L);
    }

    @Test
    public void testReadOptimizedQueryAfterInflightCompactionAndCompletedDeltaCommit() {
        Tuple2 tuple2 = new Tuple2((Object)"hoodie_mor_ro_read_test_table", (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_mor_test_table"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.basePath})));
        if (tuple2 != null) {
            Tuple2 tuple22;
            String tableName = (String)tuple2._1();
            String tablePath = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)tableName, (Object)tablePath);
            String tableName2 = (String)tuple23._1();
            String tablePath2 = (String)tuple23._2();
            String precombineField = "col3";
            String recordKeyField = "key";
            String dataField = "age";
            scala.collection.immutable.Map options = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)HoodieTableType.MERGE_ON_READ.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()), (Object)DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)precombineField), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)recordKeyField), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()), (Object)"org.apache.hudi.keygen.NonpartitionedKeyGenerator"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)tableName2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"1")}));
            Dataset firstDf = this.spark().range(0L, 10L).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{recordKeyField})).withColumn(precombineField, functions$.MODULE$.expr(recordKeyField)).withColumn(dataField, functions$.MODULE$.expr(new StringBuilder().append((Object)recordKeyField).append((Object)" + 1000").toString()));
            firstDf.write().format("hudi").options((Map)options).mode(SaveMode.Overwrite).save(tablePath2);
            Dataset secondDf = this.spark().range(0L, 10L).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{recordKeyField})).withColumn(precombineField, functions$.MODULE$.expr(recordKeyField)).withColumn(dataField, functions$.MODULE$.expr(new StringBuilder().append((Object)recordKeyField).append((Object)" + 2000").toString()));
            secondDf.write().format("hudi").options((Map)options).mode(SaveMode.Append).save(tablePath2);
            scala.collection.immutable.Map compactionOptions = options.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCompactionConfig.INLINE_COMPACT_TRIGGER_STRATEGY.key()), (Object)CompactionTriggerStrategy.NUM_COMMITS.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCompactionConfig.INLINE_COMPACT_NUM_DELTA_COMMITS.key()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.ASYNC_COMPACT_ENABLE().key()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.WRITE_PAYLOAD_CLASS_NAME.key()), (Object)OverwriteWithLatestAvroPayload.class.getName())})));
            SparkRDDWriteClient client = DataSourceUtils.createHoodieClient((JavaSparkContext)JavaSparkContext$.MODULE$.fromSparkContext(this.spark().sparkContext()), (String)"", (String)tablePath2, (String)tableName2, (java.util.Map)JavaConversions$.MODULE$.mapAsJavaMap((Map)compactionOptions));
            String compactionInstant = (String)client.scheduleCompaction(Option.empty()).get();
            client.compact(compactionInstant);
            client.close();
            Dataset thirdDf = this.spark().range(0L, 10L).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{recordKeyField})).withColumn(precombineField, functions$.MODULE$.expr(recordKeyField)).withColumn(dataField, functions$.MODULE$.expr(new StringBuilder().append((Object)recordKeyField).append((Object)" + 3000").toString()));
            thirdDf.write().format("hudi").options((Map)options).mode(SaveMode.Append).save(tablePath2);
            Dataset roDf = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).load(tablePath2);
            Assertions.assertEquals((long)10L, (long)roDf.count());
            Assertions.assertEquals((long)1000L, (long)((Row[])roDf.where(functions$.MODULE$.col(recordKeyField).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0))).select(dataField, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect())[0].getLong(0));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public TestMORDataSource() {
        SparkDatasetMixin$class.$init$(this);
        this.spark = null;
        this.log = LogManager.getLogger(TestMORDataSource.class);
        this.commonOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test")}));
        this.verificationCol = "driver";
        this.updatedVerificationVal = "driver_update";
    }
}

