/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieDataSourceHelpers;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.testutils.SparkClientFunctionalTestHarness;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.functions$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@Tag(value="functional")
@ScalaSignature(bytes="\u0006\u0001i4A!\u0001\u0002\u0001\u0017\tAB+Z:u\u001b>\u0013F)\u0019;b'>,(oY3Ti>\u0014\u0018mZ3\u000b\u0005\r!\u0011A\u00034v]\u000e$\u0018n\u001c8bY*\u0011QAB\u0001\u0005QV$\u0017N\u0003\u0002\b\u0011\u00051\u0011\r]1dQ\u0016T\u0011!C\u0001\u0004_J<7\u0001A\n\u0003\u00011\u0001\"!\u0004\t\u000e\u00039Q!a\u0004\u0003\u0002\u0013Q,7\u000f^;uS2\u001c\u0018BA\t\u000f\u0005\u0001\u001a\u0006/\u0019:l\u00072LWM\u001c;Gk:\u001cG/[8oC2$Vm\u001d;ICJtWm]:\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\f\u0001\u001b\u0005\u0011\u0001b\u0002\r\u0001\u0005\u0004%I!G\u0001\u0004Y><W#\u0001\u000e\u0011\u0005mqR\"\u0001\u000f\u000b\u0005u1\u0011!\u00027pORR\u0017BA\u0010\u001d\u0005\u0019aunZ4fe\"1\u0011\u0005\u0001Q\u0001\ni\tA\u0001\\8hA!91\u0005\u0001b\u0001\n\u0003!\u0013AC2p[6|gn\u00149ugV\tQ\u0005\u0005\u0003'[=zS\"A\u0014\u000b\u0005!J\u0013!C5n[V$\u0018M\u00197f\u0015\tQ3&\u0001\u0006d_2dWm\u0019;j_:T\u0011\u0001L\u0001\u0006g\u000e\fG.Y\u0005\u0003]\u001d\u00121!T1q!\t\u0001T'D\u00012\u0015\t\u00114'\u0001\u0003mC:<'\"\u0001\u001b\u0002\t)\fg/Y\u0005\u0003mE\u0012aa\u0015;sS:<\u0007B\u0002\u001d\u0001A\u0003%Q%A\u0006d_6lwN\\(qiN\u0004\u0003b\u0002\u001e\u0001\u0005\u0004%\taO\u0001\u0010m\u0016\u0014\u0018NZ5dCRLwN\\\"pYV\tA\b\u0005\u0002>\u0003:\u0011ahP\u0007\u0002W%\u0011\u0001iK\u0001\u0007!J,G-\u001a4\n\u0005Y\u0012%B\u0001!,\u0011\u0019!\u0005\u0001)A\u0005y\u0005\u0001b/\u001a:jM&\u001c\u0017\r^5p]\u000e{G\u000e\t\u0005\b\r\u0002\u0011\r\u0011\"\u0001<\u0003Y)\b\u000fZ1uK\u00124VM]5gS\u000e\fG/[8o-\u0006d\u0007B\u0002%\u0001A\u0003%A(A\fva\u0012\fG/\u001a3WKJLg-[2bi&|gNV1mA!)!\n\u0001C\u0001\u0017\u00061B/Z:u\u001b\u0016\u0014x-Z(o%\u0016\fGm\u0015;pe\u0006<W\rF\u0002M\u001fR\u0003\"AP'\n\u00059[#\u0001B+oSRDQ\u0001U%A\u0002E\u000b\u0011#[:NKR\fG-\u0019;b\u000b:\f'\r\\3e!\tq$+\u0003\u0002TW\t9!i\\8mK\u0006t\u0007\"B+J\u0001\u0004a\u0014A\u00049sK\u000e{W.\u001b8f\r&,G\u000e\u001a\u0015\u0005\u0013^\u001bG\r\u0005\u0002YC6\t\u0011L\u0003\u0002[7\u0006A\u0001O]8wS\u0012,'O\u0003\u0002];\u00061\u0001/\u0019:b[NT!AX0\u0002\u000f),\b/\u001b;fe*\u0011\u0001\rC\u0001\u0006UVt\u0017\u000e^\u0005\u0003Ef\u0013\u0011bQ:w'>,(oY3\u0002\u000bY\fG.^3-\t\u0015<\u0017n[\u0011\u0002M\u0006)AO];fY\u0005\n\u0001.\u0001\nueV,GFZ1sK:\u001aWO\u001d:f]\u000eL\u0018%\u00016\u0002\r\u0019\fGn]3-C\u0005a\u0017a\u00054bYN,GFZ1sK:\u001aWO\u001d:f]\u000eL\bFA%o!\ty\u0007/D\u0001\\\u0013\t\t8LA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgRDC\u0001A:dsB\u0011Ao^\u0007\u0002k*\u0011a/X\u0001\u0004CBL\u0017B\u0001=v\u0005\r!\u0016mZ\u0011\u0002\u0007\u0001")
public class TestMORDataSourceStorage
extends SparkClientFunctionalTestHarness {
    private final Logger log = LogManager.getLogger(TestMORDataSourceStorage.class);
    private final scala.collection.immutable.Map<String, String> commonOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.bulkinsert.shuffle.parallelism"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.delete.shuffle.parallelism"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test")}));
    private final String verificationCol;
    private final String updatedVerificationVal;

    private Logger log() {
        return this.log;
    }

    public scala.collection.immutable.Map<String, String> commonOpts() {
        return this.commonOpts;
    }

    public String verificationCol() {
        return this.verificationCol;
    }

    public String updatedVerificationVal() {
        return this.updatedVerificationVal;
    }

    @ParameterizedTest
    @CsvSource(value={"true,", "true,fare.currency", "false,", "false,fare.currency"})
    public void testMergeOnReadStorage(boolean isMetadataEnabled, String preComineField) {
        scala.collection.immutable.Map options = this.commonOpts().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)String.valueOf(isMetadataEnabled)));
        if (!StringUtils.isNullOrEmpty((String)preComineField)) {
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)preComineField));
        }
        HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator(57071L);
        FileSystem fs = FSUtils.getFs((String)this.basePath(), (Configuration)this.spark().sparkContext().hadoopConfiguration());
        List records1 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options((Map)options).option("hoodie.compact.inline", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath());
        Assertions.assertTrue((boolean)HoodieDataSourceHelpers.hasNewCommits((FileSystem)fs, (String)this.basePath(), (String)"000"));
        Dataset hudiRODF1 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabled).load(this.basePath());
        Assertions.assertEquals((long)100L, (long)hudiRODF1.count());
        String insertCommitTime = HoodieDataSourceHelpers.latestCommit((FileSystem)fs, (String)this.basePath());
        List insertCommitTimes = ((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(hudiRODF1.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().collectAsList()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Row r) {
                return r.getString(0);
            }
        }, Buffer$.MODULE$.canBuildFrom())).toList();
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{insertCommitTime})), (Object)insertCommitTimes);
        List records2 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateUniqueUpdates("002", Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options((Map)options).mode(SaveMode.Append).save(this.basePath());
        String updateCommitTime = HoodieDataSourceHelpers.latestCommit((FileSystem)fs, (String)this.basePath());
        Dataset hudiSnapshotDF2 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabled).load(this.basePath());
        List updateCommitTimes = ((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(hudiSnapshotDF2.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().collectAsList()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Row r) {
                return r.getString(0);
            }
        }, Buffer$.MODULE$.canBuildFrom())).toList();
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{updateCommitTime})), (Object)updateCommitTimes);
        String verificationRowKey = ((Row)hudiSnapshotDF2.limit(1).select("_row_key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).first()).getString(0);
        Dataset inputDF3 = hudiSnapshotDF2.filter(functions$.MODULE$.col("_row_key").$eq$eq$eq((Object)verificationRowKey)).withColumn(this.verificationCol(), functions$.MODULE$.lit((Object)this.updatedVerificationVal()));
        inputDF3.write().format("org.apache.hudi").options((Map)options).mode(SaveMode.Append).save(this.basePath());
        Dataset hudiSnapshotDF3 = this.spark().read().format("hudi").option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabled).load(this.basePath());
        Assertions.assertEquals((long)100L, (long)hudiSnapshotDF3.count());
        Assertions.assertEquals((Object)this.updatedVerificationVal(), (Object)((Row)hudiSnapshotDF3.filter(functions$.MODULE$.col("_row_key").$eq$eq$eq((Object)verificationRowKey)).select(this.verificationCol(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).first()).getString(0));
    }

    public TestMORDataSourceStorage() {
        this.verificationCol = "driver";
        this.updatedVerificationVal = "driver_update";
    }
}

