/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.util.List;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.testutils.SparkClientFunctionalTestHarness;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@Tag(value="functional")
@ScalaSignature(bytes="\u0006\u0001E4A!\u0001\u0002\u0001\u0017\t!C+Z:u\u001b\u0016$\u0018\rZ1uCR\u000b'\r\\3XSRD7\u000b]1sW\u0012\u000bG/Y*pkJ\u001cWM\u0003\u0002\u0004\t\u0005Qa-\u001e8di&|g.\u00197\u000b\u0005\u00151\u0011\u0001\u00025vI&T!a\u0002\u0005\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0011aA8sO\u000e\u00011C\u0001\u0001\r!\ti\u0001#D\u0001\u000f\u0015\tyA!A\u0005uKN$X\u000f^5mg&\u0011\u0011C\u0004\u0002!'B\f'o[\"mS\u0016tGOR;oGRLwN\\1m)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fC\u0003\u0014\u0001\u0011\u0005A#\u0001\u0004=S:LGO\u0010\u000b\u0002+A\u0011a\u0003A\u0007\u0002\u0005!9Q\u0001\u0001b\u0001\n\u0003AR#A\r\u0011\u0005iyR\"A\u000e\u000b\u0005qi\u0012\u0001\u00027b]\u001eT\u0011AH\u0001\u0005U\u00064\u0018-\u0003\u0002!7\t11\u000b\u001e:j]\u001eDaA\t\u0001!\u0002\u0013I\u0012!\u00025vI&\u0004\u0003b\u0002\u0013\u0001\u0001\u0004%\t!J\u0001\u000bG>lWn\u001c8PaR\u001cX#\u0001\u0014\u0011\t\u001dr\u0013$G\u0007\u0002Q)\u0011\u0011FK\u0001\nS6lW\u000f^1cY\u0016T!a\u000b\u0017\u0002\u0015\r|G\u000e\\3di&|gNC\u0001.\u0003\u0015\u00198-\u00197b\u0013\ty\u0003FA\u0002NCBDq!\r\u0001A\u0002\u0013\u0005!'\u0001\bd_6lwN\\(qiN|F%Z9\u0015\u0005M:\u0004C\u0001\u001b6\u001b\u0005a\u0013B\u0001\u001c-\u0005\u0011)f.\u001b;\t\u000fa\u0002\u0014\u0011!a\u0001M\u0005\u0019\u0001\u0010J\u0019\t\ri\u0002\u0001\u0015)\u0003'\u0003-\u0019w.\\7p]>\u0003Ho\u001d\u0011\t\u000bq\u0002A\u0011A\u001f\u0002\u001fQ,7\u000f\u001e*fC\u0012\f'-\u001b7jif$\u0012a\r\u0015\u0003w}\u0002\"\u0001Q$\u000e\u0003\u0005S!AQ\"\u0002\u0007\u0005\u0004\u0018N\u0003\u0002E\u000b\u00069!.\u001e9ji\u0016\u0014(B\u0001$\t\u0003\u0015QWO\\5u\u0013\tA\u0015I\u0001\u0003UKN$\b\"\u0002&\u0001\t\u0013Y\u0015\u0001\u00049beN,'+Z2pe\u0012\u001cHC\u0001'Y!\tiUK\u0004\u0002O'6\tqJ\u0003\u0002Q#\u0006\u00191/\u001d7\u000b\u0005I3\u0011!B:qCJ\\\u0017B\u0001+P\u0003\u001d\u0001\u0018mY6bO\u0016L!AV,\u0003\u0013\u0011\u000bG/\u0019$sC6,'B\u0001+P\u0011\u0015I\u0016\n1\u0001[\u0003\u001d\u0011XmY8sIN\u00042a\u00172f\u001d\ta\u0016M\u0004\u0002^A6\taL\u0003\u0002`\u0015\u00051AH]8pizJ\u0011!L\u0005\u0003)2J!a\u00193\u0003\u0007M+\u0017O\u0003\u0002UYA\u0011a-\u001b\b\u0003i\u001dL!\u0001\u001b\u0017\u0002\rA\u0013X\rZ3g\u0013\t\u0001#N\u0003\u0002iY!\"\u0001\u0001\\8q!\t\u0001U.\u0003\u0002o\u0003\n\u0019A+Y4\u0002\u000bY\fG.^3\"\u0003\r\u0001")
public class TestMetadataTableWithSparkDataSource
extends SparkClientFunctionalTestHarness {
    private final String hudi;
    private scala.collection.immutable.Map<String, String> commonOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.bulkinsert.shuffle.parallelism"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.delete.shuffle.parallelism"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test")}));

    public String hudi() {
        return this.hudi;
    }

    public scala.collection.immutable.Map<String, String> commonOpts() {
        return this.commonOpts;
    }

    public void commonOpts_$eq(scala.collection.immutable.Map<String, String> x$1) {
        this.commonOpts = x$1;
    }

    @Test
    public void testReadability() {
        HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator();
        scala.collection.immutable.Map metadataOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key()), (Object)"true")}));
        scala.collection.immutable.Map combinedOpts = this.commonOpts().$plus$plus((GenTraversableOnce)metadataOpts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.COMPACT_NUM_DELTA_COMMITS.key()), (Object)"1")})));
        List newRecords = dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(100));
        Dataset<Row> newRecordsDF = this.parseRecords((Seq<String>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((List)newRecords)).asScala()));
        newRecordsDF.write().format(this.hudi()).options((Map)combinedOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath());
        List updatedRecords = dataGen.generateUpdates("002", newRecords);
        Dataset<Row> updatedRecordsDF = this.parseRecords((Seq<String>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((List)updatedRecords)).asScala()));
        updatedRecordsDF.write().format(this.hudi()).options((Map)combinedOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath());
        Dataset filesPartitionDF = this.spark().read().format(this.hudi()).load(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/.hoodie/metadata/files"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.basePath()})));
        filesPartitionDF.show();
        Assertions.assertEquals((long)4L, (long)filesPartitionDF.count());
        Seq expectedKeys = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2015/03/16", "2015/03/17", "2016/03/15", "__all_partitions__"}));
        Seq keys = (Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])filesPartitionDF.select("key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Row x$1) {
                return x$1.getString(0);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSeq().sorted((Ordering)Ordering.String$.MODULE$);
        Assertions.assertEquals((Object)expectedKeys, (Object)keys);
        Dataset colStatsDF = this.spark().read().format(this.hudi()).load(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/.hoodie/metadata/column_stats"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.basePath()})));
        colStatsDF.show();
    }

    private Dataset<Row> parseRecords(Seq<String> records) {
        return this.spark().read().json(this.spark().sparkContext().parallelize(records, 2, ClassTag$.MODULE$.apply(String.class)));
    }

    public TestMetadataTableWithSparkDataSource() {
        this.hudi = "org.apache.hudi";
    }
}

