/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.keygen.BuiltinKeyGenerator;
import org.apache.hudi.keygen.CustomKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.keygen.constant.KeyGeneratorType;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import org.apache.hudi.testutils.KeyGeneratorTestUtilities;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.unsafe.types.UTF8String;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCustomKeyGenerator
extends KeyGeneratorTestUtilities {
    private TypedProperties getCommonProps(boolean getComplexRecordKey, boolean useKeyGeneratorClassName) {
        TypedProperties properties = new TypedProperties();
        if (getComplexRecordKey) {
            properties.put((Object)KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), (Object)"_row_key, pii_col");
        } else {
            properties.put((Object)KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), (Object)"_row_key");
        }
        if (useKeyGeneratorClassName) {
            properties.put((Object)HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), (Object)CustomKeyGenerator.class.getName());
        } else {
            properties.put((Object)HoodieWriteConfig.KEYGENERATOR_TYPE.key(), (Object)KeyGeneratorType.CUSTOM.name());
        }
        properties.put((Object)KeyGeneratorOptions.HIVE_STYLE_PARTITIONING_ENABLE.key(), (Object)"true");
        return properties;
    }

    private TypedProperties getPropertiesForSimpleKeyGen(boolean useKeyGeneratorClassName) {
        TypedProperties properties = this.getCommonProps(false, useKeyGeneratorClassName);
        properties.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"timestamp:simple");
        return properties;
    }

    private TypedProperties getImproperPartitionFieldFormatProp(boolean useKeyGeneratorClassName) {
        TypedProperties properties = this.getCommonProps(false, useKeyGeneratorClassName);
        properties.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"timestamp");
        return properties;
    }

    private TypedProperties getInvalidPartitionKeyTypeProps(boolean useKeyGeneratorClassName) {
        TypedProperties properties = this.getCommonProps(false, useKeyGeneratorClassName);
        properties.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"timestamp:dummy");
        return properties;
    }

    private TypedProperties getComplexRecordKeyWithSimplePartitionProps(boolean useKeyGeneratorClassName) {
        TypedProperties properties = this.getCommonProps(true, useKeyGeneratorClassName);
        properties.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"timestamp:simple");
        return properties;
    }

    private TypedProperties getComplexRecordKeyAndPartitionPathProps(boolean useKeyGeneratorClassName) {
        TypedProperties properties = this.getCommonProps(true, useKeyGeneratorClassName);
        properties.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"timestamp:simple,ts_ms:timestamp");
        this.populateNecessaryPropsForTimestampBasedKeyGen(properties);
        return properties;
    }

    private TypedProperties getPropsWithoutRecordKeyFieldProps(boolean useKeyGeneratorClassName) {
        TypedProperties properties = new TypedProperties();
        properties.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"timestamp:simple");
        if (useKeyGeneratorClassName) {
            properties.put((Object)HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), (Object)CustomKeyGenerator.class.getName());
        } else {
            properties.put((Object)HoodieWriteConfig.KEYGENERATOR_TYPE.key(), (Object)KeyGeneratorType.CUSTOM.name());
        }
        return properties;
    }

    private void populateNecessaryPropsForTimestampBasedKeyGen(TypedProperties properties) {
        properties.put((Object)"hoodie.deltastreamer.keygen.timebased.timestamp.type", (Object)"DATE_STRING");
        properties.put((Object)"hoodie.deltastreamer.keygen.timebased.input.dateformat", (Object)"yyyy-MM-dd");
        properties.put((Object)"hoodie.deltastreamer.keygen.timebased.output.dateformat", (Object)"yyyyMMdd");
    }

    private TypedProperties getPropertiesForTimestampBasedKeyGen(boolean useKeyGeneratorClassName) {
        TypedProperties properties = this.getCommonProps(false, useKeyGeneratorClassName);
        properties.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"ts_ms:timestamp");
        this.populateNecessaryPropsForTimestampBasedKeyGen(properties);
        return properties;
    }

    private TypedProperties getPropertiesForNonPartitionedKeyGen(boolean useKeyGeneratorClassName) {
        TypedProperties properties = this.getCommonProps(false, useKeyGeneratorClassName);
        properties.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"");
        return properties;
    }

    private String stackTraceToString(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    @Test
    public void testSimpleKeyGeneratorWithKeyGeneratorClass() throws IOException {
        this.testSimpleKeyGenerator(this.getPropertiesForSimpleKeyGen(true));
    }

    @Test
    public void testSimpleKeyGeneratorWithKeyGeneratorType() throws IOException {
        this.testSimpleKeyGenerator(this.getPropertiesForSimpleKeyGen(false));
    }

    public void testSimpleKeyGenerator(TypedProperties props) throws IOException {
        BuiltinKeyGenerator keyGenerator = (BuiltinKeyGenerator)HoodieSparkKeyGeneratorFactory.createKeyGenerator((TypedProperties)props);
        GenericRecord record = TestCustomKeyGenerator.getRecord();
        HoodieKey key = keyGenerator.getKey(record);
        Assertions.assertEquals((Object)"key1", (Object)key.getRecordKey());
        Assertions.assertEquals((Object)"timestamp=4357686", (Object)key.getPartitionPath());
        Row row = KeyGeneratorTestUtilities.getRow(record);
        Assertions.assertEquals((Object)"key1", (Object)keyGenerator.getRecordKey(row));
        Assertions.assertEquals((Object)"timestamp=4357686", (Object)keyGenerator.getPartitionPath(row));
        InternalRow internalRow = KeyGeneratorTestUtilities.getInternalRow(row);
        Assertions.assertEquals((Object)UTF8String.fromString((String)"timestamp=4357686"), (Object)keyGenerator.getPartitionPath(internalRow, row.schema()));
    }

    @Test
    public void testTimestampBasedKeyGeneratorWithKeyGeneratorClass() throws IOException {
        this.testTimestampBasedKeyGenerator(this.getPropertiesForTimestampBasedKeyGen(true));
    }

    @Test
    public void testTimestampBasedKeyGeneratorWithKeyGeneratorType() throws IOException {
        this.testTimestampBasedKeyGenerator(this.getPropertiesForTimestampBasedKeyGen(false));
    }

    public void testTimestampBasedKeyGenerator(TypedProperties props) throws IOException {
        BuiltinKeyGenerator keyGenerator = (BuiltinKeyGenerator)HoodieSparkKeyGeneratorFactory.createKeyGenerator((TypedProperties)props);
        GenericRecord record = TestCustomKeyGenerator.getRecord();
        HoodieKey key = keyGenerator.getKey(record);
        Assertions.assertEquals((Object)"key1", (Object)key.getRecordKey());
        Assertions.assertEquals((Object)"ts_ms=20200321", (Object)key.getPartitionPath());
        Row row = KeyGeneratorTestUtilities.getRow(record);
        Assertions.assertEquals((Object)"key1", (Object)keyGenerator.getRecordKey(row));
        Assertions.assertEquals((Object)"ts_ms=20200321", (Object)keyGenerator.getPartitionPath(row));
        InternalRow internalRow = KeyGeneratorTestUtilities.getInternalRow(row);
        Assertions.assertEquals((Object)UTF8String.fromString((String)"ts_ms=20200321"), (Object)keyGenerator.getPartitionPath(internalRow, row.schema()));
    }

    @Test
    public void testNonPartitionedKeyGeneratorWithKeyGeneratorClass() throws IOException {
        this.testNonPartitionedKeyGenerator(this.getPropertiesForNonPartitionedKeyGen(true));
    }

    @Test
    public void testNonPartitionedKeyGeneratorWithKeyGeneratorType() throws IOException {
        this.testNonPartitionedKeyGenerator(this.getPropertiesForNonPartitionedKeyGen(false));
    }

    public void testNonPartitionedKeyGenerator(TypedProperties props) throws IOException {
        BuiltinKeyGenerator keyGenerator = (BuiltinKeyGenerator)HoodieSparkKeyGeneratorFactory.createKeyGenerator((TypedProperties)props);
        GenericRecord record = TestCustomKeyGenerator.getRecord();
        HoodieKey key = keyGenerator.getKey(record);
        Assertions.assertEquals((Object)key.getRecordKey(), (Object)"key1");
        Assertions.assertTrue((boolean)key.getPartitionPath().isEmpty());
        Row row = KeyGeneratorTestUtilities.getRow(record);
        Assertions.assertEquals((Object)keyGenerator.getRecordKey(row), (Object)"key1");
        Assertions.assertTrue((boolean)keyGenerator.getPartitionPath(row).isEmpty());
        InternalRow internalRow = KeyGeneratorTestUtilities.getInternalRow(row);
        Assertions.assertEquals((int)0, (int)keyGenerator.getPartitionPath(internalRow, row.schema()).numBytes());
    }

    @Test
    public void testInvalidPartitionKeyTypeWithKeyGeneratorClass() {
        this.testInvalidPartitionKeyType(this.getInvalidPartitionKeyTypeProps(true));
    }

    @Test
    public void testInvalidPartitionKeyTypeWithKeyGeneratorType() {
        this.testInvalidPartitionKeyType(this.getInvalidPartitionKeyTypeProps(false));
    }

    public void testInvalidPartitionKeyType(TypedProperties props) {
        BuiltinKeyGenerator keyGenerator;
        try {
            keyGenerator = (BuiltinKeyGenerator)HoodieSparkKeyGeneratorFactory.createKeyGenerator((TypedProperties)props);
            keyGenerator.getKey(TestCustomKeyGenerator.getRecord());
            Assertions.fail((String)"should fail when invalid PartitionKeyType is provided!");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("No enum constant org.apache.hudi.keygen.CustomAvroKeyGenerator.PartitionKeyType.DUMMY"));
        }
        try {
            keyGenerator = (BuiltinKeyGenerator)HoodieSparkKeyGeneratorFactory.createKeyGenerator((TypedProperties)props);
            GenericRecord record = TestCustomKeyGenerator.getRecord();
            Row row = KeyGeneratorTestUtilities.getRow(record);
            keyGenerator.getPartitionPath(row);
            Assertions.fail((String)"should fail when invalid PartitionKeyType is provided!");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("No enum constant org.apache.hudi.keygen.CustomAvroKeyGenerator.PartitionKeyType.DUMMY"));
        }
    }

    @Test
    public void testNoRecordKeyFieldPropWithKeyGeneratorClass() {
        this.testNoRecordKeyFieldProp(true);
    }

    @Test
    public void testNoRecordKeyFieldPropWithKeyGeneratorType() {
        this.testNoRecordKeyFieldProp(false);
    }

    public void testNoRecordKeyFieldProp(boolean useKeyGeneratorClassName) {
        BuiltinKeyGenerator keyGenerator;
        TypedProperties propsWithoutRecordKeyFieldProps = this.getPropsWithoutRecordKeyFieldProps(useKeyGeneratorClassName);
        try {
            keyGenerator = (BuiltinKeyGenerator)HoodieSparkKeyGeneratorFactory.createKeyGenerator((TypedProperties)propsWithoutRecordKeyFieldProps);
            keyGenerator.getKey(TestCustomKeyGenerator.getRecord());
            Assertions.fail((String)"should fail when record key field is not provided!");
        }
        catch (Exception e) {
            if (useKeyGeneratorClassName) {
                Assertions.assertTrue((boolean)e.getCause().getCause().getCause().getMessage().contains("Property hoodie.datasource.write.recordkey.field not found"));
            }
            Assertions.assertTrue((boolean)this.stackTraceToString(e).contains("Property hoodie.datasource.write.recordkey.field not found"));
        }
        try {
            keyGenerator = (BuiltinKeyGenerator)HoodieSparkKeyGeneratorFactory.createKeyGenerator((TypedProperties)propsWithoutRecordKeyFieldProps);
            GenericRecord record = TestCustomKeyGenerator.getRecord();
            Row row = KeyGeneratorTestUtilities.getRow(record);
            keyGenerator.getRecordKey(row);
            Assertions.fail((String)"should fail when record key field is not provided!");
        }
        catch (Exception e) {
            if (useKeyGeneratorClassName) {
                Assertions.assertTrue((boolean)e.getCause().getCause().getCause().getMessage().contains("Property hoodie.datasource.write.recordkey.field not found"));
            }
            Assertions.assertTrue((boolean)this.stackTraceToString(e).contains("Property hoodie.datasource.write.recordkey.field not found"));
        }
    }

    @Test
    public void testPartitionFieldsInImproperFormatWithKeyGeneratorClass() {
        this.testPartitionFieldsInImproperFormat(this.getImproperPartitionFieldFormatProp(true));
    }

    @Test
    public void testPartitionFieldsInImproperFormatWithKeyGeneratorType() {
        this.testPartitionFieldsInImproperFormat(this.getImproperPartitionFieldFormatProp(false));
    }

    public void testPartitionFieldsInImproperFormat(TypedProperties props) {
        BuiltinKeyGenerator keyGenerator;
        try {
            keyGenerator = (BuiltinKeyGenerator)HoodieSparkKeyGeneratorFactory.createKeyGenerator((TypedProperties)props);
            keyGenerator.getKey(TestCustomKeyGenerator.getRecord());
            Assertions.fail((String)"should fail when partition key field is provided in improper format!");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("Unable to find field names for partition path in proper format"));
        }
        try {
            keyGenerator = (BuiltinKeyGenerator)HoodieSparkKeyGeneratorFactory.createKeyGenerator((TypedProperties)props);
            GenericRecord record = TestCustomKeyGenerator.getRecord();
            Row row = KeyGeneratorTestUtilities.getRow(record);
            keyGenerator.getPartitionPath(row);
            Assertions.fail((String)"should fail when partition key field is provided in improper format!");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("Unable to find field names for partition path in proper format"));
        }
    }

    @Test
    public void testComplexRecordKeyWithSimplePartitionPathWithKeyGeneratorClass() throws IOException {
        this.testComplexRecordKeyWithSimplePartitionPath(this.getComplexRecordKeyWithSimplePartitionProps(true));
    }

    @Test
    public void testComplexRecordKeyWithSimplePartitionPathWithKeyGeneratorType() throws IOException {
        this.testComplexRecordKeyWithSimplePartitionPath(this.getComplexRecordKeyWithSimplePartitionProps(false));
    }

    public void testComplexRecordKeyWithSimplePartitionPath(TypedProperties props) throws IOException {
        BuiltinKeyGenerator keyGenerator = (BuiltinKeyGenerator)HoodieSparkKeyGeneratorFactory.createKeyGenerator((TypedProperties)props);
        GenericRecord record = TestCustomKeyGenerator.getRecord();
        HoodieKey key = keyGenerator.getKey(record);
        Assertions.assertEquals((Object)"_row_key:key1,pii_col:pi", (Object)key.getRecordKey());
        Assertions.assertEquals((Object)"timestamp=4357686", (Object)key.getPartitionPath());
        Row row = KeyGeneratorTestUtilities.getRow(record);
        Assertions.assertEquals((Object)"_row_key:key1,pii_col:pi", (Object)keyGenerator.getRecordKey(row));
        Assertions.assertEquals((Object)"timestamp=4357686", (Object)keyGenerator.getPartitionPath(row));
        InternalRow internalRow = KeyGeneratorTestUtilities.getInternalRow(row);
        Assertions.assertEquals((Object)UTF8String.fromString((String)"timestamp=4357686"), (Object)keyGenerator.getPartitionPath(internalRow, row.schema()));
    }

    @Test
    public void testComplexRecordKeysWithComplexPartitionPathWithKeyGeneratorClass() throws IOException {
        this.testComplexRecordKeysWithComplexPartitionPath(this.getComplexRecordKeyAndPartitionPathProps(true));
    }

    @Test
    public void testComplexRecordKeysWithComplexPartitionPathWithKeyGeneratorType() throws IOException {
        this.testComplexRecordKeysWithComplexPartitionPath(this.getComplexRecordKeyAndPartitionPathProps(false));
    }

    public void testComplexRecordKeysWithComplexPartitionPath(TypedProperties props) throws IOException {
        BuiltinKeyGenerator keyGenerator = (BuiltinKeyGenerator)HoodieSparkKeyGeneratorFactory.createKeyGenerator((TypedProperties)props);
        GenericRecord record = TestCustomKeyGenerator.getRecord();
        HoodieKey key = keyGenerator.getKey(record);
        Assertions.assertEquals((Object)"_row_key:key1,pii_col:pi", (Object)key.getRecordKey());
        Assertions.assertEquals((Object)"timestamp=4357686/ts_ms=20200321", (Object)key.getPartitionPath());
        Row row = KeyGeneratorTestUtilities.getRow(record);
        Assertions.assertEquals((Object)"_row_key:key1,pii_col:pi", (Object)keyGenerator.getRecordKey(row));
        Assertions.assertEquals((Object)"timestamp=4357686/ts_ms=20200321", (Object)keyGenerator.getPartitionPath(row));
        InternalRow internalRow = KeyGeneratorTestUtilities.getInternalRow(row);
        Assertions.assertEquals((Object)UTF8String.fromString((String)"timestamp=4357686/ts_ms=20200321"), (Object)keyGenerator.getPartitionPath(internalRow, row.schema()));
    }
}

