/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.util.stream.Stream;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieKeyException;
import org.apache.hudi.keygen.SimpleKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.testutils.KeyGeneratorTestUtilities;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.unsafe.types.UTF8String;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class TestSimpleKeyGenerator
extends KeyGeneratorTestUtilities {
    private TypedProperties getCommonProps() {
        TypedProperties properties = new TypedProperties();
        properties.put((Object)KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), (Object)"_row_key");
        properties.put((Object)KeyGeneratorOptions.HIVE_STYLE_PARTITIONING_ENABLE.key(), (Object)"true");
        return properties;
    }

    private TypedProperties getPropertiesWithoutPartitionPathProp() {
        return this.getCommonProps();
    }

    private TypedProperties getPropertiesWithoutRecordKeyProp() {
        TypedProperties properties = new TypedProperties();
        properties.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"timestamp");
        return properties;
    }

    private TypedProperties getWrongRecordKeyFieldProps() {
        TypedProperties properties = new TypedProperties();
        properties.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"timestamp");
        properties.put((Object)KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), (Object)"_wrong_key");
        return properties;
    }

    private TypedProperties getWrongPartitionPathFieldProps() {
        TypedProperties properties = new TypedProperties();
        properties.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"_wrong_partition_path");
        properties.put((Object)KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), (Object)"_row_key");
        return properties;
    }

    private TypedProperties getComplexRecordKeyProp() {
        TypedProperties properties = new TypedProperties();
        properties.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"timestamp");
        properties.put((Object)KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), (Object)"_row_key,pii_col");
        return properties;
    }

    private TypedProperties getProps() {
        TypedProperties properties = this.getCommonProps();
        properties.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"timestamp");
        return properties;
    }

    private TypedProperties getPropsWithNestedPartitionPathField() {
        TypedProperties properties = this.getCommonProps();
        properties.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"nested_col.prop1");
        return properties;
    }

    @Test
    public void testNullPartitionPathFields() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new SimpleKeyGenerator(this.getPropertiesWithoutPartitionPathProp()));
    }

    @Test
    public void testNullRecordKeyFields() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new SimpleKeyGenerator(this.getPropertiesWithoutRecordKeyProp()));
    }

    @Test
    public void testWrongRecordKeyField() {
        SimpleKeyGenerator keyGenerator = new SimpleKeyGenerator(this.getWrongRecordKeyFieldProps());
        Assertions.assertThrows(HoodieKeyException.class, () -> keyGenerator.getRecordKey(TestSimpleKeyGenerator.getRecord()));
    }

    @Test
    public void testWrongPartitionPathField() {
        SimpleKeyGenerator keyGenerator = new SimpleKeyGenerator(this.getWrongPartitionPathFieldProps());
        GenericRecord record = TestSimpleKeyGenerator.getRecord();
        Assertions.assertThrows(HoodieException.class, () -> keyGenerator.getPartitionPath(KeyGeneratorTestUtilities.getRow(record)));
    }

    @Test
    public void testComplexRecordKeyField() {
        SimpleKeyGenerator keyGenerator = new SimpleKeyGenerator(this.getComplexRecordKeyProp());
        Assertions.assertThrows(HoodieKeyException.class, () -> keyGenerator.getRecordKey(TestSimpleKeyGenerator.getRecord()));
    }

    @Test
    public void testHappyFlow() {
        SimpleKeyGenerator keyGenerator = new SimpleKeyGenerator(this.getProps());
        GenericRecord record = TestSimpleKeyGenerator.getRecord();
        HoodieKey key = keyGenerator.getKey(TestSimpleKeyGenerator.getRecord());
        Assertions.assertEquals((Object)"key1", (Object)key.getRecordKey());
        Assertions.assertEquals((Object)"timestamp=4357686", (Object)key.getPartitionPath());
        Row row = KeyGeneratorTestUtilities.getRow(record);
        Assertions.assertEquals((Object)"key1", (Object)keyGenerator.getRecordKey(row));
        Assertions.assertEquals((Object)"timestamp=4357686", (Object)keyGenerator.getPartitionPath(row));
        InternalRow internalRow = KeyGeneratorTestUtilities.getInternalRow(row);
        Assertions.assertEquals((Object)UTF8String.fromString((String)"timestamp=4357686"), (Object)keyGenerator.getPartitionPath(internalRow, row.schema()));
    }

    private static Stream<GenericRecord> nestedColTestRecords() {
        return Stream.of(null, TestSimpleKeyGenerator.getNestedColRecord(null, 10L), TestSimpleKeyGenerator.getNestedColRecord("", 10L), TestSimpleKeyGenerator.getNestedColRecord("val1", 10L));
    }

    @ParameterizedTest
    @MethodSource(value={"nestedColTestRecords"})
    public void testNestedPartitionPathField(GenericRecord nestedColRecord) {
        SimpleKeyGenerator keyGenerator = new SimpleKeyGenerator(this.getPropsWithNestedPartitionPathField());
        GenericRecord record = TestSimpleKeyGenerator.getRecord(nestedColRecord);
        String partitionPathFieldValue = null;
        if (nestedColRecord != null) {
            partitionPathFieldValue = (String)nestedColRecord.get("prop1");
        }
        String expectedPartitionPath = "nested_col.prop1=" + (partitionPathFieldValue != null && !partitionPathFieldValue.isEmpty() ? partitionPathFieldValue : "__HIVE_DEFAULT_PARTITION__");
        HoodieKey key = keyGenerator.getKey(record);
        Assertions.assertEquals((Object)"key1", (Object)key.getRecordKey());
        Assertions.assertEquals((Object)expectedPartitionPath, (Object)key.getPartitionPath());
        Row row = KeyGeneratorTestUtilities.getRow(record);
        Assertions.assertEquals((Object)"key1", (Object)keyGenerator.getRecordKey(row));
        Assertions.assertEquals((Object)expectedPartitionPath, (Object)keyGenerator.getPartitionPath(row));
    }
}

