/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen.factory;

import java.io.IOException;
import java.util.stream.Stream;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieKeyGeneratorException;
import org.apache.hudi.keygen.ComplexKeyGenerator;
import org.apache.hudi.keygen.CustomKeyGenerator;
import org.apache.hudi.keygen.GlobalDeleteKeyGenerator;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.keygen.NonpartitionedKeyGenerator;
import org.apache.hudi.keygen.SimpleKeyGenerator;
import org.apache.hudi.keygen.TimestampBasedKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.keygen.constant.KeyGeneratorType;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestCreateKeyGeneratorByTypeWithFactory {
    private TypedProperties props;

    private static Stream<Arguments> configParams() {
        String[] types = new String[]{KeyGeneratorType.SIMPLE.name(), KeyGeneratorType.TIMESTAMP.name(), KeyGeneratorType.COMPLEX.name(), KeyGeneratorType.CUSTOM.name(), KeyGeneratorType.NON_PARTITION.name(), KeyGeneratorType.GLOBAL_DELETE.name()};
        return Stream.of(types).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @BeforeEach
    public void init() {
        this.props = new TypedProperties();
        this.props.put((Object)KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), (Object)"_row_key");
        this.props.put((Object)KeyGeneratorOptions.HIVE_STYLE_PARTITIONING_ENABLE.key(), (Object)"true");
        this.props.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"timestamp");
        this.props.put((Object)"hoodie.deltastreamer.keygen.timebased.timestamp.type", (Object)"DATE_STRING");
        this.props.put((Object)"hoodie.deltastreamer.keygen.timebased.input.dateformat", (Object)"yyyy-MM-dd");
        this.props.put((Object)"hoodie.deltastreamer.keygen.timebased.output.dateformat", (Object)"yyyyMMdd");
    }

    @AfterEach
    public void teardown() {
        this.props = null;
    }

    @ParameterizedTest
    @MethodSource(value={"configParams"})
    public void testKeyGeneratorTypes(String keyGenType) throws IOException {
        this.props.put((Object)HoodieWriteConfig.KEYGENERATOR_TYPE.key(), (Object)keyGenType);
        KeyGeneratorType keyType = KeyGeneratorType.valueOf((String)keyGenType);
        KeyGenerator keyGenerator = HoodieSparkKeyGeneratorFactory.createKeyGenerator((TypedProperties)this.props);
        switch (keyType) {
            case SIMPLE: {
                Assertions.assertEquals((Object)SimpleKeyGenerator.class.getName(), (Object)keyGenerator.getClass().getName());
                return;
            }
            case COMPLEX: {
                Assertions.assertEquals((Object)ComplexKeyGenerator.class.getName(), (Object)keyGenerator.getClass().getName());
                return;
            }
            case TIMESTAMP: {
                Assertions.assertEquals((Object)TimestampBasedKeyGenerator.class.getName(), (Object)keyGenerator.getClass().getName());
                return;
            }
            case CUSTOM: {
                Assertions.assertEquals((Object)CustomKeyGenerator.class.getName(), (Object)keyGenerator.getClass().getName());
                return;
            }
            case NON_PARTITION: {
                Assertions.assertEquals((Object)NonpartitionedKeyGenerator.class.getName(), (Object)keyGenerator.getClass().getName());
                return;
            }
            case GLOBAL_DELETE: {
                Assertions.assertEquals((Object)GlobalDeleteKeyGenerator.class.getName(), (Object)keyGenerator.getClass().getName());
                return;
            }
        }
        throw new HoodieKeyGeneratorException("Unsupported keyGenerator Type " + keyGenType);
    }
}

