/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.testutils;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;

public class DataSourceTestUtils {
    private static final Random RANDOM = new Random(-626139411L);

    public static Schema getStructTypeExampleSchema() throws IOException {
        return new Schema.Parser().parse(FileIOUtils.readAsUTFString((InputStream)DataSourceTestUtils.class.getResourceAsStream("/exampleSchema.txt")));
    }

    public static Schema getStructTypeExampleEvolvedSchema() throws IOException {
        return new Schema.Parser().parse(FileIOUtils.readAsUTFString((InputStream)DataSourceTestUtils.class.getResourceAsStream("/exampleEvolvedSchema.txt")));
    }

    public static List<Row> generateRandomRows(int count) {
        ArrayList<Row> toReturn = new ArrayList<Row>();
        List<String> partitions = Arrays.asList("2016/03/15", "2015/03/16", "2015/03/17");
        for (int i = 0; i < count; ++i) {
            Object[] values = new Object[]{HoodieTestDataGenerator.genPseudoRandomUUID((Random)RANDOM).toString(), partitions.get(RANDOM.nextInt(3)), new Date().getTime()};
            toReturn.add(RowFactory.create((Object[])values));
        }
        return toReturn;
    }

    public static List<Row> generateUpdates(List<Row> records, int count) {
        ArrayList<Row> toReturn = new ArrayList<Row>();
        for (int i = 0; i < count; ++i) {
            Object[] values = new Object[]{records.get(i).getString(0), records.get(i).getAs(1), new Date().getTime()};
            toReturn.add(RowFactory.create((Object[])values));
        }
        return toReturn;
    }

    public static List<Row> getUniqueRows(List<Row> inserts, int count) {
        ArrayList<Row> toReturn = new ArrayList<Row>();
        int soFar = 0;
        int curIndex = 0;
        while (soFar < count) {
            if (!toReturn.contains(inserts.get(curIndex))) {
                toReturn.add(inserts.get(curIndex));
                ++soFar;
            }
            ++curIndex;
        }
        return toReturn;
    }

    public static List<Row> generateRandomRowsEvolvedSchema(int count) {
        ArrayList<Row> toReturn = new ArrayList<Row>();
        List<String> partitions = Arrays.asList("2016/03/15", "2015/03/16", "2015/03/17");
        for (int i = 0; i < count; ++i) {
            Object[] values = new Object[]{UUID.randomUUID().toString(), partitions.get(RANDOM.nextInt(3)), new Date().getTime(), UUID.randomUUID().toString()};
            toReturn.add(RowFactory.create((Object[])values));
        }
        return toReturn;
    }

    public static List<Row> updateRowsWithHigherTs(Dataset<Row> inputDf) {
        List input = inputDf.collectAsList();
        ArrayList<Row> rows = new ArrayList<Row>();
        for (Row row : input) {
            Object[] values = new Object[]{row.getAs("_row_key"), row.getAs("partition"), (Long)row.getAs("ts") + (long)RANDOM.nextInt(1000)};
            rows.add(RowFactory.create((Object[])values));
        }
        return rows;
    }

    public static boolean isLogFileOnly(String basePath) throws IOException {
        Configuration conf = new Configuration();
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(conf).setBasePath(basePath).build();
        String baseDataFormat = metaClient.getTableConfig().getBaseFileFormat().getFileExtension();
        Path path = new Path(basePath);
        FileSystem fs = path.getFileSystem(conf);
        RemoteIterator files = fs.listFiles(path, true);
        while (files.hasNext()) {
            LocatedFileStatus file = (LocatedFileStatus)files.next();
            if (!file.isFile() || !file.getPath().toString().endsWith(baseDataFormat)) continue;
            return false;
        }
        return true;
    }
}

