/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import java.io.File;
import java.nio.file.Paths;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.util.PathUtils$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001a2A!\u0001\u0002\u0001\u0017\tiA+Z:u!\u0006$\b.\u0016;jYNT!a\u0001\u0003\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u000b\u0019\tA\u0001[;eS*\u0011q\u0001C\u0001\u0007CB\f7\r[3\u000b\u0003%\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0007\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g\u0011\u0015\u0019\u0002\u0001\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\u0017\u00015\t!\u0001C\u0003\u0019\u0001\u0011\u0005\u0011$A\u0007uKN$x\t\\8c!\u0006$\bn\u001d\u000b\u00035u\u0001\"!D\u000e\n\u0005qq!\u0001B+oSRDQAH\fA\u0002}\tq\u0001^3na\u0012K'\u000f\u0005\u0002!K5\t\u0011E\u0003\u0002#G\u0005\u0011\u0011n\u001c\u0006\u0002I\u0005!!.\u0019<b\u0013\t1\u0013E\u0001\u0003GS2,\u0007FA\u000f)!\tI\u0013'D\u0001+\u0015\t\u00113F\u0003\u0002-[\u0005\u0019\u0011\r]5\u000b\u00059z\u0013a\u00026va&$XM\u001d\u0006\u0003a!\tQA[;oSRL!A\r\u0016\u0003\u000fQ+W\u000e\u001d#je\"\u0012q\u0003\u000e\t\u0003kYj\u0011aK\u0005\u0003o-\u0012A\u0001V3ti\u0002")
public class TestPathUtils {
    @Test
    public void testGlobPaths(@TempDir File tempDir) {
        Seq folders = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{new Path(Paths.get(tempDir.getAbsolutePath(), "folder1").toUri()), new Path(Paths.get(tempDir.getAbsolutePath(), "folder2").toUri()), new Path(Paths.get(tempDir.getAbsolutePath(), ".hoodie").toUri()), new Path(Paths.get(tempDir.getAbsolutePath(), ".hoodie", "metadata").toUri())}));
        Seq files = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{new Path(Paths.get(tempDir.getAbsolutePath(), "folder1", "file1").toUri()), new Path(Paths.get(tempDir.getAbsolutePath(), "folder1", "file2").toUri()), new Path(Paths.get(tempDir.getAbsolutePath(), "folder2", "file3").toUri()), new Path(Paths.get(tempDir.getAbsolutePath(), "folder2", "file4").toUri()), new Path(Paths.get(tempDir.getAbsolutePath(), ".hoodie", "metadata", "file5").toUri()), new Path(Paths.get(tempDir.getAbsolutePath(), ".hoodie", "metadata", "file6").toUri())}));
        folders.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Path folder) {
                return new File(folder.toUri()).mkdir();
            }
        });
        files.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Path file) {
                return new File(file.toUri()).createNewFile();
            }
        });
        Seq paths = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)tempDir.getAbsolutePath()).append((Object)"/*").toString()}));
        Seq globbedPaths = PathUtils$.MODULE$.checkAndGlobPathIfNecessary(paths, new Path((String)paths.head()).getFileSystem(new Configuration()));
        Assertions.assertEquals((Object)((SeqLike)folders.filterNot((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Path entry) {
                return entry.toString().contains(".hoodie");
            }
        })).sortWith((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Path x$1, Path x$2) {
                return new StringOps(Predef$.MODULE$.augmentString(x$1.toString())).$less((Object)x$2.toString());
            }
        }), (Object)globbedPaths.sortWith((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Path x$3, Path x$4) {
                return new StringOps(Predef$.MODULE$.augmentString(x$3.toString())).$less((Object)x$4.toString());
            }
        }));
        paths = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)tempDir.getAbsolutePath()).append((Object)"/*/*").toString()}));
        globbedPaths = PathUtils$.MODULE$.checkAndGlobPathIfNecessary(paths, new Path((String)paths.head()).getFileSystem(new Configuration()));
        Assertions.assertEquals((Object)((SeqLike)files.filterNot((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Path entry) {
                return entry.toString().contains(".hoodie");
            }
        })).sortWith((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Path x$5, Path x$6) {
                return new StringOps(Predef$.MODULE$.augmentString(x$5.toString())).$less((Object)x$6.toString());
            }
        }), (Object)globbedPaths.sortWith((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Path x$7, Path x$8) {
                return new StringOps(Predef$.MODULE$.augmentString(x$7.toString())).$less((Object)x$8.toString());
            }
        }));
        paths = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)tempDir.getAbsolutePath()).append((Object)"/folder1/*").toString()}));
        globbedPaths = PathUtils$.MODULE$.checkAndGlobPathIfNecessary(paths, new Path((String)paths.head()).getFileSystem(new Configuration()));
        Assertions.assertEquals((Object)((SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{(Path)files.apply(0), (Path)files.apply(1)}))).sortWith((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Path x$9, Path x$10) {
                return new StringOps(Predef$.MODULE$.augmentString(x$9.toString())).$less((Object)x$10.toString());
            }
        }), (Object)globbedPaths.sortWith((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Path x$11, Path x$12) {
                return new StringOps(Predef$.MODULE$.augmentString(x$11.toString())).$less((Object)x$12.toString());
            }
        }));
        paths = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)tempDir.getAbsolutePath()).append((Object)"/folder2/*").toString()}));
        globbedPaths = PathUtils$.MODULE$.checkAndGlobPathIfNecessary(paths, new Path((String)paths.head()).getFileSystem(new Configuration()));
        Assertions.assertEquals((Object)((SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{(Path)files.apply(2), (Path)files.apply(3)}))).sortWith((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Path x$13, Path x$14) {
                return new StringOps(Predef$.MODULE$.augmentString(x$13.toString())).$less((Object)x$14.toString());
            }
        }), (Object)globbedPaths.sortWith((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Path x$15, Path x$16) {
                return new StringOps(Predef$.MODULE$.augmentString(x$15.toString())).$less((Object)x$16.toString());
            }
        }));
        paths = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)tempDir.getAbsolutePath()).append((Object)"/folder1/*").toString(), new StringBuilder().append((Object)tempDir.getAbsolutePath()).append((Object)"/folder2/*").toString()}));
        globbedPaths = PathUtils$.MODULE$.checkAndGlobPathIfNecessary(paths, new Path((String)paths.head()).getFileSystem(new Configuration()));
        Assertions.assertEquals((Object)((SeqLike)files.filterNot((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Path entry) {
                return entry.toString().contains(".hoodie");
            }
        })).sortWith((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Path x$17, Path x$18) {
                return new StringOps(Predef$.MODULE$.augmentString(x$17.toString())).$less((Object)x$18.toString());
            }
        }), (Object)globbedPaths.sortWith((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Path x$19, Path x$20) {
                return new StringOps(Predef$.MODULE$.augmentString(x$19.toString())).$less((Object)x$20.toString());
            }
        }));
    }
}

