/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.avro;

import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.avro.model.HoodieMetadataColumnStats;
import org.apache.hudi.avro.model.IntWrapper;
import org.apache.spark.sql.avro.HoodieAvroDeserializer;
import org.apache.spark.sql.avro.HoodieAvroSerializer;
import org.apache.spark.sql.avro.SchemaConverters;
import org.apache.spark.sql.avro.SchemaConverters$;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.types.DataType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001A2A!\u0001\u0002\u0001\u001b\tiA+Z:u\u0003Z\u0014xnU3s\t\u0016T!a\u0001\u0003\u0002\t\u00054(o\u001c\u0006\u0003\u000b\u0019\t1a]9m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019!\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u001615\taC\u0003\u0002\u0018\u0011\u0005!\u0001.\u001e3j\u0013\tIbCA\nTa\u0006\u00148.\u00113baR,'oU;qa>\u0014H\u000fC\u0003\u001c\u0001\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u0005!)\u0001\u0005\u0001C\u0001C\u0005\u0011B/Z:u\u0003Z\u0014x.\u00168j_:\u001cVM\u001d#f)\u0005\u0011\u0003CA\b$\u0013\t!\u0003C\u0001\u0003V]&$\bFA\u0010'!\t9c&D\u0001)\u0015\tI#&A\u0002ba&T!a\u000b\u0017\u0002\u000f),\b/\u001b;fe*\u0011QFC\u0001\u0006UVt\u0017\u000e^\u0005\u0003_!\u0012A\u0001V3ti\u0002")
public class TestAvroSerDe
implements SparkAdapterSupport {
    private final SparkAdapter sparkAdapter;
    private volatile boolean bitmap$0;

    private SparkAdapter sparkAdapter$lzycompute() {
        TestAvroSerDe testAvroSerDe = this;
        synchronized (testAvroSerDe) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport.class.sparkAdapter((SparkAdapterSupport)this);
                this.bitmap$0 = true;
            }
            return this.sparkAdapter;
        }
    }

    public SparkAdapter sparkAdapter() {
        return this.bitmap$0 ? this.sparkAdapter : this.sparkAdapter$lzycompute();
    }

    @Test
    public void testAvroUnionSerDe() {
        GenericData.Record minValue = new GenericData.Record(IntWrapper.SCHEMA$);
        minValue.put("value", (Object)BoxesRunTime.boxToInteger((int)9));
        GenericData.Record maxValue = new GenericData.Record(IntWrapper.SCHEMA$);
        maxValue.put("value", (Object)BoxesRunTime.boxToInteger((int)10));
        GenericData.Record record = new GenericData.Record(HoodieMetadataColumnStats.SCHEMA$);
        record.put("fileName", (Object)"9388c460-4ace-4274-9a0b-d44606af60af-0_2-25-35_20220520154514641.parquet");
        record.put("columnName", (Object)"c8");
        record.put("minValue", (Object)minValue);
        record.put("maxValue", (Object)maxValue);
        record.put("valueCount", (Object)BoxesRunTime.boxToLong((long)10L));
        record.put("nullCount", (Object)BoxesRunTime.boxToLong((long)0L));
        record.put("totalSize", (Object)BoxesRunTime.boxToLong((long)94L));
        record.put("totalUncompressedSize", (Object)BoxesRunTime.boxToLong((long)54L));
        record.put("isDeleted", (Object)BoxesRunTime.boxToBoolean((boolean)false));
        GenericData.Record originalAvroRecord = record;
        Schema avroSchema = HoodieMetadataColumnStats.SCHEMA$;
        SchemaConverters.SchemaType schemaType = SchemaConverters$.MODULE$.toSqlType(avroSchema);
        if (schemaType != null) {
            DataType catalystSchema;
            DataType dataType;
            DataType catalystSchema2 = dataType = (catalystSchema = schemaType.dataType());
            HoodieAvroDeserializer deserializer = this.sparkAdapter().createAvroDeserializer(avroSchema, catalystSchema2);
            HoodieAvroSerializer serializer = this.sparkAdapter().createAvroSerializer(catalystSchema2, avroSchema, false);
            Object row = deserializer.deserialize((Object)originalAvroRecord).get();
            Object deserializedAvroRecord = serializer.serialize(row);
            Assertions.assertEquals((Object)originalAvroRecord, (Object)deserializedAvroRecord);
            return;
        }
        throw new MatchError((Object)schemaType);
    }

    public TestAvroSerDe() {
        SparkAdapterSupport.class.$init$((SparkAdapterSupport)this);
    }
}

