/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.spark.hudi.benchmark.HoodieBenchmark;
import org.apache.spark.hudi.benchmark.HoodieBenchmark$;
import org.apache.spark.hudi.benchmark.HoodieBenchmarkBase;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.benchmark.AvroSerDerBenchmark$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class AvroSerDerBenchmark$
extends HoodieBenchmarkBase {
    public static final AvroSerDerBenchmark$ MODULE$;
    private final SparkSession spark;

    static {
        new AvroSerDerBenchmark$();
    }

    public SparkSession spark() {
        return this.spark;
    }

    public SparkSession getSparkSession() {
        return SparkSession$.MODULE$.builder().master("local[1]").config("spark.driver.memory", "8G").appName(this.getClass().getCanonicalName()).getOrCreate();
    }

    public Dataset<Row> getDataFrame(long numbers) {
        return this.spark().range(0L, numbers).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"})).withColumn("c1", functions$.MODULE$.lit((Object)"AvroSerDerBenchmark")).withColumn("c2", functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)12.99))).withColumn("c3", functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1)));
    }

    private void avroSerializerBenchmark() {
        HoodieBenchmark benchmark = new HoodieBenchmark(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"perf avro serializer for hoodie"})).s((Seq)Nil$.MODULE$), 50000000L, HoodieBenchmark$.MODULE$.$lessinit$greater$default$3(), HoodieBenchmark$.MODULE$.$lessinit$greater$default$4(), HoodieBenchmark$.MODULE$.$lessinit$greater$default$5(), HoodieBenchmark$.MODULE$.$lessinit$greater$default$6(), HoodieBenchmark$.MODULE$.$lessinit$greater$default$7());
        benchmark.addCase("serialize internalRow to avro Record", benchmark.addCase$default$2(), (Function1<Object, BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(int x$1) {
                this.apply$mcVI$sp(x$1);
            }

            public void apply$mcVI$sp(int x$1) {
                Dataset<Row> df = AvroSerDerBenchmark$.MODULE$.getDataFrame(50000000L);
                Schema avroSchema = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)df.schema(), "record", "my");
                AvroSerDerBenchmark$.MODULE$.spark().sparkContext().getConf().registerAvroSchemas((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema[]{avroSchema}));
                HoodieSparkUtils$.MODULE$.createRdd(df, "record", "my", (Option)new Some((Object)avroSchema)).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(GenericRecord f) {
                    }
                });
            }
        });
        benchmark.run();
    }

    private void avroDeserializerBenchmark() {
        HoodieBenchmark benchmark = new HoodieBenchmark(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"perf avro deserializer for hoodie"})).s((Seq)Nil$.MODULE$), 10000000L, HoodieBenchmark$.MODULE$.$lessinit$greater$default$3(), HoodieBenchmark$.MODULE$.$lessinit$greater$default$4(), HoodieBenchmark$.MODULE$.$lessinit$greater$default$5(), HoodieBenchmark$.MODULE$.$lessinit$greater$default$6(), HoodieBenchmark$.MODULE$.$lessinit$greater$default$7());
        Dataset<Row> df = this.getDataFrame(10000000L);
        StructType sparkSchema = df.schema();
        Schema avroSchema = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)df.schema(), "record", "my");
        RDD testRdd = HoodieSparkUtils$.MODULE$.createRdd(df, "record", "my", (Option)new Some((Object)avroSchema));
        testRdd.cache();
        testRdd.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(GenericRecord f) {
            }
        });
        this.spark().sparkContext().getConf().registerAvroSchemas((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema[]{avroSchema}));
        benchmark.addCase("deserialize avro Record to internalRow", benchmark.addCase$default$2(), (Function1<Object, BoxedUnit>)new Serializable(sparkSchema, testRdd){
            public static final long serialVersionUID = 0L;
            public final StructType sparkSchema$1;
            private final RDD testRdd$1;

            public final void apply(int x$2) {
                this.apply$mcVI$sp(x$2);
            }

            public void apply$mcVI$sp(int x$2) {
                this.testRdd$1.mapPartitions((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.avroDeserializerBenchmark.1 $outer;

                    public final Iterator<InternalRow> apply(Iterator<GenericRecord> iter) {
                        Schema schema = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)this.$outer.sparkSchema$1, "record", "my");
                        Function1 avroToRowConverter = AvroConversionUtils$.MODULE$.createAvroToInternalRowConverter(schema, this.$outer.sparkSchema$1);
                        return iter.map((Function1)new Serializable(this, avroToRowConverter){
                            public static final long serialVersionUID = 0L;
                            private final Function1 avroToRowConverter$1;

                            public final InternalRow apply(GenericRecord record) {
                                return (InternalRow)((Option)this.avroToRowConverter$1.apply((Object)record)).get();
                            }
                            {
                                this.avroToRowConverter$1 = avroToRowConverter$1;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, this.testRdd$1.mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class)).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(InternalRow f) {
                    }
                });
            }
            {
                this.sparkSchema$1 = sparkSchema$1;
                this.testRdd$1 = testRdd$1;
            }
        });
        benchmark.run();
    }

    @Override
    public void afterAll() {
        this.spark().stop();
    }

    @Override
    public void runBenchmarkSuite(String[] mainArgs) {
        this.avroSerializerBenchmark();
        this.avroDeserializerBenchmark();
    }

    private AvroSerDerBenchmark$() {
        MODULE$ = this;
        this.spark = this.getSparkSession();
    }
}

