/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.File;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.ColumnStatsIndexHelper;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.sort.SpaceCurveSortingHelper;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.execution.benchmark.SpaceCurveOptimizeBenchmark$;
import org.apache.spark.sql.hudi.HoodieSparkSqlTestBase;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.util.Random$;

@Tag(value="functional")
public final class SpaceCurveOptimizeBenchmark$
extends HoodieSparkSqlTestBase {
    public static final SpaceCurveOptimizeBenchmark$ MODULE$;

    static {
        new SpaceCurveOptimizeBenchmark$();
    }

    public void evalSkippingPercent(String tableName, String co1, String co2, int value1, int value2) {
        Dataset sourceTableDF = this.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select * from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
        Seq orderedColsTypes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField(co1, (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField(co2, (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}));
        Tuple4[] colStatsIndexTable = (Tuple4[])Predef$.MODULE$.refArrayOps((Object[])ColumnStatsIndexHelper.buildColumnStatsTableFor(this.spark(), JavaConversions$.MODULE$.seqAsJavaList(Predef$.MODULE$.refArrayOps((Object[])sourceTableDF.inputFiles()).toSeq()), JavaConversions$.MODULE$.seqAsJavaList(orderedColsTypes)).collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple4<Object, Object, Object, Object> apply(Row f) {
                return new Tuple4((Object)BoxesRunTime.boxToInteger((int)f.getInt(1)), (Object)BoxesRunTime.boxToInteger((int)f.getInt(2)), (Object)BoxesRunTime.boxToInteger((int)f.getInt(4)), (Object)BoxesRunTime.boxToInteger((int)f.getInt(5)));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple4.class)));
        IntRef hits = IntRef.create((int)0);
        Predef$.MODULE$.refArrayOps((Object[])colStatsIndexTable).foreach((Function1)new Serializable(value1, value2, hits){
            public static final long serialVersionUID = 0L;
            private final int value1$1;
            private final int value2$1;
            private final IntRef hits$1;

            public final void apply(Tuple4<Object, Object, Object, Object> fileStatRow) {
                if (BoxesRunTime.unboxToInt((Object)fileStatRow._1()) <= this.value1$1 && BoxesRunTime.unboxToInt((Object)fileStatRow._2()) >= this.value1$1 || BoxesRunTime.unboxToInt((Object)fileStatRow._3()) <= this.value2$1 && BoxesRunTime.unboxToInt((Object)fileStatRow._4()) >= this.value2$1) {
                    ++this.hits$1.elem;
                }
            }
            {
                this.value1$1 = value1$1;
                this.value2$1 = value2$1;
                this.hits$1 = hits$1;
            }
        });
        double p = (double)hits.elem / (double)Predef$.MODULE$.refArrayOps((Object[])colStatsIndexTable).size();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"For table ", " with query filter: ", " = ", " or ", " = ", " we can achieve skipping percent ", " (w/ total files ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, co1, BoxesRunTime.boxToInteger((int)value1), co2, BoxesRunTime.boxToInteger((int)value2), BoxesRunTime.boxToDouble((double)(1.0 - p)), BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])colStatsIndexTable).size())})));
    }

    @Test
    @Disabled
    public void runNormalTableSkippingBenchMark() {
        this.withTempDir((Function1<File, BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(File f) {
                SpaceCurveOptimizeBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table_z_sort_byMap", "table_z_sort_bySample", "table_hilbert_sort_byMap", "table_hilbert_sort_bySample"}), (Function0<BoxedUnit>)new Serializable(this, f){
                    public static final long serialVersionUID = 0L;
                    private final File f$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        SpaceCurveOptimizeBenchmark$.MODULE$.prepareInterTypeTable(new Path(this.f$1.getAbsolutePath()), 1000000, SpaceCurveOptimizeBenchmark$.MODULE$.prepareInterTypeTable$default$3(), SpaceCurveOptimizeBenchmark$.MODULE$.prepareInterTypeTable$default$4(), SpaceCurveOptimizeBenchmark$.MODULE$.prepareInterTypeTable$default$5());
                        SpaceCurveOptimizeBenchmark$.MODULE$.evalSkippingPercent("table_z_sort_byMap", "c1_int", "c2_int", 500000, 500000);
                        SpaceCurveOptimizeBenchmark$.MODULE$.evalSkippingPercent("table_z_sort_bySample", "c1_int", "c2_int", 500000, 500000);
                        SpaceCurveOptimizeBenchmark$.MODULE$.evalSkippingPercent("table_hilbert_sort_byMap", "c1_int", "c2_int", 500000, 500000);
                        SpaceCurveOptimizeBenchmark$.MODULE$.evalSkippingPercent("table_hilbert_sort_bySample", "c1_int", "c2_int", 500000, 500000);
                    }
                    {
                        this.f$1 = f$1;
                    }
                });
            }
        });
    }

    @Test
    @Disabled
    public void runSkewTableSkippingBenchMark() {
        this.withTempDir((Function1<File, BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(File f) {
                SpaceCurveOptimizeBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table_z_sort_byMap_skew", "table_z_sort_bySample_skew", "table_hilbert_sort_byMap_skew", "table_hilbert_sort_bySample_skew"}), (Function0<BoxedUnit>)new Serializable(this, f){
                    public static final long serialVersionUID = 0L;
                    private final File f$2;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        SpaceCurveOptimizeBenchmark$.MODULE$.prepareInterTypeTable(new Path(this.f$2.getAbsolutePath()), 1000000, 10000, 1000000, true);
                        SpaceCurveOptimizeBenchmark$.MODULE$.evalSkippingPercent("table_z_sort_byMap_skew", "c1_int", "c2_int", 5000, 500000);
                        SpaceCurveOptimizeBenchmark$.MODULE$.evalSkippingPercent("table_z_sort_bySample_skew", "c1_int", "c2_int", 5000, 500000);
                        SpaceCurveOptimizeBenchmark$.MODULE$.evalSkippingPercent("table_hilbert_sort_byMap_skew", "c1_int", "c2_int", 5000, 500000);
                        SpaceCurveOptimizeBenchmark$.MODULE$.evalSkippingPercent("table_hilbert_sort_bySample_skew", "c1_int", "c2_int", 5000, 500000);
                    }
                    {
                        this.f$2 = f$2;
                    }
                });
            }
        });
    }

    public void withTempTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        try {
            f.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            tableNames.foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String viewName) {
                    return SpaceCurveOptimizeBenchmark$.MODULE$.spark().catalog().dropTempView(viewName);
                }
            });
            throw throwable;
        }
        tableNames.foreach((Function1)new /* invalid duplicate definition of identical inner class */);
    }

    public void prepareInterTypeTable(Path tablePath, int numRows, int col1Range, int col2Range, boolean skewed) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(((Object)((Object)this)).getClass().getClassLoader());
        public final class Org_apache_spark_sql_execution_benchmark_SpaceCurveOptimizeBenchmark$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor()})));
            }

            public Org_apache_spark_sql_execution_benchmark_SpaceCurveOptimizeBenchmark$$typecreator4$1() {
            }
        }
        Dataset df = this.spark().range((long)numRows).map((Function1)new Serializable(col1Range, col2Range){
            public static final long serialVersionUID = 0L;
            private final int col1Range$1;
            private final int col2Range$1;

            public final Tuple2<Object, Object> apply(Long x$1) {
                return new Tuple2.mcII.sp(Random$.MODULE$.nextInt(this.col1Range$1), Random$.MODULE$.nextInt(this.col2Range$1));
            }
            {
                this.col1Range$1 = col1Range$1;
                this.col2Range$1 = col2Range$1;
            }
        }, this.spark().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_benchmark_SpaceCurveOptimizeBenchmark$$typecreator4$1()))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c1_int", "c2_int"}));
        Dataset dfOptimizeByMap = SpaceCurveSortingHelper.orderDataFrameByMappingValues((Dataset)df, (HoodieClusteringConfig.LayoutOptimizationStrategy)HoodieClusteringConfig.LayoutOptimizationStrategy.ZORDER, (List)JavaConversions$.MODULE$.seqAsJavaList((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c1_int", "c2_int"}))), (int)200);
        Dataset dfOptimizeBySample = SpaceCurveSortingHelper.orderDataFrameBySamplingValues((Dataset)df, (HoodieClusteringConfig.LayoutOptimizationStrategy)HoodieClusteringConfig.LayoutOptimizationStrategy.ZORDER, (List)JavaConversions$.MODULE$.seqAsJavaList((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c1_int", "c2_int"}))), (int)200);
        Dataset dfHilbertOptimizeByMap = SpaceCurveSortingHelper.orderDataFrameByMappingValues((Dataset)df, (HoodieClusteringConfig.LayoutOptimizationStrategy)HoodieClusteringConfig.LayoutOptimizationStrategy.HILBERT, (List)JavaConversions$.MODULE$.seqAsJavaList((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c1_int", "c2_int"}))), (int)200);
        Dataset dfHilbertOptimizeBySample = SpaceCurveSortingHelper.orderDataFrameBySamplingValues((Dataset)df, (HoodieClusteringConfig.LayoutOptimizationStrategy)HoodieClusteringConfig.LayoutOptimizationStrategy.HILBERT, (List)JavaConversions$.MODULE$.seqAsJavaList((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c1_int", "c2_int"}))), (int)200);
        this.saveAsTable((Dataset<Row>)dfOptimizeByMap, tablePath, skewed ? "z_sort_byMap_skew" : "z_sort_byMap");
        this.saveAsTable((Dataset<Row>)dfOptimizeBySample, tablePath, skewed ? "z_sort_bySample_skew" : "z_sort_bySample");
        this.saveAsTable((Dataset<Row>)dfHilbertOptimizeByMap, tablePath, skewed ? "hilbert_sort_byMap_skew" : "hilbert_sort_byMap");
        this.saveAsTable((Dataset<Row>)dfHilbertOptimizeBySample, tablePath, skewed ? "hilbert_sort_bySample_skew" : "hilbert_sort_bySample");
    }

    public int prepareInterTypeTable$default$3() {
        return 1000000;
    }

    public int prepareInterTypeTable$default$4() {
        return 1000000;
    }

    public boolean prepareInterTypeTable$default$5() {
        return false;
    }

    public void saveAsTable(Dataset<Row> df, Path savePath, String suffix) {
        df.write().mode("overwrite").save(new Path(savePath, suffix).toString());
        this.spark().read().parquet(new Path(savePath, suffix).toString()).createOrReplaceTempView(new StringBuilder().append((Object)"table_").append((Object)suffix).toString());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SpaceCurveOptimizeBenchmark$() {
        MODULE$ = this;
    }
}

