/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi;

import java.io.File;
import java.util.Properties;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.hadoop.realtime.HoodieParquetRealtimeInputFormat;
import org.apache.hudi.keygen.ComplexKeyGenerator;
import org.apache.hudi.keygen.NonpartitionedKeyGenerator;
import org.apache.hudi.keygen.SimpleKeyGenerator;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.hudi.HoodieSparkSqlTestBase;
import org.apache.spark.sql.hudi.TestCreateTable$;
import org.apache.spark.sql.hudi.TestCreateTable$$anonfun$10$;
import org.apache.spark.sql.hudi.TestCreateTable$$anonfun$10$$anonfun$apply$mcV$sp$10$;
import org.apache.spark.sql.hudi.TestCreateTable$$anonfun$10$$anonfun$apply$mcV$sp$10$$anonfun$apply$10$;
import org.apache.spark.sql.hudi.TestCreateTable$$anonfun$11$;
import org.apache.spark.sql.hudi.TestCreateTable$$anonfun$11$$anonfun$apply$mcV$sp$11$;
import org.apache.spark.sql.hudi.TestCreateTable$$anonfun$3$;
import org.apache.spark.sql.hudi.TestCreateTable$$anonfun$4$;
import org.apache.spark.sql.hudi.TestCreateTable$$anonfun$4$$anonfun$apply$mcV$sp$4$;
import org.apache.spark.sql.hudi.TestCreateTable$$anonfun$9$;
import org.apache.spark.sql.hudi.TestCreateTable$$anonfun$9$$anonfun$apply$mcV$sp$9$;
import org.apache.spark.sql.hudi.TestCreateTable$$anonfun$9$$anonfun$apply$mcV$sp$9$$anonfun$apply$9$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.junit.jupiter.api.Assertions;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple4;
import scala.Tuple5;
import scala.Tuple6;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Y1A!\u0001\u0002\u0001\u001b\tyA+Z:u\u0007J,\u0017\r^3UC\ndWM\u0003\u0002\u0004\t\u0005!\u0001.\u001e3j\u0015\t)a!A\u0002tc2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010!5\t!!\u0003\u0002\u0012\u0005\t1\u0002j\\8eS\u0016\u001c\u0006/\u0019:l'FdG+Z:u\u0005\u0006\u001cX\rC\u0003\u0014\u0001\u0011\u0005A#\u0001\u0004=S:LGO\u0010\u000b\u0002+A\u0011q\u0002\u0001")
public class TestCreateTable
extends HoodieSparkSqlTestBase {
    public TestCreateTable() {
        this.test("Test Create Managed Hoodie Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestCreateTable $outer;

            public final Dataset<Row> apply() {
                String databaseName = "hudi_database";
                this.$outer.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"create database if not exists ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{databaseName})));
                this.$outer.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"use ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{databaseName})));
                String tableName = this.$outer.generateTableName();
                this.$outer.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | create table ", " (\n         |  id int,\n         |  name string,\n         |  price double,\n         |  ts long\n         | ) using hudi\n         | tblproperties (\n         |   hoodie.database.name = \"databaseName\",\n         |   hoodie.table.name = \"tableName\",\n         |   primaryKey = 'id',\n         |   preCombineField = 'ts',\n         |   hoodie.datasource.write.operation = 'upsert'\n         | )\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})))).stripMargin());
                CatalogTable table = this.$outer.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName));
                this.$outer.assertResult(tableName, table.identifier().table(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
                this.$outer.assertResult("hudi", table.provider().get(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
                this.$outer.assertResult(CatalogTableType$.MODULE$.MANAGED(), table.tableType(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
                this.$outer.assertResult(((BufferLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(HoodieRecord.HOODIE_META_COLUMNS).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final StructField apply(String x$1) {
                        return new StructField(x$1, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                    }
                }, Buffer$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("id", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("name", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("price", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("ts", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), table.schema().fields(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
                Assertions.assertFalse((boolean)table.properties().contains((Object)HoodieTableConfig.DATABASE_NAME.key()));
                Assertions.assertFalse((boolean)table.properties().contains((Object)HoodieTableConfig.NAME.key()));
                Assertions.assertFalse((boolean)table.properties().contains((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()));
                String tablePath = (String)table.storage().properties().apply((Object)"path");
                HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(tablePath).setConf(this.$outer.spark().sessionState().newHadoopConf()).build();
                HoodieTableConfig tableConfig = metaClient.getTableConfig();
                this.$outer.assertResult(databaseName, tableConfig.getDatabaseName(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
                this.$outer.assertResult(tableName, tableConfig.getTableName(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
                Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(tableConfig.contains(DataSourceWriteOptions$.MODULE$.OPERATION().key())));
                return this.$outer.spark().sql("use default");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
        this.test("Test Create Hoodie Table With Options", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestCreateTable $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String tableName = this.$outer.generateTableName();
                this.$outer.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | create table ", " (\n         |  id int,\n         |  name string,\n         |  price double,\n         |  ts long,\n         |  dt string\n         | ) using hudi\n         | partitioned by (dt)\n         | options (\n         |   hoodie.database.name = \"databaseName\",\n         |   hoodie.table.name = \"tableName\",\n         |   primaryKey = 'id',\n         |   preCombineField = 'ts',\n         |   hoodie.datasource.write.operation = 'upsert'\n         | )\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})))).stripMargin());
                CatalogTable table = this.$outer.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName));
                this.$outer.assertResult(table.properties().apply((Object)"type"), "cow", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
                this.$outer.assertResult(table.properties().apply((Object)"primaryKey"), "id", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
                this.$outer.assertResult(table.properties().apply((Object)"preCombineField"), "ts", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
                this.$outer.assertResult(tableName, table.identifier().table(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
                this.$outer.assertResult("hudi", table.provider().get(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
                this.$outer.assertResult(CatalogTableType$.MODULE$.MANAGED(), table.tableType(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
                this.$outer.assertResult(((BufferLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(HoodieRecord.HOODIE_META_COLUMNS).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final StructField apply(String x$2) {
                        return new StructField(x$2, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                    }
                }, Buffer$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("id", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("name", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("price", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("ts", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("dt", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), table.schema().fields(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
                Assertions.assertFalse((boolean)table.properties().contains((Object)HoodieTableConfig.DATABASE_NAME.key()));
                Assertions.assertFalse((boolean)table.properties().contains((Object)HoodieTableConfig.NAME.key()));
                Assertions.assertFalse((boolean)table.properties().contains((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()));
                String tablePath = (String)table.storage().properties().apply((Object)"path");
                HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(tablePath).setConf(this.$outer.spark().sessionState().newHadoopConf()).build();
                Map tableConfig = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)metaClient.getTableConfig().getProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
                this.$outer.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)tableConfig.contains((Object)HoodieTableConfig.CREATE_SCHEMA.key())), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
                this.$outer.assertResult("dt", tableConfig.apply((Object)HoodieTableConfig.PARTITION_FIELDS.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
                this.$outer.assertResult("id", tableConfig.apply((Object)HoodieTableConfig.RECORDKEY_FIELDS.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
                this.$outer.assertResult("ts", tableConfig.apply((Object)HoodieTableConfig.PRECOMBINE_FIELD.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
                this.$outer.assertResult(SimpleKeyGenerator.class.getCanonicalName(), tableConfig.apply((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
                this.$outer.assertResult("default", tableConfig.apply((Object)HoodieTableConfig.DATABASE_NAME.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
                this.$outer.assertResult(tableName, tableConfig.apply((Object)HoodieTableConfig.NAME.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
                Assertions.assertFalse((boolean)tableConfig.contains((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        this.test("Test Create External Hoodie Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestCreateTable $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempDir((Function1<File, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    public final void apply(File tmp) {
                        String tableName = this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().generateTableName();
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |create table ", " (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | tblproperties (\n           |  primaryKey = 'id,name',\n           |  type = 'cow'\n           | )\n           | location '", "'\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, tmp.getCanonicalPath()})))).stripMargin());
                        CatalogTable table = this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertResult(tableName, table.identifier().table(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertResult("hudi", table.provider().get(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertResult(CatalogTableType$.MODULE$.EXTERNAL(), table.tableType(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertResult(((BufferLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(HoodieRecord.HOODIE_META_COLUMNS).asScala()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final StructField apply(String x$3) {
                                return new StructField(x$3, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                            }
                        }, Buffer$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("id", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("name", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("price", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("ts", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), table.schema().fields(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertResult(table.properties().apply((Object)"type"), "cow", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertResult(table.properties().apply((Object)"primaryKey"), "id,name", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |create table ", " (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long,\n           |  dt string\n           |) using hudi\n           | partitioned by (dt)\n           | tblproperties (\n           |  primaryKey = 'id',\n           |  type = 'mor'\n           | )\n           | location '", "/h0'\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, tmp.getCanonicalPath()})))).stripMargin());
                        CatalogTable table2 = this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertResult(table2.properties().apply((Object)"type"), "mor", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertResult(table2.properties().apply((Object)"primaryKey"), "id", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertResult(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dt"})), table2.partitionColumnNames(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertResult(HoodieParquetRealtimeInputFormat.class.getCanonicalName(), table2.storage().inputFormat().get(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
                        String tableName3 = this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().generateTableName();
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |create table ", "\n           |using hudi\n           |location '", "/h0'\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName3, tmp.getCanonicalPath()})))).stripMargin());
                        CatalogTable table3 = this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName3));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertResult(table3.properties().apply((Object)"type"), "mor", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertResult(table3.properties().apply((Object)"primaryKey"), "id", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertResult(((BufferLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(HoodieRecord.HOODIE_META_COLUMNS).asScala()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final StructField apply(String x$4) {
                                return new StructField(x$4, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                            }
                        }, Buffer$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("id", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("name", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("price", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("ts", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("dt", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), table3.schema().fields(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TestCreateTable org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
        this.test("Test Table Column Validate", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestCreateTable $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempDir((Function1<File, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final void apply(File tmp) {
                        String tableName = this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().generateTableName();
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertThrows((Function0)new Serializable(this, tableName, tmp){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$3$$anonfun$apply$mcV$sp$3 $outer;
                            private final String tableName$1;
                            private final File tmp$1;

                            public final Dataset<Row> apply() {
                                return this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |create table ", " (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | tblproperties (\n             |  primaryKey = 'id1',\n             |  type = 'cow'\n             | )\n             | location '", "'\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName$1, this.tmp$1.getCanonicalPath()})))).stripMargin());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.tableName$1 = tableName$1;
                                this.tmp$1 = tmp$1;
                            }
                        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertThrows((Function0)new Serializable(this, tableName, tmp){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$3$$anonfun$apply$mcV$sp$3 $outer;
                            private final String tableName$1;
                            private final File tmp$1;

                            public final Dataset<Row> apply() {
                                return this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |create table ", " (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | tblproperties (\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts1',\n             |  type = 'cow'\n             | )\n             | location '", "'\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName$1, this.tmp$1.getCanonicalPath()})))).stripMargin());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.tableName$1 = tableName$1;
                                this.tmp$1 = tmp$1;
                            }
                        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertThrows((Function0)new Serializable(this, tableName, tmp){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$3$$anonfun$apply$mcV$sp$3 $outer;
                            private final String tableName$1;
                            private final File tmp$1;

                            public final Dataset<Row> apply() {
                                return this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |create table ", " (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | tblproperties (\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts',\n             |  type = 'cow1'\n             | )\n             | location '", "'\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName$1, this.tmp$1.getCanonicalPath()})))).stripMargin());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.tableName$1 = tableName$1;
                                this.tmp$1 = tmp$1;
                            }
                        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
                    }

                    public /* synthetic */ $anonfun$3 org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TestCreateTable org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
        this.test("Test Create Table As Select", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestCreateTable $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempDir((Function1<File, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;

                    public final void apply(File tmp) {
                        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1)new Serializable(this, tmp){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$4$$anonfun$apply$mcV$sp$4 $outer;
                            public final File tmp$2;

                            public final void apply(String tableType) {
                                String tableName1 = this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().generateTableName();
                                this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             | create table ", " using hudi\n             | tblproperties(\n             |    primaryKey = 'id',\n             |    type = '", "'\n             | )\n             | location '", "/", "'\n             | AS\n             | select 1 as id, 'a1' as name, 10 as price, 1000 as ts\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName1, tableType, this.tmp$2.getCanonicalPath(), tableName1})))).stripMargin());
                                this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().checkAnswer(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select id, name, price, ts from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName1})), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
                                String tableName2 = this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().generateTableName();
                                this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             | create table ", " using hudi\n             | partitioned by (dt)\n             | tblproperties(\n             |    primaryKey = 'id',\n             |    type = '", "'\n             | )\n             | location '", "/", "'\n             | AS\n             | select 1 as id, 'a1' as name, 10 as price, '2021-04-01' as dt\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName2, tableType, this.tmp$2.getCanonicalPath(), tableName2})))).stripMargin());
                                this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().checkAnswer(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select id, name, price, dt from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName2})), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-04-01"}))}));
                                String tableName3 = this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().generateTableName();
                                this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertThrows((Function0)new Serializable(this, tableName3, tableType){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$4$$anonfun$apply$mcV$sp$4$$anonfun$apply$7 $outer;
                                    private final String tableName3$1;
                                    private final String tableType$1;

                                    public final Dataset<Row> apply() {
                                        return this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               | create table ", " using hudi\n               | partitioned by (dt)\n               | tblproperties(\n               |    primaryKey = 'id',\n               |    type = '", "'\n               | )\n               | location '", "/", "'\n               | AS\n               | select null as id, 'a1' as name, 10 as price, '2021-05-07' as dt\n               |\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName3$1, this.tableType$1, this.$outer.tmp$2.getCanonicalPath(), this.tableName3$1})))).stripMargin());
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.tableName3$1 = tableName3$1;
                                        this.tableType$1 = tableType$1;
                                    }
                                }, ClassTag$.MODULE$.apply(Exception.class), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 327));
                                this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             | create table ", " using hudi\n             | partitioned by (dt)\n             | tblproperties(\n             |    primaryKey = 'id',\n             |    type = '", "'\n             | )\n             | location '", "/", "'\n             | AS\n             | select cast('2021-05-06 00:00:00' as timestamp) as dt, 1 as id, 'a1' as name, 10 as\n             | price\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName3, tableType, this.tmp$2.getCanonicalPath(), tableName3})))).stripMargin());
                                this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().checkAnswer(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select id, name, price, cast(dt as string) from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName3})), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-05-06 00:00:00"}))}));
                                String tableName4 = this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().generateTableName();
                                this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             | create table ", " using hudi\n             | partitioned by (dt)\n             | tblproperties(\n             |    primaryKey = 'id',\n             |    type = '", "'\n             | )\n             | location '", "/", "'\n             | AS\n             | select cast('2021-05-06' as date) as dt, 1 as id, 'a1' as name, 10 as\n             | price\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName4, tableType, this.tmp$2.getCanonicalPath(), tableName4})))).stripMargin());
                                this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().checkAnswer(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select id, name, price, cast(dt as string) from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName4})), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-05-06"}))}));
                            }

                            public /* synthetic */ $anonfun$4$$anonfun$apply$mcV$sp$4 org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.tmp$2 = tmp$2;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$4 org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TestCreateTable org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 285));
        this.test("Test Create ro/rt Table In The Right Way", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestCreateTable $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempDir((Function1<File, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;

                    public final void apply(File tmp) {
                        String parentPath = tmp.getCanonicalPath();
                        String tableName1 = this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().generateTableName();
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |create table ", " (\n           |  id int,\n           |  name string,\n           |  ts long\n           |) using hudi\n           | tblproperties (\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts',\n           |  type = 'mor'\n           | )\n           | location '", "/", "'\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName1, parentPath, tableName1})))).stripMargin());
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"insert into ", " values (1, 'a1', 1000)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName1})));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"insert into ", " values (1, 'a2', 1100)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName1})));
                        String roTableName1 = new StringBuilder().append((Object)tableName1).append((Object)"_ro").toString();
                        String rtTableName1 = new StringBuilder().append((Object)tableName1).append((Object)"_rt").toString();
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |create table ", "\n           |using hudi\n           |tblproperties (\n           | 'hoodie.query.as.ro.table' = 'true'\n           |)\n           |location '", "/", "'\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{roTableName1, parentPath, tableName1})))).stripMargin());
                        CatalogTable roCatalogTable = this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(roTableName1));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertResult(roCatalogTable.properties().apply((Object)"type"), "mor", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 419));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertResult(roCatalogTable.properties().apply((Object)"primaryKey"), "id", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 420));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertResult(roCatalogTable.properties().apply((Object)"preCombineField"), "ts", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 421));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertResult(roCatalogTable.storage().properties().apply((Object)"hoodie.query.as.ro.table"), "true", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 422));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().checkAnswer(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select id, name, ts from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{roTableName1})), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)1000)}))}));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |create table ", "\n           |using hudi\n           |tblproperties (\n           | 'hoodie.query.as.ro.table' = 'false'\n           |)\n           |location '", "/", "'\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rtTableName1, parentPath, tableName1})))).stripMargin());
                        CatalogTable rtCatalogTable = this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(rtTableName1));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertResult(rtCatalogTable.properties().apply((Object)"type"), "mor", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 438));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertResult(rtCatalogTable.properties().apply((Object)"primaryKey"), "id", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 439));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertResult(rtCatalogTable.properties().apply((Object)"preCombineField"), "ts", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 440));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertResult(rtCatalogTable.storage().properties().apply((Object)"hoodie.query.as.ro.table"), "false", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 441));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().checkAnswer(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select id, name, ts from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rtTableName1})), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a2", BoxesRunTime.boxToInteger((int)1100)}))}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TestCreateTable org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 384));
        this.test("Test Create ro/rt Table In The Wrong Way", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestCreateTable $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempDir((Function1<File, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;

                    public final void apply(File tmp) {
                        String parentPath = tmp.getCanonicalPath();
                        String tableName1 = this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().generateTableName();
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |create table ", " (\n           |  id int,\n           |  name string,\n           |  ts long\n           |) using hudi\n           | tblproperties (\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts',\n           |  type = 'cow'\n           | )\n           | location '", "/", "'\n     "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName1, parentPath, tableName1})))).stripMargin());
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"insert into ", " values (1, 'a1', 1000)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName1})));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"insert into ", " values (1, 'a2', 1100)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName1})));
                        String roTableName1 = new StringBuilder().append((Object)tableName1).append((Object)"_ro").toString();
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().checkExceptionContain(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |create table ", "\n           |using hudi\n           |tblproperties (\n           | 'hoodie.query.as.ro.table' = 'true'\n           |)\n           |location '", "/", "'\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{roTableName1, parentPath, tableName1})))).stripMargin(), "Creating ro/rt table should only apply to a mor table.");
                        String tableName2 = this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().generateTableName();
                        String rtTableName2 = new StringBuilder().append((Object)tableName2).append((Object)"_rt").toString();
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().checkExceptionContain(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |create table ", "\n           |using hudi\n           |tblproperties (\n           | 'hoodie.query.as.ro.table' = 'true'\n           |)\n           |location '", "/", "'\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rtTableName2, parentPath, tableName2})))).stripMargin(), "Creating ro/rt table need the existence of the base table.");
                        String tableName3 = this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().generateTableName();
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().checkExceptionContain(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           | create table ", " using hudi\n           | tblproperties(\n           |    primaryKey = 'id',\n           |    preCombineField = 'ts',\n           |    type = 'mor',\n           |    'hoodie.query.as.ro.table' = 'true'\n           | )\n           | location '", "/", "'\n           | AS\n           | select 1 as id, 'a1' as name, 1000 as ts\n           | "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName3, parentPath, tableName3})))).stripMargin(), "Not support CTAS for the ro/rt table");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TestCreateTable org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 448));
        this.test("Test Create Table As Select With Tblproperties For Filter Props", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestCreateTable $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    public final void apply(String tableType) {
                        String tableName = this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().generateTableName();
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           | create table ", " using hudi\n           | partitioned by (dt)\n           | tblproperties(\n           |    hoodie.database.name = \"databaseName\",\n           |    hoodie.table.name = \"tableName\",\n           |    primaryKey = 'id',\n           |    preCombineField = 'ts',\n           |    hoodie.datasource.write.operation = 'upsert',\n           |    type = '", "'\n           | )\n           | AS\n           | select 1 as id, 'a1' as name, 10 as price, '2021-04-01' as dt, 1000 as ts\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, tableType})))).stripMargin());
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().checkAnswer(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select id, name, price, dt from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-04-01"}))}));
                        CatalogTable table = this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName));
                        Assertions.assertFalse((boolean)table.properties().contains((Object)HoodieTableConfig.DATABASE_NAME.key()));
                        Assertions.assertFalse((boolean)table.properties().contains((Object)HoodieTableConfig.NAME.key()));
                        Assertions.assertFalse((boolean)table.properties().contains((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()));
                        String tablePath = (String)table.storage().properties().apply((Object)"path");
                        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(tablePath).setConf(this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sessionState().newHadoopConf()).build();
                        Map tableConfig = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)metaClient.getTableConfig().getProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertResult("default", tableConfig.apply((Object)HoodieTableConfig.DATABASE_NAME.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 549));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertResult(tableName, tableConfig.apply((Object)HoodieTableConfig.NAME.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 550));
                        Assertions.assertFalse((boolean)tableConfig.contains((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TestCreateTable org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 516));
        this.test("Test Create Table As Select With Options For Filter Props", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestCreateTable $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;

                    public final void apply(String tableType) {
                        String tableName = this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().generateTableName();
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           | create table ", " using hudi\n           | partitioned by (dt)\n           | options(\n           |    hoodie.database.name = \"databaseName\",\n           |    hoodie.table.name = \"tableName\",\n           |    primaryKey = 'id',\n           |    preCombineField = 'ts',\n           |    hoodie.datasource.write.operation = 'upsert',\n           |    type = '", "'\n           | )\n           | AS\n           | select 1 as id, 'a1' as name, 10 as price, '2021-04-01' as dt, 1000 as ts\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, tableType})))).stripMargin());
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().checkAnswer(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select id, name, price, dt from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-04-01"}))}));
                        CatalogTable table = this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName));
                        Assertions.assertFalse((boolean)table.properties().contains((Object)HoodieTableConfig.DATABASE_NAME.key()));
                        Assertions.assertFalse((boolean)table.properties().contains((Object)HoodieTableConfig.NAME.key()));
                        Assertions.assertFalse((boolean)table.properties().contains((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()));
                        String tablePath = (String)table.storage().properties().apply((Object)"path");
                        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(tablePath).setConf(this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sessionState().newHadoopConf()).build();
                        Map tableConfig = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)metaClient.getTableConfig().getProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertResult("default", tableConfig.apply((Object)HoodieTableConfig.DATABASE_NAME.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 588));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertResult(tableName, tableConfig.apply((Object)HoodieTableConfig.NAME.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 589));
                        Assertions.assertFalse((boolean)tableConfig.contains((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TestCreateTable org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 555));
        this.test("Test Create Table As Select when 'spark.sql.datetime.java8API.enabled' enables", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestCreateTable $outer;

            public final Object apply() {
                try {
                    this.$outer.spark().conf().set("spark.sql.datetime.java8API.enabled", true);
                    String tableName = this.$outer.generateTableName();
                    this.$outer.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |create table ", "\n           |using hudi\n           |partitioned by(dt)\n           |options(type = 'cow', primaryKey = 'id')\n           |as\n           |select 1 as id, 'a1' as name, 10 as price, cast('2021-05-07 00:00:00' as timestamp) as dt\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})))).stripMargin());
                    this.$outer.checkAnswer(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select id, name, price, cast(dt as string) from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-05-07 00:00:00"}))}));
                    return BoxedUnit.UNIT;
                }
                finally {
                    this.$outer.spark().conf().set("spark.sql.datetime.java8API.enabled", false);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 594));
        this.test("Test Create Table From Existing Hoodie Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestCreateTable $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempDir((Function1<File, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;

                    public final void apply(File tmp) {
                        String databaseName = "hudi_database";
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"create database if not exists ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{databaseName})));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"use ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{databaseName})));
                        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2021-08-02", "2021/08/02"}))).foreach((Function1)new Serializable(this, tmp){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$9$$anonfun$apply$mcV$sp$9 $outer;
                            private final File tmp$3;

                            public final void apply(String partitionValue) {
                                String tableName = this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().generateTableName();
                                String tablePath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tmp$3.getCanonicalPath(), tableName}));
                                JavaUniverse $u = package$.MODULE$.universe();
                                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestCreateTable.class.getClassLoader());
                                public final class Org_apache_spark_sql_hudi_TestCreateTable$$anonfun$9$$anonfun$apply$mcV$sp$9$$anonfun$apply$9$$typecreator5$1
                                extends TypeCreator {
                                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                                        Universe $u = $m$untyped.universe();
                                        Mirror<U> $m = $m$untyped;
                                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor()})));
                                    }

                                    public Org_apache_spark_sql_hudi_TestCreateTable$$anonfun$9$$anonfun$apply$mcV$sp$9$$anonfun$apply$9$$typecreator5$1($anonfun$9$$anonfun$apply$mcV$sp$9$$anonfun$apply$9 $outer) {
                                    }
                                }
                                Dataset df = this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)1000), (Object)partitionValue)})), this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hudi_TestCreateTable$$anonfun$9$$anonfun$apply$mcV$sp$9$$anonfun$apply$9$$typecreator5$1(this)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts", "dt"}));
                                df.write().format("hudi").option(HoodieWriteConfig.TBL_NAME.key(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"original_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "id").option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "ts").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "dt").option(DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key(), SimpleKeyGenerator.class.getName()).option(HoodieWriteConfig.INSERT_PARALLELISM_VALUE.key(), "1").option(HoodieWriteConfig.UPSERT_PARALLELISM_VALUE.key(), "1").mode(SaveMode.Overwrite).save(tablePath);
                                this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().checkExceptionContain(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |create table ", " using hudi\n             |partitioned by (dt)\n             |location '", "'\n             |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, tablePath})))).stripMargin(), "It is not allowed to specify partition columns when the table schema is not defined.");
                                this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |create table ", " using hudi\n             |location '", "'\n             |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, tablePath})))).stripMargin());
                                this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().checkAnswer(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select id, name, value, ts, dt from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), partitionValue}))}));
                                HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(tablePath).setConf(this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sessionState().newHadoopConf()).build();
                                Map properties = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)metaClient.getTableConfig().getProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
                                this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)properties.contains((Object)HoodieTableConfig.CREATE_SCHEMA.key())), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 669));
                                this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertResult("dt", properties.apply((Object)HoodieTableConfig.PARTITION_FIELDS.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 670));
                                this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertResult("ts", properties.apply((Object)HoodieTableConfig.PRECOMBINE_FIELD.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 671));
                                this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertResult("hudi_database", metaClient.getTableConfig().getDatabaseName(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 672));
                                this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertResult(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"original_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), metaClient.getTableConfig().getTableName(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 673));
                                this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"insert into ", " values(2, 'a2', 10, 1000, '", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, partitionValue})));
                                this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().checkAnswer(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select _hoodie_record_key, _hoodie_partition_path, id, name, value, ts, dt from ", " order by id"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", partitionValue, BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), partitionValue})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", partitionValue, BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), partitionValue}))}));
                                this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |merge into ", " h0\n             |using (select 1 as id, 'a1' as name, 11 as value, 1001 as ts, '", "' as dt) s0\n             |on h0.id = s0.id\n             |when matched then update set *\n             |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, partitionValue})))).stripMargin());
                                this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().checkAnswer(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select _hoodie_record_key, _hoodie_partition_path, id, name, value, ts, dt from ", " order by id"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", partitionValue, BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1001), partitionValue})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", partitionValue, BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), partitionValue}))}));
                                this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"update ", " set value = value + 1 where id = 2"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().checkAnswer(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select _hoodie_record_key, _hoodie_partition_path, id, name, value, ts, dt from ", " order by id"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", partitionValue, BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1001), partitionValue})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", partitionValue, BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1000), partitionValue}))}));
                                this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"delete from ", " where id = 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().checkAnswer(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select _hoodie_record_key, _hoodie_partition_path, id, name, value, ts, dt from ", " order by id"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", partitionValue, BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1000), partitionValue}))}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.tmp$3 = tmp$3;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$9 org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TestCreateTable org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 621));
        this.test("Test Create Table From Existing Hoodie Table For Multi-Level Partitioned Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestCreateTable $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempDir((Function1<File, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$10 $outer;

                    public final void apply(File tmp) {
                        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2021-08-02", "2021/08/02"}))).foreach((Function1)new Serializable(this, tmp){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$10$$anonfun$apply$mcV$sp$10 $outer;
                            private final File tmp$4;

                            public final void apply(String day) {
                                String tableName = this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().generateTableName();
                                String tablePath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tmp$4.getCanonicalPath(), tableName}));
                                JavaUniverse $u = package$.MODULE$.universe();
                                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestCreateTable.class.getClassLoader());
                                public final class Org_apache_spark_sql_hudi_TestCreateTable$$anonfun$10$$anonfun$apply$mcV$sp$10$$anonfun$apply$10$$typecreator13$1
                                extends TypeCreator {
                                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                                        Universe $u = $m$untyped.universe();
                                        Mirror<U> $m = $m$untyped;
                                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple6"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor()})));
                                    }

                                    public Org_apache_spark_sql_hudi_TestCreateTable$$anonfun$10$$anonfun$apply$mcV$sp$10$$anonfun$apply$10$$typecreator13$1($anonfun$10$$anonfun$apply$mcV$sp$10$$anonfun$apply$10 $outer) {
                                    }
                                }
                                Dataset df = this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple6[]{new Tuple6((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)1000), (Object)day, (Object)BoxesRunTime.boxToInteger((int)12))})), this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hudi_TestCreateTable$$anonfun$10$$anonfun$apply$mcV$sp$10$$anonfun$apply$10$$typecreator13$1(this)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts", "day", "hh"}));
                                df.write().format("hudi").option(HoodieWriteConfig.TBL_NAME.key(), tableName).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "id").option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "ts").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "day,hh").option(DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key(), ComplexKeyGenerator.class.getName()).option(HoodieWriteConfig.INSERT_PARALLELISM_VALUE.key(), "1").option(HoodieWriteConfig.UPSERT_PARALLELISM_VALUE.key(), "1").mode(SaveMode.Overwrite).save(tablePath);
                                this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |create table ", " using hudi\n             |location '", "'\n             |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, tablePath})))).stripMargin());
                                this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().checkAnswer(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select id, name, value, ts, day, hh from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), day, BoxesRunTime.boxToInteger((int)12)}))}));
                                HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(tablePath).setConf(this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sessionState().newHadoopConf()).build();
                                Map properties = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)metaClient.getTableConfig().getProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
                                this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)properties.contains((Object)HoodieTableConfig.CREATE_SCHEMA.key())), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 743));
                                this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertResult("day,hh", properties.apply((Object)HoodieTableConfig.PARTITION_FIELDS.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 744));
                                this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertResult("ts", properties.apply((Object)HoodieTableConfig.PRECOMBINE_FIELD.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 745));
                                this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"insert into ", " values(2, 'a2', 10, 1000, '", "', 12)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, day})));
                                this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().checkAnswer(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select _hoodie_record_key, _hoodie_partition_path, id, name, value, ts, day, hh from ", " order by id"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"id:1", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/12"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{day})), BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), day, BoxesRunTime.boxToInteger((int)12)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"id:2", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/12"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{day})), BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), day, BoxesRunTime.boxToInteger((int)12)}))}));
                                this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |merge into ", " h0\n             |using (select 1 as id, 'a1' as name, 11 as value, 1001 as ts, '", "' as day, 12 as hh) s0\n             |on h0.id = s0.id\n             |when matched then update set *\n             |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, day})))).stripMargin());
                                this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().checkAnswer(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select _hoodie_record_key, _hoodie_partition_path, id, name, value, ts, day, hh from ", " order by id"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"id:1", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/12"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{day})), BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1001), day, BoxesRunTime.boxToInteger((int)12)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"id:2", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/12"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{day})), BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), day, BoxesRunTime.boxToInteger((int)12)}))}));
                                this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"update ", " set value = value + 1 where id = 2"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().checkAnswer(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select _hoodie_record_key, _hoodie_partition_path, id, name, value, ts, day, hh from ", " order by id"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"id:1", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/12"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{day})), BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1001), day, BoxesRunTime.boxToInteger((int)12)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"id:2", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/12"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{day})), BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1000), day, BoxesRunTime.boxToInteger((int)12)}))}));
                                this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"delete from ", " where id = 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().checkAnswer(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select _hoodie_record_key, _hoodie_partition_path, id, name, value, ts, day, hh from ", " order by id"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"id:2", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/12"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{day})), BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1000), day, BoxesRunTime.boxToInteger((int)12)}))}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.tmp$4 = tmp$4;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$10 org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TestCreateTable org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 708));
        this.test("Test Create Table From Existing Hoodie Table For None Partitioned Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestCreateTable $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempDir((Function1<File, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$11 $outer;

                    public final void apply(File tmp) {
                        String tableName = this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().generateTableName();
                        JavaUniverse $u = package$.MODULE$.universe();
                        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestCreateTable.class.getClassLoader());
                        public final class Org_apache_spark_sql_hudi_TestCreateTable$$anonfun$11$$anonfun$apply$mcV$sp$11$$typecreator21$1
                        extends TypeCreator {
                            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                                Universe $u = $m$untyped.universe();
                                Mirror<U> $m = $m$untyped;
                                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor()})));
                            }

                            public Org_apache_spark_sql_hudi_TestCreateTable$$anonfun$11$$anonfun$apply$mcV$sp$11$$typecreator21$1($anonfun$11$$anonfun$apply$mcV$sp$11 $outer) {
                            }
                        }
                        Dataset df = this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)1000))})), this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hudi_TestCreateTable$$anonfun$11$$anonfun$apply$mcV$sp$11$$typecreator21$1(this)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts"}));
                        df.write().format("hudi").option(HoodieWriteConfig.TBL_NAME.key(), tableName).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "id").option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "ts").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "").option(DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key(), NonpartitionedKeyGenerator.class.getName()).option(HoodieWriteConfig.INSERT_PARALLELISM_VALUE.key(), "1").option(HoodieWriteConfig.UPSERT_PARALLELISM_VALUE.key(), "1").mode(SaveMode.Overwrite).save(tmp.getCanonicalPath());
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |create table ", " using hudi\n           |location '", "'\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, tmp.getCanonicalPath()})))).stripMargin());
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().checkAnswer(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select id, name, value, ts from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000)}))}));
                        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(tmp.getCanonicalPath()).setConf(this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sessionState().newHadoopConf()).build();
                        Map properties = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)metaClient.getTableConfig().getProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)properties.contains((Object)HoodieTableConfig.CREATE_SCHEMA.key())), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 813));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().assertResult("ts", properties.apply((Object)HoodieTableConfig.PRECOMBINE_FIELD.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 814));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"insert into ", " values(2, 'a2', 10, 1000)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().checkAnswer(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select _hoodie_record_key, _hoodie_partition_path, id, name, value, ts from ", " order by id"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", "", BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", "", BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000)}))}));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |merge into ", " h0\n           |using (select 1 as id, 'a1' as name, 11 as value, 1001 as ts) s0\n           |on h0.id = s0.id\n           |when matched then update set *\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})))).stripMargin());
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().checkAnswer(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select id, name, value, ts from ", " order by id"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1001)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000)}))}));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"update ", " set value = value + 1 where id = 2"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().checkAnswer(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select id, name, value, ts from ", " order by id"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1001)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1000)}))}));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"delete from ", " where id = 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                        this.$outer.org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer().checkAnswer(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select id, name, value, ts from ", " order by id"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1000)}))}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TestCreateTable org$apache$spark$sql$hudi$TestCreateTable$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 780));
        this.test("Test Create Table Existing In Catalog", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestCreateTable $outer;

            public final Dataset<Row> apply() {
                String tableName = this.$outer.generateTableName();
                this.$outer.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |create table ", " (\n         | id int,\n         | name string,\n         | price double\n         |) using hudi\n         |tblproperties(primaryKey = 'id')\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})))).stripMargin());
                this.$outer.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " add columns(ts bigint)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                return this.$outer.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |create table if not exists ", " (\n         | id int,\n         | name string,\n         | price double\n         |) using hudi\n         |tblproperties(primaryKey = 'id')\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})))).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 848));
        if (HoodieSparkUtils$.MODULE$.gteqSpark3_2()) {
            this.test("Test create table with comment", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TestCreateTable $outer;

                public final Assertion apply() {
                    String tableName = this.$outer.generateTableName();
                    this.$outer.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           | create table ", " (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           | ) using hudi\n           | comment \"This is a simple hudi table\"\n           | tblproperties (\n           |   primaryKey = 'id',\n           |   preCombineField = 'ts'\n           | )\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})))).stripMargin());
                    String shown = ((Row)this.$outer.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"show create table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).head()).getString(0);
                    return this.$outer.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)shown.contains("COMMENT 'This is a simple hudi table'")), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 894));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 877));
        }
        this.test("Test CTAS using an illegal definition -- a COW table with compaction enabled.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestCreateTable $outer;

            public final Assertion apply() {
                String tableName = this.$outer.generateTableName();
                this.$outer.checkExceptionContain(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | create table ", " using hudi\n         | tblproperties(\n         |    primaryKey = 'id',\n         |    type = 'cow',\n         |    hoodie.compact.inline='true'\n         | )\n         | AS\n         | select 1 as id, 'a1' as name, 10 as price, 1000 as ts\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})))).stripMargin(), "Compaction is not supported on a CopyOnWrite table");
                String dbPath = this.$outer.spark().sessionState().catalog().getDatabaseMetadata("default").locationUri().getPath();
                String tablePath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dbPath, tableName}));
                return this.$outer.assertResult(BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToBoolean((boolean)this.$outer.existsPath(tablePath)), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 913));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 898));
        this.test("Test Create Non-Hudi Table(Parquet Table)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestCreateTable $outer;

            public final Dataset<Row> apply() {
                String databaseName = "test_database";
                this.$outer.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"create database if not exists ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{databaseName})));
                this.$outer.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"use ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{databaseName})));
                String tableName = this.$outer.generateTableName();
                this.$outer.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | create table ", " (\n         |  id int,\n         |  name string,\n         |  price double,\n         |  ts long\n         | ) using parquet\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})))).stripMargin());
                CatalogTable table = this.$outer.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName));
                this.$outer.assertResult(tableName, table.identifier().table(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 933));
                this.$outer.assertResult("parquet", table.provider().get(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 934));
                this.$outer.assertResult(CatalogTableType$.MODULE$.MANAGED(), table.tableType(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 935));
                this.$outer.assertResult(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("id", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("name", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("price", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("ts", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})), table.schema().fields(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 942));
                return this.$outer.spark().sql("use default");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 916));
        this.test("Test Infer KegGenClazz", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestCreateTable $outer;

            public final Dataset<Row> apply() {
                String tableName = this.$outer.generateTableName();
                this.$outer.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | create table ", " (\n         |  id int,\n         |  name string,\n         |  price double,\n         |  ts long\n         | ) using hudi\n         | comment \"This is a simple hudi table\"\n         | tblproperties (\n         |   primaryKey = 'id',\n         |   preCombineField = 'ts'\n         | )\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})))).stripMargin());
                this.checkKeyGenerator$1("org.apache.hudi.keygen.NonpartitionedKeyGenerator", tableName);
                this.$outer.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                this.$outer.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | create table ", " (\n         |  id int,\n         |  name string,\n         |  price double,\n         |  ts long\n         | ) using hudi\n         | comment \"This is a simple hudi table\"\n         | partitioned by (ts)\n         | tblproperties (\n         |   primaryKey = 'id',\n         |   preCombineField = 'ts'\n         | )\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})))).stripMargin());
                this.checkKeyGenerator$1("org.apache.hudi.keygen.SimpleKeyGenerator", tableName);
                this.$outer.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                this.$outer.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | create table ", " (\n         |  id int,\n         |  name string,\n         |  price double,\n         |  ts long\n         | ) using hudi\n         | comment \"This is a simple hudi table\"\n         | partitioned by (ts)\n         | tblproperties (\n         |   primaryKey = 'id,name',\n         |   preCombineField = 'ts'\n         | )\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})))).stripMargin());
                this.checkKeyGenerator$1("org.apache.hudi.keygen.ComplexKeyGenerator", tableName);
                return this.$outer.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
            }

            private final Assertion checkKeyGenerator$1(String targetGenerator, String tableName) {
                String tablePath = this.$outer.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName)).location().getPath();
                HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(tablePath).setConf(this.$outer.spark().sessionState().newHadoopConf()).build();
                String realKeyGenerator = (String)((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)metaClient.getTableConfig().getProps()).asScala()).toMap(Predef$.MODULE$.$conforms()).get((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key()).get();
                return this.$outer.assertResult(targetGenerator, realKeyGenerator, Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 956));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 947));
    }
}

