/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.hudi.HoodieSparkSqlTestBase;
import org.apache.spark.sql.hudi.TestDropTable$;
import org.apache.spark.sql.hudi.TestDropTable$$anonfun$1$;
import org.apache.spark.sql.hudi.TestDropTable$$anonfun$2$;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001m2A!\u0001\u0002\u0001\u001b\tiA+Z:u\tJ|\u0007\u000fV1cY\u0016T!a\u0001\u0003\u0002\t!,H-\u001b\u0006\u0003\u000b\u0019\t1a]9m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0003\u00019\u0001\"a\u0004\t\u000e\u0003\tI!!\u0005\u0002\u0003-!{w\u000eZ5f'B\f'o[*rYR+7\u000f\u001e\"bg\u0016DQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005=\u0001\u0001\"B\f\u0001\t\u0013A\u0012\u0001F1mi\u0016\u00148+\u001a:eKB\u0013x\u000e]3si&,7\u000f\u0006\u0003\u001a?%z\u0003C\u0001\u000e\u001e\u001b\u0005Y\"\"\u0001\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yY\"\u0001B+oSRDQ\u0001\t\fA\u0002\u0005\nab]3tg&|gnQ1uC2|w\r\u0005\u0002#O5\t1E\u0003\u0002%K\u000591-\u0019;bY><'B\u0001\u0014\u0005\u0003!\u0019\u0017\r^1msN$\u0018B\u0001\u0015$\u00059\u0019Vm]:j_:\u001c\u0015\r^1m_\u001eDQA\u000b\fA\u0002-\n\u0001\u0002^1cY\u0016LE\r\u001e\t\u0003Y5j\u0011!J\u0005\u0003]\u0015\u0012q\u0002V1cY\u0016LE-\u001a8uS\u001aLWM\u001d\u0005\u0006aY\u0001\r!M\u0001\u000e]\u0016<\bK]8qKJ$\u0018.Z:\u0011\tI*\u0004\b\u000f\b\u00035MJ!\u0001N\u000e\u0002\rA\u0013X\rZ3g\u0013\t1tGA\u0002NCBT!\u0001N\u000e\u0011\u0005IJ\u0014B\u0001\u001e8\u0005\u0019\u0019FO]5oO\u0002")
public class TestDropTable
extends HoodieSparkSqlTestBase {
    public void org$apache$spark$sql$hudi$TestDropTable$$alterSerdeProperties(SessionCatalog sessionCatalog, TableIdentifier tableIdt, Map<String, String> newProperties) {
        Map storageProperties;
        CatalogTable catalogTable = this.spark().sessionState().catalog().getTableMetadata(tableIdt);
        CatalogStorageFormat storage = catalogTable.storage();
        Map x$1 = storageProperties = storage.properties().$plus$plus(newProperties);
        Option x$2 = storage.copy$default$1();
        Option x$3 = storage.copy$default$2();
        Option x$4 = storage.copy$default$3();
        Option x$5 = storage.copy$default$4();
        boolean x$6 = storage.copy$default$5();
        CatalogStorageFormat x$7 = storage.copy(x$2, x$3, x$4, x$5, x$6, x$1);
        TableIdentifier x$8 = catalogTable.copy$default$1();
        CatalogTableType x$9 = catalogTable.copy$default$2();
        StructType x$10 = catalogTable.copy$default$4();
        Option x$11 = catalogTable.copy$default$5();
        Seq x$12 = catalogTable.copy$default$6();
        Option x$13 = catalogTable.copy$default$7();
        String x$14 = catalogTable.copy$default$8();
        long x$15 = catalogTable.copy$default$9();
        long x$16 = catalogTable.copy$default$10();
        String x$17 = catalogTable.copy$default$11();
        Map x$18 = catalogTable.copy$default$12();
        Option x$19 = catalogTable.copy$default$13();
        Option x$20 = catalogTable.copy$default$14();
        Option x$21 = catalogTable.copy$default$15();
        Seq x$22 = catalogTable.copy$default$16();
        boolean x$23 = catalogTable.copy$default$17();
        boolean x$24 = catalogTable.copy$default$18();
        Map x$25 = catalogTable.copy$default$19();
        CatalogTable newCatalogTable = catalogTable.copy(x$8, x$9, x$7, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25);
        sessionCatalog.alterTable(newCatalogTable);
    }

    public TestDropTable() {
        this.test("Test Drop Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDropTable $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempDir((Function1<File, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    public final void apply(File tmp) {
                        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1)new Serializable(this, tmp){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$1$$anonfun$apply$mcV$sp$1 $outer;
                            private final File tmp$1;

                            public final Assertion apply(String tableType) {
                                String tableName = this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().generateTableName();
                                this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |create table ", " (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | location '", "/", "'\n             | tblproperties (\n             |  type = '", "',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, this.tmp$1.getCanonicalPath(), tableName, tableType})))).stripMargin());
                                this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP TABLE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().checkAnswer(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"show tables like '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), (Seq<Seq<Object>>)Nil$.MODULE$);
                                return this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().existsPath(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tmp$1.getCanonicalPath(), tableName})))), Prettifier$.MODULE$.default(), new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.tmp$1 = tmp$1;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$1 org$apache$spark$sql$hudi$TestDropTable$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TestDropTable org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 27));
        this.test("Test Drop Table with purge", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDropTable $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempDir((Function1<File, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    public final void apply(File tmp) {
                        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1)new Serializable(this, tmp){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$2$$anonfun$apply$mcV$sp$2 $outer;
                            private final File tmp$2;

                            public final Assertion apply(String tableType) {
                                String tableName = this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().generateTableName();
                                this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |create table ", " (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | location '", "/", "'\n             | tblproperties (\n             |  type = '", "',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, this.tmp$2.getCanonicalPath(), tableName, tableType})))).stripMargin());
                                this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP TABLE ", " PURGE"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().checkAnswer(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"show tables like '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), (Seq<Seq<Object>>)Nil$.MODULE$);
                                return this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().assertResult(BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToBoolean((boolean)this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().existsPath(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tmp$2.getCanonicalPath(), tableName})))), Prettifier$.MODULE$.default(), new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.tmp$2 = tmp$2;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$2 org$apache$spark$sql$hudi$TestDropTable$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TestDropTable org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        this.test("Test Drop RO & RT table by purging base table.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDropTable $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempDir((Function1<File, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final void apply(File tmp) {
                        String tableName = this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().generateTableName();
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |create table ", " (\n           |  id int,\n           |  name string,\n           |  ts long\n           |) using hudi\n           | location '", "/", "'\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, tmp.getCanonicalPath(), tableName})))).stripMargin());
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |create table ", "_ro using hudi\n           | location '", "/", "'\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, tmp.getCanonicalPath(), tableName})))).stripMargin());
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().org$apache$spark$sql$hudi$TestDropTable$$alterSerdeProperties(this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().spark().sessionState().catalog(), TableIdentifier$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_ro"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.query.as.ro.table"), (Object)"true")}))));
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |create table ", "_rt using hudi\n           | location '", "/", "'\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, tmp.getCanonicalPath(), tableName})))).stripMargin());
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().org$apache$spark$sql$hudi$TestDropTable$$alterSerdeProperties(this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().spark().sessionState().catalog(), TableIdentifier$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_rt"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.query.as.ro.table"), (Object)"false")}))));
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop table ", " purge"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().checkAnswer("show tables", (Seq<Seq<Object>>)Nil$.MODULE$);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TestDropTable org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        this.test("Test Drop RO & RT table by one by one.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDropTable $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempDir((Function1<File, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;

                    public final void apply(File tmp) {
                        String tableName = this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().generateTableName();
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |create table ", " (\n           |  id int,\n           |  name string,\n           |  ts long\n           |) using hudi\n           | location '", "/", "'\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, tmp.getCanonicalPath(), tableName})))).stripMargin());
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |create table ", "_ro using hudi\n           | location '", "/", "'\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, tmp.getCanonicalPath(), tableName})))).stripMargin());
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().org$apache$spark$sql$hudi$TestDropTable$$alterSerdeProperties(this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().spark().sessionState().catalog(), TableIdentifier$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_ro"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.query.as.ro.table"), (Object)"true")}))));
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |create table ", "_rt using hudi\n           | location '", "/", "'\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, tmp.getCanonicalPath(), tableName})))).stripMargin());
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().org$apache$spark$sql$hudi$TestDropTable$$alterSerdeProperties(this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().spark().sessionState().catalog(), TableIdentifier$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_rt"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.query.as.ro.table"), (Object)"false")}))));
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop table ", "_ro"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().checkAnswer("show tables", (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"default", tableName, BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"default", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_rt"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), BoxesRunTime.boxToBoolean((boolean)false)}))}));
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop table ", "_rt"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().checkAnswer("show tables", (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"default", tableName, BoxesRunTime.boxToBoolean((boolean)false)}))}));
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().checkAnswer("show tables", (Seq<Seq<Object>>)Nil$.MODULE$);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TestDropTable org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        this.test("Test Drop RO table with purge", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDropTable $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempDir((Function1<File, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;

                    public final void apply(File tmp) {
                        String tableName = this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().generateTableName();
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |create table ", " (\n           |  id int,\n           |  name string,\n           |  ts long\n           |) using hudi\n           | location '", "/", "'\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, tmp.getCanonicalPath(), tableName})))).stripMargin());
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |create table ", "_ro using hudi\n           | location '", "/", "'\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, tmp.getCanonicalPath(), tableName})))).stripMargin());
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().org$apache$spark$sql$hudi$TestDropTable$$alterSerdeProperties(this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().spark().sessionState().catalog(), TableIdentifier$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_ro"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.query.as.ro.table"), (Object)"true")}))));
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |create table ", "_rt using hudi\n           | location '", "/", "'\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, tmp.getCanonicalPath(), tableName})))).stripMargin());
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().org$apache$spark$sql$hudi$TestDropTable$$alterSerdeProperties(this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().spark().sessionState().catalog(), TableIdentifier$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_rt"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.query.as.ro.table"), (Object)"false")}))));
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop table ", "_ro purge"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().checkAnswer("show tables", (Seq<Seq<Object>>)Nil$.MODULE$);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TestDropTable org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
        this.test("Drop an EXTERNAL table which path is lost.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDropTable $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempDir((Function1<File, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;

                    public final void apply(File tmp) {
                        String tableName = this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().generateTableName();
                        String tablePath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tmp.getCanonicalPath(), tableName}));
                        FileSystem filesystem = FSUtils.getFs((String)tablePath, (Configuration)this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().spark().sparkContext().hadoopConfiguration());
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |create table ", " (\n           |id int,\n           |ts int,\n           |value string\n           |)using hudi\n           | location '", "'\n           | tblproperties (\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, tablePath})))).stripMargin());
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(filesystem.exists(new Path(tablePath)), "filesystem.exists(new org.apache.hadoop.fs.Path(tablePath))", Prettifier$.MODULE$.default());
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table path doesn't exists (", ")."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tablePath})), Prettifier$.MODULE$.default(), new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
                        filesystem.delete(new Path(tablePath), true);
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().checkAnswer("show tables", (Seq<Seq<Object>>)Nil$.MODULE$);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TestDropTable org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
        this.test("Drop an MOR table and related RT & RO when path is lost.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDropTable $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempDir((Function1<File, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    public final void apply(File tmp) {
                        String tableName = this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().generateTableName();
                        String tablePath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tmp.getCanonicalPath(), tableName}));
                        FileSystem filesystem = FSUtils.getFs((String)tablePath, (Configuration)this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().spark().sparkContext().hadoopConfiguration());
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |create table ", " (\n           |id int,\n           |ts int,\n           |value string\n           |)using hudi\n           | location '", "'\n           | tblproperties (\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts',\n           |  type = 'mor'\n           | )\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, tablePath})))).stripMargin());
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(filesystem.exists(new Path(tablePath)), "filesystem.exists(new org.apache.hadoop.fs.Path(tablePath))", Prettifier$.MODULE$.default());
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table path doesn't exist (", ")."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tablePath})), Prettifier$.MODULE$.default(), new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |create table ", "_ro using hudi\n           | location '", "/", "'\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, tmp.getCanonicalPath(), tableName})))).stripMargin());
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().org$apache$spark$sql$hudi$TestDropTable$$alterSerdeProperties(this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().spark().sessionState().catalog(), TableIdentifier$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_ro"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.query.as.ro.table"), (Object)"true")}))));
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |create table ", "_rt using hudi\n           | location '", "/", "'\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, tmp.getCanonicalPath(), tableName})))).stripMargin());
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().org$apache$spark$sql$hudi$TestDropTable$$alterSerdeProperties(this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().spark().sessionState().catalog(), TableIdentifier$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_rt"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.query.as.ro.table"), (Object)"false")}))));
                        filesystem.delete(new Path(tablePath), true);
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop table ", "_ro"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop table ", "_rt"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                        this.$outer.org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer().checkAnswer("show tables", (Seq<Seq<Object>>)Nil$.MODULE$);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TestDropTable org$apache$spark$sql$hudi$TestDropTable$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
        this.test("Drop an MANAGED table which path is lost.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDropTable $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String tableName = this.$outer.generateTableName();
                this.$outer.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |create table ", " (\n         |id int,\n         |ts int,\n         |value string\n         |)using hudi\n         | tblproperties (\n         |  primaryKey = 'id',\n         |  preCombineField = 'ts'\n         | )\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})))).stripMargin());
                Path tablePath = new Path(this.$outer.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName)).location());
                FileSystem filesystem = FSUtils.getFs((Path)tablePath, (Configuration)this.$outer.spark().sparkContext().hadoopConfiguration());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(filesystem.exists(tablePath), "filesystem.exists(tablePath)", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table path doesn't exists (", ")."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tablePath})), Prettifier$.MODULE$.default(), new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
                filesystem.delete(tablePath, true);
                this.$outer.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                this.$outer.checkAnswer("show tables", (Seq<Seq<Object>>)Nil$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 317));
        this.test("Drop local temporary view should not fail", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDropTable $outer;

            public final Dataset<Row> apply() {
                String viewName = this.$outer.generateTableName();
                this.$outer.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |create temporary view ", " as\n         | select 1\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{viewName})))).stripMargin());
                return this.$outer.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop view ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{viewName})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 343));
        this.test("Drop global temporary view should not fail", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestDropTable $outer;

            public final Dataset<Row> apply() {
                String viewName = this.$outer.generateTableName();
                this.$outer.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |create global temporary view ", " as\n         | select 1\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{viewName})))).stripMargin());
                return this.$outer.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop view global_temp.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{viewName})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 354));
    }
}

