/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi;

import java.io.File;
import java.math.BigDecimal;
import java.sql.Date;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.hudi.HoodieSparkSqlTestBase;
import org.apache.spark.sql.hudi.TestSpark3DDL$;
import org.apache.spark.sql.hudi.TestSpark3DDL$$anonfun$1$;
import org.apache.spark.sql.hudi.TestSpark3DDL$$anonfun$2$;
import org.apache.spark.sql.hudi.TestSpark3DDL$$anonfun$3$;
import org.apache.spark.sql.hudi.TestSpark3DDL$$anonfun$3$$anonfun$apply$mcV$sp$3$;
import org.apache.spark.sql.hudi.TestSpark3DDL$$anonfun$4$;
import org.apache.spark.sql.hudi.TestSpark3DDL$$anonfun$5$;
import org.apache.spark.sql.hudi.TestSpark3DDL$$anonfun$6$;
import org.apache.spark.sql.hudi.TestSpark3DDL$$anonfun$7$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

@ScalaSignature(bytes="\u0006\u0001m2A!\u0001\u0002\u0001\u001b\tiA+Z:u'B\f'o[\u001aE\t2S!a\u0001\u0003\u0002\t!,H-\u001b\u0006\u0003\u000b\u0019\t1a]9m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0003\u00019\u0001\"a\u0004\t\u000e\u0003\tI!!\u0005\u0002\u0003-!{w\u000eZ5f'B\f'o[*rYR+7\u000f\u001e\"bg\u0016DQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005=\u0001\u0001\"B\f\u0001\t\u0003A\u0012\u0001E2sK\u0006$X\rV3tiJ+7/\u001e7u)\tI2\u0005E\u0002\u001b;}i\u0011a\u0007\u0006\u00029\u0005)1oY1mC&\u0011ad\u0007\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003A\u0005j\u0011\u0001B\u0005\u0003E\u0011\u00111AU8x\u0011\u0015!c\u00031\u0001&\u0003%!\u0018M\u00197f\u001d\u0006lW\r\u0005\u0002'S9\u0011!dJ\u0005\u0003Qm\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0016,\u0005\u0019\u0019FO]5oO*\u0011\u0001f\u0007\u0005\u0006[\u0001!\tAL\u0001\u001fGJ,\u0017\r^3B]\u0012\u0004&/\u001a9be\u0016\u0004\u0016M\u001d;ji&|g\u000eV1cY\u0016$Ra\f\u001a7oe\u0002\"A\u0007\u0019\n\u0005EZ\"\u0001B+oSRDQa\u0002\u0017A\u0002M\u0002\"\u0001\t\u001b\n\u0005U\"!\u0001D*qCJ\\7+Z:tS>t\u0007\"\u0002\u0013-\u0001\u0004)\u0003\"\u0002\u001d-\u0001\u0004)\u0013!\u0003;bE2,\u0007+\u0019;i\u0011\u0015QD\u00061\u0001&\u0003%!\u0018M\u00197f)f\u0004X\r")
public class TestSpark3DDL
extends HoodieSparkSqlTestBase {
    public Row[] createTestResult(String tableName) {
        return (Row[])this.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select * from ", " order by id"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_hoodie_commit_time", "_hoodie_commit_seqno", "_hoodie_record_key", "_hoodie_partition_path", "_hoodie_file_name"})).collect();
    }

    public void createAndPreparePartitionTable(SparkSession spark, String tableName, String tablePath, String tableType) {
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |create table ", " (\n         |  id int, comb int, col0 int, col1 bigint, col2 float, col3 double, col4 decimal(10,4), col5 string, col6 date, col7 timestamp, col8 boolean, col9 binary, par date\n         |) using hudi\n         | location '", "'\n         | options (\n         |  type = '", "',\n         |  primaryKey = 'id',\n         |  preCombineField = 'comb'\n         | )\n         | partitioned by (par)\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, tablePath, tableType})))).stripMargin());
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | insert into ", " values\n         | (1,1,11,100001,101.01,1001.0001,100001.0001,'a000001',DATE'2021-12-25',TIMESTAMP'2021-12-25 12:01:01',true,X'a01',TIMESTAMP'2021-12-25'),\n         | (2,2,12,100002,102.02,1002.0002,100002.0002,'a000002',DATE'2021-12-25',TIMESTAMP'2021-12-25 12:02:02',true,X'a02',TIMESTAMP'2021-12-25'),\n         | (3,3,13,100003,103.03,1003.0003,100003.0003,'a000003',DATE'2021-12-25',TIMESTAMP'2021-12-25 12:03:03',false,X'a03',TIMESTAMP'2021-12-25'),\n         | (4,4,14,100004,104.04,1004.0004,100004.0004,'a000004',DATE'2021-12-26',TIMESTAMP'2021-12-26 12:04:04',true,X'a04',TIMESTAMP'2021-12-26'),\n         | (5,5,15,100005,105.05,1005.0005,100005.0005,'a000005',DATE'2021-12-26',TIMESTAMP'2021-12-26 12:05:05',false,X'a05',TIMESTAMP'2021-12-26')\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})))).stripMargin());
    }

    public TestSpark3DDL() {
        this.test("Test multi change data type", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestSpark3DDL $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempDir((Function1<File, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    public final void apply(File tmp) {
                        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1)new Serializable(this, tmp){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$1$$anonfun$apply$mcV$sp$1 $outer;
                            private final File tmp$1;

                            public final void apply(String tableType) {
                                String tableName = this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().generateTableName();
                                String tablePath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new Path(this.tmp$1.getCanonicalPath(), tableName).toUri().toString()}));
                                if (HoodieSparkUtils$.MODULE$.gteqSpark3_1()) {
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql("set hoodie.schema.on.read.enable=true");
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql("set spark.sql.storeAssignmentPolicy=legacy");
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().createAndPreparePartitionTable(this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark(), tableName, tablePath, tableType);
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " alter column col6 type String"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().checkAnswer((Row[])this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select col6 from ", " where id = 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2021-12-25"}))}));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               | insert into ", " values\n               | (1,1,13.0,100001,101.01,1001.0001,100001.0001,'a000001','2021-12-26','2021-12-25 12:01:01',true,'a01','2021-12-25')\n               |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})))).stripMargin());
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " alter column col6 type date"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().checkAnswer((Row[])this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select col6 from ", " where id = 1 or id = 5 order by id"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Date[]{Date.valueOf("2021-12-26")})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Date[]{Date.valueOf("2021-12-26")}))}));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " alter column col0 type double"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               | insert into ", " values\n               | (1,1,13.0,100001,101.01,1001.0001,100001.0001,'a000001','2021-12-25','2021-12-25 12:01:01',true,'a01','2021-12-25'),\n               | (6,1,14.0,100001,101.01,1001.0001,100001.0001,'a000001','2021-12-25','2021-12-25 12:01:01',true,'a01','2021-12-25')\n               |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})))).stripMargin());
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " alter column col0 type decimal(16, 4)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().checkAnswer((Row[])this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select col0 from ", " where id = 1 or id = 6 order by id"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BigDecimal[]{new BigDecimal("13.0000")})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BigDecimal[]{new BigDecimal("14.0000")}))}));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " alter column col2 type double"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               | insert into ", " values\n               | (1,1,13.0,100001,901.01,1001.0001,100001.0001,'a000001','2021-12-25','2021-12-25 12:01:01',true,'a01','2021-12-25'),\n               | (6,1,14.0,100001,601.01,1001.0001,100001.0001,'a000001','2021-12-25','2021-12-25 12:01:01',true,'a01','2021-12-25')\n               |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})))).stripMargin());
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " alter column col2 type decimal(16, 4)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().checkAnswer((Row[])this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select col0, col2 from ", " where id = 1 or id = 6 order by id"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BigDecimal[]{new BigDecimal("13.0000"), new BigDecimal("901.0100")})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BigDecimal[]{new BigDecimal("14.0000"), new BigDecimal("601.0100")}))}));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " alter column col1 type double"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               | insert into ", " values\n               | (1,1,13.0,700001.0,901.01,1001.0001,100001.0001,'a000001','2021-12-25','2021-12-25 12:01:01',true,'a01','2021-12-25')\n               |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})))).stripMargin());
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " alter column col1 type decimal(16, 4)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().checkAnswer((Row[])this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select col0, col2, col1 from ", " where id = 1 or id = 6 order by id"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BigDecimal[]{new BigDecimal("13.0000"), new BigDecimal("901.0100"), new BigDecimal("700001.0000")})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BigDecimal[]{new BigDecimal("14.0000"), new BigDecimal("601.0100"), new BigDecimal("100001.0000")}))}));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sessionState().catalog().dropTable(TableIdentifier$.MODULE$.apply(tableName), true, true);
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sessionState().catalog().refreshTable(TableIdentifier$.MODULE$.apply(tableName));
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.tmp$1 = tmp$1;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$1 org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TestSpark3DDL org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        this.test("Test multi change data type2", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestSpark3DDL $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempDir((Function1<File, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    public final void apply(File tmp) {
                        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1)new Serializable(this, tmp){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$2$$anonfun$apply$mcV$sp$2 $outer;
                            private final File tmp$2;

                            public final void apply(String tableType) {
                                String tableName = this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().generateTableName();
                                String tablePath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new Path(this.tmp$2.getCanonicalPath(), tableName).toUri().toString()}));
                                if (HoodieSparkUtils$.MODULE$.gteqSpark3_1()) {
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql("set hoodie.schema.on.read.enable=true");
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql("set spark.sql.storeAssignmentPolicy=legacy");
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().createAndPreparePartitionTable(this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark(), tableName, tablePath, tableType);
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " alter column col2 type double"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " alter column col2 type decimal(16, 4)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " alter column col2 type String"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().checkAnswer((Row[])this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select col2 from ", " where id = 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"101.01"}))}));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " alter column col1 type double"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " alter column col1 type decimal(16, 4)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " alter column col1 type String"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().checkAnswer((Row[])this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select col1 from ", " where id = 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"100001"}))}));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " alter column col0 type double"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " alter column col0 type decimal(16, 4)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " alter column col0 type String"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().checkAnswer((Row[])this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select col0 from ", " where id = 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"11"}))}));
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.tmp$2 = tmp$2;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$2 org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TestSpark3DDL org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
        this.test("Test Partition Table alter ", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestSpark3DDL $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempDir((Function1<File, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final void apply(File tmp) {
                        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1)new Serializable(this, tmp){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$3$$anonfun$apply$mcV$sp$3 $outer;
                            private final File tmp$3;

                            public final void apply(String tableType) {
                                String tableName = this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().generateTableName();
                                String tablePath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new Path(this.tmp$3.getCanonicalPath(), tableName).toUri().toString()}));
                                if (HoodieSparkUtils$.MODULE$.gteqSpark3_1()) {
                                    BoxedUnit boxedUnit;
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql("set hoodie.schema.on.read.enable=true");
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql("set spark.sql.storeAssignmentPolicy=legacy");
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().createAndPreparePartitionTable(this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark(), tableName, tablePath, tableType);
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " set tblproperties(comment='it is a hudi table', 'key1'='value1', 'key2'='value2')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    CatalogTable meta = this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName));
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((String)meta.comment().get()).equals("it is a hudi table"), "meta.comment.get.equals(\"it is a hudi table\")", Prettifier$.MODULE$.default());
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
                                    Seq $org_scalatest_assert_macro_left = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key1", "key2"}))).filter((Function1)new Serializable(this, meta){
                                        public static final long serialVersionUID = 0L;
                                        private final CatalogTable meta$1;

                                        public final boolean apply(String x$1) {
                                            return this.meta$1.properties().contains((Object)x$1);
                                        }
                                        {
                                            this.meta$1 = meta$1;
                                        }
                                    });
                                    int $org_scalatest_assert_macro_right = 2;
                                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " unset tblproperties(comment, 'key1', 'key2')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    CatalogTable unsetMeta = this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName));
                                    Seq $org_scalatest_assert_macro_left2 = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key1", "key2"}))).filter((Function1)new Serializable(this, unsetMeta){
                                        public static final long serialVersionUID = 0L;
                                        private final CatalogTable unsetMeta$1;

                                        public final boolean apply(String x$2) {
                                            return this.unsetMeta$1.properties().contains((Object)x$2);
                                        }
                                        {
                                            this.unsetMeta$1 = unsetMeta$1;
                                        }
                                    });
                                    int $org_scalatest_assert_macro_right2 = 0;
                                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
                                    Option $org_scalatest_assert_macro_left3 = unsetMeta.comment();
                                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().checkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Alter table ", " add columns(col_new1 int first)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), "forbid adjust top-level columns position by using through first syntax");
                                    ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(HoodieRecord.HOODIE_META_COLUMNS.subList(0, HoodieRecord.HOODIE_META_COLUMNS.size() - 2)).asScala()).foreach((Function1)new Serializable(this, tableName){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$3$$anonfun$apply$mcV$sp$3$$anonfun$apply$3 $outer;
                                        private final String tableName$1;

                                        public final void apply(String f) {
                                            this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().checkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Alter table ", " add columns(col_new1 int after ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName$1, f})), "forbid adjust the position of ordinary columns between meta columns");
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.tableName$1 = tableName$1;
                                        }
                                    });
                                    ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "comb", "par"}))).foreach((Function1)new Serializable(this, tableName){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$3$$anonfun$apply$mcV$sp$3$$anonfun$apply$3 $outer;
                                        private final String tableName$1;

                                        public final void apply(String col) {
                                            this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().checkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " drop column ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName$1, col})), "cannot support apply changes for primaryKey/CombineKey/partitionKey");
                                            this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().checkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " rename column ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName$1, col, new StringBuilder().append((Object)col).append((Object)col).toString()})), "cannot support apply changes for primaryKey/CombineKey/partitionKey");
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.tableName$1 = tableName$1;
                                        }
                                    });
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().checkExceptions(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " rename column col0 to col9"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cannot rename column: col0 to a existing name", "Cannot rename column, because col9 already exists in root"}))));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().checkExceptions(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " rename column col0 to COL9"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cannot rename column: col0 to a existing name", "Cannot rename column, because COL9 already exists in root"}))));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().checkExceptions(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " add columns(col9 int first)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cannot add column: col9 which already exist", "Cannot add column, because col9 already exists in root"}))));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().checkExceptions(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " add columns(COL9 int first)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cannot add column: COL9 which already exist", "Cannot add column, because COL9 already exists in root"}))));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " add columns(col1_new int comment 'add new columns col1_new after id' after id)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " alter column col9 comment 'col9 desc'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    StructType schema = this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName)).schema();
                                    String $org_scalatest_assert_macro_left4 = (String)((StructField)JavaConversions$.MODULE$.seqAsJavaList((Seq)schema.filter((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final boolean apply(StructField p) {
                                            return p.name().equals("col1_new");
                                        }
                                    })).get(0)).getComment().get();
                                    String $org_scalatest_assert_macro_right3 = "add new columns col1_new after id";
                                    String string = $org_scalatest_assert_macro_left4;
                                    String string2 = $org_scalatest_assert_macro_right3;
                                    Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
                                    String $org_scalatest_assert_macro_left5 = (String)((StructField)JavaConversions$.MODULE$.seqAsJavaList((Seq)schema.filter((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final boolean apply(StructField p) {
                                            return p.name().equals("col9");
                                        }
                                    })).get(0)).getComment().get();
                                    String $org_scalatest_assert_macro_right4 = "col9 desc";
                                    String string3 = $org_scalatest_assert_macro_left5;
                                    String string4 = $org_scalatest_assert_macro_right4;
                                    Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " alter column col2 type double"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select id, col1_new, col2 from ", " where id = 1 or id = 2 order by id"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).show(false);
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               | insert into ", " values\n               | (1,3,1,11,100001,101.01,1001.0001,100001.0001,'a000001','2021-12-25','2021-12-25 12:01:01',true,'a01','2021-12-25'),\n               | (6,6,5,15,100005,105.05,1005.0005,100005.0005,'a000005','2021-12-26','2021-12-26 12:05:05',false,'a05','2021-12-26')\n               |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})))).stripMargin());
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select id, col1_new, col2 from ", " where id = 1 or id = 6 or id = 2 order by id"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).show(false);
                                    String string5 = tableType;
                                    String string6 = "mor";
                                    Object object = !(string5 != null ? !string5.equals(string6) : string6 != null) ? this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"schedule compaction  on ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))) : BoxedUnit.UNIT;
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " alter column col4 type decimal(18, 8)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select id, col1_new, col2 from ", " where id = 1 or id = 2 order by id"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).show(false);
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               | insert into ", " values\n               | (5,6,5,15,100005,105.05,1005.0005,100005.0005,'a000005','2021-12-26','2021-12-26 12:05:05',false,'a05','2021-12-26')\n               |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})))).stripMargin());
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select id, col1_new, col4 from ", " where id = 1 or id = 6 or id = 2 order by id"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).show(false);
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " alter column col2 type string"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select id, col1_new, col2 from ", " where id = 1 or id = 2 order by id"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).show(false);
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               | insert into ", " values\n               | (1,3,1,11,100001,'101.01',1001.0001,100001.0001,'a000001','2021-12-25','2021-12-25 12:01:01',true,'a01','2021-12-25'),\n               | (6,6,5,15,100005,'105.05',1005.0005,100005.0005,'a000005','2021-12-26','2021-12-26 12:05:05',false,'a05','2021-12-26')\n               |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})))).stripMargin());
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select id, col1_new, col2 from ", " where id = 1 or id = 6 or id = 2 order by id"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).show(false);
                                    String string7 = tableType;
                                    String string8 = "mor";
                                    Object object2 = !(string7 != null ? !string7.equals(string8) : string8 != null) ? this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"schedule compaction  on ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))) : BoxedUnit.UNIT;
                                    String string9 = tableType;
                                    String string10 = "mor";
                                    if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                                        Row[] compactionRows = (Row[])this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"show compaction on ", " limit 10"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).collect();
                                        String[] timestamps = (String[])Predef$.MODULE$.refArrayOps((Object[])compactionRows).map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final String apply(Row x$3) {
                                                return x$3.getString(0);
                                            }
                                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                                        this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().assertResult(BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)timestamps.length), Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
                                        this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"run compaction on ", " at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, timestamps[1]})));
                                        boxedUnit = this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"run compaction on ", " at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, timestamps[0]})));
                                    } else {
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               | insert into ", " values\n               | (1,3,1,11,100001,'101.01',1001.0001,100009.0001,'a000008','2021-12-25','2021-12-25 12:01:01',true,'a01','2021-12-25'),\n               | (11,3,1,11,100001,'101.01',1001.0001,100011.0001,'a000008','2021-12-25','2021-12-25 12:01:01',true,'a01','2021-12-25'),\n               | (6,6,5,15,100005,'105.05',1005.0005,100007.0005,'a000009','2021-12-26','2021-12-26 12:05:05',false,'a05','2021-12-26')\n               |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})))).stripMargin());
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select id, col1_new, col2 from ", " where id = 1 or id = 6 or id = 2 or id = 11 order by id"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).show(false);
                                }
                            }

                            public /* synthetic */ $anonfun$3$$anonfun$apply$mcV$sp$3 org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.tmp$3 = tmp$3;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$3 org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TestSpark3DDL org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
        this.test("Test Chinese table ", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestSpark3DDL $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempDir((Function1<File, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;

                    public final void apply(File tmp) {
                        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1)new Serializable(this, tmp){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$4$$anonfun$apply$mcV$sp$4 $outer;
                            private final File tmp$4;

                            public final void apply(String tableType) {
                                String tableName = this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().generateTableName();
                                String tablePath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new Path(this.tmp$4.getCanonicalPath(), tableName).toUri().toString()}));
                                if (HoodieSparkUtils$.MODULE$.gteqSpark3_1()) {
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql("set hoodie.schema.on.read.enable=true");
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               |create table ", " (\n               |  id int, comb int, `\u540d\u5b57` string, col9 string, `\u6210\u7ee9` int, `\u8eab\u9ad8` float, `\u4f53\u91cd` double, `\u4e0a\u6b21\u66f4\u65b0\u65f6\u95f4` date, par date\n               |) using hudi\n               | location '", "'\n               | options (\n               |  type = '", "',\n               |  primaryKey = 'id',\n               |  preCombineField = 'comb'\n               | )\n               | partitioned by (par)\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, tablePath, tableType})))).stripMargin());
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               | insert into ", " values\n               | (1,3,'\u674e\u660e', '\u8bfb\u4e66', 100,180.0001,99.0001,'2021-12-25', '2021-12-26')\n               |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})))).stripMargin());
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " rename column col9 to `\u7231\u597d_Best`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               | insert into ", " values\n               | (1,3,'\u674e\u660e', '\u8bfb\u4e66', 100,180.0001,99.0001,'2021-12-26', '2021-12-26')\n               |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})))).stripMargin());
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " alter column `\u4e0a\u6b21\u66f4\u65b0\u65f6\u95f4` type string "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().checkAnswer((Row[])this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select `\u4e0a\u6b21\u66f4\u65b0\u65f6\u95f4` from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2021-12-26"}))}));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " alter column `\u4e0a\u6b21\u66f4\u65b0\u65f6\u95f4` type date "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select `\u4e0a\u6b21\u66f4\u65b0\u65f6\u95f4` from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).collect();
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().checkAnswer((Row[])this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select `\u4e0a\u6b21\u66f4\u65b0\u65f6\u95f4` from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Date[]{Date.valueOf("2021-12-26")}))}));
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.tmp$4 = tmp$4;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$4 org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TestSpark3DDL org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
        this.test("Test Alter Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestSpark3DDL $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempDir((Function1<File, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;

                    public final void apply(File tmp) {
                        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1)new Serializable(this, tmp){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$5$$anonfun$apply$mcV$sp$5 $outer;
                            private final File tmp$5;

                            public final void apply(String tableType) {
                                String tableName = this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().generateTableName();
                                String tablePath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new Path(this.tmp$5.getCanonicalPath(), tableName).toUri().toString()}));
                                if (HoodieSparkUtils$.MODULE$.gteqSpark3_1()) {
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql("set hoodie.schema.on.read.enable=true");
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               |create table ", " (\n               |  id int,\n               |  name string,\n               |  price double,\n               |  ts long\n               |) using hudi\n               | location '", "'\n               | options (\n               |  type = '", "',\n               |  primaryKey = 'id',\n               |  preCombineField = 'ts'\n               | )\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, tablePath, tableType})))).stripMargin());
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"show create table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).show(false);
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"insert into ", " values (1, 'jack', 0.9, 1000)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"update ", " set price = 1.9  where id =  1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " alter column id type long"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().checkAnswer(this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().createTestResult(tableName), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "jack", BoxesRunTime.boxToDouble((double)1.9), BoxesRunTime.boxToInteger((int)1000)}))}));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " add columns(ext1 string comment 'add ext1' after name)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"insert into ", " values (2, 'jack', 'exx1', 0.9, 1000)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().checkAnswer(this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().createTestResult(tableName), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "jack", null, BoxesRunTime.boxToDouble((double)1.9), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "jack", "exx1", BoxesRunTime.boxToDouble((double)0.9), BoxesRunTime.boxToInteger((int)1000)}))}));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " rename column price to newprice"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().checkAnswer(this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().createTestResult(tableName), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "jack", null, BoxesRunTime.boxToDouble((double)1.9), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "jack", "exx1", BoxesRunTime.boxToDouble((double)0.9), BoxesRunTime.boxToInteger((int)1000)}))}));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"update ", " set ext1 =  'haha' where id =  1 "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().checkAnswer(this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().createTestResult(tableName), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "jack", "haha", BoxesRunTime.boxToDouble((double)1.9), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "jack", "exx1", BoxesRunTime.boxToDouble((double)0.9), BoxesRunTime.boxToInteger((int)1000)}))}));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " drop column newprice"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().checkAnswer(this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().createTestResult(tableName), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "jack", "haha", BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "jack", "exx1", BoxesRunTime.boxToInteger((int)1000)}))}));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " add columns(newprice string comment 'add newprice back' after ext1)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().checkAnswer(this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().createTestResult(tableName), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "jack", "haha", null, BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "jack", "exx1", null, BoxesRunTime.boxToInteger((int)1000)}))}));
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.tmp$5 = tmp$5;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$5 org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TestSpark3DDL org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 327));
        this.test("Test Alter Table complex", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestSpark3DDL $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempDir((Function1<File, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;

                    public final void apply(File tmp) {
                        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cow", "mor"}))).foreach((Function1)new Serializable(this, tmp){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$6$$anonfun$apply$mcV$sp$6 $outer;
                            private final File tmp$6;

                            public final void apply(String tableType) {
                                String tableName = this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().generateTableName();
                                String tablePath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new Path(this.tmp$6.getCanonicalPath(), tableName).toUri().toString()}));
                                if (HoodieSparkUtils$.MODULE$.gteqSpark3_1()) {
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql("set hoodie.schema.on.read.enable=true");
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               |create table ", " (\n               |  id int,\n               |  name string,\n               |  members map<String, struct<n:string, a:int>>,\n               |  user struct<name:string, age:int, score: int>,\n               |  ts long\n               |) using hudi\n               | location '", "'\n               | options (\n               |  type = '", "',\n               |  primaryKey = 'id',\n               |  preCombineField = 'ts'\n               | )\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, tablePath, tableType})))).stripMargin());
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " alter column members.value.a first"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"insert into ", " values(1, 'jack', map('k1', struct(100, 'v1'), 'k2', struct(200, 'v2')), struct('jackStruct', 29, 100), 1000)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " rename column user to userx"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().checkAnswer((Row[])this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select ts, userx.score, id, userx.age, name from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1000), BoxesRunTime.boxToInteger((int)100), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)29), "jack"}))}));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " drop columns(name, userx.name, userx.score)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select * from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).show(false);
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " add columns(name string comment 'add name back' after userx,"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" userx.name string comment 'add userx.name back' first, userx.score int comment 'add userx.score back' after age)"})).s((Seq)Nil$.MODULE$)).toString());
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().checkAnswer((Row[])this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select name, userx.name, userx.score from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Null$[]{null, null, null}))}));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"insert into ", " values(2 , map('k1', struct(100, 'v1'), 'k2', struct(200, 'v2')), struct('jackStructNew', 291 , 101), 'jacknew', 1000)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().checkAnswer((Row[])this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select name, userx.name as uxname, userx.score as uxs from ", " order by id"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Null$[]{null, null, null})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"jacknew", "jackStructNew", BoxesRunTime.boxToInteger((int)101)}))}));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " alter column userx.age type long"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select userx.age, id, name from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().checkAnswer((Row[])this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select userx.age, id, name from ", " order by id"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)29), BoxesRunTime.boxToInteger((int)1), null})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)291), BoxesRunTime.boxToInteger((int)2), "jacknew"}))}));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " add columns(mxp map<String, int>)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"insert into ", " values(2, map('k1', struct(100, 'v1'), 'k2', struct(200, 'v2')), struct('jackStructNew', 291 , 101), 'jacknew', 1000, map('t1', 9))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " alter column mxp.value type double"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"insert into ", " values(2, map('k1', struct(100, 'v1'), 'k2', struct(200, 'v2')), struct('jackStructNew', 291 , 101), 'jacknew', 1000, map('t1', 10))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select * from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).show(false);
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().checkAnswer((Row[])this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select mxp from ", " order by id"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Null$[]{null})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"t1"), (Object)BoxesRunTime.boxToDouble((double)10.0))}))}))}));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " rename column members to mem"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " rename column mem.value.n to nn"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " rename column userx to us"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alter table ", " rename column us.age to age1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"insert into ", " values(2, map('k1', struct(100, 'v1'), 'k2', struct(200, 'v2')), struct('jackStructNew', 291 , 101), 'jacknew', 1000, map('t1', 10))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select mem.value.nn, us.age1 from ", " order by id"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).show();
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().checkAnswer((Row[])this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select mem.value.nn, us.age1 from ", " order by id"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)29)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)291)}))}));
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.tmp$6 = tmp$6;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$6 org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TestSpark3DDL org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 388));
        this.test("Test schema auto evolution", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestSpark3DDL $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempDir((Function1<File, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    public final void apply(File tmp) {
                        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"COPY_ON_WRITE", "MERGE_ON_READ"}))).foreach((Function1)new Serializable(this, tmp){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$7$$anonfun$apply$mcV$sp$7 $outer;
                            private final File tmp$7;

                            public final void apply(String tableType) {
                                String tableName = this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().generateTableName();
                                String tablePath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new Path(this.tmp$7.getCanonicalPath(), tableName).toUri().toString()}));
                                if (HoodieSparkUtils$.MODULE$.gteqSpark3_1()) {
                                    HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator();
                                    String schema = "{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}";
                                    List records1 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateInsertsAsPerSchema("001", Predef$.MODULE$.int2Integer(1000), schema))).toList();
                                    Dataset inputDF1 = this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().read().json(this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
                                    Dataset orgStringDf = inputDF1.drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"city_to_state", "distance_in_meters", "drivers"})).withColumn("tip_history", functions$.MODULE$.arrays_zip((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("tip_history.currency")})));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql("set hoodie.schema.on.read.enable=true");
                                    scala.collection.immutable.Map hudiOptions = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TABLE_NAME), (Object)tableName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE_OPT_KEY()), (Object)tableType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD_OPT_KEY()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD_OPT_KEY()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD_OPT_KEY()), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.schema.on.read.enable"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.datasource.write.reconcile.schema"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING_OPT_KEY()), (Object)"true")}));
                                    orgStringDf.write().format("org.apache.hudi").option(DataSourceWriteOptions$.MODULE$.OPERATION_OPT_KEY(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).options((Map)hudiOptions).mode(SaveMode.Overwrite).save(tablePath);
                                    Dataset oldView = this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().read().format("hudi").load(tablePath);
                                    oldView.show(false);
                                    List records2 = JavaConversions$.MODULE$.asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateUpdatesAsPerSchema("002", Predef$.MODULE$.int2Integer(100), schema))).toList();
                                    Dataset inputD2 = this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().read().json(this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
                                    Dataset updatedStringDf = inputD2.drop("fare").drop("height");
                                    String checkRowKey = (String)JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer(inputD2.select("_row_key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collectAsList()).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(Row x$4) {
                                            return x$4.getString(0);
                                        }
                                    }, Buffer$.MODULE$.canBuildFrom())).get(0);
                                    updatedStringDf.write().format("org.apache.hudi").options((Map)hudiOptions).option(DataSourceWriteOptions$.MODULE$.OPERATION_OPT_KEY(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).option("hoodie.datasource.write.reconcile.schema", "true").mode(SaveMode.Append).save(tablePath);
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().read().format("hudi").load(tablePath).registerTempTable("newView");
                                    Tuple5[] checkResult = (Tuple5[])Predef$.MODULE$.refArrayOps((Object[])this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select tip_history.amount,city_to_state,distance_in_meters,fare,height from newView where _row_key='", "' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{checkRowKey}))).collect()).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final Tuple5<Object, Object, Object, Object, Object> apply(Row row) {
                                            return new Tuple5((Object)BoxesRunTime.boxToBoolean((boolean)row.isNullAt(0)), (Object)BoxesRunTime.boxToBoolean((boolean)row.isNullAt(1)), (Object)BoxesRunTime.boxToBoolean((boolean)row.isNullAt(2)), (Object)BoxesRunTime.boxToBoolean((boolean)row.isNullAt(3)), (Object)BoxesRunTime.boxToBoolean((boolean)row.isNullAt(4)));
                                        }
                                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple5.class)));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().assertResult(new Tuple5((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)true)), checkResult[0], Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 528));
                                    this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().checkAnswer((Row[])this.$outer.org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select fare,height from newView where _row_key='", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{checkRowKey}))).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Null$[]{null, null}))}));
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.tmp$7 = tmp$7;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$7 org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TestSpark3DDL org$apache$spark$sql$hudi$TestSpark3DDL$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 476));
    }
}

