/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi;

import java.io.File;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.common.config.DFSPropertiesConfiguration;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.spark.sql.hudi.HoodieSparkSqlTestBase;
import org.apache.spark.sql.hudi.TestSqlConf$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000152A!\u0001\u0002\u0001\u001b\tYA+Z:u'Fd7i\u001c8g\u0015\t\u0019A!\u0001\u0003ik\u0012L'BA\u0003\u0007\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011c\u0001\u0001\u000f%A\u0011q\u0002E\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002\u0017\u0011>|G-[3Ta\u0006\u00148nU9m)\u0016\u001cHOQ1tKB\u00111CF\u0007\u0002))\u0011QCC\u0001\ng\u000e\fG.\u0019;fgRL!a\u0006\u000b\u0003\u001d\t+gm\u001c:f\u0003:$\u0017I\u001a;fe\")\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\u0012a\u0007\t\u0003\u001f\u0001AQ!\b\u0001\u0005\u0002y\taa]3u\u000b:4HcA\u0010*WA\u0011\u0001E\n\b\u0003C\u0011j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QEI\u0001\u0007!J,G-\u001a4\n\u0005\u001dB#AB*ue&twM\u0003\u0002&E!)!\u0006\ba\u0001?\u0005\u00191.Z=\t\u000b1b\u0002\u0019A\u0010\u0002\u000bY\fG.^3")
public class TestSqlConf
extends HoodieSparkSqlTestBase
implements BeforeAndAfter {
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    @Override
    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Args)args);
    }

    public String setEnv(String key, String value) {
        Field field = System.getenv().getClass().getDeclaredField("m");
        field.setAccessible(true);
        Map map = (Map)field.get(System.getenv());
        return map.put(key, value);
    }

    public TestSqlConf() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        this.test("Test Hudi Conf", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestSqlConf $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempDir((Function1<File, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    public final void apply(File tmp) {
                        String tableName = this.$outer.org$apache$spark$sql$hudi$TestSqlConf$$anonfun$$$outer().generateTableName();
                        String tablePath = tmp.getCanonicalPath();
                        String partitionVal = "2021";
                        this.$outer.org$apache$spark$sql$hudi$TestSqlConf$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |create table ", " (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long,\n           |  year string\n           |) using hudi\n           | partitioned by (year)\n           | location '", "'\n           | options (\n           |  primaryKey ='id',\n           |  preCombineField = 'ts'\n           | )\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, tablePath})))).stripMargin());
                        this.$outer.org$apache$spark$sql$hudi$TestSqlConf$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"insert into ", " values(1, 'a1', 10, 1000, ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, partitionVal})));
                        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(tablePath).setConf(this.$outer.org$apache$spark$sql$hudi$TestSqlConf$$anonfun$$$outer().spark().sessionState().newHadoopConf()).build();
                        String firstCommit = ((HoodieInstant)metaClient.getActiveTimeline().filterCompletedInstants().lastInstant().get()).getTimestamp();
                        this.$outer.org$apache$spark$sql$hudi$TestSqlConf$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"insert into ", " values(2, 'a2', 10, 1000, ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, partitionVal})));
                        this.$outer.org$apache$spark$sql$hudi$TestSqlConf$$anonfun$$$outer().checkAnswer(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select id, name, price, ts, year from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), partitionVal})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), partitionVal}))}));
                        this.$outer.org$apache$spark$sql$hudi$TestSqlConf$$anonfun$$$outer().assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)Files.exists(Paths.get(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tablePath, partitionVal})), new String[0]), new LinkOption[0])), Prettifier$.MODULE$.default(), new Position("TestSqlConf.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
                        this.$outer.org$apache$spark$sql$hudi$TestSqlConf$$anonfun$$$outer().assertResult(HoodieTableType.MERGE_ON_READ, new HoodieTableConfig(new Path(tablePath).getFileSystem(new Configuration()), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tablePath}))).append((Object)".hoodie").toString(), (String)HoodieTableConfig.PAYLOAD_CLASS_NAME.defaultValue()).getTableType(), Prettifier$.MODULE$.default(), new Position("TestSqlConf.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
                        DFSPropertiesConfiguration.addToGlobalProps((String)DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), (String)DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL());
                        DFSPropertiesConfiguration.addToGlobalProps((String)DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), (String)firstCommit);
                        this.$outer.org$apache$spark$sql$hudi$TestSqlConf$$anonfun$$$outer().spark().catalog().refreshTable(tableName);
                        this.$outer.org$apache$spark$sql$hudi$TestSqlConf$$anonfun$$$outer().checkAnswer(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select id, name, price, ts, year from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), partitionVal}))}));
                        this.$outer.org$apache$spark$sql$hudi$TestSqlConf$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"delete from ", " where year = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, partitionVal})));
                        long cnt = this.$outer.org$apache$spark$sql$hudi$TestSqlConf$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select * from ", " where year = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, partitionVal}))).count();
                        this.$outer.org$apache$spark$sql$hudi$TestSqlConf$$anonfun$$$outer().assertResult(BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToLong((long)cnt), Prettifier$.MODULE$.default(), new Position("TestSqlConf.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TestSqlConf org$apache$spark$sql$hudi$TestSqlConf$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestSqlConf.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
        this.before((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestSqlConf $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String testPropsFilePath = new File("src/test/resources/external-config").getAbsolutePath();
                this.$outer.setEnv("HUDI_CONF_DIR", testPropsFilePath);
                DFSPropertiesConfiguration.refreshGlobalProps();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestSqlConf.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        this.after((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DFSPropertiesConfiguration.clearGlobalProps();
            }
        }, new Position("TestSqlConf.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
    }
}

